/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.Field;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.StringsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"(\n)\u0001C)\u001a7fO\u0006$X\r\u001a)s_B,'\u000f^=GS\u0016dG\rR3tGJL\u0007\u000f^8s\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\u0002Z3ck\u001e<WM\u001d\u0006\u0007e\u0016tG-\u001a:\u000b'\u0019KW\r\u001c3EKN\u001c'/\u001b9u_JLU\u000e\u001d7\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\t)\u0018N\u0003\u0003j[Bd'\"B<bi\u000eD'B\u0002\u001fj]&$hHC\u0004qe>TWm\u0019;\u000b\u000fA\u0013xN[3di*9q\u000e]3oCBL'\"C8cU\u0016\u001cGOU3g\u0015=y%M[3diJ+g-\u001a:f]\u000e,'bA:v]*\u0019!\u000eZ5\u000b\u0011\u0011,G.Z4bi\u0016TQAR5fY\u0012TqC]3oI\u0016\u0014H)\u001a7fO\u0006$X\r\u001a)s_B,'\u000f^=\u000b\u000f\t{w\u000e\\3b]*Yq-\u001a;EK2,w-\u0019;f\u001519W\r^(cU\u0016\u001cGOU3g\u0015i9W\r\u001e*f]\u0012,'\u000fR3mK\u001e\fG/\u001a3Qe>\u0004XM\u001d;z\u0015%\u0019\u0017\r\\2WC2,XMC\tfm\u0006dW/\u0019;j_:\u001cuN\u001c;fqRTQ#\u0012<bYV\fG/[8o\u0007>tG/\u001a=u\u00136\u0004HN\u0003\u0004f]\u001eLg.\u001a\u0006\u000bKZ\fG.^1uS>t'\"\u0002,bYV,'B\b4j]\u0012<U\r\u001e;fe\u001a{'\u000fR3mK\u001e\fG/\u001a3Qe>\u0004XM\u001d;z\u0015\u0019iU\r\u001e5pI*yq-\u001a;EK\u000ed\u0017M]3e)f\u0004XM\u0003\u0004TiJLgn\u001a\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'bF4fi\u0012+7o\u0019:jaR|'/\u0012<bYV\fG/[8o\u0015\u001d\u0019wN\u001c;fqRTq\u0002R3ck\u001e<WM]\"p]R,\u0007\u0010\u001e\u0006\u000e!NLW\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007A\u001c\u0018NC\u0004hKRt\u0015-\\3\u0013\u0006)\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011QA\u0001C\u0002\u0011\u000b)!\u0001\u0002\u0002\t\u0007\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0003\t\u0011A)!\u0002\u0002\u0005\n!)QA\u0001\u0003\u0006\u0011\u0017)!\u0001b\u0003\t\r\u0015\u0019AA\u0002E\u0004\u0019\u0001)!\u0001\u0002\u0003\t\u0011\u0015\u0011Aa\u0002\u0005\b\u000b\r!y\u0001c\u0004\r\u0001\u0015\u0011Aq\u0001E\n\u000b\t!\t\u0002\u0003\u0006\u0006\u0007\u0011I\u0001\"\u0003\u0007\u0001\u000b\r!\u0011\u0002C\u0006\r\u0001\u0015\t\u00012A\u0003\u0004\t+AA\u0002\u0004\u0001\u0006\u0005\u0011=\u0001rB\u0003\u0003\t%A\u0011\"\u0002\u0002\u0005\u0013!YQA\u0001C\u0005\u0011?)!\u0001B\u0007\t!\u0015\u0019A1\u0004\u0005\u0010\u0019\u0001)1\u0001B\u0005\t\"1\u0001QA\u0001\u0003\n\u0011C)!\u0001b\u0007\t\u001f\u0015\u0019A!\u0003E\u0012\u0019\u0001)!\u0001B\u0005\t$\u0015\u0019AQ\u0003E\u0013\u0019\u0001)\u0011\u0001C\n\u0006\u0005\u0011\r\u0002rE\u0003\u0003\tIA)#B\u0002\u0005\n!)B\u0002A\u0003\u0003\t\u0011Aa#B\u0002\u0005(!-B\u0002A\u0003\u0003\tOAY#\u0002\u0002\u0005\n!)Ba\u0001\u0007\u00043\r)\u0011\u0001#\u0004\u0019\u000e5\u0002Ba\u0019\u0003\u0019\u0016\u0005\u001aQ!\u0001\u0005\u000b1))6\u0001C\u0003\u0004\t+I\u0011\u0001#\u0007\u000e\u0007\u0011e\u0011\"\u0001E\r[A!1\r\u0002M\tC\r)\u0011\u0001c\u0005\u0019\u0014U\u001b\u0001\"B\u0002\u0005\u0012%\t\u0001\u0002D\u0007\u0004\t5I\u0011\u0001\u0003\u0007.!\u0011\u0019G\u0001g\u0006\"\u0007\u0015\t\u0001b\u0003\r\f+\u000eAQa\u0001C\f\u0013\u0005!\t!D\u0002\u0005\u001c%\tA\u0011A\u0017\u0018\t-Ab\"(\u0005\u0005\u0001!uQ\u0002B\u0003\u0002\u00119a\t\u0001\u0007\bQ\u0007\u0001\tC!B\u0001\t\u001e1\u0005\u0001TD)\u0004\u000b\u0011q\u0011\"\u0001\u0005\u0010\u001b\u0005Ay\"l\u0006\u0005\u0003a\t\u0012\u0005B\u0003\u0002\u0011Aa\t\u0001\u0007\tR\u0007\r!\u0011#C\u0001\t\"5^Aa\u0003\r\u0013C\u0011)\u0011\u0001C\t\r\u0002a\t\u0012kA\u0002\u0005%%\t\u0001RE\u0017\u0018\t-AB#(\u0005\u0005\u0001!%R\u0002B\u0003\u0002\u0011Ma\t\u0001G\nQ\u0007\u0001\tC!B\u0001\t)1\u0005\u0001\u0004F)\u0004\u000b\u0011!\u0012\"\u0001E\u0015\u001b\u0005AQ#,\u0006\u0005\u0017a5\u0012eA\u0003\u0002\u0011EA\u0012#U\u0002\u0004\t[I\u0011\u0001#\n6m\u0015)Da9\u0001\u0019\u000eu=A\u0001\u0001\u0005\b\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\u0001!h\u0004\u0005\u0001!EQbA\u0003\u0002\u0011'A\u001a\u0002UB\u0001;\u001f!\u0001\u0001#\u0006\u000e\u0007\u0015\t\u0001B\u0003\r\u000b!\u000e\tQt\u0002\u0003\u0001\u0011/i1!B\u0001\t\u0017aY\u0001ka\u0001\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000eYAQB\u0005\u0002\t\u0001i\u0011\u0001c\u0006\u000e\u0003!aQ\"\u0001E\r\u001b\u0005!\t\u0001"})
public final class DelegatedPropertyFieldDescriptor
extends FieldDescriptorImpl {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final ObjectReference objectRef;
    @NotNull
    private final Field delegate;
    private final boolean renderDelegatedProperty;

    static {
        $kotlinClass = Reflection.createKotlinClass(DelegatedPropertyFieldDescriptor.class);
    }

    @Nullable
    public Value calcValue(@Nullable EvaluationContextImpl evaluationContext) {
        ThreadReference threadReference;
        if (evaluationContext == null) {
            return null;
        }
        if (!this.renderDelegatedProperty) {
            return super.calcValue(evaluationContext);
        }
        Method method = this.findGetterForDelegatedProperty();
        ThreadReferenceProxyImpl threadReferenceProxyImpl = evaluationContext.getSuspendContext().getThread();
        ThreadReference threadReference2 = threadReference = threadReferenceProxyImpl != null ? threadReferenceProxyImpl.getThreadReference() : null;
        if (method == null || threadReference == null) {
            return super.calcValue(evaluationContext);
        }
        try {
            return evaluationContext.getDebugProcess().invokeInstanceMethod((EvaluationContext)evaluationContext, this.getObject(), method, CollectionsKt.listOf(), evaluationContext.getSuspendContext().getSuspendPolicy());
        }
        catch (EvaluateException e) {
            return e.getExceptionFromTargetVM();
        }
    }

    @NotNull
    public String getName() {
        return StringsKt.removeSuffix((String)this.delegate.name(), (String)JvmAbi.DELEGATED_PROPERTY_NAME_SUFFIX);
    }

    @Nullable
    public PsiExpression getDescriptorEvaluation(@Nullable DebuggerContext context) {
        return null;
    }

    private final Method findGetterForDelegatedProperty() {
        String fieldName = this.getName();
        if (!Name.isValidIdentifier(fieldName)) {
            return null;
        }
        List<Method> list = this.getObject().referenceType().methodsByName(JvmAbi.getterName(fieldName));
        return list != null ? (Method)CollectionsKt.firstOrNull(list) : null;
    }

    @Nullable
    public String getDeclaredType() {
        Mirror mirror = this.findGetterForDelegatedProperty();
        return mirror != null && (mirror = mirror.returnType()) != null ? mirror.name() : null;
    }

    @NotNull
    public final ObjectReference getObjectRef() {
        return this.objectRef;
    }

    @NotNull
    public final Field getDelegate() {
        return this.delegate;
    }

    public final boolean getRenderDelegatedProperty() {
        return this.renderDelegatedProperty;
    }

    public DelegatedPropertyFieldDescriptor(@NotNull Project project, @NotNull ObjectReference objectRef, @NotNull Field delegate2, boolean renderDelegatedProperty) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)objectRef, (String)"objectRef");
        Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
        super(project, objectRef, delegate2);
        this.objectRef = objectRef;
        this.delegate = delegate2;
        this.renderDelegatedProperty = renderDelegatedProperty;
    }
}

