/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.JvmSmartStepIntoHandler;
import com.intellij.debugger.actions.MethodSmartStepTarget;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.CollectionsKt;
import kotlin.MapsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.intrinsics.IntrinsicMethods;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.DescriptorToSourceUtilsIde;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaMethodFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinLambdaSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinMethodSmartStepTarget;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSmartStepIntoHandler;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0017\b)Q2j\u001c;mS:\u001cV.\u0019:u'R,\u0007/\u00138u_\"\u000bg\u000e\u001a7fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'\u0002\u00033fEV<w-\u001a:\u000b\u0011M$X\r\u001d9j]\u001eTqC\u0013<n'6\f'\u000f^*uKBLe\u000e^8IC:$G.\u001a:\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\u001d\t7\r^5p]NTa\u0001P5oSRt$bB7fi\"|Gm\u001d\u0006\u0011\u0013:$(/\u001b8tS\u000elU\r\u001e5pINTqaY8eK\u001e,gN\u0003\u0006j]R\u0014\u0018N\\:jGNT!c\u0019:fCR,W*\u001a;i_\u00124\u0015\u000e\u001c;fe*Q1\u000f^3q)\u0006\u0014x-\u001a;\u000b\u001fMk\u0017M\u001d;Ti\u0016\u0004H+\u0019:hKRTA\"T3uQ>$g)\u001b7uKJTa!\u001a8hS:,'\u0002\u00064j]\u0012\u001cV.\u0019:u'R,\u0007\u000fV1sO\u0016$8O\u0003\u0005q_NLG/[8o\u00159\u0019v.\u001e:dKB{7/\u001b;j_:TA\u0001T5ti*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0017%\u001c\u0018I^1jY\u0006\u0014G.\u001a\u0006\b\u0005>|G.Z1o\u0015-I7/\u00138ue&t7/[2\u000b\u0015\u0011,7o\u0019:jaR|'O\u0003\rDC2d\u0017M\u00197f\u001b\u0016l'-\u001a:EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!\u0002\u0002\u0005\u0005!\u0019Qa\u0001C\u0003\u0011\u0001a\u0001!B\u0001\t\t\u0015\u0011Aq\u0001E\u0005\u000b\t!A\u0001#\u0002\u0006\u0005\u0011%\u0001\"B\u0003\u0004\t\u0015A9\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001bB\u0003\u0003\t\u0019Ay!B\u0002\u0005\u000e!5A\u0002A\u0003\u0003\t\u001bAi!B\u0002\u0005\u000b!IA\u0002A\u0003\u0003\t\u0013A!\"B\u0002\u0005\u0012!MA\u0002A\u0003\u0003\t#A\u0019\"\u0002\u0002\u0005\u000b!IQa\u0001C\u0005\u0011/a\u0001!B\u0001\t\u0004\u0015\u0019Aa\u0003\u0005\r\u0019\u0001)\u0011\u0001#\u0007\u0006\u0005\u0011a\u0001\"D\u0003\u0003\t3AA\"\u0002\u0002\u0005\n!]Qa\u0001\u0003\f\u00119a\u0001!\u0002\u0002\u0005\u0003!\u0001Ra\u0001C\u000f\u0011?a\u0001!\u0002\u0002\u0005\u001e!}Aa\u0001\u0007\u00043\r)\u0011\u0001c\u0003\u0019\f5bA!\u0019\u0003\u0019\r\u0005\u001aQ!\u0001\u0005\b1\u001d)6\u0001B\u0003\u0004\t\u0019I\u0011\u0001c\u0004./\u0011Q\u0001\u0004CO\t\t\u0001A\t\"\u0004\u0003\u0006\u0003!AA\u0012\u0001\r\t!\u000e\u0001\u0011\u0005B\u0003\u0002\u0011%a\t\u0001G\u0005R\u0007\u0015!\u0001\"C\u0001\t\u00145\t\u0001BC\u0017\u001b\t-A*\"h\u0004\u0005\u0001!YQbA\u0003\u0002\u0011+A*\u0002U\u0002\u0001C!)\u0011\u0001c\u0006\n\t%\u0019Q!\u0001\u0005\t1!A:\"U\u0002\u0006\t+I\u0011\u0001C\u0007\u000e\u0003!mQF\u0006\u0003\f17i\n\u0002\u0002\u0001\t\u00175!Q!\u0001E\u000b\u0019\u0003A*\u0002U\u0002\u0001C\r)\u0011\u0001\u0003\b\u0019\u001dE\u001bQ\u0001b\u0007\n\u0003\u0011\u0005Q\"\u0001E\u000e[U!\u0011\u0001'\b\u001e\u0010\u0011\u0001\u0001bD\u0007\u0004\u000b\u0005Aq\u0002G\bQ\u0007\u0001\t3!B\u0001\t\u001daq\u0011kA\u0003\u0005\u001e%\tA\u0011A\u0007\u0002\u0011?)D\"B\u0006\u0005G\u0004AZ!I\u0002\u0006\u0003!\u0019\u0001dA)\u0004\u0007\u0011-\u0011\"\u0001\u0003\u0001"})
public final class KotlinSmartStepIntoHandler
extends JvmSmartStepIntoHandler {
    public static final /* synthetic */ KClass $kotlinClass;
    private final IntrinsicMethods methods = new IntrinsicMethods();

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSmartStepIntoHandler.class);
    }

    public boolean isAvailable(@Nullable SourcePosition position) {
        SourcePosition sourcePosition2 = position;
        return (sourcePosition2 != null ? sourcePosition2.getFile() : null) instanceof JetFile;
    }

    @NotNull
    public List<SmartStepTarget> findSmartStepTargets(@NotNull SourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        if (position.getLine() < 0) {
            return CollectionsKt.emptyList();
        }
        PsiFile file = position.getFile();
        Integer n = CodeInsightUtils.getStartLineOffset(file, position.getLine());
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int lineStart = ((Number)n).intValue();
        PsiElement psiElement2 = file.findElementAt(lineStart);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement elementAtOffset = psiElement2;
        PsiElement element2 = CodeInsightUtils.getTopmostElementAtOffset(elementAtOffset, lineStart);
        if (!(element2 instanceof JetElement)) {
            return CollectionsKt.emptyList();
        }
        TextRange textRange = ((JetElement)element2).getTextRange();
        if (textRange == null) {
            return CollectionsKt.emptyList();
        }
        TextRange elementTextRange = textRange;
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Document doc = document;
        Range lines = new Range((Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(doc.getLineNumber(elementTextRange.getEndOffset())));
        BindingContext bindingContext2 = ResolutionUtils.analyzeFully((JetElement)element2);
        OrderedSet result2 = new OrderedSet();
        ((JetElement)element2).accept(new JetTreeVisitorVoid(this, result2, lines, bindingContext2, file){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinSmartStepIntoHandler this$0;
            final /* synthetic */ OrderedSet $result;
            final /* synthetic */ Range $lines;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ PsiFile $file;

            static {
                $kotlinClass = Reflection.createKotlinClass(findSmartStepTargets.1.class);
            }

            /*
             * WARNING - void declaration
             */
            public void visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context = ResolutionUtils.analyze$default(expression2, null, 1);
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(CallUtilKt.getParentCall$default(expression2, context, false, 2), context);
                if (resolvedCall != null && !InlineUtil.isInline(resolvedCall.getResultingDescriptor())) {
                    Map<ValueParameterDescriptor, ResolvedValueArgument> arguments2 = resolvedCall.getValueArguments();
                    Iterator iterator2 = MapsKt.iterator(arguments2);
                    while (iterator2.hasNext()) {
                        boolean bl;
                        ValueParameterDescriptor param;
                        block3: {
                            void $receiver;
                            Map.Entry entry = (Map.Entry)iterator2.next();
                            param = (ValueParameterDescriptor)MapsKt.component1((Map.Entry)entry);
                            ResolvedValueArgument argument = (ResolvedValueArgument)MapsKt.component2((Map.Entry)entry);
                            Iterable iterable = argument.getArguments();
                            for (T element2 : $receiver) {
                                ValueArgument it = (ValueArgument)element2;
                                if (!Intrinsics.areEqual((Object)it.getArgumentExpression(), (Object)expression2)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                        if (!bl) continue;
                        DeclarationDescriptor declarationDescriptor = resolvedCall.getResultingDescriptor();
                        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"resolvedCall.getResultingDescriptor()");
                        Name name2 = param.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"param.getName()");
                        String label = KotlinLambdaSmartStepTarget.Companion.calcLabel(declarationDescriptor, name2);
                        this.$result.add((Object)((Object)new KotlinLambdaSmartStepTarget(label, expression2, (Range<Integer>)this.$lines)));
                        break;
                    }
                }
            }

            public void visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            }

            public void visitIfExpression(@NotNull JetIfExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitWhileExpression(@NotNull JetWhileExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitDoWhileExpression(@NotNull JetDoWhileExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getCondition();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitForExpression(@NotNull JetForExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getLoopRange();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitWhenExpression(@NotNull JetWhenExpression expression2) {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getSubjectExpression();
                if (jetExpression != null) {
                    jetExpression.accept(this);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }

            public void visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.recordFunction(expression2);
                super.visitArrayAccessExpression(expression2);
            }

            public void visitUnaryExpression(@NotNull JetUnaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
                this.recordFunction(jetExpression);
                super.visitUnaryExpression(expression2);
            }

            public void visitBinaryExpression(@NotNull JetBinaryExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression jetExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression, (String)"expression.getOperationReference()");
                this.recordFunction(jetExpression);
                super.visitBinaryExpression(expression2);
            }

            public void visitCallExpression(@NotNull JetCallExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                JetExpression calleeExpression = expression2.getCalleeExpression();
                if (calleeExpression != null) {
                    this.recordFunction(calleeExpression);
                }
                super.visitCallExpression(expression2);
            }

            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
                PropertyGetterDescriptor getterDescriptor;
                CallableDescriptor propertyDescriptor;
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall != null && (propertyDescriptor = resolvedCall.getResultingDescriptor()) instanceof PropertyDescriptor && (getterDescriptor = ((PropertyDescriptor)propertyDescriptor).getGetter()) != null && !getterDescriptor.isDefault()) {
                    ResolvedCall delegatedResolvedCall = (ResolvedCall)this.$bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getterDescriptor);
                    if (delegatedResolvedCall == null) {
                        Project project = this.$file.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                        PsiElement getter = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, getterDescriptor);
                        if (getter instanceof JetPropertyAccessor && (((JetPropertyAccessor)getter).getBodyExpression() != null || ((JetPropertyAccessor)getter).getEqualsToken() != null)) {
                            String label = KotlinMethodSmartStepTarget.Companion.calcLabel(getterDescriptor);
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetElement)getter, label, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                        }
                    } else {
                        FunctionDescriptor delegatedPropertyGetterDescriptor = (FunctionDescriptor)delegatedResolvedCall.getResultingDescriptor();
                        if (delegatedPropertyGetterDescriptor instanceof CallableMemberDescriptor) {
                            Project project = this.$file.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                            PsiElement function2 = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, delegatedPropertyGetterDescriptor);
                            if (function2 instanceof JetNamedFunction || function2 instanceof JetSecondaryConstructor) {
                                String label = ((PropertyDescriptor)propertyDescriptor).getName() + "." + KotlinMethodSmartStepTarget.Companion.calcLabel(delegatedPropertyGetterDescriptor);
                                PsiElement psiElement2 = function2;
                                if (psiElement2 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFunction");
                                }
                                this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetFunction)psiElement2, label, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                            }
                        }
                    }
                }
                super.visitSimpleNameExpression(expression2);
            }

            private final void recordFunction(JetExpression expression2) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(expression2, this.$bindingContext);
                if (resolvedCall == null) {
                    return;
                }
                ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
                CallableDescriptor descriptor2 = resolvedCall2.getResultingDescriptor();
                if (descriptor2 instanceof CallableMemberDescriptor) {
                    CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"descriptor");
                    if (!KotlinSmartStepIntoHandler.access$isIntrinsic$0(this.this$0, callableMemberDescriptor)) {
                        Project project = this.$file.getProject();
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.getProject()");
                        DeclarationDescriptor declarationDescriptor = descriptor2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor, (String)"descriptor");
                        PsiElement function2 = DescriptorToSourceUtilsIde.INSTANCE$.getAnyDeclaration(project, declarationDescriptor);
                        if (function2 instanceof JetNamedFunction || function2 instanceof JetSecondaryConstructor) {
                            DeclarationDescriptor declarationDescriptor2 = descriptor2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"descriptor");
                            String label = KotlinMethodSmartStepTarget.Companion.calcLabel(declarationDescriptor2);
                            PsiElement psiElement2 = function2;
                            if (psiElement2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetFunction");
                            }
                            this.$result.add((Object)((Object)new KotlinMethodSmartStepTarget((JetFunction)psiElement2, label, (PsiElement)expression2, (Range<Integer>)this.$lines)));
                        } else if (function2 instanceof PsiMethod) {
                            this.$result.add((Object)new MethodSmartStepTarget((PsiMethod)function2, (String)null, (PsiElement)expression2, false, this.$lines));
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$result = $captured_local_variable$1;
                this.$lines = $captured_local_variable$2;
                this.$bindingContext = $captured_local_variable$3;
                this.$file = $captured_local_variable$4;
            }
        }, null);
        return (List)result2;
    }

    @Nullable
    protected MethodFilter createMethodFilter(@Nullable SmartStepTarget stepTarget) {
        MethodFilter methodFilter2;
        SmartStepTarget smartStepTarget = stepTarget;
        if (smartStepTarget instanceof KotlinMethodSmartStepTarget) {
            JetElement jetElement = ((KotlinMethodSmartStepTarget)stepTarget).getResolvedElement();
            Range range = ((KotlinMethodSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.getCallingExpressionLines()!!");
            methodFilter2 = (MethodFilter)new KotlinBasicStepMethodFilter(jetElement, (Range<Integer>)range);
        } else if (smartStepTarget instanceof KotlinLambdaSmartStepTarget) {
            JetFunctionLiteralExpression jetFunctionLiteralExpression = ((KotlinLambdaSmartStepTarget)stepTarget).getLambda();
            Range range = ((KotlinLambdaSmartStepTarget)stepTarget).getCallingExpressionLines();
            if (range == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)range, (String)"stepTarget.getCallingExpressionLines()!!");
            methodFilter2 = (MethodFilter)new KotlinLambdaMethodFilter(jetFunctionLiteralExpression, (Range<Integer>)range);
        } else {
            methodFilter2 = super.createMethodFilter(stepTarget);
        }
        return methodFilter2;
    }

    private final boolean isIntrinsic(CallableMemberDescriptor descriptor2) {
        return this.methods.getIntrinsic(descriptor2) != null;
    }

    public static final /* synthetic */ boolean access$isIntrinsic$0(KotlinSmartStepIntoHandler $this, @NotNull CallableMemberDescriptor descriptor2) {
        return $this.isIntrinsic(descriptor2);
    }
}

