/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.refactoring.JetRefactoringUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSteppingCommandProvider;
import org.jetbrains.kotlin.idea.util.DebuggerUtils;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCatchClause;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0010\u0012)i2j\u001c;mS:\u001cF/\u001a9qS:<7i\\7nC:$\u0007K]8wS\u0012,'OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0011\u0011,'-^4hKJT\u0001b\u001d;faBLgn\u001a\u0006\u001b\u0015Zl7\u000b^3qa&twmQ8n[\u0006tG\r\u0015:pm&$WM\u001d\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\t%l\u0007\u000f\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u0003QS1!\u00118z\u0015Y\u0019w.\u001c9vi\u0016Le.T1oC\u001e,'\u000f\u00165sK\u0006$'BD:vgB,g\u000eZ\"p]R,\u0007\u0010\u001e\u0006\u0013'V\u001c\b/\u001a8e\u0007>tG/\u001a=u\u00136\u0004HN\u0003\u0004f]\u001eLg.\u001a\u0006\u0007C\u000e$\u0018n\u001c8\u000b\u0013\u0019+hn\u0019;j_:\f$\u0002\u00026bm\u0006TA\u0001\\1oO*1qJ\u00196fGRT1A\u001b<n\u0015%1WO\\2uS>t7O\u0003\fhKRLe\u000e\\5oK\u0006\u0013x-^7f]RLe-\u00118z\u0015\u00111\u0017\u000e\\3\u000b\u000f)+GOR5mK*\u0019\u0001o]5\u000b\r=4gm]3u\u0015\rIe\u000e\u001e\u0006\u0013\u0015\u0016$h)\u001e8di&|g\u000eT5uKJ\fGNC\u000ehKRLe\u000e\\5oK\u001a+hn\u0019;j_:\u001c\u0015\r\u001c7t\u0013\u001a\fe.\u001f\u0006\u000fg>,(oY3Q_NLG/[8o\u00159\u0019v.\u001e:dKB{7/\u001b;j_:TA\u0001T5ti*\t\"*\u001a;DC2dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b\tU$\u0018\u000e\u001c\u0006\u0018O\u0016$\u0018J\u001c7j]\u00164UO\\2uS>t7/\u00134B]fT\u0001CS3u\u001d\u0006lW\r\u001a$v]\u000e$\u0018n\u001c8\u000b1\u001d,G/\u00138mS:,G-\u0011:hk6,g\u000e^:JM\u0006s\u0017PC\nj]2Lg.\u001a$v]\u000e$\u0018n\u001c8DC2d7OC\u0006KKR4UO\\2uS>t'\"E4fiN#X\r](vi\u000e{W.\\1oI*A1\u000f^3q'&TXMC\u0007SKN,X.Z\"p[6\fg\u000e\u001a\u0006\u0011\t\u0016\u0014Wo\u001a)s_\u000e,7o]%na2Ta\u0004R3ck\u001e\u0004&o\\2fgNLU\u000e\u001d7%%\u0016\u001cX/\\3D_6l\u0017M\u001c3\u000b%\u001d,Go\u0015;fa>3XM]\"p[6\fg\u000e\u001a\u0006\u0012S\u001etwN]3Ce\u0016\f7\u000e]8j]R\u001c(b\u0002\"p_2,\u0017M\u001c\u0006\u0018SN\\u\u000e\u001e7j]N#(/\u0019;b\u0003Z\f\u0017\u000e\\1cY\u0016T!\u0002U:j\u000b2,W.\u001a8u\u0015!\u0019wN\u001c;bS:\u001c(bB3mK6,g\u000e\u001e\u0006\u001cO\u0016$\u0018\t\u001a3ji&|g.\u00197FY\u0016lWM\u001c;t)>\u001c6.\u001b9\u000b3\u001d,GOT3yiB{7/\u001b;j_:<\u0016\u000e\u001e5GS2$XM\u001d\u0006\nY>\u001c\u0017\r^5p]NT\u0001\u0002T8dCRLwN\u001c\u0006\u0004gVt'b\u00016eS*!1o[5q\u0015%1UO\\2uS>t'GC\nY'>,(oY3Q_NLG/[8o\u00136\u0004HNC\u0005yI\u0016\u0014WoZ4fe*As-\u001a;Y!>\u001c\u0018\u000e^5p]\u001a{'o\u0015;fa>+HO\u0012:p[&sG.\u001b8f\rVt7\r^5p]*)\u0012N\u001c7j]\u00164UO\\2uS>t7\u000fV8TW&\u0004(\"K4fib\u0003vn]5uS>tgi\u001c:Ti\u0016\u0004x*\u001e;Ge>l\u0017J\u001c7j]\u0016$\u0017I]4v[\u0016tGOC\u000bj]2Lg.\u001a3Be\u001e,X.\u001a8u)>\u001c6.\u001b9\u000b)MDw.\u001e7e\u001d>$Xk]3Ti\u0016\u0004xJ^3s\u0015%)G.Z7f]R\fE\u000f:\u0002\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0003\u000b\t!!\u0001C\u0002\u0006\u0007\u0011\u0015\u0001\u0002\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\b!%QA\u0001\u0003\u0005\u0011\u000b)!\u0001\"\u0003\t\u000b\u0015\u0019A!\u0002E\u0004\u0019\u0001)\u0011\u0001c\u0001\u0006\u0007\u00111\u0001R\u0002\u0007\u0001\u000b\t!I\u0001#\u0005\u0006\u0007\u00119\u0001\u0002\u0003\u0007\u0001\u000b\r!a\u0001c\u0005\r\u0001\u0015\t\u0001BC\u0003\u0003\t#A)\"\u0002\u0002\u0005\u0013!YQA\u0001\u0003\b\u0011!)!\u0001\u0002\u0004\t\u0018\u0015\u0011AQ\u0003\u0005\r\u000b\t!1\u0002c\u0005\u0006\u0005\u0011\t\u0001BD\u0003\u0004\t1AY\u0002\u0004\u0001\u0006\u0007\u00111\u0001b\u0004\u0007\u0001\u000b\r!A\u0002c\b\r\u0001\u0015\u0011A\u0001\u0004E\u0010\u000b\t!A\u0002c\u0007\u0006\u0007\u0011%\u0001\"\u0005\u0007\u0001\u000b\r!a\u0001c\t\r\u0001\u0015\u0019A\u0001\u0004\u0005\u0013\u0019\u0001)!\u0001\"\u0005\t&\u0015\u0011A\u0011\u0005E\u0012\u000b\t!I\u0001C\t\u0006\u0007\u0011a\u0001r\u0005\u0007\u0001\u000b\r!A\u0002C\u000b\r\u0001\u0015\u0019Aa\u0002\u0005\u0018\u0019\u0001)1\u0001B\n\t.1\u0001QA\u0001\u0003\b\u0011_)1\u0001\u0002\u0004\t31\u0001QA\u0001\u0003\u0005\u00119)1\u0001B\u000b\t51\u0001QA\u0001\u0003\u0016\u0011i)!\u0001b\u0002\t<\u0015\u0011AQ\u0006\u0005\u001f\u000b\r!q\u0003C\u000f\r\u0001\u0015\u0019AA\u0002\u0005 \u0019\u0001)!\u0001\u0002\u0003\tA\u0015\u0011A\u0011\u0007\u0005\u0006\u000b\r!\u0011\u0004c\u0010\r\u0001\u0015\u0011A!\u0007E \u000b\t!1\u0002C\u0010\u0005\u00071\u0019\u0011dA\u0003\u0002\u0011\u0017AZ!,\u001b\u0005\u0003E1A\u0001\u0001\u0005\u0007+\r)\u0011\u0001#\u0004\u0019\u000ea9Qt\u0002\u0003\u0001\u0011\u001fi1!B\u0001\t\u0010a=\u0001k\u0001\u0001\u001e(\u0011\u0001\u0001\"C\u0007\u0010\u000b\u0005A\u0001\"\u0003\u0003\n\u0007\u0015\t\u0001r\u0002M\b\u0013\u0019IQ!\u0002\u0002\u0005\u0002!\u0001A\u0012\u0001\u000f\u00011!\u00016\u0011A\u0011\u0006\u000b\t!\t\u0001\u0003\u0001\r\u0002q\u0001\u0011kA\u0004\u0005\u000f%\t\u00012C\u0007\u0002\u0011)i\u0011\u0001c\u0006.B\u0011\t\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!e\u0001\u0014\u0004)\u0004\u0001u=A\u0001\u0001E\u000f\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\t!\t\u0003\u0006\u0003!mA\u0012\u0001M\u000e#\u000e9A\u0011D\u0005\u0002\u00119i\u0011\u0001#\b\u000e\u0003\u0011\u0015QF\u0007\u0003\u00021Aiz\u0001\u0002\u0001\t\"5\u0019Q!\u0001\u0005\u00101=\u00016\u0001A\u0011\t\u000b\u0005Ay\"\u0003\u0003\n\u0007\u0015\t\u0001\u0002\u0005\r\u00111?\t6!\u0002\u0003\u0011\u0013\u0005A\u0011#D\u0001\t$5&C!\u0001\r\u0014;\u001f!\u0001\u0001C\u0007\u000e\u0007\u0015\t\u0001\u0012\u0004M\r!\u000e\u0001Qt\u0002\u0003\u0001\u0011;i1!B\u0001\t\u001bai\u0001k!\u0001\"\u0011\u0015\t\u0001rD\u0005\u0005\u0013\r)\u0011\u0001\u0003\n\u0019%a}\u0011kA\u0004\u0005'%\t\u0001\"E\u0007\u0002\u0011;i\u0011\u0001\"\u0002.?\u0011\t\u0001\u0004FO\r\t\u0001AI#\u0004\u0005\u0006\u0003!}\u0011\u0002B\u0005\u0004\u000b\u0005A\u0001\u0003\u0007\t\u0019 A\u001b\u0001!\t\u0005\u0006\u0003!}\u0011\u0002B\u0005\u0004\u000b\u0005A)\u0003'\n\u0019 E\u001bQ\u0001\u0002\u000b\n\u0003!\tR\"\u0001\u0005\u0012[\u0007\"1\u0002g\u000b\u001e\u0012\u0011\u0001\u0001rB\u0007\u0005\u000b\u0005Ay\u0001$\u0001\u0019\u0010A\u001b\u0001!h\u0004\u0005\u0001!1RbA\u0003\u0002\u00115AR\u0002UB\u0001C\u0011)\u0011\u0001c\n\r\u0002a\u001d\u0012kA\u0004\u0005,%\t\u0001\u0002F\u0007\u0002\u0011)i\u0011\u0001\"\u0002.Y\u0011Y\u0001\u0004GO\t\t\u0001Ay!\u0004\u0003\u0006\u0003!=A\u0012\u0001M\b!\u000e\u0001Qt\u0002\u0003\u0001\u0011ci1!B\u0001\t*a%\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001BF\u0007\u0004\u000b\u0005AQ\u0002G\u0007Q\u0007\u0005\tC!B\u0001\t(1\u0005\u0001tE)\u0004\u0013\u0011A\u0012\"\u0001\u0005\u0015\u001b\u0005A!\"D\u0001\u0005\u00025\tAQA\u0017\u0016\t\u0005A\u001a$h\u0004\u0005\u0001!=QbA\u0003\u0002\u0011\u001fAz\u0001U\u0002\u0001C\r)\u0011\u0001#\u000b\u0019*E\u001bQ\u0001b\r\n\u0003\u0011\u0005Q\"\u0001\u0005\u000b[q!\u0011!\u0006\u0003\u0006\u0003!-B\u0012\u0001M\u00161kiz\u0001\u0002\u0001\t75\u0019Q!\u0001E\u00161W\u00016\u0011A\u0011\u0004\u000b\u0005AI\u0003'\u000bR\u0007\u001d!)$C\u0001\u0005\u00025\t\u0001BF\u0007\u0002\u0011Yi[\u0003B\u0001\u0016\u0007\u0015\t\u00012\u0006M\u00161o\t\u0003\"B\u0001\t %!\u0011bA\u0003\u0002\u0011WAZ\u0003g\bR\u0007\u0015!9$C\u0001\t#5\t\u0001BFW;\t\u0005)2!B\u0001\t\u0010a=\u0001\u0004HO\r\t\u0001AI$\u0004\u0005\u0006\u0003!}\u0011\u0002B\u0005\u0004\u000b\u0005Ay\u0003g\f\u0019 A\u001b\t!(\f\u0005\u0001!uRBE\u0003\u0002\u0011aIA!C\u0002\u0006\u0003!e\u0001\u0014D\u0005\u0005\u0013\r)\u0011\u0001C\u0007\u0019\u001b%!\u0011bA\u0003\u0002\u0011SAJ\u0003\u0007\rQ\u0007\u0005\tC!B\u0001\t41\u0005\u00014G)\u0004\u0013\u0011a\u0012\"\u0001\u0005\u001b\u001b\u0005A!\"D\u0001\t#5\t\u0001RGW1\t\u0005)2!B\u0001\t\u0010a=\u0001\u0014IO\r\t\u0001AI$\u0004\u0005\u0006\u0003!}\u0011\u0002B\u0005\u0004\u000b\u0005Ay\u0003g\f\u0019 A\u001b\t!(\u0007\u0005\u0001!\tS\u0002C\u0003\u0002\u0011?IA!C\u0002\u0006\u0003!\u0011\u0002D\u0005M\u0010!\u000e\t\u0011\u0005B\u0003\u0002\u0011ga\t\u0001g\rR\u0007%!\t%C\u0001\t55\t\u0001BC\u0007\u0002\u0011Ei\u0011\u0001C\t.X\u0011\tQcA\u0003\u0002\u0011\u001fAz\u0001g\u0011\u001e\u001a\u0011\u0001\u0001\u0012H\u0007\t\u000b\u0005Ay\"\u0003\u0003\n\u0007\u0015\t\u0001r\u0006M\u00181?\u00016\u0011AO\b\t\u0001A!%D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0003\u0005\"Q!\u0001E\u001a\u0019\u0003A\u001a$U\u0002\n\t\u0007J\u0011\u0001\u0003\u000e\u000e\u0003!QQ\"\u0001\u0005\u0012\u001b\u0005Aa\"L\u000e\u0005\u0003U\u0019Q!\u0001E\u00161WA*%h\u0004\u0005\u0001!\u0019SbA\u0003\u0002\u0011WAZ\u0003UB\u0001C\r)\u0011\u0001#\u000b\u0019*E\u001bq\u0001\"\u0012\n\u0003\u0011\u0005Q\"\u0001\u0005\u0017\u001b\u0005Aa#\u000e\u0007\u0006\u0017\u0011\u0019\u000f\u0001g\u0003\"\u0007\u0015\t\u0001b\u0001\r\u0004#\u000e\u0019A1B\u0005\u0002\t\u0001\u0001"})
public final class KotlinSteppingCommandProvider
extends JvmSteppingCommandProvider {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinSteppingCommandProvider.class);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOverCommand(@Nullable SuspendContextImpl suspendContext, boolean ignoreBreakpoints, int stepSize) {
        void destination;
        void $receiver;
        Object it;
        Iterable $receiver2;
        void strict;
        void $receiver3;
        JetNamedFunction containingFunction;
        boolean bl;
        Object element22;
        List<JetFunction> inlinedArguments;
        JetFile file;
        ReferenceType computedReferenceType;
        SourcePosition sourcePosition2;
        Location location2;
        block23: {
            void $receiver4;
            if (suspendContext == null || suspendContext.isResumed()) {
                return null;
            }
            Location location3 = (Location)this.computeInManagerThread(suspendContext, getStepOverCommand.location.1.INSTANCE$);
            if (location3 == null) {
                return null;
            }
            location2 = location3;
            SourcePosition sourcePosition3 = suspendContext.getDebugProcess().getPositionManager().getSourcePosition(location2);
            if (sourcePosition3 == null) {
                return null;
            }
            sourcePosition2 = sourcePosition3;
            ReferenceType referenceType = location2.declaringType();
            if (referenceType == null) {
                return null;
            }
            computedReferenceType = referenceType;
            PsiFile psiFile = sourcePosition2.getFile();
            if (!(psiFile instanceof JetFile)) {
                psiFile = null;
            }
            JetFile jetFile = (JetFile)psiFile;
            if (jetFile == null) {
                return null;
            }
            file = jetFile;
            SourcePosition sourcePosition4 = sourcePosition2;
            Intrinsics.checkExpressionValueIsNotNull((Object)sourcePosition4, (String)"sourcePosition");
            List<JetCallExpression> inlineFunctionCalls = this.getInlineFunctionCallsIfAny(sourcePosition4);
            if (inlineFunctionCalls.isEmpty()) {
                return null;
            }
            inlinedArguments = this.getInlinedArgumentsIfAny(inlineFunctionCalls);
            Iterable iterable = inlinedArguments;
            for (Object element22 : $receiver4) {
                JetFunction it2 = (JetFunction)element22;
                PsiElement psiElement2 = it2;
                PsiElement psiElement3 = sourcePosition2.getElementAt();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"sourcePosition.elementAt");
                if (!this.shouldNotUseStepOver(psiElement2, psiElement3)) continue;
                bl = true;
                break block23;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        List<PsiElement> additionalElementsToSkip = this.getAdditionalElementsToSkip(sourcePosition2.getElementAt());
        element22 = sourcePosition2.getElementAt();
        boolean it2 = false;
        JetNamedFunction jetNamedFunction = containingFunction = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver3, JetNamedFunction.class, (boolean)strict);
        if (jetNamedFunction == null) {
            return null;
        }
        int startLineNumber = JetRefactoringUtilKt.getLineNumber(jetNamedFunction, true);
        JetNamedFunction jetNamedFunction2 = containingFunction;
        if (jetNamedFunction2 == null) {
            return null;
        }
        int endLineNumber = JetRefactoringUtilKt.getLineNumber(jetNamedFunction2, false);
        IntRange linesRange = new IntRange(startLineNumber + 1, endLineNumber + 1);
        Iterable iterable = computedReferenceType.allLineLocations();
        boolean yielding22 = false;
        Collection list = new ArrayList();
        for (Object item : $receiver2) {
            if (yielding22) {
                ((ArrayList)list).add(item);
                continue;
            }
            it = (Location)item;
            if (Intrinsics.areEqual((Object)it, (Object)location2) ^ true) continue;
            ((ArrayList)list).add(item);
            yielding22 = true;
        }
        $receiver2 = CollectionsKt.drop((Iterable)((List)list), (int)1);
        Iterable yielding22 = $receiver2;
        list = new ArrayList();
        for (Object element3 : $receiver) {
            it = (Location)element3;
            if (!(Intrinsics.areEqual((Object)it.method(), (Object)location2.method()) && linesRange.contains(it.lineNumber()))) continue;
            destination.add(element3);
        }
        $receiver2 = (List)destination;
        boolean yielding = false;
        list = new ArrayList();
        for (Object item : $receiver2) {
            if (yielding) {
                ((ArrayList)list).add(item);
                continue;
            }
            it = (Location)item;
            if (it.lineNumber() == location2.lineNumber()) continue;
            ((ArrayList)list).add(item);
            yielding = true;
        }
        List locations = (List)list;
        for (Location locationAtLine : locations) {
            boolean bl2;
            int lineStartOffset;
            block25: {
                boolean bl3;
                JetFunction it3;
                Iterable $receiver5;
                block24: {
                    Object item;
                    int lineNumber = locationAtLine.lineNumber();
                    Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber - 1);
                    if (n == null) {
                        continue;
                    }
                    lineStartOffset = ((Number)n).intValue();
                    item = inlinedArguments;
                    for (Object element4 : $receiver5) {
                        it3 = (JetFunction)element4;
                        if (!it3.getTextRange().contains(lineStartOffset)) continue;
                        bl3 = true;
                        break block24;
                    }
                    bl3 = false;
                }
                if (bl3) continue;
                $receiver5 = additionalElementsToSkip;
                for (Object element4 : $receiver5) {
                    it3 = (PsiElement)element4;
                    if (!it3.getTextRange().contains(lineStartOffset)) continue;
                    bl2 = true;
                    break block25;
                }
                bl2 = false;
            }
            if (bl2) continue;
            PsiElement psiElement4 = file.findElementAt(lineStartOffset);
            if (psiElement4 == null) {
                continue;
            }
            PsiElement elementAt = psiElement4;
            XSourcePositionImpl xSourcePositionImpl = XSourcePositionImpl.createByElement((PsiElement)elementAt);
            if (xSourcePositionImpl == null) {
                return null;
            }
            XSourcePositionImpl xPosition = xSourcePositionImpl;
            return suspendContext.getDebugProcess().createRunToCursorCommand(suspendContext, (XSourcePosition)xPosition, ignoreBreakpoints);
        }
        DebugProcessImpl.ResumeCommand resumeCommand = suspendContext.getDebugProcess().createStepOutCommand(suspendContext);
        if (resumeCommand == null) {
            Intrinsics.throwNpe();
        }
        return resumeCommand;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiElement> getAdditionalElementsToSkip(PsiElement $receiver) {
        List list;
        ArrayList arrayList;
        void strict4;
        void strict22;
        void $receiver2;
        void strict3;
        Object $receiver3;
        ArrayList result2 = CollectionsKt.arrayListOf((Object[])new PsiElement[0]);
        PsiElement psiElement2 = $receiver;
        boolean bl = false;
        JetIfExpression ifParent = (JetIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver3, JetIfExpression.class, (boolean)strict3);
        if (ifParent != null && this.contains((PsiElement)ifParent.getThen(), $receiver)) {
            Boolean bl2;
            Boolean bl3;
            PsiElement psiElement3 = ifParent.getElseKeyword();
            if (psiElement3 != null) {
                $receiver3 = psiElement3;
                PsiElement it = $receiver3;
                bl3 = result2.add(it);
            } else {
                bl3 = null;
            }
            JetExpression jetExpression = ifParent.getElse();
            if (jetExpression != null) {
                $receiver3 = jetExpression;
                JetExpression it = (JetExpression)$receiver3;
                bl2 = result2.add(it);
            } else {
                bl2 = null;
            }
        }
        PsiElement it = $receiver;
        boolean bl4 = false;
        JetTryExpression tryParent = (JetTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetTryExpression.class, (boolean)strict22);
        if (tryParent != null) {
            Iterable $receiver4;
            PsiElement strict22 = $receiver;
            boolean bl5 = false;
            JetCatchClause catchClause = (JetCatchClause)PsiTreeUtil.getParentOfType((PsiElement)$receiver4, JetCatchClause.class, (boolean)strict4);
            if (catchClause != null) {
                void destination;
                void $receiver5;
                $receiver4 = tryParent.getCatchClauses();
                arrayList = result2;
                Iterable strict4 = $receiver4;
                Collection collection = new ArrayList();
                for (Object element2 : $receiver5) {
                    JetCatchClause it2 = (JetCatchClause)element2;
                    if (!(Intrinsics.areEqual((Object)it2, (Object)catchClause) ^ true)) continue;
                    destination.add(element2);
                }
                list = (List)destination;
                arrayList.addAll(list);
            }
        }
        PsiElement $receiver6 = $receiver;
        boolean $receiver5 = false;
        JetWhenEntry whenEntry = (JetWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver6, JetWhenEntry.class, (boolean)strict4);
        if (whenEntry != null && this.contains((PsiElement)whenEntry.getExpression(), $receiver)) {
            void strict52;
            PsiElement strict6 = (PsiElement)whenEntry;
            boolean destination = false;
            JetWhenExpression whenParent = (JetWhenExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver8, JetWhenExpression.class, (boolean)strict52);
            if (whenParent != null) {
                void destination2;
                void $receiver7;
                Iterable $receiver8 = whenParent.getEntries();
                arrayList = result2;
                Iterable strict52 = $receiver8;
                Collection collection = new ArrayList();
                for (Object element3 : $receiver7) {
                    JetWhenEntry it3 = (JetWhenEntry)element3;
                    if (!(Intrinsics.areEqual((Object)it3, (Object)whenEntry) ^ true)) continue;
                    destination2.add(element3);
                }
                list = (List)destination2;
                arrayList.addAll(list);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldNotUseStepOver(PsiElement $receiver, PsiElement elementAt) {
        void strict;
        Object[] $receiver2;
        int strict32;
        Object[] $receiver3;
        boolean strict2;
        void strict42;
        void $receiver4;
        PsiElement psiElement2 = $receiver;
        boolean bl = false;
        JetIfExpression ifParent = (JetIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver4, JetIfExpression.class, (boolean)strict42);
        if (ifParent != null) {
            void $receiver5;
            if (this.contains((PsiElement)ifParent.getCondition(), $receiver)) {
                return true;
            }
            PsiElement strict42 = elementAt;
            boolean bl2 = false;
            JetIfExpression ifParentElementAt = (JetIfExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver5, JetIfExpression.class, (boolean)strict2);
            if (ifParentElementAt == null) {
                if (this.contains((PsiElement)ifParent.getThen(), $receiver)) {
                    return true;
                }
                if (this.contains((PsiElement)ifParent.getElse(), $receiver)) {
                    return true;
                }
            }
        }
        PsiElement $receiver5 = $receiver;
        strict2 = false;
        JetTryExpression tryParent = (JetTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver5, JetTryExpression.class, (boolean)strict2);
        if (tryParent != null && this.contains((PsiElement)tryParent.getTryBlock(), $receiver)) {
            return true;
        }
        PsiElement strict22 = $receiver;
        boolean bl3 = false;
        JetWhenEntry whenEntry = (JetWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver3, JetWhenEntry.class, strict32 != 0);
        if (whenEntry == null) return false;
        $receiver3 = whenEntry.getConditions();
        for (strict32 = 0; strict32 < $receiver3.length; ++strict32) {
            Object element2 = $receiver3[strict32];
            JetWhenCondition it = (JetWhenCondition)element2;
            if (!this.contains((PsiElement)it, $receiver)) continue;
            return true;
        }
        boolean bl4 = false;
        if (bl4) {
            return true;
        }
        if (!this.contains((PsiElement)whenEntry.getExpression(), $receiver)) return false;
        PsiElement strict32 = elementAt;
        boolean element2 = false;
        JetWhenEntry jetWhenEntry = (JetWhenEntry)PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetWhenEntry.class, (boolean)strict);
        if (jetWhenEntry == null) return true;
        JetWhenEntry parentEntryElementAt = jetWhenEntry;
        if (!Intrinsics.areEqual((Object)parentEntryElementAt, (Object)whenEntry)) return false;
        $receiver2 = whenEntry.getConditions();
        int n = 0;
        while (n < $receiver2.length) {
            Object element3 = $receiver2[n];
            JetWhenCondition it = (JetWhenCondition)element3;
            if (this.contains((PsiElement)it, elementAt)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final boolean contains(PsiElement $receiver, PsiElement element2) {
        PsiElement psiElement2 = $receiver;
        return psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.contains(element2.getTextRange()) : false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public DebugProcessImpl.ResumeCommand getStepOutCommand(@Nullable SuspendContextImpl suspendContext, int stepSize) {
        void destination;
        void $receiver;
        Location it;
        Iterable $receiver2;
        if (suspendContext == null || suspendContext.isResumed()) {
            return null;
        }
        Location location2 = (Location)this.computeInManagerThread(suspendContext, getStepOutCommand.location.1.INSTANCE$);
        if (location2 == null) {
            return null;
        }
        Location location3 = location2;
        SourcePosition sourcePosition2 = suspendContext.getDebugProcess().getPositionManager().getSourcePosition(location3);
        if (sourcePosition2 == null) {
            return null;
        }
        SourcePosition sourcePosition3 = sourcePosition2;
        ReferenceType referenceType = location3.declaringType();
        if (referenceType == null) {
            return null;
        }
        ReferenceType computedReferenceType = referenceType;
        List<Location> locations = computedReferenceType.allLineLocations();
        PsiFile psiFile = sourcePosition3.getFile();
        if (!(psiFile instanceof JetFile)) {
            psiFile = null;
        }
        JetFile jetFile = (JetFile)psiFile;
        if (jetFile == null) {
            return null;
        }
        JetFile file = jetFile;
        Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, sourcePosition3.getLine());
        if (n == null) {
            return null;
        }
        int lineStartOffset = ((Number)n).intValue();
        Iterable iterable = locations;
        boolean yielding22 = false;
        Collection list = new ArrayList();
        for (Object item : $receiver2) {
            if (yielding22) {
                ((ArrayList)list).add(item);
                continue;
            }
            it = (Location)item;
            if (it.lineNumber() != location3.lineNumber()) continue;
            ((ArrayList)list).add(item);
            yielding22 = true;
        }
        $receiver2 = (List)list;
        Iterable yielding22 = $receiver2;
        list = new ArrayList();
        for (Object element2 : $receiver) {
            it = (Location)element2;
            if (!Intrinsics.areEqual((Object)it.method(), (Object)location3.method())) continue;
            destination.add(element2);
        }
        List nextLineLocations = (List)destination;
        List<JetNamedFunction> inlineFunction = this.getInlineFunctionsIfAny(file, lineStartOffset);
        if (CollectionsKt.isNotEmpty((Collection)inlineFunction)) {
            XSourcePositionImpl xSourcePositionImpl = this.getXPositionForStepOutFromInlineFunction(suspendContext, nextLineLocations, inlineFunction);
            if (xSourcePositionImpl == null) {
                return null;
            }
            XSourcePositionImpl xPosition = xSourcePositionImpl;
            return suspendContext.getDebugProcess().createRunToCursorCommand(suspendContext, (XSourcePosition)xPosition, true);
        }
        JetFunctionLiteral inlinedArgument = this.getInlineArgumentIfAny(file, lineStartOffset);
        if (inlinedArgument != null) {
            XSourcePositionImpl xSourcePositionImpl = this.getXPositionForStepOutFromInlinedArgument(suspendContext, nextLineLocations, inlinedArgument);
            if (xSourcePositionImpl == null) {
                return null;
            }
            XSourcePositionImpl xPosition = xSourcePositionImpl;
            return suspendContext.getDebugProcess().createRunToCursorCommand(suspendContext, (XSourcePosition)xPosition, true);
        }
        return null;
    }

    private final XSourcePositionImpl getXPositionForStepOutFromInlineFunction(SuspendContextImpl $receiver, List<? extends Location> locations, List<? extends JetNamedFunction> inlineFunctionsToSkip) {
        return this.getNextPositionWithFilter($receiver, locations, (Function2<? super JetFile, ? super Integer, ? extends Boolean>)((Function2)new Function2<JetFile, Integer, Boolean>(this, inlineFunctionsToSkip){
            final /* synthetic */ KotlinSteppingCommandProvider this$0;
            final /* synthetic */ List $inlineFunctionsToSkip;

            public final boolean invoke(@NotNull JetFile file, int offset2) {
                boolean bl;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                    Iterable $receiver = this.$inlineFunctionsToSkip;
                    for (T element2 : $receiver) {
                        JetNamedFunction it = (JetNamedFunction)element2;
                        if (!it.getTextRange().contains(offset2)) continue;
                        bl = true;
                        break block2;
                    }
                    bl = false;
                }
                if (bl) {
                    return true;
                }
                JetFunctionLiteral inlinedArgument = KotlinSteppingCommandProvider.access$getInlineArgumentIfAny$2(this.this$0, file, offset2);
                return inlinedArgument != null && inlinedArgument.getTextRange().contains(offset2);
            }
            {
                this.this$0 = kotlinSteppingCommandProvider;
                this.$inlineFunctionsToSkip = list;
                super(2);
            }
        }));
    }

    private final XSourcePositionImpl getXPositionForStepOutFromInlinedArgument(SuspendContextImpl $receiver, List<? extends Location> locations, JetFunctionLiteral inlinedArgumentToSkip) {
        return this.getNextPositionWithFilter($receiver, locations, (Function2<? super JetFile, ? super Integer, ? extends Boolean>)((Function2)new Function2<JetFile, Integer, Boolean>(inlinedArgumentToSkip){
            final /* synthetic */ JetFunctionLiteral $inlinedArgumentToSkip;

            public final boolean invoke(@NotNull JetFile file, int offset2) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                return this.$inlinedArgumentToSkip.getTextRange().contains(offset2);
            }
            {
                this.$inlinedArgumentToSkip = jetFunctionLiteral;
                super(2);
            }
        }));
    }

    private final XSourcePositionImpl getNextPositionWithFilter(SuspendContextImpl $receiver, List<? extends Location> locations, Function2<? super JetFile, ? super Integer, ? extends Boolean> skip2) {
        for (Location location2 : locations) {
            JetFile file;
            SourcePosition sourcePosition2 = $receiver.getDebugProcess().getPositionManager().getSourcePosition(location2);
            Object object = sourcePosition2 != null ? sourcePosition2.getFile() : null;
            if (!(object instanceof JetFile)) {
                object = null;
            }
            if ((JetFile)object == null) {
                continue;
            }
            int currentLine = location2.lineNumber() - 1;
            Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, currentLine);
            if (n == null) {
                continue;
            }
            int lineStartOffset = ((Number)n).intValue();
            if (((Boolean)skip2.invoke((Object)file, (Object)lineStartOffset)).booleanValue()) continue;
            PsiElement psiElement2 = file.findElementAt(lineStartOffset);
            if (psiElement2 == null) {
                continue;
            }
            PsiElement elementAt = psiElement2;
            return XSourcePositionImpl.createByElement((PsiElement)elementAt);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JetNamedFunction> getInlineFunctionsIfAny(JetFile file, int offset2) {
        void destination;
        void $receiver;
        void $receiver2;
        void strict;
        void $receiver3;
        PsiElement elementAt;
        PsiElement psiElement2 = file.findElementAt(offset2);
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        boolean bl = false;
        JetNamedFunction jetNamedFunction = (JetNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$receiver3, JetNamedFunction.class, (boolean)strict);
        if (jetNamedFunction == null) {
            return CollectionsKt.emptyList();
        }
        JetNamedFunction containingFunction = jetNamedFunction;
        DeclarationDescriptor descriptor2 = ResolutionUtils.resolveToDescriptor(containingFunction);
        if (!InlineUtil.isInline(descriptor2)) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = DebuggerUtils.analyzeElementWithInline(ResolutionUtils.getResolutionFacade(containingFunction), ResolutionUtils.analyzeFully(containingFunction), containingFunction, false);
        void var8_9 = $receiver2;
        Collection collection = new ArrayList();
        for (Object element2 : $receiver) {
            if (!(element2 instanceof JetNamedFunction)) continue;
            destination.add(element2);
        }
        List inlineFunctionsCalls = (List)destination;
        return inlineFunctionsCalls;
    }

    /*
     * WARNING - void declaration
     */
    private final JetFunctionLiteral getInlineArgumentIfAny(JetFile file, int offset2) {
        void strict;
        void $receiver;
        PsiElement elementAt;
        PsiElement psiElement2 = file.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement psiElement3 = elementAt = psiElement2;
        boolean bl = false;
        JetFunctionLiteralExpression jetFunctionLiteralExpression = (JetFunctionLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetFunctionLiteralExpression.class, (boolean)strict);
        if (jetFunctionLiteralExpression == null) {
            return null;
        }
        JetFunctionLiteralExpression functionLiteralExpression = jetFunctionLiteralExpression;
        BindingContext context = ResolutionUtils.analyze(functionLiteralExpression, BodyResolveMode.PARTIAL);
        if (!InlineUtil.isInlinedArgument(functionLiteralExpression.getFunctionLiteral(), context, false)) {
            return null;
        }
        return functionLiteralExpression.getFunctionLiteral();
    }

    private final boolean isKotlinStrataAvailable(SuspendContextImpl suspendContext) {
        Object object = suspendContext.getFrameProxy();
        if (object == null || (object = object.location()) == null || (object = object.declaringType()) == null || (object = object.availableStrata()) == null) {
            return false;
        }
        Object availableStrata = object;
        return availableStrata.contains("Kotlin");
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T computeInManagerThread(SuspendContextImpl suspendContext, Function1<? super SuspendContextImpl, ? extends T> action) {
        Unit unit;
        void result2;
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        DebuggerCommandImpl worker2 = new DebuggerCommandImpl(this, suspendContext, (Ref.ObjectRef)result2, action, semaphore){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ KotlinSteppingCommandProvider this$0;
            final /* synthetic */ SuspendContextImpl $suspendContext;
            final /* synthetic */ Ref.ObjectRef $result;
            final /* synthetic */ Function1 $action;
            final /* synthetic */ Semaphore $semaphore;

            static {
                $kotlinClass = Reflection.createKotlinClass(computeInManagerThread.worker.1.class);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void action() {
                try {
                    if (KotlinSteppingCommandProvider.access$isKotlinStrataAvailable$3(this.this$0, this.$suspendContext)) {
                        this.$result.element = this.$action.invoke((Object)this.$suspendContext);
                    }
                }
                finally {
                    this.$semaphore.up();
                }
            }
            {
                this.this$0 = $outer;
                this.$suspendContext = $captured_local_variable$1;
                this.$result = $captured_local_variable$2;
                this.$action = $captured_local_variable$3;
                this.$semaphore = $captured_local_variable$4;
            }
        };
        DebuggerManagerThreadImpl debuggerManagerThreadImpl = suspendContext.getDebugProcess().getManagerThread();
        if (debuggerManagerThreadImpl != null) {
            debuggerManagerThreadImpl.invoke(worker2);
            unit = Unit.INSTANCE$;
        } else {
            unit = null;
        }
        int n = 0;
        int n2 = 25;
        if (n <= n2) {
            void i;
            while (!semaphore.waitFor(20L) && i != n2) {
                ++i;
            }
        }
        return (T)result2.element;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JetFunction> getInlinedArgumentsIfAny(List<? extends JetCallExpression> inlineFunctionCalls) {
        void destination;
        void $receiver;
        Iterable $receiver2 = inlineFunctionCalls;
        Iterable iterable = $receiver2;
        Collection collection = new ArrayList();
        for (Object element2 : $receiver) {
            JetExpression jetExpression;
            JetFunctionLiteralExpression it;
            Collection collection2;
            Collection destination2;
            Iterable $receiver3;
            Iterable $receiver4;
            JetCallExpression it2 = (JetCallExpression)element2;
            Iterable iterable2 = it2.getValueArguments();
            void var9_9 = $receiver4;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
            for (Object item : $receiver3) {
                JetValueArgument jetValueArgument = (JetValueArgument)item;
                collection2 = destination2;
                jetExpression = ((JetValueArgument)((Object)it)).getArgumentExpression();
                collection2.add(jetExpression);
            }
            $receiver4 = (List)destination2;
            $receiver3 = $receiver4;
            destination2 = new ArrayList();
            for (Object element3 : $receiver3) {
                if (!(element3 instanceof JetFunctionLiteralExpression)) continue;
                destination2.add(element3);
            }
            $receiver4 = (List)destination2;
            $receiver3 = $receiver4;
            destination2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
            for (Object item : $receiver3) {
                it = (JetFunctionLiteralExpression)item;
                collection2 = destination2;
                jetExpression = it.getFunctionLiteral();
                collection2.add(jetExpression);
            }
            Iterable list = (List)destination2;
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        return (List)destination;
    }

    /*
     * WARNING - void declaration
     */
    private final List<JetCallExpression> getInlineFunctionCallsIfAny(SourcePosition sourcePosition2) {
        void destination;
        void $receiver;
        JetCallExpression it;
        Iterable destination2;
        Iterable $receiver2;
        Iterable $receiver3;
        PsiFile psiFile = sourcePosition2.getFile();
        if (!(psiFile instanceof JetFile)) {
            psiFile = null;
        }
        JetFile jetFile = (JetFile)psiFile;
        if (jetFile == null) {
            return CollectionsKt.emptyList();
        }
        JetFile file = jetFile;
        int lineNumber = sourcePosition2.getLine();
        PsiElement elementAt = sourcePosition2.getElementAt();
        Integer n = JetRefactoringUtilKt.getLineStartOffset((PsiFile)file, lineNumber);
        Integer n2 = JetRefactoringUtilKt.getLineEndOffset((PsiFile)file, lineNumber);
        int endOffset = n2 != null ? ((Number)n2).intValue() : PsiUtilsKt.getEndOffset(elementAt);
        PsiElement topMostElement = null;
        for (int startOffset = (v755288) != null ? ((Number)(v755288)).intValue() : PsiUtilsKt.getStartOffset(elementAt); !(topMostElement instanceof JetElement) && startOffset < endOffset; ++startOffset) {
            elementAt = file.findElementAt(startOffset);
            if (elementAt == null) continue;
            topMostElement = CodeInsightUtils.getTopmostElementAtOffset(elementAt, startOffset);
        }
        if (!(topMostElement instanceof JetElement)) {
            return CollectionsKt.emptyList();
        }
        int start = PsiUtilsKt.getStartOffset(topMostElement);
        int end = PsiUtilsKt.getEndOffset(topMostElement);
        getInlineFunctionCallsIfAny.1 isInlineCall$ = getInlineFunctionCallsIfAny.1.INSTANCE$;
        Iterable iterable = CodeInsightUtils.findElementsOfClassInRange((PsiFile)file, start, end, JetExpression.class);
        void var13_12 = $receiver3;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver3, (int)10));
        for (Object item : $receiver2) {
            PsiElement psiElement2 = (PsiElement)item;
            void var20_17 = destination2;
            void v4 = it;
            if (v4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetExpression");
            }
            JetExpression jetExpression = JetPsiUtil.getParentCallIfPresent((JetExpression)v4);
            var20_17.add(jetExpression);
        }
        $receiver3 = (List)destination2;
        $receiver2 = $receiver3;
        destination2 = new ArrayList();
        for (Object element2 : $receiver2) {
            if (!(element2 instanceof JetCallExpression)) continue;
            destination2.add(element2);
        }
        $receiver3 = (List)destination2;
        $receiver2 = $receiver3;
        destination2 = new ArrayList();
        for (Object element2 : $receiver2) {
            it = (JetCallExpression)element2;
            if (!getInlineFunctionCallsIfAny.1.INSTANCE$.invoke(it)) continue;
            destination2.add(element2);
        }
        Set allInlineFunctionCalls = CollectionsKt.toSet((Iterable)((List)destination2));
        $receiver3 = new Ref.ObjectRef();
        ((Ref.ObjectRef)$receiver3).element = new IntRange(lineNumber, lineNumber);
        $receiver2 = allInlineFunctionCalls;
        destination2 = $receiver2;
        Collection collection2 = new ArrayList();
        for (Object element3 : $receiver) {
            void linesRange;
            JetCallExpression it2 = (JetCallExpression)element3;
            boolean shouldInclude = ((IntRange)linesRange.element).contains(JetRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1));
            if (shouldInclude) {
                linesRange.element = new IntRange(Math.min(((Number)((IntRange)linesRange.element).getStart()).intValue(), JetRefactoringUtilKt.getLineNumber$default((PsiElement)it2, false, 1)), Math.max(((Number)((IntRange)linesRange.element).getEnd()).intValue(), JetRefactoringUtilKt.getLineNumber((PsiElement)it2, false)));
            }
            if (!shouldInclude) continue;
            destination.add(element3);
        }
        return (List)destination;
    }

    @Nullable
    public static final /* synthetic */ JetFunctionLiteral access$getInlineArgumentIfAny$2(KotlinSteppingCommandProvider $this, @NotNull JetFile file, int offset2) {
        return $this.getInlineArgumentIfAny(file, offset2);
    }

    public static final /* synthetic */ boolean access$isKotlinStrataAvailable$3(KotlinSteppingCommandProvider $this, @NotNull SuspendContextImpl suspendContext) {
        return $this.isKotlinStrataAvailable(suspendContext);
    }
}

