/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.navigation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.idea.decompiler.KotlinClsFileBase;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.idea.stubindex.StaticFacadeIndexUtil;
import org.jetbrains.kotlin.idea.vfilefinder.JsVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.JvmVirtualFileFinderFactory;
import org.jetbrains.kotlin.load.kotlin.PackageClassUtils;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilPackage;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptPackageFragment;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

public final class DecompiledNavigationUtils {
    @Nullable
    public static JetDeclaration getDeclarationFromDecompiledClassFile(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getDeclarationFromDecompiledClassFile"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getDeclarationFromDecompiledClassFile"));
        }
        if (DecompiledNavigationUtils.isLocal(referencedDescriptor)) {
            return null;
        }
        VirtualFile virtualFile = DecompiledNavigationUtils.findVirtualFileContainingDescriptor(project, referencedDescriptor);
        if (virtualFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (!(psiFile instanceof KotlinClsFileBase)) {
            return null;
        }
        return ((KotlinClsFileBase)psiFile).getDeclarationForDescriptor(referencedDescriptor);
    }

    private static boolean isLocal(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ParameterDescriptor) {
            return DecompiledNavigationUtils.isLocal(descriptor2.getContainingDeclaration());
        }
        return DescriptorUtils.isLocal(descriptor2);
    }

    @Nullable
    private static VirtualFile findVirtualFileContainingDescriptor(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "findVirtualFileContainingDescriptor"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "findVirtualFileContainingDescriptor"));
        }
        if (ErrorUtils.isError(referencedDescriptor)) {
            return null;
        }
        ClassId containerClassId = DecompiledNavigationUtils.getContainerClassId(project, referencedDescriptor);
        if (containerClassId == null) {
            return null;
        }
        GlobalSearchScope scopeToSearchIn = JetSourceFilterScope.kotlinSourceAndClassFiles(GlobalSearchScope.allScope((Project)project), project);
        VirtualFileFinderFactory virtualFileFinderFactory = DecompiledNavigationUtils.isFromKotlinJavasriptMetadata(referencedDescriptor) ? JsVirtualFileFinderFactory.SERVICE.getInstance(project) : JvmVirtualFileFinderFactory.SERVICE.getInstance(project);
        VirtualFileFinder fileFinder = virtualFileFinderFactory.create(scopeToSearchIn);
        return fileFinder.findVirtualFileWithHeader(containerClassId);
    }

    private static boolean isFromKotlinJavasriptMetadata(@NotNull DeclarationDescriptor referencedDescriptor) {
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "isFromKotlinJavasriptMetadata"));
        }
        PackageFragmentDescriptor packageFragmentDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, PackageFragmentDescriptor.class, false);
        return packageFragmentDescriptor instanceof KotlinJavascriptPackageFragment;
    }

    @Nullable
    private static ClassId getContainerClassId(@NotNull Project project, @NotNull DeclarationDescriptor referencedDescriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getContainerClassId"));
        }
        if (referencedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referencedDescriptor", "org/jetbrains/kotlin/idea/decompiler/navigation/DecompiledNavigationUtils", "getContainerClassId"));
        }
        DeserializedCallableMemberDescriptor deserializedCallableContainer = DescriptorUtils.getParentOfType(referencedDescriptor, DeserializedCallableMemberDescriptor.class, true);
        if (deserializedCallableContainer != null) {
            return DecompiledNavigationUtils.getContainerClassId(project, deserializedCallableContainer);
        }
        ClassOrPackageFragmentDescriptor containerDescriptor = DescriptorUtils.getParentOfType(referencedDescriptor, ClassOrPackageFragmentDescriptor.class, false);
        if (containerDescriptor instanceof PackageFragmentDescriptor) {
            FqName packageFQN = ((PackageFragmentDescriptor)containerDescriptor).getFqName();
            if (referencedDescriptor instanceof DeserializedCallableMemberDescriptor) {
                DeserializedCallableMemberDescriptor deserializedDescriptor = (DeserializedCallableMemberDescriptor)referencedDescriptor;
                ProtoBuf.Callable proto = deserializedDescriptor.getProto();
                NameResolver nameResolver = deserializedDescriptor.getNameResolver();
                if (proto.hasExtension(JvmProtoBuf.implClassName)) {
                    Name partClassName = nameResolver.getName((Integer)proto.getExtension(JvmProtoBuf.implClassName));
                    FqName partFQN = packageFQN.child(partClassName);
                    Collection<JetFile> multifileFacadeJetFiles = StaticFacadeIndexUtil.getMultifileClassForPart(partFQN, GlobalSearchScope.allScope((Project)project), project);
                    if (multifileFacadeJetFiles.isEmpty()) {
                        return new ClassId(packageFQN, partClassName);
                    }
                    JetFile multifileFacade = multifileFacadeJetFiles.iterator().next();
                    String multifileFacadeName = multifileFacade.getVirtualFile().getNameWithoutExtension();
                    return new ClassId(packageFQN, Name.identifier(multifileFacadeName));
                }
            }
            return PackageClassUtils.getPackageClassId(packageFQN);
        }
        if (containerDescriptor instanceof ClassDescriptor) {
            if (containerDescriptor.getContainingDeclaration() instanceof ClassDescriptor || ExpressionTypingUtils.isLocal(containerDescriptor.getContainingDeclaration(), containerDescriptor)) {
                return DecompiledNavigationUtils.getContainerClassId(project, containerDescriptor.getContainingDeclaration());
            }
            return DescriptorUtilPackage.getClassId((ClassDescriptor)containerDescriptor);
        }
        return null;
    }

    private DecompiledNavigationUtils() {
    }
}

