/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.idea.editor.JetLtGtTypingUtils;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;

public class KotlinTypedHandler
extends TypedHandlerDelegate {
    private static final TokenSet CONTROL_FLOW_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{JetNodeTypes.IF, JetNodeTypes.FOR, JetNodeTypes.WHILE});
    private boolean jetLTTyped;

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        if (!(file instanceof JetFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        switch (c) {
            case '<': {
                this.jetLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JetLtGtTypingUtils.shouldAutoCloseAngleBracket(editor.getCaretModel().getOffset(), editor);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '>': {
                if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JetLtGtTypingUtils.handleJetGTInsert(editor)) {
                    return TypedHandlerDelegate.Result.STOP;
                }
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '{': {
                ASTNode nonWhitespaceSibling;
                PsiElement parent2;
                int offset2 = editor.getCaretModel().getOffset();
                if (offset2 == 0) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(offset2 - 1);
                while (!iterator2.atEnd() && iterator2.getTokenType() == TokenType.WHITE_SPACE) {
                    iterator2.retreat();
                }
                if (iterator2.atEnd() || iterator2.getTokenType() != JetTokens.RPAR) {
                    return TypedHandlerDelegate.Result.CONTINUE;
                }
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement leaf = file.findElementAt(offset2);
                if (leaf != null && (parent2 = leaf.getParent()) != null && CONTROL_FLOW_EXPRESSIONS.contains(parent2.getNode().getElementType()) && (nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)leaf.getNode())) != null && nonWhitespaceSibling.getText().equals(")")) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{", (boolean)false, (boolean)true);
                    KotlinTypedHandler.indentBrace(project, editor, '{');
                    return TypedHandlerDelegate.Result.STOP;
                }
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '.': {
                KotlinTypedHandler.autoPopupMemberLookup(project, editor);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            case '@': {
                KotlinTypedHandler.autoPopupLabelLookup(project, editor);
                return TypedHandlerDelegate.Result.CONTINUE;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void autoPopupMemberLookup(Project project, final Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, (Condition)new Condition<PsiFile>(){

            public boolean value(PsiFile file) {
                int offset2 = editor.getCaretModel().getOffset();
                PsiElement lastElement = file.findElementAt(offset2 - 1);
                if (lastElement == null) {
                    return false;
                }
                String text = lastElement.getText();
                return ".".equals(text) || "?.".equals(text);
            }
        });
    }

    private static void autoPopupLabelLookup(Project project, final Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, (Condition)new Condition<PsiFile>(){

            public boolean value(PsiFile file) {
                int offset2 = editor.getCaretModel().getOffset();
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (!(KotlinTypedHandler.endsWith(chars, offset2, "this@") || KotlinTypedHandler.endsWith(chars, offset2, "return@") || KotlinTypedHandler.endsWith(chars, offset2, "break@") || KotlinTypedHandler.endsWith(chars, offset2, "continue@"))) {
                    return false;
                }
                PsiElement lastElement = file.findElementAt(offset2 - 1);
                if (lastElement == null) {
                    return false;
                }
                return lastElement.getNode().getElementType() == JetTokens.AT;
            }
        });
    }

    private static boolean endsWith(CharSequence chars, int offset2, String text) {
        if (offset2 < text.length()) {
            return false;
        }
        return ((Object)chars.subSequence(offset2 - text.length(), offset2)).toString().equals(text);
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler", "charTyped"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler", "charTyped"));
        }
        if (!(file instanceof JetFile)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (this.jetLTTyped) {
            this.jetLTTyped = false;
            JetLtGtTypingUtils.handleJetAutoCloseLT(editor);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '{' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            int offset2 = editor.getCaretModel().getOffset();
            PsiElement previousElement2 = file.findElementAt(offset2 - 1);
            if (previousElement2 instanceof LeafPsiElement && ((LeafPsiElement)previousElement2).getElementType() == JetTokens.LONG_TEMPLATE_ENTRY_START) {
                editor.getDocument().insertString(offset2, (CharSequence)"}");
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static void indentBrace(final @NotNull Project project, final @NotNull Editor editor, char braceChar) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler", "indentBrace"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler", "indentBrace"));
        }
        final int offset2 = editor.getCaretModel().getOffset() - 1;
        Document document = editor.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset2 < 0 || chars.charAt(offset2) != braceChar) {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset2 - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            boolean isBrace;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            documentManager.commitDocument(document);
            final PsiFile file = documentManager.getPsiFile(document);
            if (file == null || !file.isWritable()) {
                return;
            }
            PsiElement element2 = file.findElementAt(offset2);
            if (element2 == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(offset2);
            FileType fileType = file.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)fileType, (HighlighterIterator)iterator2);
            boolean bl = isBrace = braceMatcher.isLBraceToken(iterator2, chars, fileType) || braceMatcher.isRBraceToken(iterator2, chars, fileType);
            if (element2.getNode() != null && isBrace) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        int newOffset = CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, offset2);
                        editor.getCaretModel().moveToOffset(newOffset + 1);
                        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                        editor.getSelectionModel().removeSelection();
                    }
                });
            }
        }
    }
}

