/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.findUsages.KotlinPropertyFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;

public class KotlinFindPropertyUsagesDialog
extends JavaFindUsagesDialog<KotlinPropertyFindUsagesOptions> {
    private StateRestoringCheckBox cbReaders;
    private StateRestoringCheckBox cbWriters;
    private StateRestoringCheckBox cbOverrides;

    public KotlinFindPropertyUsagesDialog(PsiElement element2, Project project, KotlinPropertyFindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super(element2, project, (FindUsagesOptions)findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    protected KotlinPropertyFindUsagesOptions getFindUsagesOptions() {
        return (KotlinPropertyFindUsagesOptions)this.myFindUsagesOptions;
    }

    public JComponent getPreferredFocusedControl() {
        return this.myCbToSkipResultsWhenOneUsage;
    }

    public void calcFindUsagesOptions(KotlinPropertyFindUsagesOptions options) {
        super.calcFindUsagesOptions((JavaFindUsagesOptions)options);
        options.isReadAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.cbReaders);
        options.isWriteAccess = KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.cbWriters);
        options.setSearchOverrides(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.cbOverrides));
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = new JPanel();
        findWhatPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FindBundle.message((String)"find.what.group", (Object[])new Object[0]), (boolean)true));
        findWhatPanel.setLayout(new BoxLayout(findWhatPanel, 1));
        KotlinPropertyFindUsagesOptions options = this.getFindUsagesOptions();
        this.cbReaders = this.addCheckboxToPanel(JetBundle.message("find.what.property.readers.checkbox", new Object[0]), options.isReadAccess, findWhatPanel, true);
        this.cbWriters = this.addCheckboxToPanel(JetBundle.message("find.what.property.writers.checkbox", new Object[0]), options.isWriteAccess, findWhatPanel, true);
        return findWhatPanel;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        if (coloredComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coloredComponent", "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindPropertyUsagesDialog", "configureLabelComponent"));
        }
        Utils.configureLabelComponent(coloredComponent, (JetNamedDeclaration)this.getPsiElement());
    }

    protected void addUsagesOptions(JPanel optionsPanel) {
        super.addUsagesOptions(optionsPanel);
        JetNamedDeclaration property2 = (JetNamedDeclaration)this.getPsiElement();
        boolean isAbstract = property2.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean isOpen = property2.hasModifier(JetTokens.OPEN_KEYWORD);
        if (isOpen || isAbstract) {
            this.cbOverrides = this.addCheckboxToPanel(isAbstract ? JetBundle.message("find.what.implementing.properties.checkbox", new Object[0]) : JetBundle.message("find.what.overriding.properties.checkbox", new Object[0]), FindSettings.getInstance().isSearchOverloadedMethods(), optionsPanel, false);
        }
    }

    protected void update() {
        this.setOKActionEnabled(KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.cbReaders) || KotlinFindPropertyUsagesDialog.isSelected((JCheckBox)this.cbWriters));
    }
}

