/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.JavaHierarchyUtil;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Function;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetEnumEntry;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCallHierarchyNodeDescriptor
extends HierarchyNodeDescriptor
implements Navigatable {
    private int usageCount;
    private final Set<PsiReference> references;
    private final CallHierarchyNodeDescriptor javaDelegate;

    public KotlinCallHierarchyNodeDescriptor(@NotNull Project project, HierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement element2, boolean isBase, boolean navigateToReference) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCallHierarchyNodeDescriptor", "<init>"));
        }
        super(project, (NodeDescriptor)parentDescriptor, element2, isBase);
        this.usageCount = 0;
        this.references = new HashSet<PsiReference>();
        this.javaDelegate = new CallHierarchyNodeDescriptor(this.myProject, null, element2, isBase, navigateToReference);
    }

    public final CallHierarchyNodeDescriptor getJavaDelegate() {
        return this.javaDelegate;
    }

    public final void addReference(PsiReference reference) {
        if (this.references.add(reference)) {
            ++this.usageCount;
        }
        this.javaDelegate.addReference(reference);
    }

    public final PsiElement getTargetElement() {
        return this.getPsiElement();
    }

    public final boolean isValid() {
        PsiElement myElement = this.getPsiElement();
        return myElement != null && myElement.isValid();
    }

    public final boolean update() {
        CompositeAppearance oldText = this.myHighlightedText;
        Icon oldIcon = this.getIcon();
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement targetElement = this.getTargetElement();
        String elementText = KotlinCallHierarchyNodeDescriptor.renderElement(targetElement);
        if (elementText == null) {
            String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newIcon = targetElement.getIcon(flags);
        if (changes && this.myIsBase) {
            LayeredIcon icon = new LayeredIcon(2);
            icon.setIcon(newIcon, 0);
            icon.setIcon(AllIcons.Hierarchy.Base, 1, -AllIcons.Hierarchy.Base.getIconWidth() / 2, 0);
            newIcon = icon;
        }
        this.setIcon(newIcon);
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes mainTextAttributes = null;
        if (this.myColor != null) {
            mainTextAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        String packageName = null;
        if (targetElement instanceof JetElement) {
            packageName = JetPsiUtil.getPackageName((JetElement)targetElement);
        } else {
            PsiClass enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)targetElement, PsiClass.class, (boolean)false);
            if (enclosingClass != null) {
                packageName = JavaHierarchyUtil.getPackageName((PsiClass)enclosingClass);
            }
        }
        this.myHighlightedText.getEnding().addText(elementText, mainTextAttributes);
        if (this.usageCount > 1) {
            this.myHighlightedText.getEnding().addText(IdeBundle.message((String)"node.call.hierarchy.N.usages", (Object[])new Object[]{this.usageCount}), HierarchyNodeDescriptor.getUsageCountPrefixAttributes());
        }
        if (packageName == null) {
            packageName = "";
        }
        this.myHighlightedText.getEnding().addText("  (" + packageName + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText) || !Comparing.equal((Object)this.getIcon(), (Object)oldIcon)) {
            changes = true;
        }
        return changes;
    }

    @Nullable
    private static String renderElement(@Nullable PsiElement element2) {
        String elementText;
        String containerText = null;
        if (element2 instanceof JetFile) {
            elementText = ((JetFile)element2).getName();
        } else if (element2 instanceof JetNamedDeclaration) {
            BindingContext bindingContext2 = ResolutionUtils.analyze((JetElement)element2, BodyResolveMode.FULL);
            DeclarationDescriptor descriptor2 = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
            if (descriptor2 == null) {
                return null;
            }
            if (element2 instanceof JetClassOrObject) {
                if (element2 instanceof JetObjectDeclaration && ((JetObjectDeclaration)element2).isCompanion()) {
                    if (!((descriptor2 = descriptor2.getContainingDeclaration()) instanceof ClassDescriptor)) {
                        return null;
                    }
                    elementText = KotlinCallHierarchyNodeDescriptor.renderClassOrObject((ClassDescriptor)descriptor2);
                } else {
                    elementText = element2 instanceof JetEnumEntry ? ((JetEnumEntry)element2).getName() : (((JetClassOrObject)element2).getName() != null ? KotlinCallHierarchyNodeDescriptor.renderClassOrObject((ClassDescriptor)descriptor2) : "[anonymous]");
                }
            } else if (element2 instanceof JetNamedFunction || element2 instanceof JetSecondaryConstructor) {
                elementText = KotlinCallHierarchyNodeDescriptor.renderNamedFunction((FunctionDescriptor)descriptor2);
            } else if (element2 instanceof JetProperty) {
                elementText = ((JetProperty)element2).getName();
            } else {
                return null;
            }
            for (DeclarationDescriptor containerDescriptor = descriptor2.getContainingDeclaration(); containerDescriptor != null; containerDescriptor = containerDescriptor.getContainingDeclaration()) {
                String name2 = containerDescriptor.getName().asString();
                if (name2.startsWith("<")) continue;
                containerText = name2;
                break;
            }
        } else {
            return null;
        }
        if (elementText == null) {
            return null;
        }
        return containerText != null ? containerText + "." + elementText : elementText;
    }

    public static String renderNamedFunction(FunctionDescriptor descriptor2) {
        DeclarationDescriptor descriptorForName = descriptor2 instanceof ConstructorDescriptor ? descriptor2.getContainingDeclaration() : descriptor2;
        String name2 = descriptorForName.getName().asString();
        String paramTypes = StringUtil.join(descriptor2.getValueParameters(), (Function)new Function<ValueParameterDescriptor, String>(){

            public String fun(ValueParameterDescriptor descriptor2) {
                return DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType(descriptor2.getType());
            }
        }, (String)", ");
        return name2 + "(" + paramTypes + ")";
    }

    private static String renderClassOrObject(ClassDescriptor descriptor2) {
        return descriptor2.getName().asString();
    }

    public void navigate(boolean requestFocus) {
        this.javaDelegate.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.javaDelegate.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.javaDelegate.canNavigateToSource();
    }
}

