/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.calls;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CallHierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.call.CalleeMethodsTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.hierarchy.calls.CalleeReferenceVisitorBase;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallHierarchyNodeDescriptor;
import org.jetbrains.kotlin.idea.hierarchy.calls.KotlinCallTreeStructure;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassInitializer;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

public class KotlinCalleeMethodsTreeStructure
extends KotlinCallTreeStructure {
    private final CalleeMethodsTreeStructure javaTreeStructure;
    private final PsiClass representativePsiClass;

    public KotlinCalleeMethodsTreeStructure(@NotNull Project project, @NotNull PsiElement element2, String scopeType) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "<init>"));
        }
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "<init>"));
        }
        super(project, element2, scopeType);
        PsiMethod representativePsiMethod = KotlinCalleeMethodsTreeStructure.getRepresentativePsiMethod(element2);
        assert (representativePsiMethod != null);
        this.representativePsiClass = representativePsiMethod.getContainingClass();
        this.javaTreeStructure = new CalleeMethodsTreeStructure(project, representativePsiMethod, scopeType);
    }

    private static Map<PsiReference, PsiElement> getReferencesToCalleeElements(@NotNull JetElement rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "getReferencesToCalleeElements"));
        }
        ArrayList<JetElement> elementsToAnalyze = new ArrayList<JetElement>();
        if (rootElement instanceof JetNamedFunction) {
            elementsToAnalyze.add(((JetNamedFunction)rootElement).getBodyExpression());
        } else if (rootElement instanceof JetProperty) {
            for (JetPropertyAccessor accessor : ((JetProperty)rootElement).getAccessors()) {
                JetExpression body2 = accessor.getBodyExpression();
                if (body2 == null) continue;
                elementsToAnalyze.add(body2);
            }
        } else {
            JetClassOrObject classOrObject = (JetClassOrObject)rootElement;
            for (JetDelegationSpecifier specifier : classOrObject.getDelegationSpecifiers()) {
                if (!(specifier instanceof JetCallElement)) continue;
                elementsToAnalyze.add(specifier);
            }
            JetClassBody body3 = classOrObject.getBody();
            if (body3 != null) {
                for (JetClassInitializer initializer : body3.getAnonymousInitializers()) {
                    JetExpression initializerBody = initializer.getBody();
                    if (initializerBody == null) continue;
                    elementsToAnalyze.add(initializerBody);
                }
                for (JetProperty property2 : body3.getProperties()) {
                    JetExpression initializer = property2.getInitializer();
                    if (initializer == null) continue;
                    elementsToAnalyze.add(initializer);
                }
            }
        }
        final HashMap<PsiReference, PsiElement> referencesToCalleeElements = new HashMap<PsiReference, PsiElement>();
        for (JetElement element2 : elementsToAnalyze) {
            element2.accept(new CalleeReferenceVisitorBase(ResolutionUtils.analyze(element2, BodyResolveMode.FULL), false){

                @Override
                protected void processDeclaration(JetSimpleNameExpression reference, PsiElement declaration) {
                    referencesToCalleeElements.put(ReferencesPackage.getMainReference(reference), declaration);
                }
            });
        }
        return referencesToCalleeElements;
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor2) {
        PsiMethod psiMethod;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
        }
        PsiElement targetElement = KotlinCalleeMethodsTreeStructure.getTargetElement(descriptor2);
        if (targetElement instanceof PsiMethod && (psiMethod = (PsiMethod)targetElement).isConstructor()) {
            PsiElement navigationElement;
            PsiClass psiClass = psiMethod.getContainingClass();
            PsiElement psiElement2 = navigationElement = psiClass != null ? psiClass.getNavigationElement() : null;
            if (navigationElement instanceof JetClass) {
                Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, (JetElement)navigationElement);
                if (objectArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
                }
                return objectArray;
            }
        }
        if (targetElement instanceof KotlinLightMethod) {
            Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, ((KotlinLightMethod)targetElement).getOrigin());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        if (targetElement instanceof JetElement) {
            Object[] objectArray = this.buildChildrenByKotlinTarget(descriptor2, (JetElement)targetElement);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
            }
            return objectArray;
        }
        CallHierarchyNodeDescriptor javaDescriptor = descriptor2 instanceof CallHierarchyNodeDescriptor ? (CallHierarchyNodeDescriptor)descriptor2 : ((KotlinCallHierarchyNodeDescriptor)descriptor2).getJavaDelegate();
        Object[] objectArray = this.javaTreeStructure.getChildElements((Object)javaDescriptor);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/hierarchy/calls/KotlinCalleeMethodsTreeStructure", "buildChildren"));
        }
        return objectArray;
    }

    private Object[] buildChildrenByKotlinTarget(HierarchyNodeDescriptor descriptor2, JetElement targetElement) {
        Map<PsiReference, PsiElement> referencesToCalleeElements = KotlinCalleeMethodsTreeStructure.getReferencesToCalleeElements(targetElement);
        return this.collectNodeDescriptors(descriptor2, referencesToCalleeElements, this.representativePsiClass);
    }
}

