/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"+\u0004)\u0011r-\u001a;DC2dg*Y7f\rJ|W\u000eU:j\u0015\u001d)G.Z7f]RT!BS3u\u000b2,W.\u001a8u\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u00019tS*!a*Y7f\u0015\u0011q\u0017-\\3\u000bO-{G\u000f\\5o%\u0016\u001cWO]:jm\u0016\u001c\u0015\r\u001c7MS:,W*\u0019:lKJ\u0004&o\u001c<jI\u0016\u00148\n\u001e\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'NC\u0007hKRd\u0015N\\3Ok6\u0014WM\u001d\u0006\u0004\u0013:$(M\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\t!\u0011\u0001\u0003\u0003\u0006\u0007\u0011\u0015\u0001r\u0001\u0007\u0001\u000b\t!)\u0001c\u0002\u0006\u0005\u0011\r\u0001\"A\u0003\u0002\u0011\u0017)!\u0001\"\u0003\t\r\u0015\u0011A!\u0002\u0005\u0004\u000b\r!Y\u0001C\u0003\r\u0001\u0015\t\u0001RA\u0003\u0004\t\u001bAq\u0001\u0004\u0001\u0006\u0005\u0011-\u0001\"BC\u0018\t\u0005A\u0002!h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001C\u0011)\u0011\u0001C\u0002\r\u0002a\u0019\u0011kA\u0003\u0005\u0001%\t\u0001rA\u0007\u0002\u0011\u0011A6\u0011B\u0003\u0013\t\u0005)2!B\u0001\t\ra1\u0001TB\u0011\u0004\u000b\u0005Aq\u0001G\u0004R\u0007\u0015!i!C\u0001\u0005\u00065\t\u0001r\u0002-\u0004\n\u0001"})
public final class KotlinRecursiveCallLineMarkerProviderKt {
    public static final int getLineNumber(PsiElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Document document = PsiDocumentManager.getInstance((Project)$receiver.getProject()).getDocument($receiver.getContainingFile());
        if (document == null) {
            Intrinsics.throwNpe();
        }
        return document.getLineNumber($receiver.getTextOffset());
    }

    @Nullable
    public static final Name getCallNameFromPsi(@NotNull JetElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetElement jetElement = element2;
        if (jetElement instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression operationReference;
            PsiElement elementParent = ((JetSimpleNameExpression)element2).getParent();
            PsiElement psiElement2 = elementParent;
            if (psiElement2 instanceof JetCallExpression) {
                return Name.identifierNoValidate(((JetSimpleNameExpression)element2).getText());
            }
            if (psiElement2 instanceof JetOperationExpression && Intrinsics.areEqual((Object)element2, (Object)(operationReference = ((JetOperationExpression)elementParent).getOperationReference()))) {
                Name name2;
                IElementType node = operationReference.getReferencedNameElementType();
                if (node instanceof JetToken) {
                    name2 = OperatorConventions.getNameForOperationSymbol((JetToken)node);
                    if (name2 == null) {
                        name2 = Name.identifierNoValidate(((JetSimpleNameExpression)element2).getText());
                    }
                } else {
                    name2 = Name.identifierNoValidate(((JetSimpleNameExpression)element2).getText());
                }
                return name2;
            }
        } else {
            if (jetElement instanceof JetArrayAccessExpression) {
                return Name.identifier("get");
            }
            if (jetElement instanceof JetThisExpression && ((JetThisExpression)element2).getParent() instanceof JetCallExpression) {
                return OperatorConventions.INVOKE;
            }
        }
        return null;
    }
}

