/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.highlighter.DeclarationKindDetector;
import org.jetbrains.kotlin.idea.quickfix.AnnotationHostKind;
import org.jetbrains.kotlin.idea.quickfix.KotlinSuppressIntentionAction;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"w\u0004)a2M]3bi\u0016\u001cV\u000f\u001d9sKN\u001cx+\u0019:oS:<\u0017i\u0019;j_:\u001c(bB3mK6,g\u000e\u001e\u0006\u000b!NLW\t\\3nK:$(bA2p[*A\u0011N\u001c;fY2L'NC\u0002qg&T\u0011\u0003Z5bO:|7\u000f^5d\r\u0006\u001cGo\u001c:z\u0015E!\u0015.Y4o_N$\u0018n\u0019$bGR|'/\u001f\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*YA-[1h]>\u001cH/[2t\u0015\u0011a\u0015n\u001d;\u000b/M+\b\u000f\u001d:fgNLe\u000e^3oi&|g.Q2uS>t'BD2pI\u0016Len\u001d9fGRLwN\u001c\u0006\u0005U\u00064\u0018M\u0003\u0003vi&d'bJ&pi2LgnU;qaJ,7o]1cY\u0016<\u0016M\u001d8j]\u001e\u0004&o\u001c2mK6<%o\\;q\u0017Rd'B\u0001\t\u0004\u0015\u0011A\u0001\u0001\u0005\u0003\u000b\t!\t\u0001#\u0002\u0006\u0007\u0011\t\u0001\"\u0001\u0007\u0001\u000b\u0005AA!\u0002\u0002\u0005\u0005!%QA\u0001C\u0003\u0011\u0015)!\u0001B\u0002\t\f\u0015\u0019Aq\u0001E\u0004\u0019\u0001)\u0011\u0001C\u0003\u0006\u0007\u0011%\u0001B\u0002\u0007\u0001\u000b\t!\t\u0001C\u0004\u0006\u0007\u0011-\u0001R\u0002\u0007\u0001\u000b\u0005Ay!\u0002\u0002\u0005\u000e!AQA\u0001\u0003\b\u0011\u0019)!\u0001B\u0001\t\u0003\u0015\u0011Aq\u0001E\u0004\u000b!\"1\u0001\u0007\u0001\u001e\u0010\u0011\u0001\u0001\u0012A\u0007\u0004\u000b\u0005A\u0019\u0001g\u0001Q\u0007\u0001i\u001a\u0002\u0002\u0001\t\u00075)Q!\u0001\u0005\u0005\u0013\u0005!\u0019\u0001\u0007\u0003Q\u0007\u0003\t\u0003\"B\u0001\t\u000b%!\u0011bA\u0003\u0002\u0011\u0019Ab\u0001G\u0003R\u0007\u001d!\u0001!C\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011#A6\u0011\u0003"})
public final class KotlinSuppressableWarningProblemGroupKt {
    @NotNull
    public static final List<SuppressIntentionAction> createSuppressWarningActions(@NotNull PsiElement element2, @NotNull DiagnosticFactory<?> diagnosticFactory) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(diagnosticFactory, (String)"diagnosticFactory");
        if (Intrinsics.areEqual((Object)((Object)diagnosticFactory.getSeverity()), (Object)((Object)Severity.WARNING)) ^ true) {
            List<SuppressIntentionAction> list = Collections.emptyList();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"Collections.emptyList()");
            return list;
        }
        ArrayList actions = CollectionsKt.arrayListOf((Object[])new SuppressIntentionAction[0]);
        boolean suppressAtStatementAllowed = true;
        for (PsiElement current = element2; current != null; current = current.getParent()) {
            if (current instanceof JetDeclaration && !(current instanceof JetMultiDeclaration)) {
                PsiElement declaration = current;
                AnnotationHostKind kind2 = DeclarationKindDetector.INSTANCE$.detect((JetDeclaration)declaration);
                if (kind2 != null) {
                    actions.add(new KotlinSuppressIntentionAction((JetExpression)declaration, diagnosticFactory, kind2));
                }
                suppressAtStatementAllowed = false;
                continue;
            }
            if (!(current instanceof JetExpression) || !suppressAtStatementAllowed || !(((JetExpression)current).getParent() instanceof JetBlockExpression) && !(((JetExpression)current).getParent() instanceof JetMultiDeclaration)) continue;
            String kind3 = ((JetExpression)current).getParent() instanceof JetBlockExpression ? "statement" : "initializer";
            actions.add(new KotlinSuppressIntentionAction((JetExpression)current, diagnosticFactory, new AnnotationHostKind(kind3, "", true)));
            suppressAtStatementAllowed = false;
        }
        return actions;
    }
}

