/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SyntheticFieldDescriptor;
import org.jetbrains.kotlin.idea.highlighter.AfterAnalysisHighlightingVisitor;
import org.jetbrains.kotlin.idea.highlighter.JetHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.JetPsiChecker;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.TasksPackage;

class PropertiesHighlightingVisitor
extends AfterAnalysisHighlightingVisitor {
    PropertiesHighlightingVisitor(AnnotationHolder holder, BindingContext bindingContext2) {
        super(holder, bindingContext2);
    }

    @Override
    public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitSimpleNameExpression"));
        }
        if (expression2.getParent() instanceof JetThisExpression) {
            return;
        }
        DeclarationDescriptor target = this.bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
        if (target instanceof SyntheticFieldDescriptor) {
            JetPsiChecker.highlightName(this.holder, (PsiElement)expression2, JetHighlightingColors.BACKING_FIELD_VARIABLE);
            return;
        }
        if (!(target instanceof PropertyDescriptor)) {
            return;
        }
        this.highlightProperty((PsiElement)expression2, (PropertyDescriptor)target, false);
        if (expression2.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            JetPsiChecker.highlightName(this.holder, (PsiElement)expression2, JetHighlightingColors.BACKING_FIELD_ACCESS);
        }
    }

    @Override
    public void visitProperty(@NotNull JetProperty property2) {
        if (property2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitProperty"));
        }
        PsiElement nameIdentifier = property2.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        VariableDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.VARIABLE, property2);
        if (propertyDescriptor instanceof PropertyDescriptor) {
            Boolean backingFieldRequired = this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)propertyDescriptor);
            this.highlightProperty(nameIdentifier, (PropertyDescriptor)propertyDescriptor, Boolean.TRUE.equals(backingFieldRequired));
        }
        super.visitProperty(property2);
    }

    @Override
    public void visitParameter(@NotNull JetParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "visitParameter"));
        }
        PsiElement nameIdentifier = parameter.getNameIdentifier();
        if (nameIdentifier == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
        if (propertyDescriptor != null) {
            Boolean backingFieldRequired = this.bindingContext.get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
            this.highlightProperty(nameIdentifier, propertyDescriptor, Boolean.TRUE.equals(backingFieldRequired));
        }
        super.visitParameter(parameter);
    }

    private void highlightProperty(@NotNull PsiElement elementToHighlight, @NotNull PropertyDescriptor descriptor2, boolean withBackingField) {
        if (elementToHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementToHighlight", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "highlightProperty"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/idea/highlighter/PropertiesHighlightingVisitor", "highlightProperty"));
        }
        if (TasksPackage.isDynamic(descriptor2)) {
            JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.DYNAMIC_PROPERTY_CALL);
            return;
        }
        boolean isStatic = DescriptorUtils.isStaticDeclaration(descriptor2);
        JetPsiChecker.highlightName(this.holder, elementToHighlight, isStatic ? JetHighlightingColors.PACKAGE_PROPERTY : JetHighlightingColors.INSTANCE_PROPERTY);
        if (descriptor2.getExtensionReceiverParameter() != null) {
            JetPsiChecker.highlightName(this.holder, elementToHighlight, JetHighlightingColors.EXTENSION_PROPERTY);
        }
        if (withBackingField) {
            this.holder.createInfoAnnotation(elementToHighlight, "This property has a backing field").setTextAttributes(JetHighlightingColors.PROPERTY_WITH_BACKING_FIELD);
        }
    }
}

