/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeHighlighting.Pass;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkerNavigator;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtil;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.idea.highlighter.markers.JavaPsiUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenFunctionMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.OverridenPropertyMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.ResolveWithParentsResult;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerKt;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerNavigationHandler;
import org.jetbrains.kotlin.idea.highlighter.markers.SuperDeclarationMarkerTooltip;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"7\u000e)\u0001\u0012*\u0014)M\u000b6+e\nV#E?6\u000b%k\u0013\u0006\u0005\u0013\u000e|gNC\u0003kCZ\f\u0007PC\u0003to&twMC\nhKRLU\n\u0015'F\u001b\u0016sE+\u0012#`\u001b\u0006\u00136J\u0003\u000eL_Rd\u0017N\u001c'j]\u0016l\u0015M]6feB\u0013xN^5eKJ\\EOC\tJ\u001bBcU)T#O)&suiX'B%.SAcZ3u\u00136\u0003F*R'F\u001dRKejR0N\u0003J[%bE(W\u000bJ\u0013\u0016\n\u0012#F\u001d~3UKT\"U\u0013>s%BC'be.,'\u000fV=qK*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1bY8eK&s7/[4ii*1A-Y3n_:TA![7qY*1r-\u001a;P-\u0016\u0013&+\u0013#E\u000b:{f)\u0016(D)&{eJC\bP-\u0016\u0013&+\u0013#E\u000b:{V*\u0011*L\u0015I9W\r^(W\u000bJ\u0013\u0016\n\u0012#F\u001d~k\u0015IU&\u000b'=3VI\u0015*J\t\u0012+ej\u0018)S\u001fB+%\u000bV-\u000b-\u001d,Go\u0014,F%JKE\tR#O?B\u0013v\nU#S)fSqb\u0014,F%JKE)\u0013(H?6\u000b%k\u0013\u0006\u0013O\u0016$xJV#S%&#\u0015JT$`\u001b\u0006\u00136J\u0003\tT+\n\u001bE*Q*T\u000b\u0012{6\tT!T'*\u0019r-\u001a;T+\n\u001bE*Q*T\u000b\u0012{6\tT!T'*Y2m\u001c7mK\u000e$\u0018J\u001c5fe&$X\rZ\"mCN\u001cX*\u0019:lKJTq!\u001a7f[\u0016tGO\u0003\u0005KKR\u001cE.Y:t\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'b\u00019tS*1!/Z:vYRT\u0011#T;uC\ndWmQ8mY\u0016\u001cG/[8o\u00159a\u0015N\\3NCJ\\WM]%oM>TA!\u00168ji*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u0015\r{G\u000e\\3di&|gN\u0003\u000ed_2dWm\u0019;Pm\u0016\u0014(/\u001b3eK:4UO\\2uS>t7OC\u0005gk:\u001cG/[8og*\u0001\"*\u001a;OC6,GMR;oGRLwN\u001c\u0006#G>dG.Z2u\u001fZ,'O]5eI\u0016t\u0007K]8qKJ$\u00180Q2dKN\u001cxN]:\u000b\u0015A\u0014x\u000e]3si&,7OC\u0006KKR\u0004&o\u001c9feRL(BH2pY2,7\r^*va\u0016\u0014H)Z2mCJ\fG/[8o\u001b\u0006\u00148.\u001a:t\u0015-!Wm\u00197be\u0006$\u0018n\u001c8\u000b\u001d)+G\u000fR3dY\u0006\u0014\u0018\r^5p]*Y\u0012n]%na2,W.\u001a8ug\u0006sGMT8u\u001fZ,'O]5eKNT!\u0002Z3tGJL\u0007\u000f^8s\u0015a\u0019\u0015\r\u001c7bE2,W*Z7cKJ$Um]2sSB$xN\u001d\u0006\fI\u0016\u001c8M]5qi>\u00148OC\tpm\u0016\u0014(/\u001b3eK:lU-\u001c2feNTqAQ8pY\u0016\fg\u000ev\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQa\u0001C\u0001\u0011\u0003a\u0001!\u0002\u0002\u0005\u0002!\u0005Q!\u0001\u0005\u0006\u000b\t!!\u0001c\u0003\u0006\u0005\u0011\u0015\u0001BB\u0003\u0003\t\rAi!\u0002\u0002\u0005\b!9Qa\u0001\u0003\u0005\u0011\u0013a\u0001!\u0002\u0002\u0005\t!%Q!\u0001E\u000e\u000b\t!Y\u0001\u0003\b\u0006\u0005\u00111\u0001RD\u0003\u0003\t\u001bAq\"B\u0002\u0005\u000f!iA\u0002A\u0003\u0002\u0011;)1\u0001\u0002\u0005\t!1\u0001Qa\u0001C\u0004\u0011Ca\u0001!B\u0002\u0005\u0011!\tB\u0002A\u0003\u0003\t\u001dAQ\"B\u0001\t$\u0015\u0011AQ\u0003\u0005\u0013\u000b\t!1\u0002#\n\u0006\u0007\u0011A\u0001R\u0005\u0007\u0001\u000b\r!q\u0001\u0003\u000b\r\u0001\u0015\u0019Aa\u0002E\u0016\u0019\u0001)1\u0001B\u0004\t/1\u0001QA\u0001\u0003\b\u0011])!\u0001\"\u0004\t3\u0015\u0019AQ\u0004E\u0019\u0019\u0001)1\u0001\u0002\u0005\t51\u0001QA\u0001C\u000f\u0011c)\u0019\u0003B1\u00051\u0001\t3!B\u0001\t\u0003a\tQk\u0001\u0005\u0006\u0007\u0011\u0001\u0011\"\u0001E\u0002\u001b\r!!!C\u0001\t\u0004a\u001b)!b\t\u0005C\u0012A2!I\u0002\u0006\u0003!\t\u0001$A+\u0004\u0011\u0015\u0019AaA\u0005\u0002\u0011\u0007i1\u0001b\u0002\n\u0003!\r\u0001l!\u0002\u0006$\u0011\tG\u0001\u0007\u0003\"\u0007\u0015\t\u0001\u0012\u0002M\u0005+\u000eAQa\u0001\u0003\u0005\u0013\u0005AQ!D\u0002\u0005\u0010%\t\u0001\"\u0002-\u0004\u0006\u0015\rB!\u0019\u0003\u0019\u0011\u0005\u001aQ!\u0001\u0005\u00021\u0005)6\u0001C\u0003\u0004\t!I\u0011\u0001c\u0001\u000e\u0007\u0011E\u0011\"\u0001E\u00021\u000e\u0015Q1\u0005\u0003b\taI\u0011eA\u0003\u0002\u0011\u0013AJ!V\u0002\t\u000b\r!\u0011\"C\u0001\t\u000b5\u0019A1C\u0005\u0002\u0011\u0015A6QAC\u0012\t\u0005$\u0001DC\u0011\u0004\u000b\u0005A\u0011\u0001G\u0001V\u0007!)1\u0001\u0002\u0006\n\u0003!\rQb\u0001C\u000b\u0013\u0005A\u0019\u0001WB\u0003\u000bG!\u0011\r\u0002\r\fC\r)\u0011\u0001#\u0003\u0019\nU\u001b\u0001\"B\u0002\u0005\u0017%\t\u0001\"B\u0007\u0004\t/I\u0011\u0001C\u0003Y\u0007\u000b)\u0001\u0006B\u0001\u0019\u0019u=A\u0001\u0001E\r\u001b\r)\u0011\u0001c\u0004\u0019\u0010A\u001b\u0001!(\b\u0005\u0001!}QBC\u0003\u0002\u0011#Ia!C\u0003\u0006\u0003!I\u0011\"\u0001C\u00021%A\n\u0002UB\u0001C\r)\u0011\u0001c\u0005\u0019\u0014E\u001bq\u0001\u0002\u0007\n\u0003\u0011\u0001Q\"\u0001\u0005\u000b\u001b\u0005A9\u0002WB\u0003\u000b5\"\u0011\u0001G\n\u001e\u001a\u0011\u0001\u0001rE\u0007\t\u000b\u0005AA\"\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0004M\r11\u00016\u0001AO\u000f\t\u0001Ay\"\u0004\u0006\u0006\u0003!E\u0011BB\u0005\u0006\u000b\u0005A\u0011\"C\u0001\u0005\u0004aI\u0001\u0014\u0003)\u0004\u0002\u0005\u001aQ!\u0001E\n1'\t6a\u0002\u0003\u0014\u0013\u0005!\u0001!D\u0001\t\u00185\t\u0001r\u0003-\u0004\u0006\u0015iC!\u0001M\u0015;3!\u0001\u0001C\u000b\u000e\u0011\u0015\t\u0001\u0002D\u0005\u0005\u0013\r)\u0011\u0001C\u0007\u0019\u001baa\u0001k\u0001\u0001\u001e\u001e\u0011\u0001\u0001rD\u0007\u000b\u000b\u0005A\t\"\u0003\u0004\n\u000b\u0015\t\u0001\"C\u0005\u0002\t\u0007A\u0012\u0002'\u0005Q\u0007\u0003\t3!B\u0001\t\u0014aM\u0011kA\u0004\u0005*%\tA\u0001A\u0007\u0002\u0011/i\u0011\u0001c\u0006Y\u0007\u000b)\u0001\u0006B\u0001\u0019-u=A\u0001\u0001E\u0017\u001b\r)\u0011\u0001c\u0007\u0019\u001cA\u001b\u0001!(\b\u0005\u0001!}QBC\u0003\u0002\u0011#Ia!C\u0003\u0006\u0003!I\u0011\"\u0001C\u00021%A\n\u0002UB\u0001C\r)\u0011\u0001c\u0005\u0019\u0014E\u001bq\u0001\u0002\f\n\u0003\u0011\u0001Q\"\u0001\u0005\u000f\u001b\u0005A9\u0002WB\u0003\u000b\u0019\"\u0011\u0001g\f\u001e\u0010\u0011\u0001\u0001\u0002G\u0007\u0004\u000b\u0005Aq\u0002G\bQ\u0007\u0001iJ\u0002\u0002\u0001\t45AQ!\u0001\u0005\r\u0013\u0011I1!B\u0001\t\u001fay\u0001\u0004\u0004)\u0004\u0002\u0005\u001aQ!\u0001E\u00101?\t6a\u0002C\u0018\u0013\u0005!\t!D\u0001\t!5\t\u0001r\u0003-\u0004\u0006\u0001"})
public final class KotlinLineMarkerProviderKt {
    @NotNull
    static final Icon OVERRIDING_MARK;
    @NotNull
    static final Icon IMPLEMENTING_MARK;
    @NotNull
    static final Icon OVERRIDDEN_MARK;
    @NotNull
    static final Icon IMPLEMENTED_MARK;
    @NotNull
    static final MarkerType SUBCLASSED_CLASS;
    @NotNull
    static final MarkerType OVERRIDDEN_FUNCTION;
    @NotNull
    static final MarkerType OVERRIDDEN_PROPERTY;

    @NotNull
    public static final Icon getOVERRIDING_MARK() {
        return OVERRIDING_MARK;
    }

    @NotNull
    public static final Icon getIMPLEMENTING_MARK() {
        return IMPLEMENTING_MARK;
    }

    @NotNull
    public static final Icon getOVERRIDDEN_MARK() {
        return OVERRIDDEN_MARK;
    }

    @NotNull
    public static final Icon getIMPLEMENTED_MARK() {
        return IMPLEMENTED_MARK;
    }

    @NotNull
    public static final MarkerType getSUBCLASSED_CLASS() {
        return SUBCLASSED_CLASS;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_FUNCTION() {
        return OVERRIDDEN_FUNCTION;
    }

    @NotNull
    public static final MarkerType getOVERRIDDEN_PROPERTY() {
        return OVERRIDDEN_PROPERTY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isImplementsAndNotOverrides(@NotNull CallableMemberDescriptor descriptor2, @NotNull Collection<? extends CallableMemberDescriptor> overriddenMembers) {
        Object element2;
        CallableMemberDescriptor it;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(overriddenMembers, (String)"overriddenMembers");
        if (!(Intrinsics.areEqual((Object)((Object)descriptor2.getModality()), (Object)((Object)Modality.ABSTRACT)) ^ true)) return false;
        Iterable $receiver = overriddenMembers;
        Iterator iterator2 = $receiver.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while (Intrinsics.areEqual((Object)((Object)(it = (CallableMemberDescriptor)(element2 = iterator2.next())).getModality()), (Object)((Object)Modality.ABSTRACT)));
        return false;
    }

    public static final void collectSuperDeclarationMarkers(@NotNull JetDeclaration declaration, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        PreconditionsKt.assert((declaration instanceof JetNamedFunction || declaration instanceof JetProperty ? 1 : 0) != 0);
        if (!declaration.hasModifier(JetTokens.OVERRIDE_KEYWORD)) {
            return;
        }
        ResolveWithParentsResult resolveWithParents = SuperDeclarationMarkerKt.resolveDeclarationWithParents(declaration);
        if (resolveWithParents.getOverriddenDescriptors().isEmpty()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = resolveWithParents.getDescriptor();
        if (callableMemberDescriptor == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = KotlinLineMarkerProviderKt.isImplementsAndNotOverrides(callableMemberDescriptor, resolveWithParents.getOverriddenDescriptors());
        LineMarkerInfo marker = new LineMarkerInfo((PsiElement)declaration, declaration.getTextOffset(), bl ? IMPLEMENTING_MARK : OVERRIDING_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, (Function)SuperDeclarationMarkerTooltip.INSTANCE$, (GutterIconNavigationHandler)new SuperDeclarationMarkerNavigationHandler());
        result2.add(marker);
    }

    public static final void collectInheritedClassMarker(@NotNull JetClass element2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        boolean isTrait = element2.isInterface();
        if (!(isTrait || element2.hasModifier(JetTokens.OPEN_KEYWORD) || element2.hasModifier(JetTokens.ABSTRACT_KEYWORD))) {
            return;
        }
        PsiClass psiClass = LightClassUtil.INSTANCE$.getPsiClass(element2);
        if (psiClass == null) {
            return;
        }
        PsiClass lightClass2 = psiClass;
        if (ClassInheritorsSearch.search((PsiClass)lightClass2, (boolean)false).findFirst() == null) {
            return;
        }
        PsiElement psiElement2 = element2.getNameIdentifier();
        if (psiElement2 == null) {
            psiElement2 = element2;
        }
        PsiElement anchor2 = psiElement2;
        result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), isTrait ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, SUBCLASSED_CLASS.getTooltip(), SUBCLASSED_CLASS.getNavigationHandler()));
    }

    public static final void collectOverriddenPropertyAccessors(@NotNull Collection<? extends JetProperty> properties2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(properties2, (String)"properties");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashMap<PsiMethod, JetProperty> mappingToJava = new HashMap<PsiMethod, JetProperty>();
        for (JetProperty jetProperty : properties2) {
            if (!JetPsiUtilKt.isOverridable(jetProperty)) continue;
            LightClassUtil.PropertyAccessorsPsiMethods accessorsPsiMethods = LightClassUtil.INSTANCE$.getLightClassPropertyMethods(jetProperty);
            for (PsiMethod psiMethod : accessorsPsiMethods) {
                mappingToJava.put(psiMethod, jetProperty);
            }
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keySet()");
        Set<PsiClass> set = JavaPsiUtilsKt.collectContainingClasses(collection);
        for (JetProperty property3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = property3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = property3;
            }
            PsiElement anchor2 = psiElement2;
            result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), OverridenPropertyMarkerKt.isImplemented(property3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, OVERRIDDEN_PROPERTY.getTooltip(), OVERRIDDEN_PROPERTY.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    public static final void collectOverriddenFunctions(@NotNull Collection<? extends JetNamedFunction> functions2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(functions2, (String)"functions");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        HashMap<PsiMethod, JetNamedFunction> mappingToJava = new HashMap<PsiMethod, JetNamedFunction>();
        for (JetNamedFunction jetNamedFunction : functions2) {
            PsiMethod method;
            if (!JetPsiUtilKt.isOverridable(jetNamedFunction) || (method = LightClassUtil.INSTANCE$.getLightClassMethod(jetNamedFunction)) == null) continue;
            mappingToJava.put(method, jetNamedFunction);
        }
        Collection collection = mappingToJava.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"mappingToJava.keySet()");
        Set<PsiClass> set = JavaPsiUtilsKt.collectContainingClasses(collection);
        for (JetNamedFunction function3 : OverridenFunctionMarkerKt.getOverriddenDeclarations((Map)mappingToJava, set)) {
            ProgressManager.checkCanceled();
            PsiElement psiElement2 = function3.getNameIdentifier();
            if (psiElement2 == null) {
                psiElement2 = function3;
            }
            PsiElement anchor2 = psiElement2;
            result2.add(new LineMarkerInfo(anchor2, anchor2.getTextOffset(), OverridenPropertyMarkerKt.isImplemented(function3) ? IMPLEMENTED_MARK : OVERRIDDEN_MARK, Pass.UPDATE_OVERRIDEN_MARKERS, OVERRIDDEN_FUNCTION.getTooltip(), OVERRIDDEN_FUNCTION.getNavigationHandler(), GutterIconRenderer.Alignment.RIGHT));
        }
    }

    static {
        Icon icon = AllIcons.Gutter.OverridingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Gutter.OverridingMethod");
        OVERRIDING_MARK = icon;
        Icon icon2 = AllIcons.Gutter.ImplementingMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon2, (String)"AllIcons.Gutter.ImplementingMethod");
        IMPLEMENTING_MARK = icon2;
        Icon icon3 = AllIcons.Gutter.OverridenMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon3, (String)"AllIcons.Gutter.OverridenMethod");
        OVERRIDDEN_MARK = icon3;
        Icon icon4 = AllIcons.Gutter.ImplementedMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon4, (String)"AllIcons.Gutter.ImplementedMethod");
        IMPLEMENTED_MARK = icon4;
        SUBCLASSED_CLASS = new MarkerType((Function)SUBCLASSED_CLASS.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(SUBCLASSED_CLASS.2.class);
            }

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiClass psiClass = JavaPsiUtilsKt.getPsiClass(element2);
                if (psiClass != null) {
                    PsiClass $receiver = psiClass;
                    PsiClass it = $receiver;
                    MarkerType.navigateToSubclassedClass((MouseEvent)e, (PsiClass)it);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_FUNCTION = new MarkerType((Function)OVERRIDDEN_FUNCTION.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(OVERRIDDEN_FUNCTION.2.class);
            }

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiMethod psiMethod = JavaPsiUtilsKt.getPsiMethod(element2);
                if (psiMethod != null) {
                    PsiMethod $receiver = psiMethod;
                    PsiMethod it = $receiver;
                    OverridenFunctionMarkerKt.navigateToOverriddenMethod(e, it);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
        OVERRIDDEN_PROPERTY = new MarkerType((Function)OVERRIDDEN_PROPERTY.1.INSTANCE$, new LineMarkerNavigator(){
            public static final /* synthetic */ KClass $kotlinClass;

            static {
                $kotlinClass = Reflection.createKotlinClass(OVERRIDDEN_PROPERTY.2.class);
            }

            public void browse(@Nullable MouseEvent e, @Nullable PsiElement element2) {
                Unit unit;
                PsiElement psiElement2 = element2;
                if (psiElement2 != null) {
                    PsiElement $receiver = psiElement2;
                    PsiElement it = $receiver;
                    PsiElement psiElement3 = it.getParent();
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetProperty");
                    }
                    OverridenPropertyMarkerKt.navigateToPropertyOverriddenDeclarations(e, (JetProperty)psiElement3);
                    unit = Unit.INSTANCE$;
                } else {
                    unit = null;
                }
            }
        });
    }
}

