/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import kotlin.CollectionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.editor.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingRangeIntention;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetDotQualifiedExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetMultiDeclaration;
import org.jetbrains.kotlin.psi.JetMultiDeclarationEntry;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0016\u0006)i\"+Z7pm\u00164uN\u001d'p_BLe\u000eZ5dKNLe\u000e^3oi&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015%tG/\u001a8uS>t7O\u0003\u0010KKR\u001cV\r\u001c4UCJ<W\r^5oOJ\u000bgnZ3J]R,g\u000e^5p]*\u0001\"*\u001a;G_J,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'B\u0002\u001fj]&$hH\u0003\nX\u0013RCu,\u0013(E\u000bb{f)U0O\u00036+%BB*ue&twM\u0003\u0003kCZ\f'\u0002\u00027b]\u001eT!#\u00199qY&\u001c\u0017MY5mSRL(+\u00198hK*9Q\r\\3nK:$(\"\u0003+fqR\u0014\u0016M\\4f\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*9q\u000e]3oCBL'\u0002B;uS2Tq!\u00199qYf$vN\u0003\u0004fI&$xN\u001d\u0006\u0007\u000b\u0012LGo\u001c:\u000b\tUs\u0017\u000e\u001eO\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)!\u0001b\u0001\t\u0006\u0015\u0019AA\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\u00071\u0001QA\u0001\u0003\u0002\u0011\u0011)1\u0001b\u0002\t\b1\u0001Q!\u0001E\u0002\u000b\r!I\u0001c\u0003\r\u0001\u0015\t\u0001BB\u0003\u0003\t\u0017Ai!\u0002\u0002\u0005\r!-Q!\u0001E\t\u000b\t!q\u0001C\u0005\u0006\u0005\u0011=\u00012C\u0003\u0003\t!A!\"B\u0002\u0005\u0012!AA\u0002A\u0003\u0003\t#A\u0001\"\u0002\u0002\u0005\b!\u001dQA\u0001\u0003\t\u0011-)1\u0001\"\u0006\t\u00181\u0001Qa\u0001C\u0005\u00111a\u0001!\u0002\u0002\u0005\u0016!]Aa\u0001G\u00033!)\u0011\u0001C\u0002\n\t%\u0019Q!\u0001\u0005\u00051\u0011A2!\f\u0007\u0005CRAR!I\u0002\u0006\u0003!)\u0001$B+\u0004\t\u0015\u0019A!B\u0005\u0002\u0011\u001bic\u0003B\u0006\u0019\u000fu=A\u0001\u0001E\b\u001b\r)\u0011\u0001\u0003\u0003\u0019\tA\u001b\u0001!\t\u0003\u0006\u0003!IA\u0012\u0001\r\n#\u000e)AaB\u0005\u0002\u0011'i\u0011\u0001\u0003\u0006.@\u0011Y\u0001TCO\b\t\u0001Ay!D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001\u0005\f\u001b\r)\u0011\u0001C\u0006\u0019\u0017A\u001b\t!I\u0002\u0006\u0003!]\u0001tC)\u0004\u000f\u0011U\u0011\"\u0001\u0003\u0001\u001b\u0005A!\"D\u0001\t\u0019UbQa\u0003\u0003d\u0002a%\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\u0004\t\u0013I\u0011\u0001\u0002\u0001"})
public final class RemoveForLoopIndicesIntention
extends JetSelfTargetingRangeIntention<JetForExpression> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final String WITH_INDEX_FQ_NAME = "kotlin.withIndex";

    static {
        $kotlinClass = Reflection.createKotlinClass(RemoveForLoopIndicesIntention.class);
    }

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull JetForExpression element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        JetExpression jetExpression = element2.getLoopRange();
        if (!(jetExpression instanceof JetDotQualifiedExpression)) {
            jetExpression = null;
        }
        JetDotQualifiedExpression jetDotQualifiedExpression = (JetDotQualifiedExpression)jetExpression;
        if (jetDotQualifiedExpression == null) {
            return null;
        }
        JetDotQualifiedExpression loopRange = jetDotQualifiedExpression;
        JetMultiDeclaration jetMultiDeclaration = element2.getMultiParameter();
        if (jetMultiDeclaration == null) {
            return null;
        }
        JetMultiDeclaration multiParameter = jetMultiDeclaration;
        if (multiParameter.getEntries().size() != 2) {
            return null;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(element2, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall = CallUtilKt.getResolvedCall(loopRange, bindingContext2);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = resolvedCall;
        if (Intrinsics.areEqual(resolvedCall2 != null && (resolvedCall2 = resolvedCall2.getResultingDescriptor()) != null && (resolvedCall2 = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((Object)resolvedCall2))) != null ? ((FqNameUnsafe)((Object)resolvedCall2)).asString() : null, (Object)this.WITH_INDEX_FQ_NAME) ^ true) {
            return null;
        }
        JetMultiDeclarationEntry indexVar = multiParameter.getEntries().get(0);
        if (CollectionsKt.any((Iterable)((Iterable)ReferencesSearch.search((PsiElement)indexVar)))) {
            return null;
        }
        PsiElement psiElement2 = indexVar.getNameIdentifier();
        return psiElement2 != null ? FixersUtilKt.getRange(psiElement2) : null;
    }

    @Override
    public void applyTo(@NotNull JetForExpression element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetMultiDeclaration jetMultiDeclaration = element2.getMultiParameter();
        if (jetMultiDeclaration == null) {
            Intrinsics.throwNpe();
        }
        JetMultiDeclaration multiParameter = jetMultiDeclaration;
        JetExpression jetExpression = element2.getLoopRange();
        if (jetExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetDotQualifiedExpression");
        }
        JetDotQualifiedExpression loopRange = (JetDotQualifiedExpression)jetExpression;
        JetMultiDeclarationEntry elementVar = multiParameter.getEntries().get(1);
        JetPsiFactory jetPsiFactory = JetPsiFactoryKt.JetPsiFactory((PsiElement)element2);
        Object[] objectArray = new Object[1];
        String string = elementVar.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"elementVar.text");
        objectArray[0] = string;
        JetExpression jetExpression2 = CreateByPatternKt.createExpressionByPattern(jetPsiFactory, "for ($0 in _) {}", objectArray);
        if (jetExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetForExpression");
        }
        JetForExpression loop = (JetForExpression)jetExpression2;
        JetParameter jetParameter = loop.getLoopParameter();
        if (jetParameter == null) {
            Intrinsics.throwNpe();
        }
        multiParameter.replace(jetParameter);
        loopRange.replace((PsiElement)loopRange.getReceiverExpression());
    }

    public RemoveForLoopIndicesIntention() {
        super(JetForExpression.class, "Remove indices in 'for' loop", null, 4, null);
    }
}

