/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.ArraysKt;
import kotlin.IndexedValue;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiUnifierKt;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenConditionInRange;
import org.jetbrains.kotlin.psi.JetWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.JetWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"S\u0004)\t\"*\u001a;XQ\u0016tW\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1\u0001]:j\u0015U9W\r^*vE*,7\r\u001e+p\u0013:$(o\u001c3vG\u0016TQBS3u\u000bb\u0004(/Z:tS>t'\"\b\"sC:\u001c\u0007.\u001a3Ue\u0006t7OZ8s[\u0006$\u0018n\u001c8Vi&d7o\u0013;\u000bA\u001d,Go\u00165f]\u000e{g\u000eZ5uS>t7+\u001e2kK\u000e$8)\u00198eS\u0012\fG/\u001a\u0006\u0011S:$(o\u001c3vG\u0016\u001cVO\u00196fGRT\u0001CS3u/\",gnQ8oI&$\u0018n\u001c8\u000b\u0019Q|W\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u000fM,(M[3di\u0002S!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!B\u0002\u0005\u0004!\u0001A\u0002A\u0003\u0004\t\u0007A1\u0001\u0004\u0001\u0006\u0005\u0011\r\u0001bA\u0003\u0003\t\u0007A\u0001!B\u0002\u0005\u0004!)A\u0002A\u0003\u0003\t\u0007AQ!B\n\u0005\u0007U\u0019Q!\u0001\u0005\u00031\tA*!\t\u0003\u0006\u0003!\u0015A\u0012\u0001M\u0003#\u000e)AQA\u0005\u0002\u0011\ri\u0011\u0001c\u0002Y\u0007\u000f)A\u0003B\u0001\u0016\t\u0015\t\u0001R\u0001G\u00011\u000bAB!\t\u0003\u0006\u0003!\u0015A\u0012\u0001M\u0003#\u000e)A\u0001B\u0005\u0002\u0011\ri\u0011\u0001C\u0002Y\u0007\u000f)!\u0003B\u0002\u0016\u0007\u0015\t\u0001B\u0001\r\u00031\u0013\t3!B\u0001\t\u0005a\u0011\u0011kA\u0003\u0005\n%\t\u0001rA\u0007\u0002\u0011\u000fA6qAC\u001e\t\r)2!B\u0001\t\ta!\u00014BO\t\t\u0001Aa!\u0004\u0003\u0006\u0003!\u0015A\u0012\u0001M\u0003!\u000e\u0005\u0011eA\u0003\u0002\u0011\u000bA*!U\u0002\b\t\u0017I\u0011\u0001C\u0002\u000e\u0003!%Q\"\u0001\u0005\u00041\u000e\u001d\u0001"})
public final class BranchedTransformationUtilsKt {
    @NotNull
    public static final JetExpression toExpression(JetWhenCondition $receiver, @Nullable JetExpression subject) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JetPsiFactory factory2 = JetPsiFactoryKt.JetPsiFactory((PsiElement)$receiver);
        JetWhenCondition jetWhenCondition = $receiver;
        if (jetWhenCondition instanceof JetWhenConditionIsPattern) {
            Object object;
            String op = ((JetWhenConditionIsPattern)$receiver).isNegated() ? "!is" : "is";
            String string = "$" + "0 " + op + " " + "$" + "1";
            Object[] objectArray = new Object[2];
            Object object2 = subject;
            if (object2 == null) {
                object2 = objectArray[0] = "_";
            }
            if ((object = ((JetWhenConditionIsPattern)$receiver).getTypeReference()) == null) {
                object = "";
            }
            objectArray[1] = object;
            return CreateByPatternKt.createExpressionByPattern(factory2, string, objectArray);
        }
        if (jetWhenCondition instanceof JetWhenConditionInRange) {
            Object object;
            String op = ((JetWhenConditionInRange)$receiver).getOperationReference().getText();
            String string = "$" + "0 " + op + " " + "$" + "1";
            Object[] objectArray = new Object[2];
            Object object3 = subject;
            if (object3 == null) {
                object3 = objectArray[0] = "_";
            }
            if ((object = ((JetWhenConditionInRange)$receiver).getRangeExpression()) == null) {
                object = "";
            }
            objectArray[1] = object;
            return CreateByPatternKt.createExpressionByPattern(factory2, string, objectArray);
        }
        if (jetWhenCondition instanceof JetWhenConditionWithExpression) {
            JetExpression jetExpression;
            if (subject != null) {
                Object[] objectArray = new Object[2];
                objectArray[0] = subject;
                Object object = ((JetWhenConditionWithExpression)$receiver).getExpression();
                if (object == null) {
                    object = "";
                }
                objectArray[1] = object;
                jetExpression = CreateByPatternKt.createExpressionByPattern(factory2, "$0 == $1", objectArray);
            } else {
                JetExpression jetExpression2 = ((JetWhenConditionWithExpression)$receiver).getExpression();
                if (jetExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                jetExpression = jetExpression2;
                Intrinsics.checkExpressionValueIsNotNull((Object)jetExpression2, (String)"getExpression()!!");
            }
            return jetExpression;
        }
        throw (Throwable)new IllegalArgumentException("Unknown JetWhenCondition type: " + $receiver);
    }

    @Nullable
    public static final JetExpression getSubjectToIntroduce(JetWhenExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver.getSubjectExpression() != null) {
            return null;
        }
        JetExpression lastCandidate = null;
        for (JetWhenEntry entry : $receiver.getEntries()) {
            JetWhenCondition[] conditions = entry.getConditions();
            if (!entry.isElse() && ArraysKt.isEmpty((Object[])conditions)) {
                return null;
            }
            for (int i = 0; i < conditions.length; ++i) {
                JetSimpleNameExpression candidate;
                JetWhenCondition condition2 = conditions[i];
                if (!(condition2 instanceof JetWhenConditionWithExpression)) {
                    return null;
                }
                JetExpression jetExpression = ((JetWhenConditionWithExpression)condition2).getExpression();
                JetExpression jetExpression2 = jetExpression != null ? BranchedTransformationUtilsKt.getWhenConditionSubjectCandidate(jetExpression) : null;
                if (!(jetExpression2 instanceof JetSimpleNameExpression)) {
                    jetExpression2 = null;
                }
                if ((JetSimpleNameExpression)jetExpression2 == null) {
                    return null;
                }
                if (lastCandidate == null) {
                    lastCandidate = candidate;
                    continue;
                }
                if (JetPsiUnifierKt.matches((PsiElement)lastCandidate, (PsiElement)candidate)) continue;
                return null;
            }
        }
        return lastCandidate;
    }

    @Nullable
    public static final JetExpression getWhenConditionSubjectCandidate(JetExpression $receiver) {
        JetExpression jetExpression;
        JetExpression jetExpression2 = $receiver;
        if (jetExpression2 instanceof JetIsExpression) {
            jetExpression = ((JetIsExpression)$receiver).getLeftHandSide();
        } else if (jetExpression2 instanceof JetBinaryExpression) {
            JetExpression lhs = ((JetBinaryExpression)$receiver).getLeft();
            IElementType op = ((JetBinaryExpression)$receiver).getOperationToken();
            IElementType iElementType = op;
            if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.IN_KEYWORD)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.NOT_IN))) {
                jetExpression = lhs;
            } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.EQEQ))) {
                JetExpression jetExpression3 = lhs;
                if (!(jetExpression3 instanceof JetSimpleNameExpression)) {
                    jetExpression3 = null;
                }
                JetSimpleNameExpression jetSimpleNameExpression = (JetSimpleNameExpression)jetExpression3;
                jetExpression = jetSimpleNameExpression != null ? (JetExpression)jetSimpleNameExpression : ((JetBinaryExpression)$receiver).getRight();
            } else {
                jetExpression = null;
            }
        } else {
            jetExpression = null;
        }
        return jetExpression;
    }

    @NotNull
    public static final JetWhenExpression introduceSubject(JetWhenExpression $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        JetExpression jetExpression = BranchedTransformationUtilsKt.getSubjectToIntroduce($receiver);
        if (jetExpression == null) {
            Intrinsics.throwNpe();
        }
        JetExpression subject = jetExpression;
        JetExpression jetExpression2 = CreateByPatternKt.buildExpression(JetPsiFactoryKt.JetPsiFactory((PsiElement)$receiver), (Function1<? super BuilderByPattern<JetExpression>, ? extends Unit>)((Function1)new Function1<BuilderByPattern<JetExpression>, Unit>($receiver, subject){
            final /* synthetic */ JetWhenExpression receiver$0;
            final /* synthetic */ JetExpression $subject;

            public final void invoke(BuilderByPattern<JetExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                $receiver.appendFixedText("when(").appendExpression(this.$subject).appendFixedText("){\n");
                for (JetWhenEntry entry : this.receiver$0.getEntries()) {
                    JetExpression branchExpression = entry.getExpression();
                    if (entry.isElse()) {
                        $receiver.appendFixedText("else");
                    } else {
                        for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])entry.getConditions())) {
                            int i = indexedValue.component1();
                            JetWhenCondition condition2 = (JetWhenCondition)indexedValue.component2();
                            if (i > 0) {
                                $receiver.appendFixedText(",");
                            }
                            JetWhenCondition jetWhenCondition = condition2;
                            if (jetWhenCondition == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetWhenConditionWithExpression");
                            }
                            JetExpression conditionExpression = ((JetWhenConditionWithExpression)jetWhenCondition).getExpression();
                            JetExpression jetExpression = conditionExpression;
                            if (jetExpression instanceof JetIsExpression) {
                                if (((JetIsExpression)conditionExpression).isNegated()) {
                                    $receiver.appendFixedText("!");
                                }
                                $receiver.appendFixedText("is ");
                                Object object = ((JetIsExpression)conditionExpression).getTypeReference();
                                if (object == null || (object = object.getText()) == null) {
                                    object = "";
                                }
                                $receiver.appendNonFormattedText((String)object);
                                continue;
                            }
                            if (jetExpression instanceof JetBinaryExpression) {
                                JetExpression lhs = ((JetBinaryExpression)conditionExpression).getLeft();
                                JetExpression rhs = ((JetBinaryExpression)conditionExpression).getRight();
                                IElementType op = ((JetBinaryExpression)conditionExpression).getOperationToken();
                                IElementType iElementType = op;
                                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.IN_KEYWORD))) {
                                    $receiver.appendFixedText("in ").appendExpression(rhs);
                                    continue;
                                }
                                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.NOT_IN))) {
                                    $receiver.appendFixedText("!in ").appendExpression(rhs);
                                    continue;
                                }
                                if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)JetTokens.EQEQ))) {
                                    $receiver.appendExpression(JetPsiUnifierKt.matches((PsiElement)this.$subject, (PsiElement)lhs) ? rhs : lhs);
                                    continue;
                                }
                                throw (Throwable)new IllegalStateException();
                            }
                            throw (Throwable)new IllegalStateException();
                        }
                    }
                    $receiver.appendFixedText("->");
                    $receiver.appendExpression(branchExpression);
                    $receiver.appendFixedText("\n");
                }
                $receiver.appendFixedText("}");
            }
            {
                this.receiver$0 = jetWhenExpression;
                this.$subject = jetExpression;
                super(1);
            }
        }));
        if (jetExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetWhenExpression");
        }
        JetWhenExpression whenExpression2 = (JetWhenExpression)jetExpression2;
        PsiElement $receiver2 = (PsiElement)$receiver;
        PsiElement result2 = $receiver2.replace((PsiElement)whenExpression2);
        if (result2 instanceof JetWhenExpression) {
            object = result2;
        } else {
            PsiElement psiElement2 = result2;
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetParenthesizedExpression");
            }
            JetExpression jetExpression3 = ((JetParenthesizedExpression)psiElement2).getExpression();
            if (jetExpression3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            object = (JetWhenExpression)jetExpression3;
        }
        return (JetWhenExpression)object;
    }
}

