/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.branchedTransformations.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.ArraysKt;
import kotlin.IndexedValue;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.intentions.JetSelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.branchedTransformations.BranchedTransformationUtilsKt;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetPsiFactoryKt;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetWhenCondition;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"4\u0006)iR\t\\5nS:\fG/Z,iK:\u001cVO\u00196fGRLe\u000e^3oi&|gNC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0011IG-Z1\u000b\u0015%tG/\u001a8uS>t7OC\fce\u0006t7\r[3e)J\fgn\u001d4pe6\fG/[8og*I\"*\u001a;TK24G+\u0019:hKRLgnZ%oi\u0016tG/[8o\u0015EQU\r^,iK:,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0004aNL'\"\u0005'poB\u0013\u0018n\u001c:jif\f5\r^5p]*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1bY8eK&s7/[4ii*I\u0011N\u001c;f]RLwN\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\u000f\u0005\u0004\b\u000f\\=U_*9Q\r\\3nK:$(BB3eSR|'O\u0003\u0004FI&$xN\u001d\u0006\b_B,g.\u00199j\u0015\u0011)f.\u001b;\u000b\u001d%\u001c\u0018\t\u001d9mS\u000e\f'\r\\3U_*Y1-\u0019:fi>3gm]3u\u0015\rIe\u000e\u001e\u0006\b\u0005>|G.Z1oA\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)!\u0001\"\u0002\t\u0006\u0015\u0019Aa\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\b1\u0001QA\u0001\u0003\u0002\u0011\u0013)1\u0001\"\u0003\t\t1\u0001Q!\u0001E\u0006\u000b\t!Y\u0001\u0003\u0004\u0006\u0005\u00111\u0001RB\u0003\u0003\t\u001bAq!B\u0002\u0005\u000f!)A\u0002A\u0003\u0003\t\u0019A!\"\u0002\u0002\u0005\u0011!IQa\u0001C\t\u0011'a\u0001!B\u0001\t\u0004\u0015\u0019A1\u0003E\u000b\u0019\u0001)!\u0001\"\u0003\t\t\u0015\u0011A\u0011\u0003E\n\u000b\r!\u0019\u0002\u0003\u0007\r\u0001\u0015\u0019A1\u0003E\r\u0019\u0001!1\u0001d\u0002\u001a\u0011\u0015\t\u0001\u0002B\u0005\u0005\u0013\r)\u0011\u0001C\u0003\u0019\u000ba!\u0011dA\u0003\u0002\u0011\u001fAz!l\u0010\u0005\u0017aAQt\u0002\u0003\u0001\u0011#i1!B\u0001\t\u000ba)\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001\"C\u0007\u0004\u000b\u0005A\u0011\u0002G\u0005Q\u0007\u0003\t3!B\u0001\t\u0015aQ\u0011kA\u0004\u0005\u0011%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001C\u0006.@\u0011Y\u0001dCO\b\t\u0001A\t\"D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0001u=A\u0001\u0001E\f\u001b\r)\u0011\u0001c\u0006\u0019\u0018A\u001b\t!I\u0002\u0006\u0003!a\u0001\u0004D)\u0004\u000f\u0011Y\u0011\"\u0001C\u0001\u001b\u0005A)\"D\u0001\u0005\u0006UbQa\u0003\u0003d\u0002a=\u0011eA\u0003\u0002\u0011\u000fA:!U\u0002\u0004\t\u001fI\u0011\u0001\u0002\u0001"})
public final class EliminateWhenSubjectIntention
extends JetSelfTargetingIntention<JetWhenExpression>
implements LowPriorityAction {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(EliminateWhenSubjectIntention.class);
    }

    @Override
    public boolean isApplicableTo(@NotNull JetWhenExpression element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (!(element2.getSubjectExpression() instanceof JetSimpleNameExpression)) {
            return false;
        }
        PsiElement psiElement2 = element2.getOpenBrace();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement lBrace = psiElement2;
        return caretOffset <= PsiUtilsKt.getStartOffset(lBrace);
    }

    @Override
    public void applyTo(@NotNull JetWhenExpression element2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        JetExpression jetExpression = element2.getSubjectExpression();
        if (jetExpression == null) {
            Intrinsics.throwNpe();
        }
        JetExpression subject = jetExpression;
        JetExpression whenExpression2 = CreateByPatternKt.buildExpression(JetPsiFactoryKt.JetPsiFactory((PsiElement)element2), (Function1<? super BuilderByPattern<JetExpression>, ? extends Unit>)((Function1)new Function1<BuilderByPattern<JetExpression>, Unit>(element2, subject){
            final /* synthetic */ JetWhenExpression $element;
            final /* synthetic */ JetExpression $subject;

            public final void invoke(BuilderByPattern<JetExpression> $receiver) {
                Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
                $receiver.appendFixedText("when {\n");
                for (JetWhenEntry entry : this.$element.getEntries()) {
                    JetExpression branchExpression = entry.getExpression();
                    if (entry.isElse()) {
                        $receiver.appendFixedText("else");
                    } else {
                        for (IndexedValue indexedValue : ArraysKt.withIndex((Object[])entry.getConditions())) {
                            int i = indexedValue.component1();
                            JetWhenCondition condition2 = (JetWhenCondition)indexedValue.component2();
                            if (i > 0) {
                                $receiver.appendFixedText(",");
                            }
                            $receiver.appendExpression(BranchedTransformationUtilsKt.toExpression(condition2, this.$subject));
                        }
                    }
                    $receiver.appendFixedText("->");
                    $receiver.appendExpression(branchExpression);
                    $receiver.appendFixedText("\n");
                }
                $receiver.appendFixedText("}");
            }
            {
                this.$element = jetWhenExpression;
                this.$subject = jetExpression;
                super(1);
            }
        }));
        element2.replace((PsiElement)whenExpression2);
    }

    public EliminateWhenSubjectIntention() {
        super(JetWhenExpression.class, "Eliminate argument of 'when'", null, 4, null);
    }
}

