/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.liveTemplates.macro;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.IterableTypesDetection;
import org.jetbrains.kotlin.idea.core.IterableTypesDetector;
import org.jetbrains.kotlin.idea.liveTemplates.macro.JetPsiElementResult;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.ExtensionUtils;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.JetScope;

public abstract class BaseJetVariableMacro
extends Macro {
    @Nullable
    private JetNamedDeclaration[] getVariables(Expression[] params2, ExpressionContext context) {
        if (params2.length != 0) {
            return null;
        }
        Project project = context.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        if (!(psiFile instanceof JetFile)) {
            return null;
        }
        JetExpression contextExpression = BaseJetVariableMacro.findContextExpression(psiFile, context.getStartOffset());
        if (contextExpression == null) {
            return null;
        }
        ResolutionFacade resolutionFacade = ResolutionUtils.getResolutionFacade(contextExpression);
        BindingContext bindingContext2 = resolutionFacade.analyze(contextExpression, BodyResolveMode.FULL);
        JetScope scope2 = bindingContext2.get(BindingContext.RESOLUTION_SCOPE, contextExpression);
        if (scope2 == null) {
            return null;
        }
        IterableTypesDetector detector2 = resolutionFacade.getIdeService(IterableTypesDetection.class).createDetector(scope2);
        DataFlowInfo dataFlowInfo = BindingContextUtilPackage.getDataFlowInfo(bindingContext2, contextExpression);
        ArrayList<VariableDescriptor> filteredDescriptors = new ArrayList<VariableDescriptor>();
        for (DeclarationDescriptor declarationDescriptor : BaseJetVariableMacro.getAllVariables(scope2)) {
            VariableDescriptor variableDescriptor;
            if (!(declarationDescriptor instanceof VariableDescriptor) || (variableDescriptor = (VariableDescriptor)declarationDescriptor).getExtensionReceiverParameter() != null && ExtensionUtils.substituteExtensionIfCallableWithImplicitReceiver(variableDescriptor, scope2, bindingContext2, dataFlowInfo).isEmpty() || !this.isSuitable(variableDescriptor, project, detector2)) continue;
            filteredDescriptors.add(variableDescriptor);
        }
        ArrayList<JetNamedDeclaration> declarations2 = new ArrayList<JetNamedDeclaration>();
        for (VariableDescriptor declarationDescriptor : filteredDescriptors) {
            PsiElement declaration = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            assert (declaration == null || declaration instanceof PsiNamedElement);
            if (!(declaration instanceof JetProperty) && !(declaration instanceof JetParameter)) continue;
            declarations2.add((JetNamedDeclaration)declaration);
        }
        return declarations2.toArray(new JetNamedDeclaration[declarations2.size()]);
    }

    private static Collection<DeclarationDescriptor> getAllVariables(JetScope scope2) {
        ArrayList result2 = ContainerUtil.newArrayList();
        result2.addAll(scope2.getDescriptors(DescriptorKindFilter.VARIABLES, JetScope.ALL_NAME_FILTER));
        for (ReceiverParameterDescriptor implicitReceiver : scope2.getImplicitReceiversHierarchy()) {
            result2.addAll(implicitReceiver.getType().getMemberScope().getDescriptors(DescriptorKindFilter.VARIABLES, JetScope.ALL_NAME_FILTER));
        }
        return result2;
    }

    protected abstract boolean isSuitable(@NotNull VariableDescriptor var1, @NotNull Project var2, @NotNull IterableTypesDetector var3);

    @Nullable
    private static JetExpression findContextExpression(PsiFile psiFile, int startOffset) {
        for (PsiElement e = psiFile.findElementAt(startOffset); e != null; e = e.getParent()) {
            if (!(e instanceof JetExpression)) continue;
            return (JetExpression)e;
        }
        return null;
    }

    public Result calculateResult(@NotNull Expression[] params2, ExpressionContext context) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/BaseJetVariableMacro", "calculateResult"));
        }
        JetNamedDeclaration[] vars = this.getVariables(params2, context);
        if (vars == null || vars.length == 0) {
            return null;
        }
        return new JetPsiElementResult((PsiNamedElement)vars[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params2, ExpressionContext context) {
        if (params2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/kotlin/idea/liveTemplates/macro/BaseJetVariableMacro", "calculateLookupItems"));
        }
        JetNamedDeclaration[] vars = this.getVariables(params2, context);
        if (vars == null || vars.length < 2) {
            return null;
        }
        LinkedHashSet<LookupElementBuilder> set = new LinkedHashSet<LookupElementBuilder>();
        for (JetNamedDeclaration var : vars) {
            set.add(LookupElementBuilder.create((PsiNamedElement)var));
        }
        return set.toArray(new LookupElement[set.size()]);
    }
}

