/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.presentation;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProvider;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.presentation.JetDefaultNamedDeclarationPresentation;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetConstructor;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;

public class JetFunctionPresenter
implements ItemPresentationProvider<JetFunction> {
    public ItemPresentation getPresentation(final @NotNull JetFunction function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/idea/presentation/JetFunctionPresenter", "getPresentation"));
        }
        if (function2 instanceof JetFunctionLiteral) {
            return null;
        }
        return new JetDefaultNamedDeclarationPresentation(function2){

            @Override
            public String getPresentableText() {
                StringBuilder presentation = new StringBuilder(function2.getName() != null ? function2.getName() : "");
                Collection paramsStrings = Collections2.transform(function2.getValueParameters(), (Function)new Function<JetParameter, String>(){

                    public String apply(JetParameter parameter) {
                        String text;
                        JetTypeReference reference;
                        if (parameter != null && (reference = parameter.getTypeReference()) != null && (text = reference.getText()) != null) {
                            return text;
                        }
                        return "?";
                    }
                });
                presentation.append("(").append(StringUtils.join((Collection)paramsStrings, (String)",")).append(")");
                return presentation.toString();
            }

            @Override
            public String getLocationString() {
                if (function2 instanceof JetConstructor) {
                    FqName name2 = ((JetConstructor)function2).getContainingClassOrObject().getFqName();
                    return name2 != null ? String.format("(in %s)", name2) : "";
                }
                FqName name3 = function2.getFqName();
                if (name3 != null) {
                    JetTypeReference receiverTypeRef = function2.getReceiverTypeReference();
                    String extensionLocation = receiverTypeRef != null ? "for " + receiverTypeRef.getText() + " " : "";
                    return String.format("(%sin %s)", extensionLocation, name3.parent());
                }
                return "";
            }
        };
    }
}

