/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.project;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.stubindex.JetExactPackagesIndex;
import org.jetbrains.kotlin.idea.stubindex.JetSourceFilterScope;
import org.jetbrains.kotlin.psi.JetFile;

public class PluginJetFilesProvider {
    @NotNull
    public static Collection<JetFile> allFilesInProject(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/project/PluginJetFilesProvider", "allFilesInProject"));
        }
        ArrayList<JetFile> result2 = new ArrayList<JetFile>();
        GlobalSearchScope scope2 = JetSourceFilterScope.kotlinSources(GlobalSearchScope.allScope((Project)project), project);
        for (String packageWithFiles : JetExactPackagesIndex.getInstance().getAllKeys(project)) {
            result2.addAll(JetExactPackagesIndex.getInstance().get(packageWithFiles, project, scope2));
        }
        ArrayList<JetFile> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/project/PluginJetFilesProvider", "allFilesInProject"));
        }
        return arrayList;
    }

    private PluginJetFilesProvider() {
    }
}

