/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.quickfix.AddFunctionParametersFix;
import org.jetbrains.kotlin.idea.quickfix.ChangeFunctionSignatureFix;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureConfiguration$$TImpl;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.JetParameterInfo;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.psi.JetCallElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"$\n)A\u0012\t\u001a3Gk:\u001cG/[8o!\u0006\u0014\u0018-\\3uKJ\u001ch)\u001b=\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:TA!\u001b3fC*A\u0011/^5dW\u001aL\u0007P\u0003\u000eDQ\u0006tw-\u001a$v]\u000e$\u0018n\u001c8TS\u001et\u0017\r^;sK\u001aK\u0007P\u0003\u0004=S:LGO\u0010\u0006\fG\u0006dG.\u00127f[\u0016tGO\u0003\bKKR\u001c\u0015\r\u001c7FY\u0016lWM\u001c;\u000b\u0007A\u001c\u0018N\u0003\ngk:\u001cG/[8o\t\u0016\u001c8M]5qi>\u0014(B\u0005$v]\u000e$\u0018n\u001c8EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*\t\u0002.Y:UsB,W*[:nCR\u001c\u0007.Z:\u000b\u000f\t{w\u000e\\3b]*qA/\u001f9fgR{7\u000b[8si\u0016t'\"C!se\u0006LH*[:u\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\b\u0015\u0016$H+\u001f9f\u0015\u0015!\u0018\u0010]3t\u0015e\tG\r\u001a)be\u0006lW\r^3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u000b?)+Go\u00115b]\u001e,7+[4oCR,(/Z\"p]\u001aLw-\u001e:bi&|gNC\u0006sK\u001a\f7\r^8sS:<'bD2iC:<WmU5h]\u0006$XO]3\u000b\u000f\u001d,G\u000fV3yi*11\u000b\u001e:j]\u001eTA\u0001\\1oO*q\u0001.Y:Pi\",'/V:bO\u0016\u001c(\u0002\u00034v]\u000e$\u0018n\u001c8\u000b\u0015A\u001b\u0018.\u00127f[\u0016tGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\u0007S:4xn[3\u000b\u000fA\u0014xN[3di*9\u0001K]8kK\u000e$(bB8qK:\f\u0007/\u001b\u0006\u0007K\u0012LGo\u001c:\u000b\r\u0015#\u0017\u000e^8s\u0015\u00111\u0017\u000e\\3\u000b\u000f)+GOR5mK*!QK\\5u\u0015-I7/\u0011<bS2\f'\r\\3\u000b\u000fA\u001b\u0018NR5mK*i\u0011n]\"p]N$(/^2u_J$+A\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0005\u0011\r\u0001RA\u0003\u0004\t\tA\u0001\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001b\u0001\u0007\u0001\u000b\t!\u0011\u0001C\u0003\u0006\u0007\u0011\u001d\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0011\u0001#\u0004\u0006\u0007\u0011%\u0001B\u0002\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\f!=A\u0002A\u0003\u0003\t\u000fAI!\u0002\u0002\u0005\n!1Q!\u0001\u0005\n\u000b\t!y\u0001c\u0005\u0006\u0007\u0011A\u0001\u0012\u0003\u0007\u0001\u000b\t!\u0011\u0001#\u0006\u0006\u0007\u0011I\u0001B\u0003\u0007\u0001\u000b\t!\u0001\u0002#\u0005\u0006\u0005\u0011\r\u0001\u0002D\u0003\u0003\t+AI\"B\u0002\u0005\u0017!]A\u0002A\u0003\u0003\t-A9\"B\u0002\u0005\f!mA\u0002A\u0003\u0003\t\u001fAa\"\u0002\u0002\u0005\u001b!mQ!\u0001\u0005\u0011\u000b\t!a\u0002#\t\u0006\u0005\u0011u\u0001\"B\u0003\u0004\t=Ay\u0002\u0004\u0001\u0006\u0005\u0011y\u0001rD\u0003\u0003\t;A)#\u0002\u0002\u0005\"!\rRa\u0001\u0003\u0012\u0011Ia\u0001!\u0002\u0002\u0005\"!\u0019Ra\u0001\u0003\u0013\u0011Oa\u0001!B\u0002\u0005\b!%B\u0002A\u0003\u0004\t\u0017AQ\u0003\u0004\u0001\u0006\u0005\u0011\t\u0002BE\u0003\u0003\tIA9#\u0002\u0002\u0005\b!%Ra\u0001\u0003\u0010\u0011Ya\u0001!\u0002\u0002\u0005\u001f!1Ba\u0001G\u00033\r)\u0011\u0001C\u0002\u0019\u00075bA!\u0019\u0003\u0019\t\u0005\u001aQ!\u0001\u0005\u00051\u0011)6\u0001B\u0003\u0004\t\u0011I\u0011\u0001#\u0004.\u0019\u0011\tG\u0001G\u0004\"\u0007\u0015\t\u0001B\u0002\r\u0007+\u000e!Qa\u0001\u0003\b\u0013\u0005!\t!L\t\u0005C\u0012A\u0002\"\t\u0005\u0006\u0003!E\u0011\u0002B\u0005\u0004\u000b\u0005A\u0019\u0002g\u0005\u0019\u0012U\u001bA!B\u0002\u0005\u0011%\t\u0001BCW\u000b\t\u0005A2\"I\u0002\u0006\u0003!]\u0001tC)\u0004\u0007\u0011Y\u0011\"\u0001\u0005\r[+!1\u0002G\u0007\"\u0007\u0015\t\u0001\u0012\u0004M\r#\u000e\u0019A!D\u0005\u0002\u00117iS\u0003B\u0001\u0019\u001eu=A\u0001\u0001\u0005\u0010\u001b\r)\u0011\u0001c\b\u0019 A\u001b\u0001!I\u0002\u0006\u0003!1\u0001DB)\u0004\u000b\u0011u\u0011\"\u0001C\u0001\u001b\u0005A\u0001#L\u0016\u0005\u0015a\tRt\u0002\u0003\u0001\u0011Gi1!B\u0001\t$a\r\u0002k\u0001\u0001\u001e\u0012\u0011\u0001\u0001bE\u0007\u0005\u000b\u0005A)\u0003$\u0001\u0019&A\u001b\t!h\u0004\u0005\u0001!!RbA\u0003\u0002\u0011MA2\u0003U\u0002\u0002C\r)\u0011\u0001c\n\u0019(E\u001b\u0011\u0002B\t\n\u0003\u0011\u0001Q\"\u0001\u0005\u0015\u001b\u0005AI#D\u0001\t+5RCa\u0003M\u0016;\u001f!\u0001\u0001c\t\u000e\u0007\u0015\t\u00012\u0005M\u0012!\u000e\u0001Qt\u0002\u0003\u0001\u0011Mi1!B\u0001\t&a\u0015\u0002k!\u0001\u001e\u0010\u0011\u0001\u0001\u0002F\u0007\u0004\u000b\u0005AY\u0003g\u000bQ\u0007\u0005\t3!B\u0001\t\ra1\u0011kA\u0005\u0005,%\tA\u0011A\u0007\u0002\u0011Qi\u0011\u0001#\u000b\u000e\u0003!1RV\u0003\u0003\u00021[\t3!B\u0001\t\ra1\u0011kA\u0002\u0005.%\tA\u0011A[,\u000b+\"1\u001d\u0001M\u0004;\u001f!\u0001\u0001\u0003\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u0017i1!B\u0001\t\u000ba)\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Aa\u0001\u0007\u0004Q\u0007\u0005\t3!B\u0001\t\u0006a\u0015\u0011kA\u0005\u0005\b%\tA\u0001A\u0007\u0002\u0011\u001bi\u0011\u0001C\u0004\u000e\u0003\u0011\u0005\u0001"})
public final class AddFunctionParametersFix
extends ChangeFunctionSignatureFix {
    public static final /* synthetic */ KClass $kotlinClass;
    private final ArrayList<JetType> typesToShorten;
    private final JetCallElement callElement;
    private final boolean hasTypeMismatches;

    static {
        $kotlinClass = Reflection.createKotlinClass(AddFunctionParametersFix.class);
    }

    @NotNull
    public String getText() {
        String string;
        String subjectSuffix;
        List<ValueParameterDescriptor> parameters2 = this.functionDescriptor.getValueParameters();
        List<? extends ValueArgument> arguments2 = this.callElement.getValueArguments();
        int newParametersCnt = arguments2.size() - parameters2.size();
        PreconditionsKt.assert((newParametersCnt > 0 ? 1 : 0) != 0);
        String string2 = subjectSuffix = newParametersCnt > 1 ? "s" : "";
        if (this.isConstructor()) {
            String className = this.functionDescriptor.getContainingDeclaration().getName().asString();
            string = "constructor '" + className + "'";
        } else {
            String functionName = this.functionDescriptor.getName().asString();
            string = "function '" + functionName + "'";
        }
        String callableDescription = string;
        return this.hasTypeMismatches ? "Change the signature of " + callableDescription : "Add parameter" + subjectSuffix + " to " + callableDescription;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        int newParametersCnt = this.callElement.getValueArguments().size() - this.functionDescriptor.getValueParameters().size();
        return newParametersCnt > 0;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CallableDescriptor callableDescriptor = this.functionDescriptor;
        Intrinsics.checkExpressionValueIsNotNull((Object)callableDescriptor, (String)"functionDescriptor");
        JetChangeSignatureKt.runChangeSignature(project, callableDescriptor, this.addParameterConfiguration(), ResolutionUtils.analyzeFully(this.callElement), (PsiElement)this.callElement, this.getText());
    }

    private final JetChangeSignatureConfiguration addParameterConfiguration() {
        return new JetChangeSignatureConfiguration(this){
            public static final /* synthetic */ KClass $kotlinClass;
            final /* synthetic */ AddFunctionParametersFix this$0;

            static {
                $kotlinClass = Reflection.createKotlinClass(addParameterConfiguration.1.class);
            }

            @NotNull
            public JetMethodDescriptor configure(@NotNull JetMethodDescriptor originalDescriptor, @NotNull BindingContext bindingContext2) {
                Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
                return JetChangeSignatureKt.modify(originalDescriptor, (Function1<? super JetMutableMethodDescriptor, ? extends Unit>)((Function1)new Function1<JetMutableMethodDescriptor, Unit>(this, bindingContext2, originalDescriptor){
                    final /* synthetic */ addParameterConfiguration.1 this$0;
                    final /* synthetic */ BindingContext $bindingContext;
                    final /* synthetic */ JetMethodDescriptor $originalDescriptor;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull JetMutableMethodDescriptor it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        List<ValueParameterDescriptor> parameters2 = this.this$0.this$0.functionDescriptor.getValueParameters();
                        List<? extends ValueArgument> arguments2 = AddFunctionParametersFix.access$getCallElement$1(this.this$0.this$0).getValueArguments();
                        CollectingNameValidator validator2 = new CollectingNameValidator(null, null, 3, null);
                        IntRange intRange = CollectionsKt.getIndices((Collection)arguments2);
                        int n = ((Number)intRange.getStart()).intValue();
                        int n2 = ((Number)intRange.getEnd()).intValue();
                        if (n <= n2) {
                            while (true) {
                                Object it2;
                                void $receiver;
                                void i;
                                ValueArgument argument = arguments2.get((int)i);
                                JetExpression expression2 = argument.getArgumentExpression();
                                if (i < parameters2.size()) {
                                    JetType jetType;
                                    String string = parameters2.get((int)i).getName().asString();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parameters.get(i).name.asString()");
                                    validator2.addName(string);
                                    if (expression2 != null) {
                                        it2 = (JetExpression)$receiver;
                                        JetType jetType2 = (JetType)this.$bindingContext.get(BindingContext.SMARTCAST, it2);
                                        if (jetType2 == null) {
                                            jetType2 = this.$bindingContext.getType((JetExpression)it2);
                                        }
                                        jetType = jetType2;
                                    } else {
                                        jetType = null;
                                    }
                                    JetType argumentType = jetType;
                                    JetType parameterType = parameters2.get((int)i).getType();
                                    if (argumentType != null && !JetTypeChecker.DEFAULT.isSubtypeOf(argumentType, parameterType)) {
                                        it.getParameters().get((int)i).setCurrentTypeText(IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE().renderType(argumentType));
                                        AddFunctionParametersFix.access$getTypesToShorten$0(this.this$0.this$0).add(argumentType);
                                    }
                                } else {
                                    Boolean bl;
                                    CallableDescriptor callableDescriptor = this.$originalDescriptor.getBaseDescriptor();
                                    if (callableDescriptor == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.FunctionDescriptor");
                                    }
                                    JetParameterInfo parameterInfo = ChangeFunctionSignatureFix.getNewParameterInfo((FunctionDescriptor)callableDescriptor, this.$bindingContext, argument, (Function1<String, Boolean>)((Function1)validator2));
                                    if (parameterInfo.getOriginalType() != null) {
                                        it2 = (JetType)$receiver;
                                        bl = AddFunctionParametersFix.access$getTypesToShorten$0(this.this$0.this$0).add((JetType)it2);
                                    } else {
                                        bl = null;
                                    }
                                    if (expression2 != null) {
                                        parameterInfo.setDefaultValueForCall(expression2);
                                    }
                                    JetParameterInfo jetParameterInfo = parameterInfo;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)jetParameterInfo, (String)"parameterInfo");
                                    it.addParameter(jetParameterInfo);
                                }
                                if (i == n2) break;
                                ++i;
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$bindingContext = bindingContext2;
                        this.$originalDescriptor = jetMethodDescriptor;
                        super(1);
                    }
                }));
            }

            public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                PsiElement psiElement2 = (PsiElement)CollectionsKt.singleOrNull((Iterable)affectedFunctions);
                if (psiElement2 == null) {
                    return false;
                }
                PsiElement onlyFunction = psiElement2;
                return !AddFunctionParametersFix.access$getHasTypeMismatches$2(this.this$0) && !AddFunctionParametersFix.access$isConstructor$3(this.this$0) && !AddFunctionParametersFix.access$hasOtherUsages$4(this.this$0, onlyFunction);
            }
            {
                this.this$0 = $outer;
            }

            public boolean forcePerformForSelectedFunctionOnly() {
                return JetChangeSignatureConfiguration$$TImpl.forcePerformForSelectedFunctionOnly(this);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasOtherUsages(PsiElement function2) {
        boolean bl;
        block1: {
            Iterable $receiver = (Iterable)ReferencesSearch.search((PsiElement)function2);
            for (Object element2 : $receiver) {
                void strict;
                void $receiver2;
                PsiReference it = (PsiReference)element2;
                PsiElement psiElement2 = it.getElement();
                boolean bl2 = false;
                JetCallElement call = (JetCallElement)PsiTreeUtil.getParentOfType((PsiElement)$receiver2, JetCallElement.class, (boolean)strict);
                if (!(call != null && Intrinsics.areEqual((Object)this.callElement, (Object)call) ^ true)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean isConstructor() {
        return this.functionDescriptor instanceof ConstructorDescriptor;
    }

    public AddFunctionParametersFix(@NotNull JetCallElement callElement2, @NotNull FunctionDescriptor functionDescriptor, boolean hasTypeMismatches) {
        Intrinsics.checkParameterIsNotNull((Object)callElement2, (String)"callElement");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        super((PsiElement)callElement2, functionDescriptor);
        this.callElement = callElement2;
        this.hasTypeMismatches = hasTypeMismatches;
        this.typesToShorten = new ArrayList();
    }

    @NotNull
    public static final /* synthetic */ ArrayList<JetType> access$getTypesToShorten$0(AddFunctionParametersFix $this) {
        return $this.typesToShorten;
    }

    public static final /* synthetic */ boolean access$getHasTypeMismatches$2(AddFunctionParametersFix $this) {
        return $this.hasTypeMismatches;
    }

    public static final /* synthetic */ boolean access$isConstructor$3(AddFunctionParametersFix $this) {
        return $this.isConstructor();
    }

    public static final /* synthetic */ boolean access$hasOtherUsages$4(AddFunctionParametersFix $this, @NotNull PsiElement function2) {
        return $this.hasOtherUsages(function2);
    }
}

