/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionActionsFactory;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintsUtil;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"_\u0006)9\u0012\t\u001a3HK:,'/[2VaB,'OQ8v]\u00124\u0015\u000e\u001f\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*!\u0011\u000eZ3b\u0015!\tX/[2lM&D(B\u0005&fi&sG/\u001a8uS>t\u0017i\u0019;j_:T\u0001CS3u)f\u0004X\rU1sC6,G/\u001a:\u000b\u0007A\u001c\u0018N\u0003\u0004=S:LGO\u0010\u0006\u000eif\u0004X\rU1sC6,G/\u001a:\u000b\u0015U\u0004\b/\u001a:C_VtGMC\u0004KKR$\u0016\u0010]3\u000b\u000bQL\b/Z:\u000b%I,g\u000eZ3sK\u0012,\u0006\u000f]3s\u0005>,h\u000e\u001a\u0006\u0007'R\u0014\u0018N\\4\u000b\t)\fg/\u0019\u0006\u0005Y\u0006twMC\u0007hKR4\u0015-\\5ms:\u000bW.\u001a\u0006\bO\u0016$H+\u001a=u\u0015\u0019IgN^8lK*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\u0004G>l'\u0002C5oi\u0016dG.\u001b6\u000b\u000f=\u0004XM\\1qS*1Q\rZ5u_JTa!\u00123ji>\u0014(\u0002\u00024jY\u0016TqAS3u\r&dWM\u0003\u0003V]&$(bC5t\u0003Z\f\u0017\u000e\\1cY\u0016Tq\u0001U:j\r&dWMC\u0004C_>dW-\u00198\u000b\u000f\u0019\u000b7\r^8ssj\u000f!B\u0001\t\u0002\u0015\u0011A\u0001\u0001\u0005\u0002\u000b\t!\t\u0001c\u0001\u0006\u0005\u0011\t\u0001BA\u0003\u0003\t\u0007A)!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0004\t\tA1\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001\u0002B\u0003\u0004\t\u000fA9\u0001\u0004\u0001\u0006\u0005\u0011\t\u0001RB\u0003\u0004\t\u0013Aa\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001rA\u0003\u0003\t\u0013Aa!B\u0001\t\u0004\u0015\u0019AQ\u0002E\b\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u0011=\u0001\u0012C\u0003\u0003\t!Ay!B\u0001\t\u0018\u0015\u0011A!\u0003\u0005\r\u000b\t!\u0019\u0002#\u0007\u0006\u0005\u0011Q\u0001RC\u0003\u0004\t+A1\u0002\u0004\u0001\u0006\u0005\u0011Q\u0001\"D\u0003\u0004\t/AY\u0002\u0004\u0001\u0006\u0007\u0011\u001d\u0001R\u0004\u0007\u0001\u000b\r!i\u0001C\b\r\u0001\u0015\u0011AQ\u0003\u0005\f\u000b\t!9\u0002c\u0007\u0006\u0005\u0011\u001d\u0001RD\u0003\u0003\t'AA!B\u0002\u0005\u001f!\u0001B\u0002A\u0003\u0004\t\u001bA\t\u0003\u0004\u0001\u0006\u0005\u0011y\u0001\u0002\u0005\u0003\u0004\u0019\u000b\u0001\u0012#\u0007\u0005\u0006\u0003!\u0019\u0011\u0002B\u0005\u0004\u000b\u0005AA\u0001\u0007\u0003\u0019\u0007u\u0005\u0011#\f\u0007\u0005C\u0012Ar!I\u0002\u0006\u0003!9\u0001dB+\u0004\t\u0015\u0019AaB\u0005\u0002\u0011#i+\u0002B\u0006\u0019\u0013\u0005\u001aQ!\u0001\u0005\b1\u001d\t6a\u0001\u0003\n\u0013\u0005A\t\",\u0006\u0005\u0017aM\u0011eA\u0003\u0002\u0011\u001dAr!U\u0002\u0004\t'I\u0011\u0001#\u0005.W\u0011Q\u0001DCO\b\t\u0001A)\"D\u0002\u0006\u0003!Y\u0001d\u0003)\u0004\u0001uEA\u0001\u0001\u0005\u000e\u001b\u0011)\u0011\u0001\u0003\u0007\r\u0002aa\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005AI\u0002'\u0007Q\u0007\u0005\t3!B\u0001\t\u001bai\u0011kA\u0005\u0005\u0015%\tA\u0001A\u0007\u0002\u00117i\u0011\u0001\u0003\b\u000e\u0003!uQf\u000b\u0003\f1?iz\u0001\u0002\u0001\t\u00165\u0019Q!\u0001\u0005\f1-\u00016\u0001AO\t\t\u0001AQ\"\u0004\u0003\u0006\u0003!aA\u0012\u0001\r\r!\u000e\u0005Qt\u0002\u0003\u0001\u00119i1!B\u0001\t a}\u0001kA\u0001\"\u0007\u0015\t\u0001\u0002\u0005\r\u0011#\u000eIAqD\u0005\u0002\t\u0003i\u0011\u0001c\u0007\u000e\u0003!qQ\"\u0001E\u0011k\u0005*\u0001\u0005Br\u00011\u0013iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001AO\b\t\u0001AY!D\u0002\u0006\u0003!)\u0001$\u0002)\u0004\u0002\u0005\u001aQ!\u0001E\u00031\u000b\t6a\u0002C\u0005\u0013\u0005!\u0001!D\u0001\t\f5\t\u0001B\u0002"})
public final class AddGenericUpperBoundFix
extends JetIntentionAction<JetTypeParameter> {
    public static final /* synthetic */ KClass $kotlinClass;
    private final String renderedUpperBound;
    public static final Factory Factory;

    static {
        $kotlinClass = Reflection.createKotlinClass(AddGenericUpperBoundFix.class);
        Factory factory2 = Factory = new Factory(null);
    }

    @NotNull
    public String getText() {
        return "Add '" + this.renderedUpperBound + "' as upper bound for " + ((JetTypeParameter)this.element).getName();
    }

    @NotNull
    public String getFamilyName() {
        return "Add generic upper bound";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        return ((JetTypeParameter)this.element).getName() != null && ((JetTypeParameter)this.element).getExtendsBound() == null;
    }

    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull JetFile file) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PreconditionsKt.assert((((JetTypeParameter)this.element).getExtendsBound() == null ? 1 : 0) != 0, (Object)"Don't know what to do with existing bounds");
        JetTypeReference typeReference = new JetPsiFactory(project).createType(this.renderedUpperBound);
        JetTypeReference jetTypeReference = ((JetTypeParameter)this.element).setExtendsBound(typeReference);
        if (jetTypeReference == null) {
            Intrinsics.throwNpe();
        }
        JetTypeReference insertedTypeReference = jetTypeReference;
        ShortenReferences shortenReferences = ShortenReferences.Companion.getDEFAULT();
        JetElement jetElement = insertedTypeReference;
        Intrinsics.checkExpressionValueIsNotNull((Object)jetElement, (String)"insertedTypeReference");
        ShortenReferences.process$default(shortenReferences, jetElement, null, 2);
    }

    public AddGenericUpperBoundFix(@NotNull JetTypeParameter typeParameter, @NotNull JetType upperBound) {
        Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkParameterIsNotNull((Object)upperBound, (String)"upperBound");
        super((PsiElement)typeParameter);
        this.renderedUpperBound = IdeDescriptorRenderers.INSTANCE$.getSOURCE_CODE().renderType(upperBound);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"w\u0006)9a)Y2u_JL(bF!eI\u001e+g.\u001a:jGV\u0003\b/\u001a:C_VtGMR5y\u0015\ry'o\u001a\u0006\nU\u0016$(M]1j]NTaa[8uY&t'\u0002B5eK\u0006T\u0001\"];jG.4\u0017\u000e\u001f\u0006\u001b\u0015\u0016$\u0018J\u001c;f]RLwN\\!di&|gn\u001d$bGR|'/\u001f\u0006\rGJ,\u0017\r^3BGRLwN\u001c\u0006\tCJ<W/\\3oi*9!*\u001a;UsB,'\"\u0002;za\u0016\u001c(BC;qa\u0016\u0014(i\\;oI*y\u0011J\u001c;f]RLwN\\!di&|gNC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\fG>$W-\u00138tS\u001eDGOC\u0005j]R,g\u000e^5p]*a2M]3bi\u0016\f5\r^5p]N\u0014\u00150\u00138gKJ,gnY3ECR\f'\"D5oM\u0016\u0014XM\\2f\t\u0006$\u0018M\u0003\nJ]\u001a,'/\u001a8dK\u0016\u0013(o\u001c:ECR\f'b\u0002:fg>dg/\u001a\u0006\u0006G\u0006dGn\u001d\u0006\nS:4WM]3oG\u0016TA\u0001T5ti*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b\u001f\u0011|7I]3bi\u0016\f5\r^5p]NT!\u0002Z5bO:|7\u000f^5d\u0015)!\u0015.Y4o_N$\u0018n\u0019\u0006\fI&\fwM\\8ti&\u001c7\u000fp\u0001\u000b\u0005A\u0011!\u0002\u0002\u0005\u0001!\rQA\u0001C\u0001\u0011\t)!\u0001B\u0001\t\u0006\u0015\u0011A1\u0001\u0005\u0004\u000b\r!!\u0001#\u0001\r\u0001\u0015\u0019AQ\u0001\u0005\u0001\u0019\u0001)1\u0001\u0002\u0002\t\b1\u0001QA\u0001\u0003\u0002\u0011\u0017)1\u0001\u0002\u0003\t\u000b1\u0001Q!\u0001\u0005\b\u000b\t!Q\u0001c\u0004\u0006\u0005\u0011-\u0001\u0002C\u0003\u0003\t\u0019A\t\"B\u0002\u0005\u000e!5A\u0002A\u0003\u0003\t\u001bAi!\u0002\u0002\u0005\t!)QA\u0001\u0003\u0002\u0011+)!\u0001\"\u0005\t\u0017\u0015\u0011A!\u0003E\f\u000b\r!\u0019\u0002\u0003\u0006\r\u0001\u0015\t\u0001BA\u0003\u0004\t+AA\u0002\u0004\u0001\u0006\u0003!eQA\u0001C\f\u00115)!\u0001\u0002\u0007\t\u0019\u0015\u0011A1\u0003\u0005\u000b\u000b\t!\u0011\u0001C\b\u0006\u0007\u0011m\u0001R\u0004\u0007\u0001\u000b\t!Y\u0002#\b\u0005\u0007\ba1!G\u0002\u0006\u0003!\u001d\u0001tAW!\t\u0005AB!h\u0004\u0005\u0001!%QbA\u0003\u0002\u0011\u0013AJ\u0001U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0004\u000e\u0007\u0015\t\u0001\u0012\u0002M\u0005!\u000e\u0005\u0011\u0005B\u0003\u0002\u0011\u001da\t\u0001G\u0004R\u0007\u001d!A!C\u0001\t\u00105\t\u0001\u0002C\u0007\u0002\u0011!i#\u0004B\u0001\u0019\u0013u=A\u0001\u0001E\n\u001b\r)\u0011\u0001\u0003\u0006\u0019\u0015A\u001b\u0001!\t\u0005\u0006\u0003!Y\u0011\u0002B\u0005\u0004\u000b\u0005Aq\u0001G\u0004\u0019\u0017E\u001bQ\u0001B\u0005\n\u0003!eQ\"\u0001\u0005\u000e[i!!\u0002g\u0007\u001e\u0010\u0011\u0001\u0001BD\u0007\u0004\u000b\u0005Aa\u0002\u0007\bQ\u0007\u0001\t\u0003\"B\u0001\t\u0017%!\u0011bA\u0003\u0002\u0011\u001dAr\u0001G\u0006R\u0007\u0015!Y\"C\u0001\t\u001a5\t\u0001RD\u001b\u0001"})
    public static final class Factory
    extends JetIntentionActionsFactory {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Factory.class);
        }

        @Override
        @NotNull
        protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
            List<IntentionAction> list;
            Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
            DiagnosticFactory<?> diagnosticFactory = diagnostic.getFactory();
            if (Intrinsics.areEqual(diagnosticFactory, Errors.UPPER_BOUND_VIOLATED)) {
                DiagnosticWithParameters2 upperBoundViolated = (DiagnosticWithParameters2)Errors.UPPER_BOUND_VIOLATED.cast(diagnostic);
                JetType jetType = (JetType)upperBoundViolated.getB();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"upperBoundViolated.b");
                JetType jetType2 = (JetType)upperBoundViolated.getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType2, (String)"upperBoundViolated.a");
                list = CollectionsKt.singletonOrEmptyList(this.createAction(jetType, jetType2));
            } else if (Intrinsics.areEqual(diagnosticFactory, Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED)) {
                InferenceErrorData inferenceData;
                InferenceErrorData inferenceErrorData = inferenceData = (InferenceErrorData)((DiagnosticWithParameters1)Errors.TYPE_INFERENCE_UPPER_BOUND_VIOLATED.cast(diagnostic)).getA();
                Intrinsics.checkExpressionValueIsNotNull((Object)inferenceErrorData, (String)"inferenceData");
                list = this.createActionsByInferenceData(inferenceErrorData);
            } else {
                list = kotlin.CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntentionAction> createActionsByInferenceData(InferenceErrorData inferenceData) {
            void destination;
            void $receiver;
            void $receiver2;
            ConstraintSystem constraintSystem;
            ConstraintSystem constraintSystem2 = inferenceData.constraintSystem;
            if (!(constraintSystem2 instanceof ConstraintSystemImpl)) {
                constraintSystem2 = null;
            }
            if ((constraintSystem = (ConstraintSystemImpl)constraintSystem2) == null || (constraintSystem = ((ConstraintSystemImpl)constraintSystem).filterConstraintsOut(ConstraintPositionKind.TYPE_BOUND_POSITION)) == null) {
                return kotlin.CollectionsKt.emptyList();
            }
            ConstraintSystem successfulConstraintSystem = constraintSystem;
            if (!successfulConstraintSystem.getStatus().isSuccessful()) {
                return kotlin.CollectionsKt.emptyList();
            }
            TypeSubstitutor resultingSubstitutor = successfulConstraintSystem.getResultingSubstitutor();
            Iterable iterable = inferenceData.descriptor.getTypeParameters();
            void var5_5 = $receiver2;
            Collection collection = new ArrayList(kotlin.CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                IntentionAction intentionAction;
                void typeParameterDescriptor;
                TypeParameterDescriptor typeParameterDescriptor2 = (TypeParameterDescriptor)item;
                void var12_12 = destination;
                if (ConstraintsUtil.checkUpperBoundIsSatisfied(successfulConstraintSystem, (TypeParameterDescriptor)typeParameterDescriptor, true)) {
                    intentionAction = null;
                } else if ((JetType)kotlin.CollectionsKt.singleOrNull((Iterable)typeParameterDescriptor.getUpperBounds()) == null) {
                    intentionAction = null;
                } else if (resultingSubstitutor.substitute(typeParameterDescriptor.getDefaultType(), Variance.INVARIANT) == null) {
                    intentionAction = null;
                } else {
                    JetType upperBound;
                    JetType argument;
                    JetType jetType = argument;
                    Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"argument");
                    intentionAction = Factory.createAction(jetType, upperBound);
                }
                IntentionAction intentionAction2 = intentionAction;
                var12_12.add(intentionAction2);
            }
            return kotlin.CollectionsKt.filterNotNull((Iterable)((List)destination));
        }

        private final IntentionAction createAction(JetType argument, JetType upperBound) {
            if (!upperBound.getConstructor().isDenotable()) {
                return null;
            }
            ClassifierDescriptor classifierDescriptor = argument.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            if (typeParameterDescriptor == null) {
                return null;
            }
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor2);
            if (!(psiElement2 instanceof JetTypeParameter)) {
                psiElement2 = null;
            }
            JetTypeParameter jetTypeParameter = (JetTypeParameter)psiElement2;
            if (jetTypeParameter == null) {
                return null;
            }
            JetTypeParameter typeParameterDeclaration = jetTypeParameter;
            return new AddGenericUpperBoundFix(typeParameterDeclaration, upperBound);
        }

        private Factory() {
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

