/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.core.quickfix.QuickFixUtil;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferencesPackage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetSecondaryConstructor;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetTypeReference;

public class AddOpenModifierToClassDeclarationFix
extends JetIntentionAction<JetTypeReference> {
    private JetClass classDeclaration;

    public AddOpenModifierToClassDeclarationFix(@NotNull JetTypeReference typeReference) {
        if (typeReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeReference", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "<init>"));
        }
        super(typeReference);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "isAvailable"));
        }
        if (!super.isAvailable(project, editor, file)) {
            return false;
        }
        JetSimpleNameExpression referenceExpression = (JetSimpleNameExpression)PsiTreeUtil.findChildOfType((PsiElement)this.element, JetSimpleNameExpression.class);
        if (referenceExpression == null) {
            return false;
        }
        JetSimpleNameReference reference = ReferencesPackage.getMainReference(referenceExpression);
        PsiElement target = reference.resolve();
        if (target instanceof JetSecondaryConstructor) {
            target = ((JetSecondaryConstructor)target).getContainingClassOrObject();
        }
        if (target instanceof JetClass && QuickFixUtil.canModifyElement(target)) {
            this.classDeclaration = (JetClass)target;
            return !this.classDeclaration.isEnum() && !this.classDeclaration.isInterface();
        }
        return false;
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("make.element.modifier", this.classDeclaration != null ? this.classDeclaration.getName() : "<unknown>", "open");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.modifier.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "invoke"));
        }
        this.classDeclaration.addModifier(JetTokens.OPEN_KEYWORD);
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public IntentionAction createAction(Diagnostic diagnostic) {
                JetTypeReference typeReference = QuickFixUtil.getParentElementOfType(diagnostic, JetTypeReference.class);
                return typeReference == null ? null : new AddOpenModifierToClassDeclarationFix(typeReference);
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOpenModifierToClassDeclarationFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

