/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.project.PluginJetFilesProvider;
import org.jetbrains.kotlin.idea.quickfix.JetIntentionAction;
import org.jetbrains.kotlin.idea.quickfix.JetSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetModifierListOwner;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetTypeReference;

public class AddOverrideToEqualsHashCodeToStringFix
extends JetIntentionAction<PsiElement> {
    public AddOverrideToEqualsHashCodeToStringFix(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "<init>"));
        }
        super(element2);
    }

    @NotNull
    public String getText() {
        String string = JetBundle.message("add.override.to.equals.hashCode.toString", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = JetBundle.message("add.override.to.equals.hashCode.toString", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "isAvailable"));
        }
        return super.isAvailable(project, editor, file) && AddOverrideToEqualsHashCodeToStringFix.isEqualsHashCodeOrToString(this.element);
    }

    private static boolean isEqualsHashCodeOrToString(@Nullable PsiElement element2) {
        if (!(element2 instanceof JetNamedFunction)) {
            return false;
        }
        JetNamedFunction function2 = (JetNamedFunction)element2;
        String name2 = function2.getName();
        if ("equals".equals(name2)) {
            List<JetParameter> parameters2 = function2.getValueParameters();
            if (parameters2.size() != 1) {
                return false;
            }
            JetTypeReference parameterType = parameters2.iterator().next().getTypeReference();
            return parameterType != null && "Any?".equals(parameterType.getText());
        }
        if ("hashCode".equals(name2) || "toString".equals(name2)) {
            return function2.getValueParameters().isEmpty();
        }
        return false;
    }

    @Override
    protected void invoke(@NotNull Project project, Editor editor, JetFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "invoke"));
        }
        Collection<JetFile> files = PluginJetFilesProvider.allFilesInProject(file.getProject());
        for (JetFile jetFile : files) {
            for (Diagnostic diagnostic : ResolutionUtils.analyzeFully(jetFile).getDiagnostics()) {
                JetModifierListOwner element2;
                if (diagnostic.getFactory() != Errors.VIRTUAL_MEMBER_HIDDEN || !AddOverrideToEqualsHashCodeToStringFix.isEqualsHashCodeOrToString(element2 = (JetModifierListOwner)diagnostic.getPsiElement())) continue;
                element2.addModifier(JetTokens.OVERRIDE_KEYWORD);
                element2.removeModifier(JetTokens.PUBLIC_KEYWORD);
            }
        }
    }

    @NotNull
    public static JetSingleIntentionActionFactory createFactory() {
        JetSingleIntentionActionFactory jetSingleIntentionActionFactory = new JetSingleIntentionActionFactory(){

            @Override
            @Nullable
            public AddOverrideToEqualsHashCodeToStringFix createAction(@NotNull Diagnostic diagnostic) {
                if (diagnostic == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diagnostic", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix$1", "createAction"));
                }
                return new AddOverrideToEqualsHashCodeToStringFix(diagnostic.getPsiElement());
            }
        };
        if (jetSingleIntentionActionFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/quickfix/AddOverrideToEqualsHashCodeToStringFix", "createFactory"));
        }
        return jetSingleIntentionActionFactory;
    }
}

