/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.extractionEngine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.duplicates.MethodDuplicatesHandler;
import com.intellij.ui.ReplacePromptDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.CollectionsKt;
import kotlin.IndexedValue;
import kotlin.MapsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiRange;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u001f\u0006)\t\u0002O]8dKN\u001cH)\u001e9mS\u000e\fG/Z:\u000b%\u0011,\b\u000f\\5dCR,'+\u001a9mC\u000e,'o\u001d\u0006\u0004\u001b\u0006\u0004(BB6pi2LgNC\u0006KKR\u00046/\u001b*b]\u001e,'bA8sO*I!.\u001a;ce\u0006Lgn\u001d\u0006\u0005S\u0012,\u0017M\u0003\u0003vi&d'b\u00019tS*y\u0001/\u0019;uKJtW*\u0019;dQ&twMC\u0005Gk:\u001cG/[8oa)!QK\\5u\u0015\u001d\u0001(o\u001c6fGRTq\u0001\u0015:pU\u0016\u001cGOC\u0002d_6T\u0001\"\u001b8uK2d\u0017N\u001b\u0006\b_B,g.\u00199j\u0015\u0019)G-\u001b;pe*1Q\tZ5u_JTAA[1wC*yA)\u001e9mS\u000e\fG/Z+uS2\\EOC\rqe>\u001cWm]:EkBd\u0017nY1uKN\u001c\u0016\u000e\\3oi2L(\"\u00035jO\"d\u0017n\u001a5u\u0015A\u0011\u0016M\\4f\u0011&<\u0007\u000e\\5hQR,'O\u0003\u0004nCJ\\W\u000f\u001d\u0006\baJ,g/[3x]\u0007Q!\u0001E\u0002\u000b\r!\u0001\u0001C\u0001\r\u0001\u0015\t\u0001RA\u0003\u0003\t\u0005A1!\u0002\u0002\u0005\u0004!\rQA\u0001\u0003\u0003\u0011\u000f)!\u0001\"\u0002\t\t\u0015\u0011Aa\u0001E\u0005\u000b\t!9\u0001C\u0003\u0006\u0007\u0011!\u0001B\u0001\u0007\u0001\u000b\r!\u0001\u0001c\u0003\r\u0001\u0015\u0019A\u0001\u0001\u0005\u0007\u0019\u0001)\u0011\u0001c\u0004\u0006\u0005\u00111\u0001\u0002C\u0003\u0003\t\u001bA\t\"\u0002\u0002\u0005\u000f!5Qa\u0001C\b\u0011\u001da\u0001!\u0002\u0002\u0005\u000f!IQa\u0001C\t\u0011'a\u0001!B\u0001\t\u0015\u0015\u0011A1\u0003\u0005\u0005\u000b\t!!\u0002C\u0001\u0006\u0005\u0011=\u0001bB\u0003\u0003\t#A\u0019\"\u0002\u0002\u0005\u0012!eQa\u0001\u0003\r\u00111a\u0001!\u0002\u0002\u0005\u0019!aQA\u0001\u0003\u0005\u0011\t))\bB\u0002\u0019\u0001u5B\u0001\u0001E\u0001\u001bI)\u0011\u0001#\u0001\n\t%\u0019Q!\u0001E\u00051\u0013I\u0011\"\u0003\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\u0019\u000ba\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003iz\u0001\u0002\u0001\t\u00135\u0019Q!\u0001\u0005\n1%\u00016!A\u0011\u0004\u000b\u0005AY\u0001g\u0003R\u0007%!\u0001!C\u0001\u0005\u00015\t\u0001RC\u0007\u0002\u0011-i\u0011\u0001c\u0006Y\u0007+)\u0001\u0007B\u0002\u0019\u0017u5B\u0001\u0001E\u0001\u001bI)\u0011\u0001#\u0001\n\t%\u0019Q!\u0001E\u00051\u0013I\u0011\"\u0003\u0005\u0006\u0003!)\u0011\u0002B\u0005\u0004\u000b\u0005AY\u0001g\u0003\u0019\u000ba\u0005\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001RB\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0003\t3!B\u0001\t\fa-\u0011kA\u0004\u0005\u0017%\tA\u0001A\u0007\u0002\u0011+i\u0011\u0001C\u0006Y\u0007+)\u0001\u0006B\u0002\u0016\u0007\u0015\t\u0001\u0012\u0002M\u00051/iz\u0001\u0002\u0001\t\u000e5\u0019Q!\u0001\u0005\t1!\u00016\u0011AO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003\u0005\"Q!\u0001E\r\u0019\u0003AJ\"U\u0002\n\t/I\u0011\u0001C\u0007\u000e\u0003!mQ\"\u0001\u0005\f\u001b\u0005A9\u0002WB\u000b\u000b!\"1!F\u0002\u0006\u0003!%\u0001\u0014\u0002\r\u000e;\u001f!\u0001\u0001#\u0004\u000e\u0007\u0015\t\u0001\u0002\u0003\r\t!\u000e\u0005Qt\u0002\u0003\u0001\u0011%i1!B\u0001\t\u0013aI\u0001kA\u0001\"\t\u0015\t\u0001\u0012\u0004G\u000113\t6!\u0003\u0003\u000e\u0013\u0005AQ\"D\u0001\t\u001c5\t\u0001bC\u0007\u0002\u0011/A6Q\u0003"})
public final class DuplicateUtilKt {
    @Nullable
    public static final RangeHighlighter highlight(JetPsiRange $receiver, @NotNull Project project, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextRange textRange = $receiver.getTextRange();
        ArrayList highlighters = new ArrayList();
        TextAttributes textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
        if (textAttributes == null) {
            Intrinsics.throwNpe();
        }
        TextAttributes attributes = textAttributes;
        HighlightManager.getInstance((Project)project).addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, true, (Collection)highlighters);
        return (RangeHighlighter)CollectionsKt.firstOrNull((List)highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final RangeHighlighter preview(JetPsiRange $receiver, @NotNull Project project, @NotNull Editor editor) {
        RangeHighlighter rangeHighlighter;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        RangeHighlighter rangeHighlighter2 = DuplicateUtilKt.highlight($receiver, project, editor);
        if (rangeHighlighter2 != null) {
            void destination;
            void $receiver2;
            void $receiver3;
            RangeHighlighter $receiver4 = rangeHighlighter2;
            RangeHighlighter it = $receiver4;
            int startOffset = $receiver.getTextRange().getStartOffset();
            Object[] objectArray = CodeFoldingManager.getInstance((Project)project).getFoldRegionsAtOffset(editor, startOffset);
            void var7_7 = $receiver3;
            Collection collection = new ArrayList();
            for (int i = 0; i < ((void)$receiver2).length; ++i) {
                void element2 = $receiver2[i];
                FoldRegion it2 = (FoldRegion)element2;
                if (!(!it2.isExpanded())) continue;
                destination.add(element2);
            }
            List foldedRegions = (List)destination;
            if (!foldedRegions.isEmpty()) {
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(foldedRegions){
                    final /* synthetic */ List $foldedRegions;

                    public final void run() {
                        Iterable $receiver = this.$foldedRegions;
                        for (T element2 : $receiver) {
                            FoldRegion it = (FoldRegion)element2;
                            it.setExpanded(true);
                        }
                    }
                    {
                        this.$foldedRegions = list;
                    }
                });
            }
            editor.getScrollingModel().scrollTo(editor.offsetToLogicalPosition(startOffset), ScrollType.MAKE_VISIBLE);
            rangeHighlighter = it;
        } else {
            rangeHighlighter = null;
        }
        return rangeHighlighter;
    }

    /*
     * WARNING - void declaration
     */
    public static final void processDuplicates(@NotNull Map<JetPsiRange, ? extends Function0<? extends Unit>> duplicateReplacers, @NotNull Project project, @NotNull Editor editor) {
        int answer;
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        int size = duplicateReplacers.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            DuplicateUtilKt.preview((JetPsiRange)CollectionsKt.first((Iterable)duplicateReplacers.keySet()), project, editor);
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            Intrinsics.throwNpe();
        }
        int n = answer = application.isUnitTestMode() ? Messages.YES : Messages.showYesNoDialog((Project)project, (String)JetRefactoringBundle.message("0.has.detected.1.code.fragments.in.this.file.that.can.be.replaced.with.a.call.to.extracted.declaration", ApplicationNamesInfo.getInstance().getProductName(), duplicateReplacers.size()), (String)"Process Duplicates", (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        boolean showAll = false;
        block5: for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)duplicateReplacers.entrySet())) {
            void replacer;
            Boolean bl;
            void pattern2;
            Map.Entry entry;
            int i = indexedValue.component1();
            Map.Entry entry2 = entry = (Map.Entry)indexedValue.component2();
            JetPsiRange jetPsiRange = (JetPsiRange)MapsKt.component1((Map.Entry)entry2);
            Function0 function0 = (Function0)MapsKt.component2((Map.Entry)entry2);
            entry2 = null;
            if (!pattern2.isValid()) continue;
            RangeHighlighter highlighter = DuplicateUtilKt.preview((JetPsiRange)pattern2, project, editor);
            Application application2 = ApplicationManager.getApplication();
            if (application2 == null) {
                Intrinsics.throwNpe();
            }
            if (!application2.isUnitTestMode() && size > 1 && !showAll) {
                RangeHighlighter promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"process.duplicates.title", (Object[])new Object[]{i + 1, size}), project);
                promptDialog.show();
                switch (promptDialog.getExitCode()) {
                    case 3: {
                        showAll = true;
                        break;
                    }
                    case 2: {
                        continue block5;
                    }
                    case 1: {
                        return;
                    }
                }
            }
            if (highlighter != null) {
                void $receiver;
                RangeHighlighter it = (RangeHighlighter)$receiver;
                bl = HighlightManager.getInstance((Project)project).removeSegmentHighlighter(editor, it);
            } else {
                bl = null;
            }
            String string = MethodDuplicatesHandler.REFACTORING_NAME;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
            ApplicationUtilsKt.executeWriteCommand(project, string, (Function0<? extends Unit>)replacer);
        }
    }

    public static final void processDuplicatesSilently(@NotNull Map<JetPsiRange, ? extends Function0<? extends Unit>> duplicateReplacers, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(duplicateReplacers, (String)"duplicateReplacers");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String string = MethodDuplicatesHandler.REFACTORING_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"MethodDuplicatesHandler.REFACTORING_NAME");
        ApplicationUtilsKt.executeWriteCommand(project, string, (Function0<? extends Unit>)((Function0)new Function0<Unit>(duplicateReplacers){
            final /* synthetic */ Map $duplicateReplacers;

            public final void invoke() {
                Iterable $receiver = this.$duplicateReplacers.values();
                for (T element2 : $receiver) {
                    Function0 it = (Function0)element2;
                    it.invoke();
                }
            }
            {
                this.$duplicateReplacers = map2;
                super(0);
            }
        }));
    }
}

