/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.idea.analysis.AnalysisPackage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.core.CorePackage;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.NewDeclarationNameValidator;
import org.jetbrains.kotlin.idea.intentions.ConvertToBlockBodyIntention;
import org.jetbrains.kotlin.idea.intentions.RemoveCurlyBracesFromTemplateIntention;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.JetRefactoringUtil;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroducePackage;
import org.jetbrains.kotlin.idea.refactoring.introduce.KotlinIntroduceHandlerBase;
import org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinVariableInplaceIntroducer;
import org.jetbrains.kotlin.idea.util.IdeDescriptorRenderers;
import org.jetbrains.kotlin.idea.util.ShortenReferences;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiRange;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.JetPsiUnifier;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.PatternMatchingPackage;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.JetContainerNode;
import org.jetbrains.kotlin.psi.JetDeclarationWithBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetLoopExpression;
import org.jetbrains.kotlin.psi.JetOperationExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStatementExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetTreeVisitorVoid;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.JetWhenEntry;
import org.jetbrains.kotlin.psi.PsiPackage;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilPackage;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTraceContext;
import org.jetbrains.kotlin.resolve.ObservableBindingTrace;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class KotlinIntroduceVariableHandler
extends KotlinIntroduceHandlerBase {
    public static final String INTRODUCE_VARIABLE = JetRefactoringBundle.message("introduce.variable", new Object[0]);
    private static Key<Boolean> OCCURRENCE = Key.create((String)"OCCURRENCE");

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "invoke"));
        }
        JetRefactoringUtil.SelectExpressionCallback callback = new JetRefactoringUtil.SelectExpressionCallback(){

            @Override
            public void run(@Nullable JetExpression expression2) {
                KotlinIntroduceVariableHandler.doRefactoring(project, editor, expression2, null, null);
            }
        };
        try {
            JetRefactoringUtil.selectExpression(editor, file, callback);
        }
        catch (JetRefactoringUtil.IntroduceRefactoringException e) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, e.getMessage());
        }
    }

    public static void doRefactoring(final @NotNull Project project, final @Nullable Editor editor, @Nullable JetExpression _expression, @Nullable List<JetExpression> occurrencesToReplace, final @Nullable Function1<JetProperty, Unit> onNonInteractiveFinish) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "doRefactoring"));
        }
        if (_expression == null) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.expression", new Object[0]));
            return;
        }
        if (_expression.getParent() instanceof JetParenthesizedExpression) {
            _expression = (JetExpression)_expression.getParent();
        }
        final JetExpression expression2 = _expression;
        boolean noTypeInference = false;
        if (expression2.getParent() instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)expression2.getParent();
            if (qualifiedExpression.getReceiverExpression() != expression2) {
                KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.expression", new Object[0]));
                return;
            }
        } else {
            JetOperationExpression operationExpression;
            if (expression2 instanceof JetStatementExpression) {
                KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.expression", new Object[0]));
                return;
            }
            if (expression2.getParent() instanceof JetOperationExpression && (operationExpression = (JetOperationExpression)expression2.getParent()).getOperationReference() == expression2) {
                KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.expression", new Object[0]));
                return;
            }
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)expression2, (Class[])new Class[]{JetTypeReference.class, JetConstructorCalleeExpression.class, JetSuperExpression.class}) != null) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.container", new Object[0]));
            return;
        }
        AnalysisResult analysisResult = ResolutionUtils.analyzeAndGetResult(expression2);
        final BindingContext bindingContext2 = analysisResult.getBindingContext();
        final JetType expressionType = bindingContext2.getType(expression2);
        JetScope scope2 = bindingContext2.get(BindingContext.RESOLUTION_SCOPE, expression2);
        if (scope2 != null) {
            DataFlowInfo dataFlowInfo = BindingContextUtilPackage.getDataFlowInfo(bindingContext2, expression2);
            ObservableBindingTrace bindingTrace = new ObservableBindingTrace(new BindingTraceContext());
            JetType typeNoExpectedType = AnalysisPackage.computeTypeInfoInContext(expression2, scope2, expression2, bindingTrace, dataFlowInfo).getType();
            if (expressionType != null && typeNoExpectedType != null && !JetTypeChecker.DEFAULT.equalTypes(expressionType, typeNoExpectedType)) {
                noTypeInference = true;
            }
        }
        if (expressionType == null && bindingContext2.get(BindingContext.QUALIFIER, expression2) != null) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.package.expression", new Object[0]));
            return;
        }
        if (expressionType != null && JetTypeChecker.DEFAULT.equalTypes(analysisResult.getModuleDescriptor().getBuiltIns().getUnitType(), expressionType)) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.expression.has.unit.type", new Object[0]));
            return;
        }
        if (expressionType == null && noTypeInference) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.expression.should.have.inferred.type", new Object[0]));
            return;
        }
        final PsiElement container2 = KotlinIntroduceVariableHandler.getContainer((PsiElement)expression2);
        PsiElement occurrenceContainer = KotlinIntroduceVariableHandler.getOccurrenceContainer((PsiElement)expression2);
        if (container2 == null) {
            KotlinIntroduceVariableHandler.showErrorHint(project, editor, JetRefactoringBundle.message("cannot.refactor.no.container", new Object[0]));
            return;
        }
        final boolean isInplaceAvailableOnDataContext = editor != null && editor.getSettings().isVariableInplaceRenameEnabled() && !ApplicationManager.getApplication().isUnitTestMode();
        final List<JetExpression> allOccurrences = occurrencesToReplace == null ? KotlinIntroduceVariableHandler.findOccurrences(occurrenceContainer, expression2) : occurrencesToReplace;
        final boolean finalNoTypeInference = noTypeInference;
        Pass<OccurrencesChooser.ReplaceChoice> callback = new Pass<OccurrencesChooser.ReplaceChoice>(){

            public void pass(OccurrencesChooser.ReplaceChoice replaceChoice) {
                List allReplaces;
                boolean replaceOccurrence = KotlinIntroduceVariableHandler.shouldReplaceOccurrence(expression2, bindingContext2, container2);
                if (OccurrencesChooser.ReplaceChoice.ALL == replaceChoice) {
                    if (allOccurrences.size() > 1) {
                        replaceOccurrence = true;
                    }
                    allReplaces = allOccurrences;
                } else {
                    allReplaces = Collections.singletonList(expression2);
                }
                PsiElement commonParent = PsiTreeUtil.findCommonParent(allReplaces);
                PsiElement commonContainer = KotlinIntroduceVariableHandler.getContainer(commonParent);
                NewDeclarationNameValidator validator2 = new NewDeclarationNameValidator(commonContainer, KotlinIntroduceVariableHandler.calculateAnchor(commonParent, commonContainer, allReplaces), NewDeclarationNameValidator.Target.VARIABLES);
                final Collection<String> suggestedNames2 = KotlinNameSuggester.INSTANCE$.suggestNamesByExpressionAndType(expression2, ResolutionUtils.analyze(expression2, BodyResolveMode.PARTIAL), validator2, "value");
                final Ref propertyRef = new Ref();
                final ArrayList references = new ArrayList();
                final Ref reference = new Ref();
                final Runnable introduceRunnable = KotlinIntroduceVariableHandler.introduceVariable(expression2, suggestedNames2.iterator().next(), allReplaces, commonContainer, commonParent, replaceOccurrence, (Ref<JetProperty>)propertyRef, references, (Ref<JetExpression>)reference, finalNoTypeInference, expressionType, bindingContext2);
                CommandProcessor.getInstance().executeCommand(project, new Runnable(){

                    @Override
                    public void run() {
                        ApplicationManager.getApplication().runWriteAction(introduceRunnable);
                        JetProperty property2 = (JetProperty)propertyRef.get();
                        if (property2 != null) {
                            if (editor != null) {
                                editor.getCaretModel().moveToOffset(property2.getTextOffset());
                                editor.getSelectionModel().removeSelection();
                                if (isInplaceAvailableOnDataContext) {
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                                    PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
                                    KotlinVariableInplaceIntroducer variableIntroducer = new KotlinVariableInplaceIntroducer(property2, (JetExpression)reference.get(), references.toArray(new JetExpression[references.size()]), suggestedNames2, false, false, expressionType, finalNoTypeInference, project, editor);
                                    variableIntroducer.startInplaceIntroduceTemplate();
                                }
                            } else if (onNonInteractiveFinish != null) {
                                onNonInteractiveFinish.invoke((Object)property2);
                            }
                        }
                    }
                }, INTRODUCE_VARIABLE, null);
            }
        };
        if (isInplaceAvailableOnDataContext && occurrencesToReplace == null) {
            OccurrencesChooser.simpleChooser((Editor)editor).showChooser((Object)expression2, allOccurrences, (Pass)callback);
        } else {
            callback.pass((Object)OccurrencesChooser.ReplaceChoice.ALL);
        }
    }

    private static Runnable introduceVariable(final JetExpression expression2, final String nameSuggestion, final List<JetExpression> allReplaces, final PsiElement commonContainer, final PsiElement commonParent, final boolean replaceOccurrence, final Ref<JetProperty> propertyRef, final ArrayList<JetExpression> references, final Ref<JetExpression> reference, final boolean noTypeInference, final JetType expressionType, final BindingContext bindingContext2) {
        final JetPsiFactory psiFactory = PsiPackage.JetPsiFactory((PsiElement)expression2);
        return new Runnable(){

            @Override
            public void run() {
                if (commonContainer instanceof JetDeclarationWithBody) {
                    JetDeclarationWithBody originalDeclaration = (JetDeclarationWithBody)commonContainer;
                    JetExpression originalBody = originalDeclaration.getBodyExpression();
                    assert (originalBody != null) : "Original body is not found: " + originalDeclaration;
                    Key EXPRESSION_KEY = Key.create((String)"EXPRESSION_KEY");
                    Key REPLACE_KEY = Key.create((String)"REPLACE_KEY");
                    Key COMMON_PARENT_KEY = Key.create((String)"COMMON_PARENT_KEY");
                    expression2.putCopyableUserData(EXPRESSION_KEY, true);
                    for (JetExpression replace2 : allReplaces) {
                        replace2.putCopyableUserData(REPLACE_KEY, true);
                    }
                    commonParent.putCopyableUserData(COMMON_PARENT_KEY, (Object)true);
                    JetDeclarationWithBody newDeclaration = ConvertToBlockBodyIntention.Companion.convert(originalDeclaration);
                    JetBlockExpression newCommonContainer = (JetBlockExpression)newDeclaration.getBodyExpression();
                    assert (newCommonContainer != null) : "New body is not found: " + newDeclaration;
                    JetExpression newExpression2 = IntroducePackage.findExpressionByCopyableDataAndClearIt((PsiElement)newCommonContainer, (Key<Boolean>)EXPRESSION_KEY);
                    PsiElement newCommonParent = IntroducePackage.findElementByCopyableDataAndClearIt((PsiElement)newCommonContainer, (Key<Boolean>)COMMON_PARENT_KEY);
                    List<JetExpression> newAllReplaces = IntroducePackage.findExpressionsByCopyableDataAndClearIt((PsiElement)newCommonContainer, (Key<Boolean>)REPLACE_KEY);
                    this.run(newExpression2, (PsiElement)newCommonContainer, newCommonParent, newAllReplaces);
                } else {
                    this.run(expression2, commonContainer, commonParent, allReplaces);
                }
            }

            private void run(JetExpression expression22, PsiElement commonContainer2, PsiElement commonParent2, List<JetExpression> allReplaces2) {
                boolean needBraces;
                JetParenthesizedExpression parenthesizedExpression;
                JetExpression innerExpression;
                String variableText = "val " + nameSuggestion;
                if (noTypeInference) {
                    variableText = variableText + ": " + IdeDescriptorRenderers.SOURCE_CODE.renderType(expressionType);
                }
                variableText = variableText + " = ";
                variableText = expression22 instanceof JetParenthesizedExpression ? ((innerExpression = (parenthesizedExpression = (JetParenthesizedExpression)expression22).getExpression()) != null ? variableText + innerExpression.getText() : variableText + expression22.getText()) : variableText + expression22.getText();
                JetProperty property2 = psiFactory.createProperty(variableText);
                Object anchor2 = KotlinIntroduceVariableHandler.calculateAnchor(commonParent2, commonContainer2, allReplaces2);
                if (anchor2 == null) {
                    return;
                }
                boolean bl = needBraces = !(commonContainer2 instanceof JetBlockExpression);
                if (!needBraces) {
                    property2 = (JetProperty)commonContainer2.addBefore((PsiElement)property2, anchor2);
                    commonContainer2.addBefore(psiFactory.createNewLine(), anchor2);
                } else {
                    PsiElement nextnext;
                    PsiElement next2;
                    JetContainerNode node;
                    JetBlockExpression emptyBody = psiFactory.createEmptyBody();
                    PsiElement firstChild = emptyBody.getFirstChild();
                    emptyBody.addAfter(psiFactory.createNewLine(), firstChild);
                    if (replaceOccurrence && commonContainer2 != null) {
                        for (JetExpression replace2 : allReplaces2) {
                            JetExpression exprAfterReplace = this.replaceExpression(replace2, false);
                            exprAfterReplace.putCopyableUserData(OCCURRENCE, true);
                            if (anchor2 != replace2) continue;
                            anchor2 = exprAfterReplace;
                        }
                        Object oldElement = commonContainer2;
                        if (commonContainer2 instanceof JetWhenEntry) {
                            JetExpression body2 = ((JetWhenEntry)commonContainer2).getExpression();
                            if (body2 != null) {
                                oldElement = body2;
                            }
                        } else if (commonContainer2 instanceof JetContainerNode) {
                            PsiElement[] children2;
                            JetContainerNode container2 = (JetContainerNode)commonContainer2;
                            for (PsiElement child : children2 = container2.getChildren()) {
                                if (!(child instanceof JetExpression)) continue;
                                oldElement = child;
                            }
                        }
                        JetExpression actualExpression = (JetExpression)reference.get();
                        int diff = actualExpression.getTextRange().getStartOffset() - oldElement.getTextRange().getStartOffset();
                        String actualExpressionText = actualExpression.getText();
                        PsiElement newElement = emptyBody.addAfter((PsiElement)oldElement, firstChild);
                        PsiElement elem = this.findElementByOffsetAndText(diff, actualExpressionText, newElement);
                        if (elem != null) {
                            reference.set((Object)((JetExpression)elem));
                        }
                        emptyBody.addAfter(psiFactory.createNewLine(), firstChild);
                        property2 = (JetProperty)emptyBody.addAfter(property2, firstChild);
                        emptyBody.addAfter(psiFactory.createNewLine(), firstChild);
                        actualExpression = (JetExpression)reference.get();
                        diff = actualExpression.getTextRange().getStartOffset() - emptyBody.getTextRange().getStartOffset();
                        actualExpressionText = actualExpression.getText();
                        emptyBody = (JetBlockExpression)anchor2.replace((PsiElement)emptyBody);
                        elem = this.findElementByOffsetAndText(diff, actualExpressionText, (PsiElement)emptyBody);
                        if (elem != null) {
                            reference.set((Object)((JetExpression)elem));
                        }
                        emptyBody.accept(new JetTreeVisitorVoid(){

                            @Override
                            public void visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2) {
                                if (expression2 == null) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler$3$1", "visitSimpleNameExpression"));
                                }
                                if (expression2.getCopyableUserData(OCCURRENCE) == null) {
                                    return;
                                }
                                expression2.putCopyableUserData(OCCURRENCE, null);
                                references.add(expression2);
                            }
                        });
                    } else {
                        PsiElement parent2 = anchor2.getParent();
                        PsiElement copyTo = parent2.getLastChild();
                        PsiElement copyFrom = anchor2.getNextSibling();
                        property2 = (JetProperty)emptyBody.addAfter(property2, firstChild);
                        emptyBody.addAfter(psiFactory.createNewLine(), firstChild);
                        if (copyFrom != null && copyTo != null) {
                            emptyBody.addRangeAfter(copyFrom, copyTo, property2);
                            parent2.deleteChildRange(copyFrom, copyTo);
                        }
                        emptyBody = (JetBlockExpression)anchor2.replace((PsiElement)emptyBody);
                    }
                    for (PsiElement child : emptyBody.getChildren()) {
                        if (!(child instanceof JetProperty)) continue;
                        property2 = (JetProperty)child;
                    }
                    if (commonContainer2 instanceof JetContainerNode && (node = (JetContainerNode)commonContainer2).getParent() instanceof JetIfExpression && (next2 = node.getNextSibling()) != null && (nextnext = next2.getNextSibling()) != null && nextnext.getNode().getElementType() == JetTokens.ELSE_KEYWORD && next2 instanceof PsiWhiteSpace) {
                        next2.replace(psiFactory.createWhiteSpace());
                    }
                }
                if (!needBraces) {
                    for (int i = 0; i < allReplaces2.size(); ++i) {
                        JetExpression replace3 = allReplaces2.get(i);
                        if (i != 0 ? replaceOccurrence : KotlinIntroduceVariableHandler.shouldReplaceOccurrence(replace3, bindingContext2, commonContainer2)) {
                            this.replaceExpression(replace3, true);
                            continue;
                        }
                        PsiElement sibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)replace3, (Class[])new Class[]{PsiWhiteSpace.class});
                        if (sibling == property2) {
                            replace3.getParent().deleteChildRange(property2.getNextSibling(), (PsiElement)replace3);
                            continue;
                        }
                        replace3.delete();
                    }
                }
                propertyRef.set((Object)property2);
                if (noTypeInference) {
                    ShortenReferences.DEFAULT.process(property2);
                }
            }

            private PsiElement findElementByOffsetAndText(int offset2, String text, PsiElement newContainer) {
                PsiElement elem;
                for (elem = newContainer.findElementAt(offset2); !(elem == null || elem instanceof JetExpression && text.equals(elem.getText())); elem = elem.getParent()) {
                }
                return elem;
            }

            private JetExpression replaceExpression(JetExpression replace2, boolean addToReferences) {
                PsiElement parent2;
                JetExpression result2;
                boolean isActualExpression = expression2 == replace2;
                JetExpression replacement = psiFactory.createExpression(nameSuggestion);
                if (PsiUtilPackage.isFunctionLiteralOutsideParentheses(replace2)) {
                    JetFunctionLiteralArgument functionLiteralArgument = (JetFunctionLiteralArgument)PsiTreeUtil.getParentOfType((PsiElement)replace2, JetFunctionLiteralArgument.class);
                    JetCallExpression newCallExpression = CorePackage.moveInsideParenthesesAndReplaceWith(functionLiteralArgument, replacement, bindingContext2);
                    result2 = ((JetValueArgument)KotlinPackage.last(newCallExpression.getValueArguments())).getArgumentExpression();
                } else {
                    result2 = (JetExpression)replace2.replace((PsiElement)replacement);
                }
                PsiElement psiElement2 = parent2 = result2 != null ? result2.getParent() : null;
                if (parent2 instanceof JetBlockStringTemplateEntry) {
                    RemoveCurlyBracesFromTemplateIntention intention = new RemoveCurlyBracesFromTemplateIntention();
                    JetBlockStringTemplateEntry entry = (JetBlockStringTemplateEntry)parent2;
                    JetBlockStringTemplateEntry newEntry = intention.isApplicableTo(entry) ? intention.applyTo(entry) : entry;
                    result2 = newEntry.getExpression();
                }
                if (addToReferences) {
                    references.add(result2);
                }
                if (isActualExpression) {
                    reference.set((Object)result2);
                }
                return result2;
            }
        };
    }

    private static PsiElement calculateAnchor(PsiElement commonParent, PsiElement commonContainer, List<JetExpression> allReplaces) {
        PsiElement anchor2 = commonParent;
        if (anchor2 != commonContainer) {
            while (anchor2.getParent() != commonContainer) {
                anchor2 = anchor2.getParent();
            }
        } else {
            anchor2 = commonContainer.getFirstChild();
            int startOffset = commonContainer.getTextRange().getEndOffset();
            for (JetExpression expr : allReplaces) {
                int offset2 = expr.getTextRange().getStartOffset();
                if (offset2 >= startOffset) continue;
                startOffset = offset2;
            }
            while (anchor2 != null && !anchor2.getTextRange().contains(startOffset)) {
                anchor2 = anchor2.getNextSibling();
            }
            if (anchor2 == null) {
                return null;
            }
        }
        return anchor2;
    }

    private static List<JetExpression> findOccurrences(PsiElement occurrenceContainer, @NotNull JetExpression originalExpression) {
        if (originalExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalExpression", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "findOccurrences"));
        }
        return KotlinPackage.map(PatternMatchingPackage.toRange((PsiElement)originalExpression).match(occurrenceContainer, JetPsiUnifier.DEFAULT), (Function1)new Function1<JetPsiRange.Match, JetExpression>(){

            public JetExpression invoke(JetPsiRange.Match match2) {
                PsiElement candidate = ((JetPsiRange.ListRange)match2.getRange()).getStartElement();
                if (candidate instanceof JetExpression) {
                    return (JetExpression)candidate;
                }
                if (candidate instanceof JetStringTemplateEntryWithExpression) {
                    return ((JetStringTemplateEntryWithExpression)candidate).getExpression();
                }
                throw new AssertionError((Object)("Unexpected candidate element: " + candidate.getText()));
            }
        });
    }

    private static boolean shouldReplaceOccurrence(@NotNull JetExpression expression2, @NotNull BindingContext bindingContext2, @Nullable PsiElement container2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "shouldReplaceOccurrence"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "shouldReplaceOccurrence"));
        }
        return BindingContextUtilPackage.isUsedAsExpression(expression2, bindingContext2) || container2 != expression2.getParent();
    }

    @Nullable
    private static PsiElement getContainer(PsiElement place) {
        if (place instanceof JetBlockExpression) {
            return place;
        }
        while (place != null) {
            PsiElement parent2 = place.getParent();
            if (parent2 instanceof JetContainerNode && !KotlinIntroduceVariableHandler.isBadContainerNode((JetContainerNode)parent2, place)) {
                return parent2;
            }
            if (parent2 instanceof JetBlockExpression || parent2 instanceof JetWhenEntry && place == ((JetWhenEntry)parent2).getExpression()) {
                return parent2;
            }
            if (parent2 instanceof JetDeclarationWithBody && ((JetDeclarationWithBody)parent2).getBodyExpression() == place) {
                return parent2;
            }
            place = parent2;
        }
        return null;
    }

    private static boolean isBadContainerNode(JetContainerNode parent2, PsiElement place) {
        if (parent2.getParent() instanceof JetIfExpression && ((JetIfExpression)parent2.getParent()).getCondition() == place) {
            return true;
        }
        if (parent2.getParent() instanceof JetLoopExpression && ((JetLoopExpression)parent2.getParent()).getBody() != place) {
            return true;
        }
        return parent2.getParent() instanceof JetArrayAccessExpression;
    }

    @Nullable
    private static PsiElement getOccurrenceContainer(PsiElement place) {
        PsiElement result2 = null;
        while (place != null) {
            PsiElement parent2 = place.getParent();
            if (parent2 instanceof JetContainerNode) {
                if (!(place instanceof JetBlockExpression) && !KotlinIntroduceVariableHandler.isBadContainerNode((JetContainerNode)parent2, place)) {
                    result2 = parent2;
                }
            } else {
                JetDeclarationWithBody function2;
                if (parent2 instanceof JetClassBody || parent2 instanceof JetFile) {
                    return result2;
                }
                if (parent2 instanceof JetBlockExpression) {
                    result2 = parent2;
                } else if (parent2 instanceof JetWhenEntry) {
                    if (!(place instanceof JetBlockExpression)) {
                        result2 = parent2;
                    }
                } else if (parent2 instanceof JetDeclarationWithBody && (function2 = (JetDeclarationWithBody)parent2).getBodyExpression() == place && !(place instanceof JetBlockExpression)) {
                    result2 = parent2;
                }
            }
            place = parent2;
        }
        return null;
    }

    private static void showErrorHint(Project project, Editor editor, String message) {
        CodeInsightUtils.showErrorHint(project, editor, message, INTRODUCE_VARIABLE, "refactoring.introduceVariable");
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/idea/refactoring/introduce/introduceVariable/KotlinIntroduceVariableHandler", "invoke"));
        }
    }
}

