/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightClass;
import org.jetbrains.kotlin.asJava.KotlinLightClassForExplicitDeclaration;
import org.jetbrains.kotlin.asJava.KotlinLightClassForFacade;
import org.jetbrains.kotlin.idea.JetBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPsiProcessor;
import org.jetbrains.kotlin.idea.references.JetSimpleNameReference;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetConstructor;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"@\b)Q\"+\u001a8b[\u0016\\u\u000e\u001e7j]\u000ec\u0017m]:Qe>\u001cWm]:pe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003jI\u0016\f'b\u0003:fM\u0006\u001cGo\u001c:j]\u001eTaA]3oC6,'\u0002\u0007*f]\u0006lWmS8uY&t\u0007k]5Qe>\u001cWm]:pe*1A(\u001b8jizR\u0011cY1o!J|7-Z:t\u000b2,W.\u001a8u\u0015\u001d)G.Z7f]RT!\u0002U:j\u000b2,W.\u001a8u\u0015\r\u0019w.\u001c\u0006\tS:$X\r\u001c7jU*\u0019\u0001o]5\u000b\u000f\t{w\u000e\\3b]*qa-\u001b8e%\u00164WM]3oG\u0016\u001c(BC\"pY2,7\r^5p]*a\u0001k]5SK\u001a,'/\u001a8dK*!!.\u0019<b\u0015\u0011)H/\u001b7\u000b'\u001d,GOS3u\u00072\f7o](s\u001f\nTWm\u0019;\u000b\u0015MDwn^#se>\u00148O\u0003\u0004fI&$xN\u001d\u0006\u0007\u000b\u0012LGo\u001c:\u000b\u000f=\u0004XM\\1qS*\u0001\"*\u001a;DY\u0006\u001c8o\u0014:PE*,7\r\u001e\u0006\u0010aJ,\u0007/\u0019:f%\u0016t\u0017-\\5oO*9a.Z<OC6,'BB*ue&twM\u0003\u0006bY2\u0014VM\\1nKNT!\"T;uC\ndW-T1q\u0015\u0011)f.\u001b;\u000b\t1\fgn\u001a\u0006\u0004\u001b\u0006\u0004(\"G:vEN$\u0018\u000e^;uK\u0016cW-\\3oiR{'+\u001a8b[\u0016Tq$[:D_6\u0004\u0018M\\5p]>\u0013'.Z2u\u00072\f7o\u001d*fM\u0016\u0014XM\\2f5\bQ!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015QA\u0001\u0003\u0003\u0011\r)1\u0001\"\u0002\t\u00011\u0001Qa\u0001C\u0003\u0011\u000fa\u0001!B\u0001\t\r\u0015\u0011A\u0001\u0002E\u0007\u000b\t!I\u0001C\u0004\u0006\u0007\u0011)\u00012\u0002\u0007\u0001\u000b\u0005A\u0019!B\u0002\u0005\r!=A\u0002A\u0003\u0003\t\u0015AY!B\u0002\u0005\r!EA\u0002A\u0003\u0004\t\u0015A\u0011\u0002\u0004\u0001\u0006\u0003!MQA\u0001C\t\u0011))!\u0001B\u0005\t\u0012\u0015\u0011A\u0011\u0002E\r\u000b\t!!\u0002c\u0006\u0006\u0007\u0011U\u0001\u0002\u0004\u0007\u0001\u000b\t!\u0011\u0001C\u0004\u0006\u0007\u0011]\u0001\"\u0004\u0007\u0001\u000b\t!9\u0002C\u0007\u0006\u0005\u0011U\u0001\u0002D\u0003\u0004\t\u0019Ai\u0002\u0004\u0001\u0006\u0007\u00111\u0001r\u0004\u0007\u0001\u000b\r!a\u0001\u0003\t\r\u0001\u0015\u0011A\u0011\u0003E\u0011\u000b\t!q\u0002#\b\u0006\u0005\u0011I\u0001\"E\u0003\u0003\t\u0015A\u0011\u0002B\u0002\r\u0007e\u0019Q!\u0001E\u00041\u000fiS\u0003B\u0006\u0019\nu=A\u0001\u0001\u0005\u0006\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\u0001!I\u0002\u0006\u0003!5\u0001TB)\u0004\u000b\u0011%\u0011\"\u0001C\u0001\u001b\u0005Aq!\f\u000e\u0005\u0017aAQt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\fa-\u0001k\u0001\u0001\"\u0011\u0015\t\u0001rB\u0005\u0005\u0013\r)\u0011\u0001\u0003\u0005\u0019\u0011a=\u0011kA\u0003\u0005\u0011%\t\u00012C\u0007\u0002\u0011\u001diS\u0006B\u0001\u0019\u0016uEA\u0001\u0001\u0005\u0006\u001b\u0011)\u0011\u0001c\u0003\r\u0002a-\u0001k\u0001\u0001\u001e\u0010\u0011\u0001\u0001bC\u0007\u0004\u000b\u0005Ai\u0001'\u0004Q\u0007\u0003i\n\u0002\u0002\u0001\t\u00185!Q!\u0001\u0005\f\u0019\u0003A2\u0002U\u0002\u0002C\u0011)\u0011\u0001\u0003\u0007\r\u0002aa\u0011kA\u0005\u0005\u0016%\t\u0001\u0012D\u0007\u0002\u0011\u001di\u0011\u0001\"\u0001\u000e\u0003!iQ\u0006\u000e\u0003\f17iz\u0001\u0002\u0001\t\u000b5\u0019Q!\u0001E\u00061\u0017\u00016\u0001AO\b\t\u0001Aa\"D\u0002\u0006\u0003!m\u00014\u0004)\u0004\u0002u\rB\u0001\u0001\u0005\u0010\u001b5)\u0011\u0001\u0003\b\n\t%\u0019Q!\u0001E\u00061\u0017IA!C\u0002\u0006\u0003!m\u00014\u0004\r\u000f!\u000e\t\u0011eA\u0003\u0002\u0011;Aj\"U\u0002\n\t7I\u0011\u0001\u0002\u0001\u000e\u0003!9Q\"\u0001E\u0010\u001b\u0005A\u0001#l\u0011\u0005\u0017a\rRt\u0002\u0003\u0001\u0011\u0015i1!B\u0001\t\fa-\u0001k\u0001\u0001\u001e\u0012\u0011\u0001\u0001rC\u0007\u0005\u000b\u0005A1\u0002$\u0001\u0019\u0017A\u001b\t!\t\u0003\u0006\u0003!-A\u0012\u0001M\u0006#\u000e9A1E\u0005\u0002\u0011\u001di\u0011\u0001C\u0004\u000e\u0003!iQ\u0016\u0005\u0003\u0002+\r)\u0011\u0001\u0003\u0005\u0019\u0011a\u0011\u0012eA\u0003\u0002\u0011\u001bAj!U\u0002\u0006\tII\u0011\u0001\"\u0001\u000e\u0003!\u0005R\u0007D\u0003\f\t\r\b\u0001\u0004B\u0011\u0004\u000b\u0005A1\u0001G\u0002R\u0007\r!A!C\u0001\u0005\u0001\u0001"})
public final class RenameKotlinClassProcessor
extends RenameKotlinPsiProcessor {
    public static final /* synthetic */ KClass $kotlinClass;

    static {
        $kotlinClass = Reflection.createKotlinClass(RenameKotlinClassProcessor.class);
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return element2 instanceof JetClassOrObject || element2 instanceof KotlinLightClass || element2 instanceof JetConstructor;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return this.getJetClassOrObject(element2, true, editor);
    }

    public void prepareRenaming(@NotNull PsiElement element2, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        String nameWithoutExtensions;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)newName, (String)"newName");
        Intrinsics.checkParameterIsNotNull(allRenames, (String)"allRenames");
        JetClassOrObject jetClassOrObject = this.getJetClassOrObject(element2, false, null);
        if (jetClassOrObject == null) {
            return;
        }
        JetClassOrObject classOrObject = jetClassOrObject;
        JetFile file = classOrObject.getContainingJetFile();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null && Intrinsics.areEqual((Object)(nameWithoutExtensions = virtualFile.getNameWithoutExtension()), (Object)classOrObject.getName())) {
            allRenames.put((PsiElement)file, newName + "." + virtualFile.getExtension());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        if (element2 instanceof JetObjectDeclaration && ((JetObjectDeclaration)element2).isCompanion()) {
            void destination;
            void $receiver;
            Iterable $receiver2 = super.findReferences(element2);
            Iterable iterable = $receiver2;
            Collection collection = new ArrayList();
            for (Object element3 : $receiver) {
                PsiReference it = (PsiReference)element3;
                if (!(!this.isCompanionObjectClassReference(it))) continue;
                destination.add(element3);
            }
            return (List)destination;
        }
        Collection collection = super.findReferences(element2);
        Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"super.findReferences(element)");
        return collection;
    }

    private final boolean isCompanionObjectClassReference(PsiReference $receiver) {
        if (!($receiver instanceof JetSimpleNameReference)) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze((JetElement)((JetSimpleNameReference)$receiver).getElement(), BodyResolveMode.PARTIAL);
        return bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, ((JetSimpleNameReference)$receiver).getElement()) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final JetClassOrObject getJetClassOrObject(PsiElement element2, boolean showErrors, Editor editor) {
        JetClassOrObject jetClassOrObject;
        PsiElement psiElement2 = element2;
        if (psiElement2 instanceof KotlinLightClass) {
            if (element2 instanceof KotlinLightClassForExplicitDeclaration) {
                jetClassOrObject = ((KotlinLightClassForExplicitDeclaration)element2).getOrigin();
            } else {
                Object v1;
                if (element2 instanceof KotlinLightClassForFacade) {
                    if (showErrors) {
                        CommonRefactoringUtil.showErrorHint((Project)((KotlinLightClassForFacade)element2).getProject(), (Editor)editor, (String)JetBundle.message("rename.kotlin.package.class.error", new Object[0]), (String)RefactoringBundle.message((String)"rename.title"), (String)null);
                    }
                    v1 = null;
                } else {
                    void value2;
                    boolean bl = false;
                    if (PreconditionsKt.getASSERTIONS_ENABLED() && value2 == false) {
                        String message = "Should not be suggested to rename element of type " + ((KotlinLightClass)element2).getClass() + " " + element2;
                        throw (Throwable)((Object)new AssertionError((Object)message));
                    }
                    v1 = null;
                }
                jetClassOrObject = v1;
            }
        } else if (psiElement2 instanceof JetConstructor) {
            jetClassOrObject = ((JetConstructor)element2).getContainingClassOrObject();
        } else {
            PsiElement psiElement3 = element2;
            if (!(psiElement3 instanceof JetClassOrObject)) {
                psiElement3 = null;
            }
            jetClassOrObject = (JetClassOrObject)psiElement3;
        }
        return jetClassOrObject;
    }
}

