/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.run;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.execution.ui.CommonJavaParametersPanel;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.run.JetRunConfiguration;

public class JetRunConfigurationEditor
extends SettingsEditor<JetRunConfiguration>
implements PanelWithAnchor {
    private JPanel myMainPanel;
    private JTextField myMainClassField;
    private JPanel myModuleChooserHolder;
    private CommonJavaParametersPanel myCommonProgramParameters;
    private AlternativeJREPanel alternativeJREPanel;
    private LabeledComponent<JTextField> mainClass;
    private final ConfigurationModuleSelector myModuleSelector;
    private JComponent anchor;
    private final LabeledComponent<JComboBox> moduleChooser;

    public JetRunConfigurationEditor(Project project) {
        this.$$$setupUI$$$();
        this.moduleChooser = LabeledComponent.create(new JComboBox(), (String)"Use classpath of module:");
        this.moduleChooser.setLabelLocation("West");
        this.myModuleChooserHolder.add((Component)this.moduleChooser, "Center");
        this.myModuleSelector = new ConfigurationModuleSelector(project, (JComboBox)this.moduleChooser.getComponent());
        this.myCommonProgramParameters.setModuleContext(this.myModuleSelector.getModule());
        ((JComboBox)this.moduleChooser.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JetRunConfigurationEditor.this.myCommonProgramParameters.setModuleContext(JetRunConfigurationEditor.this.myModuleSelector.getModule());
            }
        });
        this.anchor = UIUtil.mergeComponentsWithAnchor((PanelWithAnchor[])new PanelWithAnchor[]{this.mainClass, this.myCommonProgramParameters, this.alternativeJREPanel, this.moduleChooser});
    }

    protected void resetEditorFrom(JetRunConfiguration configuration) {
        this.myCommonProgramParameters.reset((CommonJavaRunConfigurationParameters)configuration);
        this.myMainClassField.setText(configuration.getRunClass() == null ? null : configuration.getRunClass());
        this.myModuleSelector.reset((ModuleBasedConfiguration)configuration);
        this.alternativeJREPanel.init(configuration.getAlternativeJrePath(), configuration.isAlternativeJrePathEnabled());
    }

    protected void applyEditorTo(JetRunConfiguration configuration) throws ConfigurationException {
        this.myModuleSelector.applyTo((ModuleBasedConfiguration)configuration);
        this.myCommonProgramParameters.applyTo((CommonJavaRunConfigurationParameters)configuration);
        configuration.setRunClass(this.myMainClassField.getText());
        configuration.setAlternativeJrePath(this.alternativeJREPanel.getPath());
        configuration.setAlternativeJrePathEnabled(this.alternativeJREPanel.isPathEnabled());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/run/JetRunConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    protected void disposeEditor() {
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor2) {
        this.anchor = anchor2;
        this.mainClass.setAnchor(anchor2);
        this.myCommonProgramParameters.setAnchor(anchor2);
        this.alternativeJREPanel.setAnchor(anchor2);
        this.moduleChooser.setAnchor(anchor2);
    }

    private void createUIComponents() {
        this.mainClass = new LabeledComponent();
        this.myMainClassField = new JTextField();
        this.mainClass.setComponent((JComponent)this.myMainClassField);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        AlternativeJREPanel alternativeJREPanel;
        CommonJavaParametersPanel commonJavaParametersPanel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonProgramParameters = commonJavaParametersPanel = new CommonJavaParametersPanel();
        jPanel2.add((Component)commonJavaParametersPanel, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        this.alternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel2.add((Component)alternativeJREPanel, new GridConstraints(3, 0, 1, 2, 0, 1, 3, 3, null, null, null));
        LabeledComponent<JTextField> labeledComponent = this.mainClass;
        labeledComponent.setText("Main class");
        labeledComponent.setLabelLocation("West");
        jPanel2.add((Component)labeledComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myModuleChooserHolder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

