/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.JetPluginUtil;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtils;
import org.jetbrains.kotlin.idea.configuration.KotlinJavaModuleConfigurator;
import org.jetbrains.kotlin.idea.configuration.KotlinJsModuleConfigurator;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.LibraryPresentationProviderUtil;
import org.jetbrains.kotlin.idea.project.ProjectStructureUtil;
import org.jetbrains.kotlin.idea.versions.KotlinAbiVersionIndex;
import org.jetbrains.kotlin.idea.versions.KotlinJavaScriptAbiVersionIndex;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeNotification;
import org.jetbrains.kotlin.load.java.AbiVersionUtil;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadataUtils;
import org.jetbrains.kotlin.utils.KotlinPaths;

public class KotlinRuntimeLibraryUtil {
    private KotlinRuntimeLibraryUtil() {
    }

    @NotNull
    public static Collection<VirtualFile> getLibraryRootsWithAbiIncompatibleKotlinClasses(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleKotlinClasses"));
        }
        Collection<VirtualFile> collection = KotlinRuntimeLibraryUtil.getLibraryRootsWithAbiIncompatibleVersion(project, KotlinAbiVersionIndex.INSTANCE$, new Function1<Module, Boolean>(){

            public Boolean invoke(@Nullable Module module) {
                return module != null && ProjectStructureUtil.isJavaKotlinModule(module);
            }
        }, new Function1<BinaryVersion, Boolean>(){

            public Boolean invoke(@NotNull BinaryVersion version) {
                if (version == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil$2", "invoke"));
                }
                return !AbiVersionUtil.isAbiVersionCompatible(version);
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleKotlinClasses"));
        }
        return collection;
    }

    @NotNull
    public static Collection<VirtualFile> getLibraryRootsWithAbiIncompatibleForKotlinJs(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleForKotlinJs"));
        }
        Collection<VirtualFile> collection = KotlinRuntimeLibraryUtil.getLibraryRootsWithAbiIncompatibleVersion(project, KotlinJavaScriptAbiVersionIndex.INSTANCE$, new Function1<Module, Boolean>(){

            public Boolean invoke(@Nullable Module module) {
                return module != null && ProjectStructureUtil.isJsKotlinModule(module);
            }
        }, new Function1<BinaryVersion, Boolean>(){

            public Boolean invoke(@NotNull BinaryVersion version) {
                if (version == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil$4", "invoke"));
                }
                return !KotlinJavascriptMetadataUtils.isAbiVersionCompatible(version.getMinor());
            }
        });
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleForKotlinJs"));
        }
        return collection;
    }

    public static void addJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "addJdkAnnotations"));
        }
        KotlinRuntimeLibraryUtil.addAnnotations(sdk, org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin().getJdkAnnotationsPath());
    }

    public static void addAndroidSdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "addAndroidSdkAnnotations"));
        }
        KotlinRuntimeLibraryUtil.addAnnotations(sdk, org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin().getAndroidSdkAnnotationsPath());
    }

    public static void removeJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "removeJdkAnnotations"));
        }
        KotlinRuntimeLibraryUtil.removeAnnotations(sdk, org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin().getJdkAnnotationsPath());
    }

    private static void addAnnotations(@NotNull Sdk sdk, @NotNull File annotationsPath) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "addAnnotations"));
        }
        if (annotationsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsPath", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "addAnnotations"));
        }
        KotlinRuntimeLibraryUtil.modifyAnnotations(sdk, annotationsPath, true);
    }

    private static void removeAnnotations(@NotNull Sdk sdk, @NotNull File annotationsPath) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "removeAnnotations"));
        }
        if (annotationsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsPath", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "removeAnnotations"));
        }
        KotlinRuntimeLibraryUtil.modifyAnnotations(sdk, annotationsPath, false);
    }

    private static void modifyAnnotations(@NotNull Sdk sdk, @NotNull File annotationsPath, boolean isAdd) {
        VirtualFile jdkAnnotationsJar;
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "modifyAnnotations"));
        }
        if (annotationsPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationsPath", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "modifyAnnotations"));
        }
        if (annotationsPath.exists() && (jdkAnnotationsJar = LocalFileSystem.getInstance().findFileByIoFile(annotationsPath)) != null) {
            SdkModificator modificator = sdk.getSdkModificator();
            VirtualFile jarRootForLocalFile = JarFileSystem.getInstance().getJarRootForLocalFile(jdkAnnotationsJar);
            if (isAdd) {
                modificator.addRoot(jarRootForLocalFile, AnnotationOrderRootType.getInstance());
            } else {
                modificator.removeRoot(jarRootForLocalFile, AnnotationOrderRootType.getInstance());
            }
            modificator.commitChanges();
        }
    }

    public static boolean jdkAnnotationsArePresent(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "jdkAnnotationsArePresent"));
        }
        return KotlinRuntimeLibraryUtil.areAnnotationsPresent(sdk, "kotlin-jdk-annotations.jar");
    }

    public static boolean androidSdkAnnotationsArePresent(@NotNull Sdk sdk) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "androidSdkAnnotationsArePresent"));
        }
        return KotlinRuntimeLibraryUtil.areAnnotationsPresent(sdk, "kotlin-android-sdk-annotations.jar");
    }

    private static boolean areAnnotationsPresent(@NotNull Sdk sdk, final @NotNull String jarFileName) {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "areAnnotationsPresent"));
        }
        if (jarFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFileName", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "areAnnotationsPresent"));
        }
        return ContainerUtil.exists((Object[])sdk.getRootProvider().getFiles(AnnotationOrderRootType.getInstance()), (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile file) {
                return jarFileName.equals(file.getName());
            }
        });
    }

    public static void updateLibraries(final @NotNull Project project, final @NotNull Collection<Library> libraries) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "updateLibraries"));
        }
        if (libraries == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraries", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "updateLibraries"));
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                KotlinJavaModuleConfigurator kJvmConfigurator = (KotlinJavaModuleConfigurator)ConfigureKotlinInProjectUtils.getConfiguratorByName("java");
                assert (kJvmConfigurator != null) : "Configurator with given name doesn't exists: java";
                KotlinJsModuleConfigurator kJsConfigurator = (KotlinJsModuleConfigurator)ConfigureKotlinInProjectUtils.getConfiguratorByName("js");
                assert (kJsConfigurator != null) : "Configurator with given name doesn't exists: js";
                for (Library library : libraries) {
                    if (LibraryPresentationProviderUtil.isDetected(JavaRuntimePresentationProvider.getInstance(), library)) {
                        KotlinRuntimeLibraryUtil.updateJar(project, JavaRuntimePresentationProvider.getRuntimeJar(library), LibraryJarDescriptor.RUNTIME_JAR);
                        KotlinRuntimeLibraryUtil.updateJar(project, JavaRuntimePresentationProvider.getReflectJar(library), LibraryJarDescriptor.REFLECT_JAR);
                        if (kJvmConfigurator.changeOldSourcesPathIfNeeded(library)) {
                            kJvmConfigurator.copySourcesToPathFromLibrary(library);
                            continue;
                        }
                        KotlinRuntimeLibraryUtil.updateJar(project, JavaRuntimePresentationProvider.getRuntimeSrcJar(library), LibraryJarDescriptor.RUNTIME_SRC_JAR);
                        continue;
                    }
                    if (!LibraryPresentationProviderUtil.isDetected(JSLibraryStdPresentationProvider.getInstance(), library)) continue;
                    KotlinRuntimeLibraryUtil.updateJar(project, JSLibraryStdPresentationProvider.getJsStdLibJar(library), LibraryJarDescriptor.JS_STDLIB_JAR);
                    if (kJsConfigurator.changeOldSourcesPathIfNeeded(library)) {
                        kJsConfigurator.copySourcesToPathFromLibrary(library);
                        continue;
                    }
                    KotlinRuntimeLibraryUtil.updateJar(project, JSLibraryStdPresentationProvider.getJsStdLibSrcJar(library), LibraryJarDescriptor.JS_STDLIB_SRC_JAR);
                }
            }
        });
    }

    private static void updateJar(@NotNull Project project, @Nullable VirtualFile fileToReplace, @NotNull LibraryJarDescriptor libraryJarDescriptor) {
        File jarPath;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "updateJar"));
        }
        if (libraryJarDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryJarDescriptor", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "updateJar"));
        }
        if (fileToReplace == null && !libraryJarDescriptor.shouldExist) {
            return;
        }
        KotlinPaths paths = org.jetbrains.kotlin.utils.PathUtil.getKotlinPathsForIdeaPlugin();
        switch (libraryJarDescriptor) {
            case RUNTIME_JAR: {
                jarPath = paths.getRuntimePath();
                break;
            }
            case REFLECT_JAR: {
                jarPath = paths.getReflectPath();
                break;
            }
            case RUNTIME_SRC_JAR: {
                jarPath = paths.getRuntimeSourcesPath();
                break;
            }
            case JS_STDLIB_JAR: {
                jarPath = paths.getJsStdLibJarPath();
                break;
            }
            case JS_STDLIB_SRC_JAR: {
                jarPath = paths.getJsStdLibSrcJarPath();
                break;
            }
            default: {
                jarPath = null;
            }
        }
        if (!jarPath.exists()) {
            OutdatedKotlinRuntimeNotification.showRuntimeJarNotFoundDialog(project, libraryJarDescriptor.jarName).run();
            return;
        }
        VirtualFile localJar = KotlinRuntimeLibraryUtil.getLocalJar(fileToReplace);
        assert (localJar != null);
        KotlinRuntimeLibraryUtil.replaceFile(jarPath, localJar);
    }

    @NotNull
    public static Collection<Library> findKotlinLibraries(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "findKotlinLibraries"));
        }
        HashSet libraries = Sets.newHashSet();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry entry : moduleRootManager.getOrderEntries()) {
                LibraryOrderEntry libraryOrderEntry;
                Library library;
                if (!(entry instanceof LibraryOrderEntry) || (library = (libraryOrderEntry = (LibraryOrderEntry)entry).getLibrary()) == null) continue;
                libraries.add(library);
            }
        }
        HashSet hashSet = libraries;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "findKotlinLibraries"));
        }
        return hashSet;
    }

    @NotNull
    public static String bundledRuntimeVersion() {
        String string = KotlinRuntimeLibraryUtil.bundledRuntimeVersion(JetPluginUtil.getPluginVersion());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "bundledRuntimeVersion"));
        }
        return string;
    }

    @NotNull
    public static String bundledRuntimeVersion(@NotNull String pluginVersion) {
        if (pluginVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginVersion", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "bundledRuntimeVersion"));
        }
        int placeToSplit = -1;
        for (int i = 1; i < pluginVersion.length(); ++i) {
            char ch = pluginVersion.charAt(i);
            if (!Character.isLetter(ch) || pluginVersion.charAt(i - 1) != '.') continue;
            placeToSplit = i - 1;
            break;
        }
        String string = placeToSplit != -1 ? pluginVersion.substring(0, placeToSplit) : pluginVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "bundledRuntimeVersion"));
        }
        return string;
    }

    @Nullable
    public static VirtualFile getLocalJar(@Nullable VirtualFile kotlinRuntimeJar) {
        if (kotlinRuntimeJar == null) {
            return null;
        }
        VirtualFile localJarFile = JarFileSystem.getInstance().getVirtualFileForJar(kotlinRuntimeJar);
        if (localJarFile != null) {
            return localJarFile;
        }
        return kotlinRuntimeJar;
    }

    static void replaceFile(File updatedFile, VirtualFile replacedJarFile) {
        try {
            VirtualFile replacedFile = PathUtil.getLocalFile((VirtualFile)replacedJarFile);
            String localPath = PathUtil.getLocalPath((VirtualFile)replacedFile);
            assert (localPath != null) : "Should be called for replacing valid root file: " + replacedJarFile;
            File libraryJarPath = new File(localPath);
            if (FileUtil.filesEqual((File)updatedFile, (File)libraryJarPath)) {
                throw new IllegalArgumentException("Shouldn't be called for updating same file: " + updatedFile);
            }
            FileUtil.copy((File)updatedFile, (File)libraryJarPath);
            replacedFile.refresh(false, true);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @NotNull
    private static Collection<VirtualFile> getLibraryRootsWithAbiIncompatibleVersion(@NotNull Project project, @NotNull ScalarIndexExtension<BinaryVersion> index2, @NotNull Function1<Module, Boolean> checkModule, @NotNull Function1<BinaryVersion, Boolean> checkVersion) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
        }
        if (index2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
        }
        if (checkModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkModule", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
        }
        if (checkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkVersion", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
        }
        ID id = index2.getName();
        Object[] modules = ModuleManager.getInstance((Project)project).getModules();
        List modulesToCheck = KotlinPackage.filter((Object[])modules, checkModule);
        if (modulesToCheck.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
            }
            return list;
        }
        Collection versions = KotlinRuntimeLibraryUtil.collectAllKeys(id, modulesToCheck);
        HashSet badVersions = Sets.newHashSet((Iterable)KotlinPackage.filter(versions, checkVersion));
        HashSet badRoots = Sets.newHashSet();
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        for (BinaryVersion version : badVersions) {
            Collection indexedFiles = FileBasedIndex.getInstance().getContainingFiles(id, (Object)version, ProjectScope.getLibrariesScope((Project)project));
            for (VirtualFile indexedFile : indexedFiles) {
                VirtualFile libraryRoot = fileIndex.getClassRootForFile(indexedFile);
                assert (libraryRoot != null) : "Only library roots were requested, and only class files should be indexed with KotlinAbiVersionIndex key. File: " + indexedFile.getPath();
                badRoots.add(PathUtil.getLocalFile((VirtualFile)libraryRoot));
            }
        }
        HashSet hashSet = badRoots;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "getLibraryRootsWithAbiIncompatibleVersion"));
        }
        return hashSet;
    }

    @NotNull
    private static <T> Collection<T> collectAllKeys(@NotNull ID<T, Void> id, @NotNull List<Module> modules) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "collectAllKeys"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "collectAllKeys"));
        }
        HashSet allKeys = new HashSet();
        for (Module module : modules) {
            GlobalSearchScope scope2 = GlobalSearchScope.moduleWithLibrariesScope((Module)module);
            FileBasedIndex.getInstance().processAllKeys(id, (Processor)new CommonProcessors.CollectProcessor(allKeys), scope2, null);
        }
        HashSet hashSet = allKeys;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil", "collectAllKeys"));
        }
        return hashSet;
    }

    private static enum LibraryJarDescriptor {
        RUNTIME_JAR("kotlin-runtime.jar", true),
        REFLECT_JAR("kotlin-reflect.jar", false),
        RUNTIME_SRC_JAR("kotlin-runtime-sources.jar", false),
        JS_STDLIB_JAR("kotlin-jslib.jar", true),
        JS_STDLIB_SRC_JAR("kotlin-jslib-sources.jar", false);

        public final String jarName;
        private final boolean shouldExist;

        private LibraryJarDescriptor(String jarName, boolean shouldExist) {
            if (jarName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarName", "org/jetbrains/kotlin/idea/versions/KotlinRuntimeLibraryUtil$LibraryJarDescriptor", "<init>"));
            }
            this.jarName = jarName;
            this.shouldExist = shouldExist;
        }
    }
}

