/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.Collection;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"\u0016\u0006)\u00192\r[3dWN\u001bw\u000e]3G_J4\u0015N\u001c3fe*)1oY8qK*\tr\t\\8cC2\u001cV-\u0019:dQN\u001bw\u000e]3\u000b\u0007\r|WN\u0003\u0005j]R,G\u000e\\5k\u0015\r\u00018/\u001b\u0006\u0007g\u0016\f'o\u00195\u000b\r1|wmZ3s\u0015\u0019aunZ4fe*9q\u000e]3oCBL'B\u00033jC\u001etwn\u001d;jG*!QK\\5u\u0015\u0019Yw\u000e\u001e7j]*ia)\u001b7f\r&tG-\u001a:t\u0017RT\u0011DZ5oIZK'\u000f^;bY\u001aKG.Z,ji\"DU-\u00193fe*91\r\\1tg&#'bB\"mCN\u001c\u0018\n\u001a\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0011q\u0017-\\3\u000b\u0007-,\u0017P\u0003\u0002J\t*!Q\u000f^5m\u0015!Ig\u000eZ3yS:<'B\u0002$r\u001d\u0006lWM\u0003\u0003W_&$'\u0002\u00026bm\u0006TA\u0001\\1oO*Ya+\u001b:uk\u0006dg)\u001b7f\u0015\r1hm\u001d\\\u0002\u0015\t\u00012A\u0003\u0003\t\u0001A!!\u0002\u0002\u0005\u0002!\u0015QA\u0001\u0003\u0002\u0011\r)1\u0001b\u0001\t\u00031\u0001QA\u0001C\u0001\u0011\u0013)!\u0001\"\u0002\t\u000b\u0015\u0019Aa\u0001\u0005\u0005\u0019\u0001)\u0011\u0001\u0003\u0004\u0006\u0007\u0011!\u00012\u0002\u0007\u0001\u000b\t!\u0019\u0001C\u0001\u0006\u0005\u0011\u0019\u0001\u0002B\u0003\u0002\u0011#)!\u0001\u0002\u0004\t\u0013\u0015\u0011AQ\u0002\u0005\u0007\u000b\t!q\u0001c\u0005\u0006\u0007\u0011=\u0001\u0002\u0003\u0007\u0001\u000b\t!\t\u0001C\u0006\u0006\u0005\u0011E\u0001rC\u0003\u0004\t%A)\u0002\u0004\u0001\u0006\u0007\u0011=\u0001\u0002\u0004\u0007\u0001\u000b\u0005AQ\"\u0002\u0002\u0005\u0016!mQa\u0001\u0003\f\u00113a\u0001!\u0002\u0002\u0005\u0006!uQa\u0001\u0003\r\u00119a\u0001!\u0002\u0002\u0005\u0019!qQA\u0001C\b\u0011!)!\u0001B\u0005\t\u0016\u0015\tC!\u0001\r\u0001;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\ba\u001d\u0001k!\u0001\"\u0007\u0015\t\u0001\u0012\u0002M\u0005#\u000e9A\u0001A\u0005\u0002\t\u0001i\u0011\u0001C\u0003\u000e\u0003!-\u0001l!\u0004\u0006\u0003\u0004!\u0011\u0001G\u0004\u001e\u0010\u0011\u0001\u0001rB\u0007\u0004\u000b\u0005A\u0001\u0002\u0007\u0005Q\u0007\u0001i\u001a\u0003\u0002\u0001\t\u00155iQ!\u0001E\n\u0013\u0011I1!B\u0001\t\u0015aQ\u0011\u0002B\u0005\u0004\u000b\u0005A9\u0002g\u0006\u0019\u0014A\u001b\t!h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0002;\u001f!\u0001\u0001c\u0002\u000e\u0007\u0015\t\u0001r\u0001M\u0004!\u000e\r\u0011\u0005B\u0003\u0002\u00113a\t\u0001'\u0007R\u0007-!q!C\u0001\t\u001b5\t\u00012D\u0007\u0002\u00119i\u0011\u0001C\u0003\u000e\u0003!-\u0001l!\u0004"})
public final class FileFindersKt {
    public static final void checkScopeForFinder(@NotNull GlobalSearchScope scope2, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        if (Intrinsics.areEqual((Object)scope2, (Object)GlobalSearchScope.EMPTY_SCOPE) ^ true && scope2.getProject() == null) {
            logger.warn("Scope with null project " + scope2);
        }
    }

    @Nullable
    public static final VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId, @NotNull ID<FqName, Void> key, @NotNull GlobalSearchScope scope2, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Collection files = FileBasedIndex.getInstance().getContainingFiles(key, (Object)classId.asSingleFqName(), scope2);
        if (files.isEmpty()) {
            return null;
        }
        if (files.size() > 1) {
            logger.warn("There are " + files.size() + " classes with same fqName: " + classId + " found.");
        }
        return (VirtualFile)files.iterator().next();
    }
}

