/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.project.Project;
import com.intellij.psi.CommonClassNames;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.SetsKt;
import kotlin.StringsKt;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.KotlinLightField;
import org.jetbrains.kotlin.asJava.KotlinLightMethod;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.j2k.CodeConverter;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.ConverterKt;
import org.jetbrains.kotlin.j2k.DefaultExpressionConverter;
import org.jetbrains.kotlin.j2k.ExpressionConverter;
import org.jetbrains.kotlin.j2k.SpecialMethod;
import org.jetbrains.kotlin.j2k.SpecialStatementConverter;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.AnonymousClassBody;
import org.jetbrains.kotlin.j2k.ast.ArrayAccessExpression;
import org.jetbrains.kotlin.j2k.ast.ArrayType;
import org.jetbrains.kotlin.j2k.ast.ArrayWithoutInitializationExpression;
import org.jetbrains.kotlin.j2k.ast.AssignmentExpression;
import org.jetbrains.kotlin.j2k.ast.BangBangExpression;
import org.jetbrains.kotlin.j2k.ast.BinaryExpression;
import org.jetbrains.kotlin.j2k.ast.Block;
import org.jetbrains.kotlin.j2k.ast.ClassLiteralExpression;
import org.jetbrains.kotlin.j2k.ast.ClassType;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.DummyStringExpression;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.ExpressionsKt;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.IfStatement;
import org.jetbrains.kotlin.j2k.ast.IsOperator;
import org.jetbrains.kotlin.j2k.ast.LBrace;
import org.jetbrains.kotlin.j2k.ast.LambdaExpression;
import org.jetbrains.kotlin.j2k.ast.LambdaParameter;
import org.jetbrains.kotlin.j2k.ast.LiteralExpression;
import org.jetbrains.kotlin.j2k.ast.MethodCallExpression;
import org.jetbrains.kotlin.j2k.ast.NewClassExpression;
import org.jetbrains.kotlin.j2k.ast.Nullability;
import org.jetbrains.kotlin.j2k.ast.Parameter;
import org.jetbrains.kotlin.j2k.ast.ParameterList;
import org.jetbrains.kotlin.j2k.ast.ParenthesizedExpression;
import org.jetbrains.kotlin.j2k.ast.PolyadicExpression;
import org.jetbrains.kotlin.j2k.ast.PostfixExpression;
import org.jetbrains.kotlin.j2k.ast.PrefixExpression;
import org.jetbrains.kotlin.j2k.ast.QualifiedExpression;
import org.jetbrains.kotlin.j2k.ast.RBrace;
import org.jetbrains.kotlin.j2k.ast.ReferenceElement;
import org.jetbrains.kotlin.j2k.ast.ReturnStatement;
import org.jetbrains.kotlin.j2k.ast.StarExpression;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.SuperExpression;
import org.jetbrains.kotlin.j2k.ast.ThisExpression;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.TypeCastExpression;
import org.jetbrains.kotlin.j2k.ast.TypeParametersKt;
import org.jetbrains.kotlin.j2k.ast.TypesKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetProperty;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.psiUtil.JetPsiUtilKt;
import org.jetbrains.kotlin.resolve.jvm.JvmPrimitiveType;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"]\u001e)QB)\u001a4bk2$X\t\u001f9sKN\u001c\u0018n\u001c8D_:4XM\u001d;fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0002ke-T!CS1wC\u0016cW-\\3oiZK7/\u001b;pe*\u00191m\\7\u000b\u0011%tG/\u001a7mS*T1\u0001]:j\u0015M)\u0005\u0010\u001d:fgNLwN\\\"p]Z,'\u000f^3s\u0015\u0019a\u0014N\\5u})!bj\u0014(`\u001dVcEjX(Q\u000bJ\u000be\nR0P!NS1aU3u\u00151IU\t\\3nK:$H+\u001f9f\u0015\u0011!(/Z3\u000b/-|G\u000f\\5o])4XN\f)mCR4wN]7UsB,'\u0002\u00026bm\u0006TA!\u001e;jY*qqlY8eK\u000e{gN^3si\u0016\u0014(\"D\"pI\u0016\u001cuN\u001c<feR,'OC\u0007d_\u0012,7i\u001c8wKJ$XM\u001d\u0006\u0011O\u0016$8i\u001c3f\u0007>tg/\u001a:uKJT\u0011bY8om\u0016\u0014H/\u001a:\u000b\u0013\r{gN^3si\u0016\u0014(\u0002D4fi\u000e{gN^3si\u0016\u0014(B\u0002:fgVdGO\u0003\u0006FqB\u0014Xm]:j_:T1!Y:u\u00155!\u0018\u0010]3D_:4XM\u001d;fe*iA+\u001f9f\u0007>tg/\u001a:uKJT\u0001cZ3u)f\u0004XmQ8om\u0016\u0014H/\u001a:\u000b\u0017\r\fgnS3fa\u0016\u000bX)\u001d\u0006\u0005Y\u00164GOC\u0007Qg&,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0006e&<\u0007\u000e\u001e\u0006\b\u0005>|G.Z1o\u0015A\u0019wN\u001c<feR\f%oZ;nK:$8O\u0003\u0006fqB\u0014Xm]:j_:T\u0011\u0003U:j\u0007\u0006dG.\u0012=qe\u0016\u001c8/[8o\u0015-I7/\u0012=uK:\u001c\u0018n\u001c8\u000b\t1K7\u000f\u001e\u0006\u0012G>tg/\u001a:u\u000bb\u0004(/Z:tS>t'bH2p]Z,'\u000f^'fi\"|GMU3gKJ,gnY3Rk\u0006d\u0017NZ5fe*I\u0011/^1mS\u001aLWM\u001d\u0006\u000b!NLW\t\\3nK:$(BB*ue&twM\u0003\u0003mC:<'\u0002F2p]Z,'\u000f\u001e+za\u0016\f%oZ;nK:$8O\u0003\u0003dC2d'\u0002\u0002+za\u0016T!cZ3u\u000bF,\u0018\r\\:TS\u001et\u0017\r^;sK*9\u0001O]8kK\u000e$(b\u0002)s_*,7\r\u001e\u0006\b_B,g.\u00199j\u0015\u0015\u00198m\u001c9f\u0015E9En\u001c2bYN+\u0017M]2i'\u000e|\u0007/\u001a\u0006\u0007g\u0016\f'o\u00195\u000b\u001f5+G\u000f[8e'&<g.\u0019;ve\u0016T\u0011cZ3u\u001fB,'/\u0019;peN#(/\u001b8h\u0015%!xn[3o)f\u0004XM\u0003\u000ewSNLG/\u0011:sCf\f5mY3tg\u0016C\bO]3tg&|gN\u0003\rQg&\f%O]1z\u0003\u000e\u001cWm]:FqB\u0014Xm]:j_:TA!\u00168ji*yb/[:ji\u0006\u0013(/Y=J]&$\u0018.\u00197ju\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b;A\u001b\u0018.\u0011:sCfLe.\u001b;jC2L'0\u001a:FqB\u0014Xm]:j_:T\u0011D^5tSR\f5o]5h]6,g\u000e^#yaJ,7o]5p]*9\u0002k]5BgNLwM\\7f]R,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0016m&\u001c\u0018\u000e\u001e\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015M\u00016/\u001b\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o\u0015\u00012\u0018n]5u\u00072\f7o](cU\u0016\u001cG/Q2dKN\u001cX\t\u001f9sKN\u001c\u0018n\u001c8\u000b=A\u001b\u0018n\u00117bgN|%M[3di\u0006\u001b7-Z:t\u000bb\u0004(/Z:tS>t'B\u0007<jg&$8i\u001c8eSRLwN\\1m\u000bb\u0004(/Z:tS>t'\u0002\u0007)tS\u000e{g\u000eZ5uS>t\u0017\r\\#yaJ,7o]5p]*ya/[:ji\u0016C\bO]3tg&|gNC\rwSNLG/\u00138ti\u0006t7-Z(g\u000bb\u0004(/Z:tS>t'b\u0006)tS&s7\u000f^1oG\u0016|e-\u0012=qe\u0016\u001c8/[8o\u0015U1\u0018n]5u\u0019\u0006l'\rZ1FqB\u0014Xm]:j_:T1\u0003U:j\u0019\u0006l'\rZ1FqB\u0014Xm]:j_:TaC^5tSRd\u0015\u000e^3sC2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0015!NLG*\u001b;fe\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8\u000b3YL7/\u001b;NKRDw\u000eZ\"bY2,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0018!NLW*\u001a;i_\u0012\u001c\u0015\r\u001c7FqB\u0014Xm]:j_:TaD^5tSRlU\r\u001e5pIJ+g-\u001a:f]\u000e,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b9A\u001b\u0018.T3uQ>$'+\u001a4fe\u0016t7-Z#yaJ,7o]5p]*\u0011b/[:ji:+w/\u0012=qe\u0016\u001c8/[8o\u0015A\u00016/\u001b(fo\u0016C\bO]3tg&|gN\u0003\u000fwSNLG\u000fU1sK:$\b.Z:ju\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b5A\u001b\u0018\u000eU1sK:$\b.Z:ju\u0016$W\t\u001f9sKN\u001c\u0018n\u001c8\u000b/YL7/\u001b;Q_2L\u0018\rZ5d\u000bb\u0004(/Z:tS>t'\"\u0006)tSB{G._1eS\u000e,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0017m&\u001c\u0018\u000e\u001e)pgR4\u0017\u000e_#yaJ,7o]5p]*!\u0002k]5Q_N$h-\u001b=FqB\u0014Xm]:j_:TQC^5tSR\u0004&/\u001a4jq\u0016C\bO]3tg&|gNC\nQg&\u0004&/\u001a4jq\u0016C\bO]3tg&|gN\u0003\rwSNLGOU3gKJ,gnY3FqB\u0014Xm]:j_:Ta\u0003U:j%\u00164WM]3oG\u0016,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0015m&\u001c\u0018\u000e^*va\u0016\u0014X\t\u001f9sKN\u001c\u0018n\u001c8\u000b%A\u001b\u0018nU;qKJ,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0014m&\u001c\u0018\u000e\u001e+iSN,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u0012!NLG\u000b[5t\u000bb\u0004(/Z:tS>t'b\u0006<jg&$H+\u001f9f\u0007\u0006\u001cH/\u0012=qe\u0016\u001c8/[8o\u0015U\u00016/\u001b+za\u0016\u001c\u0015m\u001d;FqB\u0014Xm]:j_:T\u0011\u0002U:j\u001b\u0016$\bn\u001c3\u000b?\u001d,G\u000fU1sC6,G/\u001a:t\r>\u0014X*\u001a;i_\u0012\u0014VMZ3sK:\u001cWM\u0003\u0005oK\u0016$G\u000b[5t\u0015QI7oS8uY&tg)\u001e8di&|g\u000eV=qK*!\u0001+Y5s\u0015)IE-\u001a8uS\u001aLWM\u001d\u0006\n\u0007>l\u0007/\u00198j_:DYA\u0003\u0002\u0011\u0003)!\u0001\u0002\u0001\t\u0003\u0015\u0011A\u0011\u0001E\u0002\u000b\t!\u0011\u0001\u0003\u0002\u0006\u0007\u0011\r\u0001\u0002\u0001\u0007\u0001\u000b\u0005A1!\u0002\u0002\u0005\u0006!\u001dQA\u0001\u0003\u0004\u0011\u0011)1\u0001b\u0002\t\u00061\u0001Qa\u0001C\u0002\u0011\u0013a\u0001!B\u0001\t\u0004\u0015\u0019A!\u0002\u0005\u0007\u0019\u0001)!\u0001b\u0002\t\u000f\u0015\u0019AA\u0002E\u0007\u0019\u0001)\u0011\u0001\u0003\u0005\u0006\u0005\u00119\u0001\u0012C\u0003\u0003\t\u001fAa!B\u0002\u0005\u0004!MA\u0002A\u0003\u0003\t\u0007A\u0019\"B\u0002\u0005\u0004!]A\u0002A\u0003\u0003\t\u0007A9\"\u0002\u0002\u0005\u0004!mQa\u0001C\u000b\u00115a\u0001!\u0002\u0002\u0005\u0016!iQa\u0001C\u0002\u0011;a\u0001!\u0002\u0002\u0005\u0004!uQa\u0001C\u0004\u0011Ca\u0001!B\u0002\u0005\u000b!\rB\u0002A\u0003\u0003\t\u000fA\t#B\u0002\u0005\b!\u0019B\u0002A\u0003\u0004\t\u0015AA\u0003\u0004\u0001\u0006\u0005\u0011=\u0001\u0002F\u0003\u0003\t\u000fA1#B\u0002\u0005\b!1B\u0002A\u0003\u0004\t\u0015Ai\u0003\u0004\u0001\u0006\u0005\u00119\u0001bF\u0003\u0003\tGAi#\u0002\u0002\u0005\b!1Ra\u0001C\u000b\u0011ca\u0001!\u0002\u0002\u0005\u0007!URA\u0001C\u0014\u0011g)1\u0001\u0002\u000b\t51\u0001QA\u0001C\u0004\u0011q)1\u0001B\u000b\t81\u0001QA\u0001C\u0004\u0011#)1\u0001\u0002\f\t:1\u0001QA\u0001\u0003\u0017\u0011s)!\u0001\u0002\u000b\t5\u0015\u0011A!\u0006E\u001c\u000b\t!a\u0001#\u0004\u0006\u0007\u0011\u001d\u0001R\b\u0007\u0001\u000b\r!Q\u0001C\u0010\r\u0001\u0015\u0011Aq\u0001E\u001f\u000b\r!9\u0001\u0003\u0011\r\u0001\u0015\u0011Aq\u0001\u0005!\u000b\r!9\u0001C\u0011\r\u0001\u0015\u0011Aq\u0001\u0005\"\u000b\r!9\u0001\u0003\u0012\r\u0001\u0015\u0011Aq\u0001\u0005#\u000b\r!9\u0001C\u0012\r\u0001\u0015\u0011Aq\u0001\u0005$\u000b\r!9\u0001\u0003\u0013\r\u0001\u0015\u0011Aq\u0001\u0005%\u000b\r!9\u0001c\u0013\r\u0001\u0015\u0011Aq\u0001E&\u000b\r!9\u0001#\u0014\r\u0001\u0015\u0011Aq\u0001E'\u000b\r!9\u0001c\u0014\r\u0001\u0015\u0011Aq\u0001E(\u000b\r!9\u0001#\u0015\r\u0001\u0015\u0011Aq\u0001E)\u000b\r!9\u0001c\u0015\r\u0001\u0015\u0011Aq\u0001E*\u000b\r!9\u0001#\u0016\r\u0001\u0015\u0011Aq\u0001E+\u000b\r!9\u0001c\u0016\r\u0001\u0015\u0011Aq\u0001E,\u000b\r!9\u0001#\u0017\r\u0001\u0015\u0011Aq\u0001E-\u000b\r!9\u0001c\u0017\r\u0001\u0015\u0011Aq\u0001E.\u000b\r!9\u0001#\u0018\r\u0001\u0015\u0011Aq\u0001E/\u000b\r!9\u0001c\u0018\r\u0001\u0015\u0011Aq\u0001E0\u000b\r!9\u0001#\u0019\r\u0001\u0015\u0011Aq\u0001E1\u000b\r!9\u0001c\u0019\r\u0001\u0015\u0011Aq\u0001E2\u000b\r!9\u0001#\u001a\r\u0001\u0015\u0011Aq\u0001E3\u000b\r!9\u0001C\u001a\r\u0001\u0015\u0019A!\u0002\u00056\u0019\u0001)1\u0001\"\u0006\tl1\u0001QA\u0001C\u0004\u0011M\"1\u0001\u0004\u0002\u0011me\u0019Q!\u0001\u0005\u00051\u0011I2!B\u0001\t\na%Q\u0014\u0001\u001c./\u0011\tG\u0001g\u0003\"\u001d\u0015\t\u00012B\u0005\u000b\u0013%)\u0011\u0001#\u0004\u0011\u0010U!Q!\u0001E\u0007\u0019\u0003Aj\u0001'\u0004\u0019\fU\u001bA!B\u0002\u0005\f%\t\u0001\u0002C\u0017\u000e\t\u0005g\u0001$C\u0011\u0005\u000b\u0005A\t\u0002$\u0001\u0019\u0012U\u001bA!B\u0002\u0005\u0013%\t\u0001\"C\u0017\u000e\t\u0005$\u0001DC\u0011\u0004\u000b\u0005A\t\u0002'\u0005%CU\u001bA!D\u0002\u0005\u0016%\t\u0001\"C\u0017\u000e\t\u0005$\u0001dC\u0011\u0004\u000b\u0005A\u0019\u0002g\u0005%CU\u001bA!D\u0002\u0005\u0019%\t\u0001BC\u0017\r\t\u0005g\u0001\u0014D\u0011\u0004\u000b\u0005A1\u0002G\u0006V\u0007\u0011)1\u0001\"\u0007\n\u0003!]Q&\u0004\u0003b\taq\u0011eA\u0003\u0002\u00111AB\u0002J\u0011V\u0007\u0011i1\u0001B\b\n\u0003!eQ\u0016\t\u0003\u00021?iz\u0001\u0002\u0001\t!5\u0019Q!\u0001\u0005\u000e15\u00016\u0001AO\t\t\u0001A\u0011#\u0004\u0003\u0006\u0003!iA\u0012\u0001\r\u000e!\u000e\u0005\u0011eA\u0003\u0002\u00117AZ\"U\u0002\b\t?I\u0011\u0001\"\u0001\u000e\u0003!qQ\"\u0001\u0005\u000f[\u0013\"\u0011\u0001\u0007\n\u001e\u0010\u0011\u0001\u0001RE\u0007\u0004\u000b\u0005Ai\u0002'\bQ\u0007\u0001iz\u0001B\u0001\t(5\u0019Q!\u0001E\u000e17\u00016\u0011A\u0011\t\u000b\u0005Aq\"\u0003\u0003\n\u0007\u0015\t\u0001b\u0003\r\f1=\t6a\u0002\u0003\u0013\u0013\u0005Ay\"D\u0001\t!5\tA\u0011AW \t-AJ#h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u00115AR\u0002U\u0002\u0001;\u001f!\u0001\u0001\u0003\u0006\u000e\u0007\u0015\t\u0001\u0012\u0003M\t!\u000e\u0005\u0011eA\u0003\u0002\u0011-A2\"U\u0002\b\tSI\u0011\u0001c\u0006\u000e\u0003!qQ\"\u0001\u0005\n[U!\u0011\u0001G\u000b\u001e\u0010\u0011\u0001\u00012F\u0007\u0004\u000b\u0005A\t\u0003'\tQ\u0007\u0001\t3!B\u0001\t#a\t\u0012kA\u0003\u0005+%\t\u0001BE\u0007\u0002\u0011Ki#\u0004B\u0001\u00190u=A\u0001\u0001\u0005\u0019\u001b\r)\u0011\u0001#\b\u0019\u001eA\u001b\u0001!\t\u0005\u0006\u0003!y\u0011\u0002B\u0005\u0004\u000b\u0005A1\u0003G\n\u0019\u001fE\u001bQ\u0001b\f\n\u0003!}Q\"\u0001\u0005\u0011[\u007f!\u0011\u0001G\r\u001e\u0010\u0011\u0001\u00012G\u0007\u0004\u000b\u0005AI\u0003'\u000bQ\u0007\u0001iz\u0001\u0002\u0001\t75\u0019Q!\u0001E\u00161W\u00016\u0011A\u0011\u0004\u000b\u0005Ai\u0003'\fR\u0007\u001d!\u0011$C\u0001\t/5\t\u0001rF\u0007\u0002\u0011aiS\u0003B\u0001\u0019;u=A\u0001\u0001E\u001e\u001b\r)\u0011\u0001#\u0004\u0019\u000eA\u001b\u0001!I\u0002\u0006\u0003!\t\u0002$E)\u0004\u000b\u0011i\u0012\"\u0001\u0005\u0013\u001b\u0005A\t$L\u000b\u0005\u0017aqRt\u0002\u0003\u0001\u0011Ki1!B\u0001\t3aI\u0002k\u0001\u0001\"\u0007\u0015\t\u00012\u0007M\u001a#\u000e)AAH\u0005\u0002\t\u0001i\u0011\u0001\u0003\u000e.+\u0011Y\u0001tHO\b\t\u0001A)#D\u0002\u0006\u0003!U\u0002T\u0007)\u0004\u0001\u0005\u001aQ!\u0001E\u001a1g\t6!\u0002C \u0013\u0005!\u0001!D\u0001\t75*Ba\u0003M!;\u001f!\u0001\u0001#\n\u000e\u0007\u0015\t\u0001r\u0007M\u001c!\u000e\u0001\u0011eA\u0003\u0002\u0011gA\u001a$U\u0002\u0006\t\u0003J\u0011\u0001\u0002\u0001\u000e\u0003!aR&\u0006\u0003\f1\u0007jz\u0001\u0002\u0001\t&5\u0019Q!\u0001E\u001d1s\u00016\u0001A\u0011\u0004\u000b\u0005A\u0019\u0004g\rR\u0007\u0015!\u0019%C\u0001\u0005\u00015\t\u0001\"H\u0017\u0016\t-A*%h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u0011wAZ\u0004U\u0002\u0001C\r)\u0011\u0001c\r\u00194E\u001bQ\u0001\"\u0012\n\u0003\u0011\u0001Q\"\u0001\u0005\u001f[U!1\u0002g\u0012\u001e\u0010\u0011\u0001\u0001RE\u0007\u0004\u000b\u0005Ai\u0004'\u0010Q\u0007\u0001\t3!B\u0001\t4aM\u0012kA\u0003\u0005H%\tA\u0001A\u0007\u0002\u0011}iS\u0003B\u0006\u0019Ju=A\u0001\u0001E\u0013\u001b\r)\u0011\u0001C\u0007\u0019\u001bA\u001b\u0001!I\u0002\u0006\u0003!M\u00024G)\u0004\u000b\u0011%\u0013\"\u0001\u0003\u0001\u001b\u0005Aa\"L\u000b\u0005\u0017a)St\u0002\u0003\u0001\u0011Ki1!B\u0001\t@a}\u0002k\u0001\u0001\"\u0007\u0015\t\u00012\u0007M\u001a#\u000e)A!J\u0005\u0002\t\u0001i\u0011\u0001\u0003\u0011.+\u0011Y\u0001DJO\b\t\u0001A)#D\u0002\u0006\u0003!\u0005\u0003\u0014\t)\u0004\u0001\u0005\u001aQ!\u0001E\u001a1g\t6!\u0002\u0003'\u0013\u0005!\u0001!D\u0001\tC5*Ba\u0003\r(;\u001f!\u0001\u0001#\n\u000e\u0007\u0015\t\u00012\tM\"!\u000e\u0001\u0011eA\u0003\u0002\u0011gA\u001a$U\u0002\u0006\t\u001dJ\u0011\u0001\u0002\u0001\u000e\u0003!\u0011S&\u0006\u0003\f1!jz\u0001\u0002\u0001\t&5\u0019Q!\u0001E#1\u000b\u00026\u0001A\u0011\u0004\u000b\u0005A\u0019\u0004g\rR\u0007\u0015!\u0001&C\u0001\u0005\u00015\t\u0001bI\u0017\u0016\t-A\u0012&h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u0011\u000fB:\u0005U\u0002\u0001C\r)\u0011\u0001c\r\u00194E\u001bQ\u0001B\u0015\n\u0003\u0011\u0001Q\"\u0001\u0005%[U!1\u0002\u0007\u0016\u001e\u0010\u0011\u0001\u0001RE\u0007\u0004\u000b\u0005AI\u0005'\u0013Q\u0007\u0001\t3!B\u0001\t4aM\u0012kA\u0003\u0005U%\tA\u0001A\u0007\u0002\u0011\u0015jS\u0003B\u0006\u0019Wu=A\u0001\u0001E\u0013\u001b\r)\u0011\u0001c\u0013\u0019LA\u001b\u0001!I\u0002\u0006\u0003!M\u00024G)\u0004\u000b\u0011Y\u0013\"\u0001\u0003\u0001\u001b\u0005Aa%L\u000b\u0005\u0017aaSt\u0002\u0003\u0001\u0011Ki1!B\u0001\tNa5\u0003k\u0001\u0001\"\u0007\u0015\t\u00012\u0007M\u001a#\u000e)A\u0001L\u0005\u0002\t\u0001i\u0011\u0001C\u0014.+\u0011Y\u0001$LO\b\t\u0001A)#D\u0002\u0006\u0003!=\u0003t\n)\u0004\u0001\u0005\u001aQ!\u0001E\u001a1g\t6!\u0002\u0003.\u0013\u0005!\u0001!D\u0001\tQ5*Ba\u0003\r/;\u001f!\u0001\u0001#\n\u000e\u0007\u0015\t\u0001\u0012\u000bM)!\u000e\u0001\u0011eA\u0003\u0002\u0011gA\u001a$U\u0002\u0006\t9J\u0011\u0001\u0002\u0001\u000e\u0003!IS&\u0006\u0003\f1=jz\u0001\u0002\u0001\t&5\u0019Q!\u0001E*1'\u00026\u0001A\u0011\u0004\u000b\u0005A\u0019\u0004g\rR\u0007\u0015!q&C\u0001\u0005\u00015\t\u0001BK\u0017\u0016\t-A\u0002'h\u0004\u0005\u0001!\u0015RbA\u0003\u0002\u0011+B*\u0006U\u0002\u0001C\r)\u0011\u0001c\r\u00194E\u001bQ\u0001\u0002\u0019\n\u0003\u0011\u0001Q\"\u0001\u0005,[U!1\u0002G\u0019\u001e\u0010\u0011\u0001\u0001RE\u0007\u0004\u000b\u0005A9\u0006g\u0016Q\u0007\u0001\t3!B\u0001\t4aM\u0012kA\u0003\u0005c%\tA\u0001A\u0007\u0002\u00111jS\u0003B\u0006\u0019eu=A\u0001\u0001E\u0013\u001b\r)\u0011\u0001#\u0017\u0019ZA\u001b\u0001!I\u0002\u0006\u0003!M\u00024G)\u0004\u000b\u0011\u0011\u0014\"\u0001\u0003\u0001\u001b\u0005AQ&l\u001b\u0005\u0003U\u0019Q!\u0001E.17B:'h\u0004\u0005\u0001!!TbA\u0003\u0002\u00117AZ\u0002UB\u0001;\u001f!\u0001\u0001#\u001b\u000e\u0007\u0015\t\u00012\u0004M\u000e!\u000e\t\u0011eE\u0003\u0002\u0011=Iq\"\u0003\b\u0006\u0003!q\u0013\u0002B\u0005\u0004\u000b\u0005Ai\u0006'\u0018\n\u000b%!Q!\u0001\u0005\u0014\u0019\u0003A2\u0003\u0007\u0018\u0019\u001fE\u001b\u0011\u0002b\u001a\n\u0003!}Q\"\u0001\u00050\u001b\u0005!\t!D\u0001\u0005\u0002UbQa\u0003\u0003d\u0002a)\u0011eA\u0003\u0002\u0011\tA\"!U\u0002\u0004\t\u0015I\u0011\u0001\u0002\u0001"})
public final class DefaultExpressionConverter
extends JavaElementVisitor
implements ExpressionConverter {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final Set<? extends String> needQualifierNameSet;
    private CodeConverter _codeConverter;
    private Expression result = Expression.Empty.INSTANCE$;
    private final Set<? extends IElementType> NON_NULL_OPERAND_OPS = SetsKt.setOf((Object[])new IElementType[]{JavaTokenType.ANDAND, JavaTokenType.OROR, JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC, JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT});
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(DefaultExpressionConverter.class);
        Companion companion = Companion = new Companion(null);
        needQualifierNameSet = SetsKt.setOf((Object[])new String[]{"java.lang.Byte", "java.lang.Double", "java.lang.Float", "java.lang.Long", "java.lang.Short"});
    }

    private final CodeConverter getCodeConverter() {
        CodeConverter codeConverter = this._codeConverter;
        if (codeConverter == null) {
            Intrinsics.throwNpe();
        }
        return codeConverter;
    }

    private final TypeConverter getTypeConverter() {
        return this.getCodeConverter().getTypeConverter();
    }

    private final Converter getConverter() {
        return this.getCodeConverter().getConverter();
    }

    @Override
    @NotNull
    public Expression convertExpression(@NotNull PsiExpression expression2, @NotNull CodeConverter codeConverter) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
        this._codeConverter = codeConverter;
        this.result = Expression.Empty.INSTANCE$;
        expression2.accept((PsiElementVisitor)this);
        return this.result;
    }

    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiElement $receiver = (PsiElement)expression2;
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiAssignmentExpression.class, (boolean)true);
        boolean lvalue = assignment != null && Intrinsics.areEqual((Object)expression2, (Object)assignment.getLExpression());
        this.result = new ArrayAccessExpression(this.getCodeConverter().convertExpression(expression2.getArrayExpression()), this.getCodeConverter().convertExpression(expression2.getIndexExpression()), lvalue);
    }

    /*
     * WARNING - void declaration
     */
    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression2) {
        List list;
        void destination;
        void $receiver;
        void $receiver2;
        void value22;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiType arrayType = expression2.getType();
        PsiType psiType = arrayType;
        if (!(psiType instanceof PsiArrayType)) {
            psiType = null;
        }
        PsiArrayType psiArrayType = (PsiArrayType)psiType;
        PsiType componentType = psiArrayType != null ? psiArrayType.getComponentType() : null;
        Type expressionType = TypeConverter.convertType$default(this.getTypeConverter(), arrayType, null, null, false, 14);
        boolean bl = expressionType instanceof ArrayType;
        if (PreconditionsKt.getASSERTIONS_ENABLED() && value22 == false) {
            String message = "Array initializer must have array type: expressionType = " + expressionType + " expression = " + expression2;
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        Type type2 = expressionType;
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.j2k.ast.ArrayType");
        }
        Object[] value22 = expression2.getInitializers();
        ArrayType arrayType2 = (ArrayType)type2;
        DefaultExpressionConverter defaultExpressionConverter = this;
        void message = $receiver2;
        Collection collection = new ArrayList(((void)$receiver2).length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            PsiExpression psiExpression = (PsiExpression)item;
            list = destination;
            Expression expression3 = this.getCodeConverter().convertExpression((PsiExpression)it, componentType);
            list.add(expression3);
        }
        list = (List)destination;
        defaultExpressionConverter.result = ExpressionsKt.createArrayInitializerExpression$default(arrayType2, list, false, 4);
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression2) {
        IElementType tokenType;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType iElementType = tokenType = expression2.getOperationSign().getTokenType();
        String secondOp = Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GTGTEQ) ? "shr" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.LTLTEQ) ? "shl" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.XOREQ) ? "xor" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.ANDEQ) ? "and" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.OREQ) ? "or" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GTGTGTEQ) ? "ushr" : "")))));
        Expression lhs = this.getCodeConverter().convertExpression(expression2.getLExpression());
        CodeConverter codeConverter = this.getCodeConverter();
        PsiExpression psiExpression = expression2.getRExpression();
        if (psiExpression == null) {
            Intrinsics.throwNpe();
        }
        Expression rhs = codeConverter.convertExpression(psiExpression, expression2.getLExpression().getType());
        if (!StringsKt.isEmpty((String)secondOp)) {
            this.result = new AssignmentExpression(lhs, (Expression)ElementKt.assignNoPrototype((Element)new BinaryExpression(lhs, rhs, secondOp)), " = ");
        } else {
            String string = expression2.getOperationSign().getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.result = new AssignmentExpression(lhs, rhs, string);
        }
    }

    public void visitBinaryExpression(@NotNull PsiBinaryExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiExpression left = expression2.getLOperand();
        PsiExpression right = expression2.getROperand();
        Expression leftConverted = this.getCodeConverter().convertExpression(left, null);
        Expression rightConverted = this.getCodeConverter().convertExpression(right, null);
        IElementType operationTokenType = expression2.getOperationTokenType();
        if (this.NON_NULL_OPERAND_OPS.contains(operationTokenType)) {
            leftConverted = BangBangExpression.Companion.surroundIfNullable(leftConverted);
            rightConverted = BangBangExpression.Companion.surroundIfNullable(rightConverted);
        }
        if (Intrinsics.areEqual((Object)operationTokenType, (Object)JavaTokenType.GTGTGT)) {
            this.result = MethodCallExpression.Companion.buildNotNull$default(MethodCallExpression.Companion, leftConverted, "ushr", CollectionsKt.listOf((Object)rightConverted), null, 8);
        } else {
            IElementType iElementType = operationTokenType;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"operationTokenType");
            String operatorString = this.getOperatorString(iElementType);
            if (Intrinsics.areEqual((Object)operationTokenType, (Object)JavaTokenType.EQEQ) || Intrinsics.areEqual((Object)operationTokenType, (Object)JavaTokenType.NE)) {
                PsiExpression psiExpression = left;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiExpression, (String)"left");
                if (!this.canKeepEqEq(psiExpression, right)) {
                    operatorString = operatorString + "=";
                }
            }
            this.result = new BinaryExpression(leftConverted, rightConverted, operatorString);
        }
    }

    private final boolean canKeepEqEq(PsiExpression left, PsiExpression right) {
        block11: {
            block10: {
                if (UtilsKt.isNullLiteral(left)) break block10;
                PsiExpression psiExpression = right;
                if (!(psiExpression != null ? UtilsKt.isNullLiteral(psiExpression) : false)) break block11;
            }
            return true;
        }
        PsiType type2 = left.getType();
        PsiType psiType = type2;
        if (psiType instanceof PsiPrimitiveType || psiType instanceof PsiArrayType) {
            return true;
        }
        if (psiType instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            if (psiClass == null) {
                return false;
            }
            PsiClass psiClass2 = psiClass;
            if (!psiClass2.hasModifierProperty(PsiModifier.FINAL)) {
                return false;
            }
            if (psiClass2.isEnum()) {
                return true;
            }
            Project project = this.getConverter().getProject();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.getConverter().getProject());
            Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(converter.project)");
            MethodSignature equalsSignature = this.getEqualsSignature(project, globalSearchScope);
            PsiMethod equalsMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)psiClass2, (MethodSignature)equalsSignature, (boolean)true);
            if (equalsMethod != null) {
                PsiClass psiClass3 = equalsMethod.getContainingClass();
                if (Intrinsics.areEqual((Object)(psiClass3 != null ? psiClass3.getQualifiedName() : null), (Object)CommonClassNames.JAVA_LANG_OBJECT) ^ true) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private final MethodSignature getEqualsSignature(Project project, GlobalSearchScope scope2) {
        PsiClassType javaLangObject = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)scope2);
        PsiType[] psiTypeArray = new PsiType[1];
        PsiClassType psiClassType = javaLangObject;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClassType, (String)"javaLangObject");
        psiTypeArray[0] = (PsiType)psiClassType;
        MethodSignature methodSignature = MethodSignatureUtil.createMethodSignature((String)"equals", (PsiType[])psiTypeArray, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        Intrinsics.checkExpressionValueIsNotNull((Object)methodSignature, (String)"MethodSignatureUtil.crea\u2026AY, PsiSubstitutor.EMPTY)");
        return methodSignature;
    }

    /*
     * WARNING - void declaration
     */
    public void visitClassObjectAccessExpression(@NotNull PsiClassObjectAccessExpression expression2) {
        String classNameToUse;
        FqName fqName2;
        Object v0;
        String typeName;
        PsiTypeElement operand;
        block5: {
            void $receiver;
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            operand = expression2.getOperand();
            typeName = operand.getType().getCanonicalText();
            Object[] objectArray = (Object[])JvmPrimitiveType.values();
            for (int i = 0; i < ((void)$receiver).length; ++i) {
                void element2 = $receiver[i];
                JvmPrimitiveType it = (JvmPrimitiveType)element2;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)typeName)) continue;
                v0 = element2;
                break block5;
            }
            v0 = null;
        }
        JvmPrimitiveType primitiveType = v0;
        if (primitiveType != null) {
            fqName2 = primitiveType.getWrapperFqName();
        } else if (Intrinsics.areEqual((Object)typeName, (Object)"void")) {
            fqName2 = new FqName("java.lang.Void");
        } else {
            Type type2 = this.getConverter().convertTypeElement(operand, Nullability.NotNull);
            this.result = new QualifiedExpression((Expression)ElementKt.assignNoPrototype((Element)new ClassLiteralExpression(type2)), (Expression)ElementKt.assignNoPrototype((Element)new Identifier("java", false, false, null, 14, null)));
            return;
        }
        FqName wrapperTypeName = fqName2;
        String qualifiedName = wrapperTypeName.asString();
        String string = classNameToUse = DefaultExpressionConverter.Companion.getNeedQualifierNameSet().contains(qualifiedName) ? qualifiedName : wrapperTypeName.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"classNameToUse");
        this.result = new QualifiedExpression((Expression)ElementKt.assignPrototype$default(new Identifier(string, false, false, null, 12, null), (PsiElement)operand, null, 2), (Expression)ElementKt.assignNoPrototype((Element)new Identifier("TYPE", false, false, null, 12, null)));
    }

    public void visitConditionalExpression(@NotNull PsiConditionalExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiExpression condition2 = expression2.getCondition();
        PsiType type2 = condition2.getType();
        Expression expr = type2 != null ? this.getCodeConverter().convertExpression(condition2, type2) : this.getCodeConverter().convertExpression(condition2);
        this.result = new IfStatement(expr, this.getCodeConverter().convertExpression(expression2.getThenExpression()), this.getCodeConverter().convertExpression(expression2.getElseExpression()), UtilsKt.isInSingleLine((PsiElement)expression2));
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiTypeElement checkType2 = expression2.getCheckType();
        this.result = new IsOperator(this.getCodeConverter().convertExpression(expression2.getOperand()), this.getConverter().convertTypeElement(checkType2, Nullability.NotNull));
    }

    public void visitLiteralExpression(@NotNull PsiLiteralExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Object value2 = expression2.getValue();
        String string = expression2.getText();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String text = string;
        PsiType type2 = expression2.getType();
        if (type2 != null) {
            String typeStr = type2.getCanonicalText();
            if (Intrinsics.areEqual((Object)typeStr, (Object)"double") && !StringsKt.contains$default((String)(text = StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"D", (String)"", (boolean)false, (int)4), (String)"d", (String)"", (boolean)false, (int)4)), (CharSequence)".", (boolean)false, (int)2)) {
                text = text + ".0";
            }
            if (Intrinsics.areEqual((Object)typeStr, (Object)"float")) {
                text = StringsKt.replace$default((String)text, (String)"F", (String)"f", (boolean)false, (int)4);
            }
            if (Intrinsics.areEqual((Object)typeStr, (Object)"long")) {
                text = StringsKt.replace$default((String)text, (String)"l", (String)"L", (boolean)false, (int)4);
            }
            if (Intrinsics.areEqual((Object)typeStr, (Object)"int")) {
                text = value2 != null ? value2.toString() : text;
            }
        }
        this.result = new LiteralExpression(text);
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiReferenceExpression methodExpr = expression2.getMethodExpression();
        PsiExpression[] arguments2 = expression2.getArgumentList().getExpressions();
        PsiElement target = methodExpr.resolve();
        boolean isNullable = target instanceof PsiMethod ? TypesKt.isNullable(this.getTypeConverter().methodNullability((PsiMethod)target), this.getCodeConverter().getSettings()) : false;
        List<Type> typeArguments = this.convertTypeArguments((PsiCallExpression)expression2);
        if (target instanceof KotlinLightMethod) {
            boolean isTopLevel;
            JetClassOrObject jetClassOrObject;
            JetDeclaration origin;
            JetDeclaration jetDeclaration = origin = ((KotlinLightMethod)target).getOrigin();
            if (jetDeclaration != null) {
                void $receiver;
                PsiElement psiElement2 = jetDeclaration;
                jetClassOrObject = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$receiver, JetClassOrObject.class, (boolean)true);
            } else {
                jetClassOrObject = null;
            }
            boolean bl = isTopLevel = jetClassOrObject == null;
            if (origin instanceof JetProperty || origin instanceof JetPropertyAccessor || origin instanceof JetParameter) {
                JetNamedDeclaration jetNamedDeclaration;
                if (origin instanceof JetPropertyAccessor) {
                    PsiElement psiElement3 = ((JetPropertyAccessor)origin).getParent();
                    if (psiElement3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetProperty");
                    }
                    jetNamedDeclaration = (JetProperty)psiElement3;
                } else {
                    JetDeclaration jetDeclaration2 = origin;
                    if (jetDeclaration2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.JetNamedDeclaration");
                    }
                    jetNamedDeclaration = (JetNamedDeclaration)jetDeclaration2;
                }
                JetNamedDeclaration property2 = jetNamedDeclaration;
                int parameterCount = ((Object[])((KotlinLightMethod)target).getParameterList().getParameters()).length;
                if (parameterCount == ((Object[])arguments2).length) {
                    String string = property2.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"property.getName()!!");
                    Identifier propertyName = (Identifier)ElementKt.assignNoPrototype((Element)new Identifier(string, isNullable, false, null, 12, null));
                    boolean isExtension = JetPsiUtilKt.isExtensionDeclaration(property2);
                    Expression propertyAccess = isTopLevel ? (isExtension ? (Expression)ElementKt.assignNoPrototype((Element)new QualifiedExpression(this.getCodeConverter().convertExpression((PsiExpression)ArraysKt.firstOrNull((Object[])arguments2)), propertyName)) : (Expression)propertyName) : (Expression)ElementKt.assignNoPrototype((Element)new QualifiedExpression(this.getCodeConverter().convertExpression(methodExpr.getQualifierExpression()), propertyName));
                    switch (isExtension ? parameterCount - 1 : parameterCount) {
                        case 0: {
                            this.result = propertyAccess;
                            return;
                        }
                        case 1: {
                            Expression argument = this.getCodeConverter().convertExpression(arguments2[isExtension ? 1 : 0]);
                            this.result = new AssignmentExpression(propertyAccess, argument, "=");
                            return;
                        }
                    }
                }
            } else if (origin instanceof JetFunction && isTopLevel) {
                MethodCallExpression methodCallExpression;
                if (JetPsiUtilKt.isExtensionDeclaration(origin)) {
                    Expression qualifier2 = this.getCodeConverter().convertExpression((PsiExpression)ArraysKt.firstOrNull((Object[])arguments2));
                    String string = ((JetFunction)origin).getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"origin.getName()!!");
                    methodCallExpression = MethodCallExpression.Companion.build(qualifier2, string, this.convertArguments((PsiCallExpression)expression2, true), typeArguments, isNullable);
                } else {
                    Expression expression3 = null;
                    String string = ((JetFunction)origin).getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"origin.getName()!!");
                    methodCallExpression = MethodCallExpression.Companion.build(expression3, string, DefaultExpressionConverter.convertArguments$default(this, (PsiCallExpression)expression2, false, 2), typeArguments, isNullable);
                }
                this.result = methodCallExpression;
                return;
            }
        }
        if (target instanceof PsiMethod) {
            Object v11;
            block24: {
                void $receiver;
                Object[] isTopLevel = (Object[])SpecialMethod.values();
                for (int i = 0; i < ((void)$receiver).length; ++i) {
                    void element2 = $receiver[i];
                    SpecialMethod it = (SpecialMethod)element2;
                    if (!it.matches((PsiMethod)target)) continue;
                    v11 = element2;
                    break block24;
                }
                v11 = null;
            }
            SpecialMethod specialMethod = v11;
            if (specialMethod != null && (specialMethod.getParameterCount() == null || Intrinsics.areEqual((Object)specialMethod.getParameterCount(), (Object)((Object[])arguments2).length))) {
                PsiExpression psiExpression = methodExpr.getQualifierExpression();
                Intrinsics.checkExpressionValueIsNotNull((Object)arguments2, (String)"arguments");
                Expression converted = specialMethod.convertCall(psiExpression, arguments2, typeArguments, this.getCodeConverter());
                if (converted != null) {
                    this.result = converted;
                    return;
                }
            }
        }
        this.result = new MethodCallExpression(this.getCodeConverter().convertExpression((PsiExpression)methodExpr), DefaultExpressionConverter.convertArguments$default(this, (PsiCallExpression)expression2, false, 2), typeArguments, isNullable);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Type> convertTypeArguments(PsiCallExpression call) {
        void destination;
        void $receiver;
        Type type2;
        void var13_13;
        PsiType $receiver2;
        PsiTypeParameter[] typeParameters;
        Iterable method;
        JavaResolveResult resolve2;
        List typeArgs = ArraysKt.toList((Object[])call.getTypeArguments());
        if (typeArgs.size() == 0 && (resolve2 = call.resolveMethodGenerics()).isValidResult()) {
            PsiElement psiElement2 = resolve2.getElement();
            if (!(psiElement2 instanceof PsiMethod)) {
                psiElement2 = null;
            }
            if ((method = (PsiMethod)psiElement2) != null && ArraysKt.isNotEmpty((Object[])(typeParameters = method.getTypeParameters()))) {
                void destination2;
                void $receiver3;
                Map map2 = resolve2.getSubstitutor().getSubstitutionMap();
                Object[] objectArray = typeParameters;
                void var8_8 = $receiver3;
                Collection collection = new ArrayList(((void)$receiver3).length);
                for (int i = 0; i < ((PsiType)$receiver2).length; ++i) {
                    void it;
                    PsiType item = $receiver2[i];
                    PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item;
                    var13_13 = destination2;
                    if ((PsiType)map2.get(it) == null) {
                        return CollectionsKt.listOf();
                    }
                    var13_13.add(type2);
                }
                typeArgs = (List)destination2;
            }
        }
        Iterable $receiver4 = typeArgs;
        method = $receiver4;
        typeParameters = (PsiTypeParameter[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver4, (int)10));
        for (Object item : $receiver) {
            void it;
            $receiver2 = (PsiType)item;
            var13_13 = destination;
            type2 = TypeConverter.convertType$default(this.getTypeConverter(), (PsiType)it, null, null, false, 14);
            var13_13.add(type2);
        }
        return (List)destination;
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (expression2.getArrayInitializer() != null) {
            this.result = this.getCodeConverter().convertExpression((PsiExpression)expression2.getArrayInitializer());
        } else if (((Object[])expression2.getArrayDimensions()).length > 0 && expression2.getType() instanceof PsiArrayType) {
            Type type2 = TypeConverter.convertType$default(this.getTypeConverter(), expression2.getType(), Nullability.NotNull, null, false, 12);
            if (type2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.j2k.ast.ArrayType");
            }
            ArrayType arrayType = (ArrayType)type2;
            CodeConverter codeConverter = this.getCodeConverter();
            PsiExpression[] psiExpressionArray = expression2.getArrayDimensions();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiExpressionArray, (String)"expression.getArrayDimensions()");
            this.result = new ArrayWithoutInitializationExpression(arrayType, codeConverter.convertExpressions(psiExpressionArray));
        } else {
            PsiAnonymousClass anonymousClass = expression2.getAnonymousClass();
            PsiExpression qualifier2 = expression2.getQualifier();
            PsiJavaCodeReferenceElement classRef = expression2.getClassOrAnonymousClassReference();
            ReferenceElement classRefConverted = classRef != null ? Converter.convertCodeReferenceElement$default(this.getConverter(), classRef, qualifier2 != null, null, 4) : (ReferenceElement)null;
            this.result = new NewClassExpression(classRefConverted, DefaultExpressionConverter.convertArguments$default(this, (PsiCallExpression)expression2, false, 2), this.getCodeConverter().convertExpression(qualifier2), anonymousClass != null ? this.getConverter().convertAnonymousClassBody(anonymousClass) : (AnonymousClassBody)null);
        }
    }

    public void visitParenthesizedExpression(@NotNull PsiParenthesizedExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        this.result = new ParenthesizedExpression(this.getCodeConverter().convertExpression(expression2.getExpression()));
    }

    public void visitPostfixExpression(@NotNull PsiPostfixExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IElementType iElementType = expression2.getOperationSign().getTokenType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.getOperationSign().getTokenType()");
        this.result = new PostfixExpression(this.getOperatorString(iElementType), this.getCodeConverter().convertExpression(expression2.getOperand()));
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        CodeConverter codeConverter = this.getCodeConverter();
        PsiExpression psiExpression = expression2.getOperand();
        PsiExpression psiExpression2 = expression2.getOperand();
        if (psiExpression2 == null) {
            Intrinsics.throwNpe();
        }
        Expression operand = codeConverter.convertExpression(psiExpression, psiExpression2.getType());
        IElementType token = expression2.getOperationTokenType();
        if (Intrinsics.areEqual((Object)token, (Object)JavaTokenType.TILDE)) {
            this.result = MethodCallExpression.Companion.buildNotNull$default(MethodCallExpression.Companion, operand, "inv", null, null, 12);
        } else if (Intrinsics.areEqual((Object)token, (Object)JavaTokenType.EXCL) && operand instanceof BinaryExpression && Intrinsics.areEqual((Object)((BinaryExpression)operand).getOp(), (Object)"==")) {
            this.result = new BinaryExpression(((BinaryExpression)operand).getLeft(), ((BinaryExpression)operand).getRight(), "!=");
        } else {
            IElementType iElementType = token;
            Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"token");
            this.result = new PrefixExpression(this.getOperatorString(iElementType), operand);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getText(), (Object)"this")) {
            this.result = new ThisExpression(Identifier.Companion.getEmpty());
            return;
        }
        if (Intrinsics.areEqual((Object)expression2.getText(), (Object)"super")) {
            this.result = new SuperExpression(Identifier.Companion.getEmpty());
            return;
        }
        String string = expression2.getReferenceName();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        String referenceName = string;
        PsiElement target = expression2.resolve();
        boolean isNullable = target instanceof PsiVariable && TypesKt.isNullable(this.getTypeConverter().variableNullability((PsiVariable)target), this.getCodeConverter().getSettings());
        PsiExpression qualifier2 = expression2.getQualifierExpression();
        String string2 = referenceName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"referenceName");
        Identifier identifier = (Identifier)ElementKt.assignNoPrototype((Element)new Identifier(string2, isNullable, false, null, 12, null));
        if (qualifier2 != null && qualifier2.getType() instanceof PsiArrayType && Intrinsics.areEqual((Object)referenceName, (Object)"length")) {
            identifier = (Identifier)ElementKt.assignNoPrototype((Element)new Identifier("size()", isNullable, false, null, 12, null));
        } else if (qualifier2 != null) {
            if (target instanceof KotlinLightField && ((KotlinLightField)target).getOrigin() instanceof JetObjectDeclaration) {
                this.result = this.getCodeConverter().convertExpression(qualifier2);
                return;
            }
        } else {
            PsiElement context;
            PsiElement psiElement2;
            if (target instanceof PsiClass) {
                boolean bl;
                block19: {
                    void $receiver;
                    Object[] objectArray = (Object[])PrimitiveType.values();
                    for (int i = 0; i < ((void)$receiver).length; ++i) {
                        void element2 = $receiver[i];
                        PrimitiveType it = (PrimitiveType)element2;
                        if (!Intrinsics.areEqual((Object)it.getTypeName().asString(), (Object)((PsiClass)target).getName())) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
                if (bl) {
                    String string3 = ((PsiClass)target).getQualifiedName();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"target.getQualifiedName()!!");
                    this.result = new Identifier(string3, false, false, null, 12, null);
                    return;
                }
            }
            if ((psiElement2 = this.getConverter().getSpecialContext()) == null) {
                psiElement2 = context = (PsiElement)expression2;
            }
            if (target instanceof PsiMember && ((PsiMember)target).hasModifierProperty(PsiModifier.STATIC) && ((PsiMember)target).getContainingClass() != null && !PsiTreeUtil.isAncestor((PsiElement)((PsiElement)((PsiMember)target).getContainingClass()), (PsiElement)context, (boolean)true)) {
                PsiFile psiFile = context.getContainingFile();
                if (psiFile == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
                }
                if (!UtilsKt.isImported((PsiMember)target, (PsiJavaFile)psiFile)) {
                    PsiMember member = (PsiMember)target;
                    String string4 = referenceName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"referenceName");
                    String code = Identifier.Companion.toKotlin(string4);
                    while (member.getContainingClass() != null) {
                        PsiClass containingClass;
                        StringBuilder stringBuilder = new StringBuilder();
                        String string5 = containingClass.getName();
                        if (string5 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"containingClass.getName()!!");
                        code = stringBuilder.append(Identifier.Companion.toKotlin(string5)).append(".").append(code).toString();
                        PsiClass psiClass = containingClass;
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"containingClass");
                        member = (PsiMember)psiClass;
                    }
                    this.result = new Identifier(code, false, false, null, 8, null);
                    return;
                }
            }
        }
        this.result = qualifier2 != null ? (Expression)new QualifiedExpression(this.getCodeConverter().convertExpression(qualifier2), identifier) : (Expression)identifier;
    }

    public void visitSuperExpression(@NotNull PsiSuperExpression expression2) {
        PsiJavaCodeReferenceElement psiQualifier;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = psiQualifier = expression2.getQualifier();
        String qualifier2 = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceName() : null;
        this.result = new SuperExpression(qualifier2 != null ? (Identifier)ElementKt.assignPrototype$default(new Identifier(qualifier2, false, false, null, 14, null), (PsiElement)psiQualifier, null, 2) : Identifier.Companion.getEmpty());
    }

    public void visitThisExpression(@NotNull PsiThisExpression expression2) {
        PsiJavaCodeReferenceElement psiQualifier;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = psiQualifier = expression2.getQualifier();
        String qualifier2 = psiJavaCodeReferenceElement != null ? psiJavaCodeReferenceElement.getReferenceName() : null;
        this.result = new ThisExpression(qualifier2 != null ? (Identifier)ElementKt.assignPrototype$default(new Identifier(qualifier2, false, false, null, 14, null), (PsiElement)psiQualifier, null, 2) : Identifier.Companion.getEmpty());
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression2) {
        PsiExpression operand;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiTypeElement psiTypeElement = expression2.getCastType();
        if (psiTypeElement == null) {
            return;
        }
        PsiTypeElement castType = psiTypeElement;
        PsiExpression psiExpression = operand = expression2.getOperand();
        PsiType operandType = psiExpression != null ? psiExpression.getType() : null;
        String typeText = castType.getType().getCanonicalText();
        String typeConversion = ConverterKt.getPRIMITIVE_TYPE_CONVERSIONS().get(typeText);
        Expression operandConverted = this.getCodeConverter().convertExpression(operand);
        if (operandType instanceof PsiPrimitiveType && typeConversion != null) {
            this.result = MethodCallExpression.Companion.buildNotNull$default(MethodCallExpression.Companion, operandConverted, typeConversion, null, null, 12);
        } else {
            Type typeConverted = TypeConverter.convertType$default(this.getTypeConverter(), castType.getType(), operandConverted.getIsNullable() ? Nullability.Nullable : Nullability.NotNull, null, false, 12);
            this.result = new TypeCastExpression(typeConverted, operandConverted);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
        void destination;
        void $receiver;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Object[] $receiver2 = expression2.getOperands();
        Object[] objectArray = $receiver2;
        Collection collection = new ArrayList($receiver2.length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            PsiExpression psiExpression = (PsiExpression)item;
            void var9_8 = destination;
            Expression expression3 = this.getCodeConverter().convertExpression((PsiExpression)it, expression2.getType());
            var9_8.add(expression3);
        }
        List args = (List)destination;
        IElementType iElementType = expression2.getOperationTokenType();
        Intrinsics.checkExpressionValueIsNotNull((Object)iElementType, (String)"expression.getOperationTokenType()");
        this.result = new PolyadicExpression(args, this.getOperatorString(iElementType));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Expression> convertArguments(PsiCallExpression expression2, boolean isExtension) {
        List list;
        Iterable $receiver;
        List list2;
        Object object;
        Iterable iterable;
        Iterable destination;
        Iterable $receiver2;
        PsiParameter[] parameters2;
        PsiMethod resolved;
        PsiMethod psiMethod;
        void arguments2;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        Object object2 = expression2.getArgumentList();
        if (object2 == null || (object2 = object2.getExpressions()) == null || (object2 = ArraysKt.toList((Object[])object2)) == null) {
            object2 = objectRef.element = CollectionsKt.listOf();
        }
        if (isExtension && CollectionsKt.isNotEmpty((Collection)((List)arguments2.element))) {
            arguments2.element = CollectionsKt.drop((Iterable)((List)arguments2.element), (int)1);
        }
        PsiParameter[] psiParameterArray = (psiMethod = (resolved = expression2.resolveMethod())) != null && (psiMethod = psiMethod.getParameterList()) != null ? psiMethod.getParameters() : (parameters2 = null);
        if (parameters2 != null) {
            void $receiver3;
            Object[] objectArray = parameters2;
            void var8_7 = $receiver3;
            Collection collection = new ArrayList(((void)$receiver3).length);
            for (int i = 0; i < ((void)$receiver2).length; ++i) {
                Iterator it;
                Iterable item = $receiver2[i];
                PsiParameter psiParameter = (PsiParameter)item;
                iterable = destination;
                object = it.getType();
                iterable.add(object);
            }
            list2 = (List)destination;
        } else {
            list2 = CollectionsKt.listOf();
        }
        List expectedTypes2 = list2;
        CommentsAndSpacesInheritance commentsAndSpacesInheritance = CommentsAndSpacesInheritance.Companion.getLINE_BREAKS();
        if (((List)arguments2.element).size() == expectedTypes2.size()) {
            void destination2;
            $receiver2 = (List)arguments2.element;
            destination = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            int index2 = 0;
            for (Object item2 : $receiver) {
                void i;
                void argument;
                int n = index2++;
                PsiExpression psiExpression = (PsiExpression)item2;
                int n2 = n;
                iterable = destination2;
                Expression converted = this.getCodeConverter().convertExpression((PsiExpression)argument, (PsiType)expectedTypes2.get((int)i));
                Expression result2 = parameters2 != null && i == CollectionsKt.getLastIndex((List)((List)arguments2.element)) && parameters2[i].isVarArgs() && argument.getType() instanceof PsiArrayType ? (Expression)new StarExpression(converted) : converted;
                object = (Expression)ElementKt.assignPrototype((Element)result2, (PsiElement)argument, commentsAndSpacesInheritance);
                iterable.add(object);
            }
            list = (List)destination2;
        } else {
            $receiver2 = (List)arguments2.element;
            $receiver = $receiver2;
            Collection destination2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                PsiExpression item2 = (PsiExpression)item;
                iterable = destination2;
                object = (Expression)ElementKt.assignPrototype((Element)this.getCodeConverter().convertExpression((PsiExpression)it), (PsiElement)it, commentsAndSpacesInheritance);
                iterable.add(object);
            }
            list = (List)destination2;
        }
        return list;
    }

    static /* synthetic */ List convertArguments$default(DefaultExpressionConverter defaultExpressionConverter, PsiCallExpression psiCallExpression, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return defaultExpressionConverter.convertArguments(psiCallExpression, bl);
    }

    private final String getOperatorString(IElementType tokenType) {
        IElementType iElementType = tokenType;
        return Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.EQEQ) ? "==" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.NE) ? "!=" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.ANDAND) ? "&&" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.OROR) ? "||" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GT) ? ">" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.LT) ? "<" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GE) ? ">=" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.LE) ? "<=" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.EXCL) ? "!" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.PLUS) ? "+" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.MINUS) ? "-" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.ASTERISK) ? "*" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.DIV) ? "/" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.PERC) ? "%" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GTGT) ? "shr" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.LTLT) ? "shl" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.XOR) ? "xor" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.AND) ? "and" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.OR) ? "or" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.GTGTGT) ? "ushr" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.PLUSPLUS) ? "++" : (Intrinsics.areEqual((Object)iElementType, (Object)JavaTokenType.MINUSMINUS) ? "--" : "")))))))))))))))))))));
    }

    /*
     * WARNING - void declaration
     */
    public void visitLambdaExpression(@NotNull PsiLambdaExpression expression2) {
        PsiElement body2;
        List list;
        void destination;
        void $receiver;
        void $receiver2;
        ParameterList parameterList2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        PsiParameterList parameters2 = expression2.getParameterList();
        Object[] objectArray = parameters2.getParameters();
        ParameterList parameterList3 = parameterList2;
        ParameterList parameterList4 = parameterList2;
        PsiElement psiElement2 = $receiver2;
        Collection collection = new ArrayList(((void)$receiver2).length);
        for (int i = 0; i < ((void)$receiver).length; ++i) {
            void it;
            void item = $receiver[i];
            PsiParameter psiParameter = (PsiParameter)item;
            list = destination;
            String string = it.getName();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name!!");
            Identifier paramName = (Identifier)ElementKt.assignNoPrototype((Element)new Identifier(string, false, false, null, 14, null));
            Type paramType = it.getTypeElement() != null ? TypeConverter.convertType$default(this.getConverter().getTypeConverter(), it.getType(), null, null, false, 14) : (Type)null;
            LambdaParameter lambdaParameter = (LambdaParameter)ElementKt.assignPrototype$default(new LambdaParameter(paramName, paramType), (PsiElement)it, null, 2);
            list.add(lambdaParameter);
        }
        list = (List)destination;
        parameterList3(list);
        ParameterList convertedParameters = (ParameterList)ElementKt.assignPrototype$default(parameterList4, (PsiElement)parameters2, null, 2);
        psiElement2 = body2 = expression2.getBody();
        if (psiElement2 instanceof PsiExpression) {
            Expression convertedBody = (Expression)ElementKt.assignPrototype$default(this.getCodeConverter().convertExpression((PsiExpression)body2), body2, null, 2);
            this.result = new LambdaExpression(convertedParameters, new Block(CollectionsKt.listOf((Object)convertedBody), (LBrace)ElementKt.assignNoPrototype((Element)new LBrace()), (RBrace)ElementKt.assignNoPrototype((Element)new RBrace()), false, 8, null));
        } else if (psiElement2 instanceof PsiCodeBlock) {
            Block convertedBlock2 = (Block)ElementKt.assignPrototype$default(CodeConverter.convertBlock$default(this.getCodeConverter().withSpecialStatementConverter(new SpecialStatementConverter(body2, expression2){
                public static final /* synthetic */ KClass $kotlinClass;
                final /* synthetic */ PsiElement $body;
                final /* synthetic */ PsiLambdaExpression $expression;

                static {
                    $kotlinClass = Reflection.createKotlinClass(visitLambdaExpression.convertedBlock.1.class);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public Statement convertStatement(@NotNull PsiStatement statement, @NotNull CodeConverter codeConverter) {
                    void strict;
                    void $receiver;
                    Expression expressionForReturn;
                    Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
                    Intrinsics.checkParameterIsNotNull((Object)codeConverter, (String)"codeConverter");
                    if (!(statement instanceof PsiReturnStatement)) {
                        return null;
                    }
                    PsiExpression returnValue = ((PsiReturnStatement)statement).getReturnValue();
                    PsiType methodReturnType = codeConverter.getMethodReturnType();
                    Expression expression2 = expressionForReturn = returnValue != null && methodReturnType != null ? codeConverter.convertExpression(returnValue, methodReturnType) : codeConverter.convertExpression(returnValue);
                    if (Intrinsics.areEqual((Object)((PsiStatement)ArraysKt.lastOrNull((Object[])((PsiCodeBlock)this.$body).getStatements())), (Object)statement)) {
                        return expressionForReturn;
                    }
                    PsiElement psiElement2 = (PsiElement)this.$expression;
                    boolean bl = false;
                    PsiMethodCallExpression callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiMethodCallExpression.class, (boolean)strict);
                    if (callExpression != null) {
                        String string = callExpression.getMethodExpression().getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"callExpression.methodExpression.text");
                        return new ReturnStatement(expressionForReturn, (Identifier)ElementKt.assignNoPrototype((Element)new Identifier(string, false, false, null, 14, null)));
                    }
                    return new ReturnStatement(expressionForReturn, null, 2, null);
                }
                {
                    this.$body = $captured_local_variable$0;
                    this.$expression = $captured_local_variable$1;
                }
            }), (PsiCodeBlock)body2, false, null, 6), body2, null, 2);
            this.result = new LambdaExpression(convertedParameters, convertedBlock2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        block18: {
            block19: {
                block17: {
                    Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
                    qualifierType = PsiMethodReferenceUtil.getQualifierType((PsiMethodReferenceExpression)expression);
                    if (qualifierType instanceof PsiArrayType) {
                        this.result = new DummyStringExpression(expression.getText() + "  /* Currently unsupported in Kotlin */ ");
                        return;
                    }
                    qualifier = expression.getQualifier();
                    if (qualifier == null) {
                        v0 = expression.getText();
                        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"expression.text");
                        this.result = new DummyStringExpression(v0);
                        return;
                    }
                    var5_4 = (PsiElement)expression;
                    var6_5 = false;
                    contextClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)$receiver, PsiClass.class, (boolean)strict);
                    functionalType = expression.getFunctionalInterfaceType();
                    v1 = qualifier;
                    if (!(v1 instanceof PsiReference)) {
                        v1 = null;
                    }
                    v2 = (PsiReference)v1;
                    isTypeInQualifier = (v2 != null ? v2.resolve() : null) instanceof PsiClass;
                    v3 /* !! */  = functionalType;
                    v4 = isKotlinFunctionType = v3 /* !! */  != null && (v3 /* !! */  = v3 /* !! */ .getCanonicalText()) != null ? StringsKt.startsWith$default((String)v3 /* !! */ , (String)"kotlin.jvm.functions.Function", (boolean)false, (int)2) : false;
                    v5 = expression.resolve();
                    if (!(v5 instanceof PsiMethod)) {
                        v5 = null;
                    }
                    v6 = method = (PsiMethod)v5;
                    hasStaticModifier = v6 != null ? v6.hasModifierProperty(PsiModifier.STATIC) : false;
                    needThis = hasStaticModifier == false && expression.isConstructor() == false && isTypeInQualifier != false;
                    v7 /* !! */  = method;
                    if (v7 /* !! */  == null || (v7 /* !! */  = this.getParametersForMethodReference(v7 /* !! */ , needThis, isKotlinFunctionType)) == null) {
                        v7 /* !! */  = parameters = CollectionsKt.emptyList();
                    }
                    if (!expression.isConstructor()) break block17;
                    v8 = null;
                    break block18;
                }
                if (!needThis) break block19;
                v8 = (Pair)CollectionsKt.firstOrNull((List)parameters);
                break block18;
            }
            if (!isTypeInQualifier) ** GOTO lbl-1000
            v9 = method;
            if (Intrinsics.areEqual((Object)(v9 != null ? v9.getContainingClass() : null), (Object)contextClass)) {
                v8 = null;
            } else lbl-1000:
            // 2 sources

            {
                v8 = qualifier instanceof PsiExpression != false ? TuplesKt.to((Object)this.getCodeConverter().convertExpression((PsiExpression)qualifier), null) : (Pair)null;
            }
        }
        receiver = v8;
        v10 /* !! */  = callParams = needThis != false ? CollectionsKt.drop((Iterable)((Iterable)parameters), (int)1) : parameters;
        if (expression.isConstructor()) {
            var15_14 = (Iterable)callParams;
            var24_15 = this.convertMethodReferenceQualifier(qualifier);
            var23_16 /* !! */  = null;
            var22_17 = MethodCallExpression.Companion;
            var16_18 = $receiver;
            var17_19 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10));
            for (T item : $receiver) {
                var20_22 = (Pair)item;
                var25_23 = destination;
                var26_24 = (Identifier)it.getFirst();
                var25_23.add(var26_24);
            }
            var25_23 = (List)destination;
            v11 = (MethodCallExpression)ElementKt.assignNoPrototype((Element)var22_17.build(var23_16 /* !! */ , (String)var24_15, (List<? extends Expression>)var25_23, CollectionsKt.emptyList(), false));
        } else {
            v12 = expression.getReferenceName();
            if (v12 == null) {
                Intrinsics.throwNpe();
            }
            referenceName = v12;
            v13 = receiver;
            v14 = v13 != null ? (Expression)v13.getFirst() : null;
            v15 = referenceName;
            Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"referenceName");
            $receiver = (Iterable)callParams;
            var24_15 = v15;
            var23_16 /* !! */  = v14;
            var22_17 = MethodCallExpression.Companion;
            destination = $receiver;
            var18_20 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10));
            for (T item : $receiver) {
                var21_25 = (Pair)item;
                var25_23 = destination;
                var26_24 = (Identifier)it.getFirst();
                var25_23.add((Identifier)var26_24);
            }
            var25_23 = (List)destination;
            v11 = (MethodCallExpression)ElementKt.assignNoPrototype((Element)var22_17.build(var23_16 /* !! */ , (String)var24_15, (List<? extends Expression>)var25_23, CollectionsKt.emptyList(), false));
        }
        statement = v11;
        v16 /* !! */  = v17;
        v18 = v17;
        if (parameters.size() == 1 && !isKotlinFunctionType) {
            v19 = CollectionsKt.emptyList();
        } else {
            $receiver = (Iterable)parameters;
            var23_16 /* !! */  = v16 /* !! */ ;
            var22_17 = v18;
            $receiver = $receiver;
            destination = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10));
            for (T item : $receiver) {
                it = (Pair)item;
                var24_15 = destination;
                var25_23 = (LambdaParameter)ElementKt.assignNoPrototype((Element)new LambdaParameter((Identifier)it.getFirst(), (Type)it.getSecond()));
                var24_15.add(var25_23);
            }
            var24_15 = (List)destination;
            v18 = var22_17;
            v16 /* !! */  = var23_16 /* !! */ ;
            v19 = var24_15;
        }
        v16 /* !! */ ((List<? extends Parameter>)v19);
        lambdaParameterList = (ParameterList)ElementKt.assignNoPrototype((Element)v18);
        lambdaExpression = (LambdaExpression)ElementKt.assignNoPrototype((Element)new LambdaExpression(lambdaParameterList, (Block)ElementKt.assignNoPrototype((Element)new Block(CollectionsKt.listOf((Object)statement), (LBrace)ElementKt.assignNoPrototype((Element)new LBrace()), (RBrace)ElementKt.assignNoPrototype((Element)new RBrace()), false, 8, null))));
        if (isKotlinFunctionType) {
            this.result = lambdaExpression;
        } else {
            convertedFunctionalType = TypeConverter.convertType$default(this.getConverter().getTypeConverter(), functionalType, null, null, false, 14);
            this.result = MethodCallExpression.Companion.build(null, ElementKt.canonicalCode(convertedFunctionalType), CollectionsKt.listOf((Object)lambdaExpression), CollectionsKt.emptyList(), false);
        }
    }

    private final String convertMethodReferenceQualifier(PsiElement qualifier2) {
        String string;
        PsiElement psiElement2 = qualifier2;
        if (psiElement2 instanceof PsiExpression) {
            string = ElementKt.canonicalCode(this.getCodeConverter().convertExpression((PsiExpression)qualifier2));
        } else if (psiElement2 instanceof PsiTypeElement) {
            string = ElementKt.canonicalCode(this.getConverter().convertTypeElement((PsiTypeElement)qualifier2, Nullability.NotNull));
        } else {
            String string2 = qualifier2.getText();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"qualifier.text");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"when(qualifier) {\n      \u2026 qualifier.text\n        }");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<? extends Identifier, ? extends Type>> getParametersForMethodReference(PsiMethod $receiver, boolean needThis, boolean isKotlinFunctionType) {
        void $receiver2;
        Object containingClassName;
        ArrayList newParameters = CollectionsKt.arrayListOf((Object[])new Pair[0]);
        ClassType thisClassType = null;
        PsiClass thisClass = $receiver.getContainingClass();
        if (thisClass != null && isKotlinFunctionType) {
            Object object = thisClass.getQualifiedName();
            if (object == null) {
                PsiClass psiClass = $receiver.getContainingClass();
                if (psiClass == null) {
                    Intrinsics.throwNpe();
                }
                object = containingClassName = psiClass.getName();
            }
            if (containingClassName != null) {
                FqName fqName2 = new FqName((String)containingClassName);
                String string = fqName2.shortName().getIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.shortName().identifier");
                Identifier identifier = (Identifier)ElementKt.assignNoPrototype((Element)new Identifier(string, false, false, CollectionsKt.listOf((Object)fqName2), 6, null));
                thisClassType = (ClassType)ElementKt.assignNoPrototype((Element)new ClassType((ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(identifier, TypeParametersKt.convertTypeParameterList(this.getConverter(), thisClass.getTypeParameterList()).getParameters())), Nullability.NotNull, this.getConverter().getSettings()));
            }
        }
        if (needThis) {
            newParameters.add(TuplesKt.to((Object)ElementKt.assignNoPrototype((Element)new Identifier("obj", false, false, null, 12, null)), (Object)thisClassType));
        }
        containingClassName = $receiver.getParameterList().getParameters();
        for (int i = 0; i < ((void)$receiver2).length; ++i) {
            void element2 = $receiver2[i];
            PsiParameter it = (PsiParameter)element2;
            Type parameterType = isKotlinFunctionType ? TypeConverter.convertType$default(this.getConverter().getTypeConverter(), it.getType(), Nullability.NotNull, null, false, 12) : (Type)null;
            String string = it.getName();
            if (string == null) {
                string = "p";
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name ?: \"p\"");
            newParameters.add(TuplesKt.to((Object)ElementKt.assignNoPrototype((Element)new Identifier(string, false, false, null, 12, null)), (Object)parameterType));
        }
        if (newParameters.size() == 1 && !isKotlinFunctionType) {
            newParameters.clear();
            newParameters.add(TuplesKt.to((Object)ElementKt.assignNoPrototype((Element)new Identifier("it", false, false, null, 12, null)), null));
        }
        return newParameters;
    }

    public void visitExpression(@NotNull PsiExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        String string = expression2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
        this.result = new DummyStringExpression(string);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0012\u0004)I1i\\7qC:LwN\u001c\u0006\u001b\t\u00164\u0017-\u001e7u\u000bb\u0004(/Z:tS>t7i\u001c8wKJ$XM\u001d\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*\u0019!NM6\u000b\u0007\u0005s\u0017P\u0003\u000boK\u0016$\u0017+^1mS\u001aLWM\u001d(b[\u0016\u001cV\r\u001e\u0006\u0004'\u0016$(BB*ue&twM\u0003\u0003kCZ\f'\u0002B;uS2TqcZ3u\u001d\u0016,G-U;bY&4\u0017.\u001a:OC6,7+\u001a;S\u0015\t\u0001\"A\u0003\u0003\t\u0001A\u0019!\u0002\u0002\u0005\u0002!\u0011QA\u0001\u0003\u0002\u0011\u000b)1\u0001b\u0001\t\u00021\u0001Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0001\t\u0005\u0015\u0019Aa\u0001\u0005\u0004\u0019\u0001)1\u0001B\u0002\t\t1\u0001Qa\u0001\u0003\u0004\u0011\u0013a\u0001!B\u0001\t\u000b\u0015\u0011A!\u0002E\u0006\u000b\t!Y\u0001\u0003\u0003\u0005\u0007\ba)!G\u0002\u0006\u0003!\u001d\u0001tA\u0017\u0017\t\u0005$\u0001tA\u0011\t\u000b\u0005AA!\u0003\u0003\n\u0007\u0015\t\u0001\u0012\u0002M\u00051\u0011)6!C\u0003\u0005\t\u000fI\u0011\u0001\u0003\u0004\r\u00025\u0019AAB\u0005\u0002\u0011\u0019)\u0004\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final Set<String> getNeedQualifierNameSet() {
            return needQualifierNameSet;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

