/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.Annotations;
import org.jetbrains.kotlin.j2k.ast.DeferredElement;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Member;
import org.jetbrains.kotlin.j2k.ast.Modifier;
import org.jetbrains.kotlin.j2k.ast.ModifierKt;
import org.jetbrains.kotlin.j2k.ast.Modifiers;
import org.jetbrains.kotlin.j2k.ast.Property;
import org.jetbrains.kotlin.j2k.ast.PropertyAccessor;
import org.jetbrains.kotlin.j2k.ast.Type;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000f\b)A\u0001K]8qKJ$\u0018PC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\rQ'g\u001b\u0006\u0004CN$(BB'f[\n,'O\u0003\u0004=S:LGO\u0010\u0006\u000bS\u0012,g\u000e^5gS\u0016\u0014(BC%eK:$\u0018NZ5fe*Y\u0011M\u001c8pi\u0006$\u0018n\u001c8t\u0015-\teN\\8uCRLwN\\:\u000b\u00135|G-\u001b4jKJ\u001c(\"C'pI&4\u0017.\u001a:t\u0015\u0015I7OV1s\u0015\u001d\u0011un\u001c7fC:TA\u0001^=qK*!A+\u001f9f\u00151)\u0007\u0010\u001d7jG&$H+\u001f9f\u0015-Ig.\u001b;jC2L'0\u001a:\u000b\u001f\u0011+g-\u001a:sK\u0012,E.Z7f]RT!\"\u0012=qe\u0016\u001c8/[8o\u0015=qW-\u001a3J]&$\u0018.\u00197ju\u0016\u0014(BB4fiR,'O\u0003\tQe>\u0004XM\u001d;z\u0003\u000e\u001cWm]:pe*11/\u001a;uKJTQ\"[:J]&sG/\u001a:gC\u000e,'bD4fi\u0016C\b\u000f\\5dSR$\u0016\u0010]3\u000b\u001b\u001d,G/\u00133f]RLg-[3s\u0015!9W\r^%t-\u0006\u0014(bB4fiRK\b/\u001a\u0006\rO\u0016tWM]1uK\u000e{G-\u001a\u0006\bEVLG\u000eZ3s\u0015-\u0019u\u000eZ3Ck&dG-\u001a:\u000b\tUs\u0017\u000e\u001e\u0006\u0016aJ,7/\u001a8uCRLwN\\'pI&4\u0017.\u001a:tU\u0007Q!\u0001E\u0001\u000b\t!\u0001\u0001C\u0001\u0006\u0005\u0011\u0005\u00012A\u0003\u0003\t\u0005A!!\u0002\u0002\u0005\u0004!\u0015Qa\u0001\u0003\u0003\u0011\u0001a\u0001!B\u0002\u0005\u0005!\u0019A\u0002A\u0003\u0004\t\tAI\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u00012\u0002\u0007\u0001\u000b\r!!\u0001#\u0004\r\u0001\u0015\t\u00012A\u0003\u0004\t\u0015Ay\u0001\u0004\u0001\u0006\u0007\u0011\u0011\u0001\u0012\u0003\u0007\u0001\u000b\r!!\u0001\u0003\u0006\r\u0001\u0015\u0019AA\u0001E\u000b\u0019\u0001)1\u0001\u0002\u0002\t\u00191\u0001QA\u0001\u0003\u0003\u0011\u0013)!\u0001\u0002\u0002\t\f\u0015\u0011AA\u0001E\u0007\u000b\t!!\u0001#\u0005\u0006\u0005\u0011\u0011\u0001BC\u0003\u0003\t\tAA\"B\u0002\u0005\u0004!\u0005B\u0002A\u0003\u0004\t\u0015A\u0011\u0003\u0004\u0001\u0006\u0005\u0011\r\u0001\u0012\u0005\u0003\u0004\u0019\u000bI2!B\u0001\t\u0007a\u0019Q\u0006\u0005\u0003d\taI\u0011eA\u0003\u0002\u0011\u0017AZ!V\u0002\t\u000b\r!\u0011\"C\u0001\u0005\u00025\u0019A1D\u0005\u0002\t\u0003iS\u0002B1\u00051/\tC!B\u0001\t\u00101\u0005\u0001tB+\u0004\t\u0015\u0019AqC\u0005\u0002\u0011+i\u0003\u0003B2\u00051\u0011\t3!B\u0001\t\ba\u001dQk\u0001\u0005\u0006\u0007\u0011!\u0011\"\u0001\u0005\t\u001b\r!a\"C\u0001\t\u00115\nB!\u0019\u0003\u0019\u0014\u0005BQ!\u0001E\u0007\u0013\u0011I1!B\u0001\t\u000fa9\u0001TB+\u0004\t\u0015\u0019A1C\u0005\u0002\u0011)iC\u0002B1\u000515\t3!B\u0001\t\fa-Qk\u0001\u0003\u0006\u0007\u0011i\u0011\"\u0001C\u0001[A!1\r\u0002\r\bC\r)\u0011\u0001c\u0003\u0019\fU\u001b\u0001\"B\u0002\u0005\u000f%\tA\u0011A\u0007\u0004\t;I\u0011\u0001\"\u0001.\u0019\u0011\tG\u0001G\u0006\"\u0007\u0015\t\u00012\u0002M\u0006+\u000e!Qa\u0001\u0003\f\u0013\u0005!\t!L\u0007\u0005C\u0012AJ\"\t\u0003\u0006\u0003!=A\u0012\u0001M\b+\u000e!Qa\u0001C\r\u0013\u0005A)\"\f\t\u0005G\u0012A\u0002\"I\u0002\u0006\u0003!1\u0001DB+\u0004\u0011\u0015\u0019A\u0001C\u0005\u0002\u0011'i1\u0001B\b\n\u0003!MQ&\u0006\u0003\f1?iz\u0001\u0002\u0001\t!5\u0019Q!\u0001\u0005\f1-\u00016\u0001A\u0011\u0004\u000b\u0005A9\u0002g\u0006R\u0007\u0015!y\"C\u0001\u0005\u00015\t\u0001\u0002DW\u000b\t\u0005A\u001a#I\u0002\u0006\u0003!%\u0001\u0014B)\u0004\u0007\u0011\r\u0012\"\u0001\u0005\nk\u001d\u000bQ1R\u0001\u0005G\u0004A:!h\u0004\u0005\u0001!!QbA\u0003\u0002\u0011\u000fA:\u0001U\u0002\u0001;\u001f!\u0001\u0001C\u0003\u000e\u0007\u0015\t\u0001\u0002\u0002\r\u0005!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0019i1!B\u0001\t\na%\u0001kA\u0001\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0007iz\u0001\u0002\u0001\t\u00115\u0019Q!\u0001\u0005\u00071\u0019\u00016AAO\b\t\u0001A\u0011\"D\u0002\u0006\u0003!-\u00014\u0002)\u0004\u0006ueA\u0001\u0001E\n\u001b!)\u0011\u0001#\u0004\n\t%\u0019Q!\u0001\u0005\b1\u001dAj\u0001U\u0002\u0004;\u001f!\u0001\u0001C\u0006\u000e\u0007\u0015\t\u00012\u0002M\u0006!\u000e\u001dQ\u0014\u0003\u0003\u0001\u0011/iA!B\u0001\t\u00101\u0005\u0001t\u0002)\u0004\tuEA\u0001\u0001E\r\u001b\u0011)\u0011\u0001c\u0004\r\u0002a=\u0001k!\u0003\u001e\u0010\u0011\u0001\u0001\"D\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0015\t3!B\u0001\t\u0006a\u0015\u0011kA\r\u0005\b%\tA\u0001A\u0007\u0002\u0011!i\u0011\u0001#\u0005\u000e\u0003!IQ\"\u0001C\u0001\u001b\u0005A\u0019\"D\u0001\u0005\u00025\t\u0001BC\u0007\u0002\t\u0003i\u0011\u0001#\u0006\u000e\u0003!UQ\"\u0001C\u0001"})
public final class Property
extends Member {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    private final Identifier identifier;
    private final boolean isVar;
    @NotNull
    private final Type type;
    private final boolean explicitType;
    private final DeferredElement<Expression> initializer;
    private final boolean needInitializer;
    private final PropertyAccessor getter;
    private final PropertyAccessor setter;
    private final boolean isInInterface;

    static {
        $kotlinClass = Reflection.createKotlinClass(Property.class);
    }

    private final Modifiers presentationModifiers() {
        Modifiers modifiers = this.getModifiers();
        if (this.isInInterface) {
            modifiers = modifiers.without(Modifier.ABSTRACT);
        }
        if (modifiers.contains(Modifier.OVERRIDE)) {
            modifiers = ModifierKt.filter(modifiers, (Function1<? super Modifier, ? extends Boolean>)((Function1)presentationModifiers.1.INSTANCE$));
        }
        return modifiers;
    }

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Element initializerToUse;
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        ModifierKt.appendWithSpaceAfter(builder.append(this.getAnnotations()), this.presentationModifiers()).append(this.isVar ? "var " : "val ").append(this.identifier);
        if (this.explicitType) {
            builder.append(":").append(this.type);
        }
        if ((initializerToUse = (Element)this.initializer).getIsEmpty() && this.needInitializer) {
            Expression expression2 = UtilsKt.getDefaultInitializer(this);
            Element element2 = initializerToUse = expression2 != null ? (Element)expression2 : (Element)Element.Empty.INSTANCE$;
        }
        if (!initializerToUse.getIsEmpty()) {
            builder.append(" = ").append(initializerToUse);
        }
        if (this.getter != null) {
            builder.append("\n").append(this.getter);
        }
        if (this.setter != null) {
            builder.append("\n").append(this.setter);
        }
    }

    @NotNull
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    public final boolean getIsVar() {
        return this.isVar;
    }

    @NotNull
    public final Type getType() {
        return this.type;
    }

    public final boolean getExplicitType() {
        return this.explicitType;
    }

    public Property(@NotNull Identifier identifier, @NotNull Annotations annotations2, @NotNull Modifiers modifiers, boolean isVar, @NotNull Type type2, boolean explicitType2, @NotNull DeferredElement<Expression> initializer, boolean needInitializer, @Nullable PropertyAccessor getter, @Nullable PropertyAccessor setter, boolean isInInterface) {
        Intrinsics.checkParameterIsNotNull((Object)identifier, (String)"identifier");
        Intrinsics.checkParameterIsNotNull((Object)annotations2, (String)"annotations");
        Intrinsics.checkParameterIsNotNull((Object)modifiers, (String)"modifiers");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        Intrinsics.checkParameterIsNotNull(initializer, (String)"initializer");
        super(annotations2, modifiers);
        this.identifier = identifier;
        this.isVar = isVar;
        this.type = type2;
        this.explicitType = explicitType2;
        this.initializer = initializer;
        this.needInitializer = needInitializer;
        this.getter = getter;
        this.setter = setter;
        this.isInInterface = isInInterface;
    }
}

