/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.DeserializedDescriptorResolver;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.ClassData;
import org.jetbrains.kotlin.serialization.ClassDataWithSource;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBufUtil;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u000f\u0006)\u0019\"*\u0019<b\u00072\f7o\u001d#bi\u00064\u0015N\u001c3fe*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgN\u0003\u0003m_\u0006$'bD\"mCN\u001cH)\u0019;b\r&tG-\u001a:\u000b\u001bM,'/[1mSj\fG/[8o\u0015=!Wm]3sS\u0006d\u0017N_1uS>t'B\u0002\u001fj]&$hHC\tl_Rd\u0017N\\\"mCN\u001ch)\u001b8eKJT\u0011cS8uY&t7\t\\1tg\u001aKg\u000eZ3s\u0015y!Wm]3sS\u0006d\u0017N_3e\t\u0016\u001c8M]5qi>\u0014(+Z:pYZ,'O\u0003\u0010EKN,'/[1mSj,G\rR3tGJL\u0007\u000f^8s%\u0016\u001cx\u000e\u001c<fe*ia-\u001b8e\u00072\f7o\u001d#bi\u0006Tqa\u00197bgNLEMC\u0004DY\u0006\u001c8/\u00133\u000b\t9\fW.\u001a\u0006\u0014\u00072\f7o\u001d#bi\u0006<\u0016\u000e\u001e5T_V\u00148-\u001a<\u000b\u0005A\t!\u0002\u0002\u0005\u0001!\tQA\u0001C\u0001\u0011\u0007)!\u0001B\u0001\t\u0005\u0015\u0011A1\u0001E\u0002\u000b\r!!\u0001\u0003\u0001\r\u0001\u0015\u0011A!\u0001\u0005\u0004\u000b\t!1\u0001c\u0002\u0006\u0007\u0011\u001d\u0001R\u0001\u0007\u0001\u000b\r!!\u0001C\u0003\r\u0001\u0015\u0019AA\u0001\u0005\u0007\u0019\u0001)!\u0001\u0002\u0002\t\u000b\u0015\u0011AA\u0001\u0005\u0007\u000b\t!\u0011\u0001\u0003\u0005\u0006\u0007\u00115\u0001r\u0002\u0007\u0001\u000b\r!1\u0001#\u0005\r\u0001\u0015\u0011Aa\u0001E\t\u000b\t!i\u0001c\u0004\u0005\u00071\u0015\u0011dA\u0003\u0002\u0011\u0011AB!\f\u0007\u0005C\u0012AZ!I\u0002\u0006\u0003!)\u0001$B+\u0004\t\u0015\u0019A1B\u0005\u0002\u0011\u0019iC\u0002B1\u00051\u0013\t3!B\u0001\t\na%Qk\u0001\u0003\u0006\u0007\u0011%\u0011\"\u0001E\u0006[Y!1\u0002'\u0004\u001e\u0010\u0011\u0001\u0001bB\u0007\u0004\u000b\u0005Aq\u0001G\u0004Q\u0007\u0001\tC!B\u0001\t\u00101\u0005\u0001tB)\u0004\u000b\u00115\u0011\"\u0001\u0005\t\u001b\u0005A\t\"N\u0011\u0006A\u0011\u0019\u000f\u0001\u0007\u0003\u001e\u0010\u0011\u0001\u0001\u0012B\u0007\u0004\u000b\u0005AI\u0001'\u0003Q\u0007\u0001iz\u0001\u0002\u0001\t\f5\u0019Q!\u0001\u0005\u00061\u0015\u00016\u0011A\u0011\u0004\u000b\u0005A)\u0001'\u0002R\u0007\u001d!A!C\u0001\u0005\u00015\t\u00012B\u0007\u0002\u0011\u0019\u0001"})
public final class JavaClassDataFinder
implements ClassDataFinder {
    public static final /* synthetic */ KClass $kotlinClass;
    private final KotlinClassFinder kotlinClassFinder;
    private final DeserializedDescriptorResolver deserializedDescriptorResolver;

    static {
        $kotlinClass = Reflection.createKotlinClass(JavaClassDataFinder.class);
    }

    @Override
    @Nullable
    public ClassDataWithSource findClassData(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.kotlinClassFinder.findKotlinClass(classId);
        if (kotlinJvmBinaryClass == null) {
            return null;
        }
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        boolean value2 = Intrinsics.areEqual((Object)kotlinJvmBinaryClass2.getClassId(), (Object)classId);
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Class with incorrect id found: expected " + classId + ", actual " + kotlinJvmBinaryClass2.getClassId();
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        String[] stringArray = this.deserializedDescriptorResolver.readData(kotlinJvmBinaryClass2, DeserializedDescriptorResolver.KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        Intrinsics.checkExpressionValueIsNotNull((Object)data2, (String)"data");
        ClassData classData = JvmProtoBufUtil.readClassDataFrom(data2);
        return new ClassDataWithSource(classData, new KotlinJvmBinarySourceElement(kotlinJvmBinaryClass2));
    }

    public JavaClassDataFinder(@NotNull KotlinClassFinder kotlinClassFinder, @NotNull DeserializedDescriptorResolver deserializedDescriptorResolver) {
        Intrinsics.checkParameterIsNotNull((Object)kotlinClassFinder, (String)"kotlinClassFinder");
        Intrinsics.checkParameterIsNotNull((Object)deserializedDescriptorResolver, (String)"deserializedDescriptorResolver");
        this.kotlinClassFinder = kotlinClassFinder;
        this.deserializedDescriptorResolver = deserializedDescriptorResolver;
    }
}

