/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin.header;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.AbiVersionUtil;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.header.KotlinClassHeader;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.BinaryVersion;

public class ReadKotlinClassHeaderAnnotationVisitor
implements KotlinJvmBinaryClass.AnnotationVisitor {
    private static final Map<JvmClassName, KotlinClassHeader.Kind> HEADER_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private static final Map<JvmClassName, KotlinClassHeader.Kind> OLD_DEPRECATED_ANNOTATIONS_KINDS = new HashMap<JvmClassName, KotlinClassHeader.Kind>();
    private BinaryVersion version = AbiVersionUtil.INVALID_VERSION;
    private String multifileClassName = null;
    private String[] filePartClassNames = null;
    private String[] annotationData = null;
    private KotlinClassHeader.Kind headerKind = null;
    private JvmAnnotationNames.KotlinClass.Kind classKind = null;
    private JvmAnnotationNames.KotlinSyntheticClass.Kind syntheticClassKind = null;

    private static void initOldAnnotations() {
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_CLASS_ANNOTATION), KotlinClassHeader.Kind.CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_JET_PACKAGE_CLASS_ANNOTATION), KotlinClassHeader.Kind.PACKAGE_FACADE);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_CLASS), KotlinClassHeader.Kind.CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_PACKAGE_FRAGMENT), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
        OLD_DEPRECATED_ANNOTATIONS_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.OLD_KOTLIN_TRAIT_IMPL), KotlinClassHeader.Kind.SYNTHETIC_CLASS);
    }

    @Nullable
    public KotlinClassHeader createHeader() {
        if (this.headerKind == null) {
            return null;
        }
        if (this.headerKind == KotlinClassHeader.Kind.CLASS && this.classKind == null) {
            this.classKind = JvmAnnotationNames.KotlinClass.Kind.CLASS;
        }
        if (!AbiVersionUtil.isAbiVersionCompatible(this.version)) {
            return new KotlinClassHeader(this.headerKind, this.version, null, this.classKind, this.syntheticClassKind, null, null);
        }
        if (this.shouldHaveData() && this.annotationData == null) {
            return null;
        }
        return new KotlinClassHeader(this.headerKind, this.version, this.annotationData, this.classKind, this.syntheticClassKind, this.filePartClassNames, this.multifileClassName);
    }

    private boolean shouldHaveData() {
        return this.headerKind == KotlinClassHeader.Kind.CLASS || this.headerKind == KotlinClassHeader.Kind.PACKAGE_FACADE || this.headerKind == KotlinClassHeader.Kind.FILE_FACADE || this.headerKind == KotlinClassHeader.Kind.MULTIFILE_CLASS_PART;
    }

    @Override
    @Nullable
    public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull ClassId classId, @NotNull SourceElement source) {
        if (classId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "visitAnnotation"));
        }
        if (this.headerKind != null) {
            return null;
        }
        JvmClassName annotation2 = JvmClassName.byClassId(classId);
        KotlinClassHeader.Kind newKind = HEADER_KINDS.get(annotation2);
        if (newKind != null) {
            this.headerKind = newKind;
            switch (newKind) {
                case CLASS: {
                    return new ClassHeaderReader();
                }
                case PACKAGE_FACADE: {
                    return new PackageHeaderReader();
                }
                case FILE_FACADE: {
                    return new FileFacadeHeaderReader();
                }
                case MULTIFILE_CLASS: {
                    return new MultifileClassHeaderReader();
                }
                case MULTIFILE_CLASS_PART: {
                    return new MultifileClassPartHeaderReader();
                }
                case SYNTHETIC_CLASS: {
                    return new SyntheticClassHeaderReader();
                }
            }
            return null;
        }
        KotlinClassHeader.Kind oldAnnotationKind = OLD_DEPRECATED_ANNOTATIONS_KINDS.get(annotation2);
        if (oldAnnotationKind != null) {
            this.headerKind = oldAnnotationKind;
        }
        return null;
    }

    @Override
    public void visitEnd() {
    }

    @Nullable
    private static <E extends Enum<E>> E valueOfOrNull(@NotNull Class<E> enumClass, @NotNull String entry) {
        if (enumClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClass", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "valueOfOrNull"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor", "valueOfOrNull"));
        }
        try {
            return Enum.valueOf(enumClass, entry);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    static /* synthetic */ String[] access$202(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.filePartClassNames = x1;
        return x1;
    }

    static /* synthetic */ String[] access$302(ReadKotlinClassHeaderAnnotationVisitor x0, String[] x1) {
        x0.annotationData = x1;
        return x1;
    }

    static {
        HEADER_KINDS.put(JvmAnnotationNames.KotlinClass.CLASS_NAME, KotlinClassHeader.Kind.CLASS);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE), KotlinClassHeader.Kind.PACKAGE_FACADE);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_FILE_FACADE), KotlinClassHeader.Kind.FILE_FACADE);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS), KotlinClassHeader.Kind.MULTIFILE_CLASS);
        HEADER_KINDS.put(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS_PART), KotlinClassHeader.Kind.MULTIFILE_CLASS_PART);
        HEADER_KINDS.put(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME, KotlinClassHeader.Kind.SYNTHETIC_CLASS);
        ReadKotlinClassHeaderAnnotationVisitor.initOldAnnotations();
    }

    private class SyntheticClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public SyntheticClassHeaderReader() {
            super(JvmAnnotationNames.KotlinSyntheticClass.CLASS_NAME);
        }

        @Override
        public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$SyntheticClassHeaderReader", "visitEnum"));
            }
            if (JvmAnnotationNames.KotlinSyntheticClass.KIND_CLASS_ID.equals(enumClassId) && "kind".equals(name2.asString())) {
                ReadKotlinClassHeaderAnnotationVisitor.this.syntheticClassKind = (JvmAnnotationNames.KotlinSyntheticClass.Kind)ReadKotlinClassHeaderAnnotationVisitor.valueOfOrNull(JvmAnnotationNames.KotlinSyntheticClass.Kind.class, enumEntryName.asString());
            }
        }
    }

    private class MultifileClassPartHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public MultifileClassPartHeaderReader() {
            super(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS_PART));
        }
    }

    private class MultifileClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public MultifileClassHeaderReader() {
            super(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_MULTIFILE_CLASS));
        }
    }

    private class FileFacadeHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public FileFacadeHeaderReader() {
            super(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_FILE_FACADE));
        }
    }

    private class PackageHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public PackageHeaderReader() {
            super(JvmClassName.byFqNameWithoutInnerClasses(JvmAnnotationNames.KOTLIN_PACKAGE));
        }
    }

    private class ClassHeaderReader
    extends HeaderAnnotationArgumentVisitor {
        public ClassHeaderReader() {
            super(JvmAnnotationNames.KotlinClass.CLASS_NAME);
        }

        @Override
        public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$ClassHeaderReader", "visitEnum"));
            }
            if (JvmAnnotationNames.KotlinClass.KIND_CLASS_ID.equals(enumClassId) && "kind".equals(name2.asString())) {
                ReadKotlinClassHeaderAnnotationVisitor.this.classKind = (JvmAnnotationNames.KotlinClass.Kind)ReadKotlinClassHeaderAnnotationVisitor.valueOfOrNull(JvmAnnotationNames.KotlinClass.Kind.class, enumEntryName.asString());
            }
        }
    }

    private abstract class HeaderAnnotationArgumentVisitor
    implements KotlinJvmBinaryClass.AnnotationArgumentVisitor {
        protected final JvmClassName annotationClassName;

        public HeaderAnnotationArgumentVisitor(JvmClassName annotationClassName) {
            if (annotationClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClassName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "<init>"));
            }
            this.annotationClassName = annotationClassName;
        }

        @Override
        public void visit(@Nullable Name name2, @Nullable Object value2) {
            if (name2 == null) {
                return;
            }
            String string = name2.asString();
            if ("version".equals(string)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.version = value2 instanceof int[] ? BinaryVersion.create((int[])value2) : AbiVersionUtil.INVALID_VERSION;
            } else if ("multifileClassName".equals(string)) {
                ReadKotlinClassHeaderAnnotationVisitor.this.multifileClassName = value2 instanceof String ? (String)value2 : null;
            } else if ("abiVersion".equals(string) && ReadKotlinClassHeaderAnnotationVisitor.this.version == AbiVersionUtil.INVALID_VERSION && value2 instanceof Integer && (Integer)value2 > 0) {
                ReadKotlinClassHeaderAnnotationVisitor.this.version = BinaryVersion.create(0, (Integer)value2, 0);
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor visitArray(@NotNull Name name2) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitArray"));
            }
            if (name2.asString().equals("data")) {
                return this.dataArrayVisitor();
            }
            if (name2.asString().equals("filePartClassNames")) {
                return this.filePartClassNamesVisitor();
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor filePartClassNamesVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(String[] data2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$202(ReadKotlinClassHeaderAnnotationVisitor.this, data2);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "filePartClassNamesVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @Override
        public void visitEnum(@NotNull Name name2, @NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
            if (enumEntryName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitEnum"));
            }
        }

        @Override
        @Nullable
        public KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(@NotNull Name name2, @NotNull ClassId classId) {
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "visitAnnotation"));
            }
            return null;
        }

        @NotNull
        private KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor dataArrayVisitor() {
            CollectStringArrayAnnotationVisitor collectStringArrayAnnotationVisitor = new CollectStringArrayAnnotationVisitor(){

                @Override
                protected void visitEnd(String[] data2) {
                    ReadKotlinClassHeaderAnnotationVisitor.access$302(ReadKotlinClassHeaderAnnotationVisitor.this, data2);
                }
            };
            if (collectStringArrayAnnotationVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor", "dataArrayVisitor"));
            }
            return collectStringArrayAnnotationVisitor;
        }

        @Override
        public void visitEnd() {
        }

        private abstract class CollectStringArrayAnnotationVisitor
        implements KotlinJvmBinaryClass.AnnotationArrayArgumentVisitor {
            private final List<String> strings = new ArrayList<String>();

            @Override
            public void visit(@Nullable Object value2) {
                if (value2 instanceof String) {
                    this.strings.add((String)value2);
                }
            }

            @Override
            public void visitEnum(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
                if (enumClassId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumClassId", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
                }
                if (enumEntryName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumEntryName", "org/jetbrains/kotlin/load/kotlin/header/ReadKotlinClassHeaderAnnotationVisitor$HeaderAnnotationArgumentVisitor$CollectStringArrayAnnotationVisitor", "visitEnum"));
                }
            }

            @Override
            public void visitEnd() {
                this.visitEnd(this.strings.toArray(new String[this.strings.size()]));
            }

            protected abstract void visitEnd(String[] var1);
        }
    }
}

