/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetNamedDeclaration;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;

public final class JetNamedDeclarationUtil {
    @Nullable
    public static FqNameUnsafe getUnsafeFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getUnsafeFQName"));
        }
        FqName fqName2 = namedDeclaration.getFqName();
        return fqName2 != null ? fqName2.toUnsafe() : null;
    }

    @Nullable
    static FqName getFQName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getFQName"));
        }
        Name name2 = namedDeclaration.getNameAsName();
        if (name2 == null) {
            return null;
        }
        FqName parentFqName = JetNamedDeclarationUtil.getParentFqName(namedDeclaration);
        if (parentFqName == null) {
            return null;
        }
        return parentFqName.child(name2);
    }

    @Nullable
    public static FqName getParentFqName(@NotNull JetNamedDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namedDeclaration", "org/jetbrains/kotlin/psi/JetNamedDeclarationUtil", "getParentFqName"));
        }
        PsiElement parent2 = namedDeclaration.getParent();
        if (parent2 instanceof JetClassBody) {
            parent2 = parent2.getParent();
        }
        if (parent2 instanceof JetFile) {
            return ((JetFile)parent2).getPackageFqName();
        }
        if (parent2 instanceof JetNamedFunction || parent2 instanceof JetClass) {
            return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent2);
        }
        if (namedDeclaration instanceof JetParameter) {
            JetClassOrObject constructorClass = JetPsiUtil.getClassIfParameterIsProperty((JetParameter)namedDeclaration);
            if (constructorClass != null) {
                return JetNamedDeclarationUtil.getFQName(constructorClass);
            }
        } else if (parent2 instanceof JetObjectDeclaration) {
            return JetNamedDeclarationUtil.getFQName((JetNamedDeclaration)parent2);
        }
        return null;
    }

    private JetNamedDeclarationUtil() {
    }
}

