/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetClassBody;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetParameterList;
import org.jetbrains.kotlin.psi.JetPropertyAccessor;
import org.jetbrains.kotlin.psi.JetPropertyDelegate;
import org.jetbrains.kotlin.psi.JetPsiFactory;
import org.jetbrains.kotlin.psi.JetTypeParameterListOwnerStub;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVariableDeclaration;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinPropertyStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.kotlin.psi.typeRefHelpers.TypeRefHelpersPackage;

public class JetProperty
extends JetTypeParameterListOwnerStub<KotlinPropertyStub>
implements JetVariableDeclaration,
PsiModifiableCodeBlock {
    private static final Logger LOG = Logger.getInstance(JetProperty.class);
    private static final TokenSet VAL_VAR_TOKEN_SET = TokenSet.create((IElementType[])new IElementType[]{JetTokens.VAL_KEYWORD, JetTokens.VAR_KEYWORD});

    public JetProperty(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetProperty", "<init>"));
        }
        super(node);
    }

    public JetProperty(@NotNull KotlinPropertyStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetProperty", "<init>"));
        }
        super(stub, JetStubElementTypes.PROPERTY);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetProperty", "accept"));
        }
        return visitor2.visitProperty(this, data2);
    }

    @Override
    public boolean isVar() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isVar();
        }
        return this.getNode().findChildByType((IElementType)JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isLocal() {
        PsiElement parent2 = this.getParent();
        return !(parent2 instanceof JetFile) && !(parent2 instanceof JetClassBody);
    }

    public boolean isTopLevel() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.isTopLevel();
        }
        return this.getParent() instanceof JetFile;
    }

    @Override
    @Nullable
    public JetParameterList getValueParameterList() {
        return null;
    }

    @Override
    @NotNull
    public List<JetParameter> getValueParameters() {
        List<JetParameter> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetProperty", "getValueParameters"));
        }
        return list;
    }

    @Override
    @Nullable
    public JetTypeReference getReceiverTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            if (!stub.isExtension()) {
                return null;
            }
            return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
        }
        return this.getReceiverTypeRefByTree();
    }

    @Nullable
    private JetTypeReference getReceiverTypeRefByTree() {
        IElementType tt;
        for (ASTNode node = this.getNode().getFirstChildNode(); node != null && (tt = node.getElementType()) != JetTokens.COLON; node = node.getTreeNext()) {
            if (tt != JetNodeTypes.TYPE_REFERENCE) continue;
            return (JetTypeReference)node.getPsi();
        }
        return null;
    }

    @Override
    @Nullable
    public JetTypeReference getTypeReference() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            int returnTypeRefPositionInPsi;
            if (!stub.hasReturnTypeRef()) {
                return null;
            }
            List typeReferences = this.getStubOrPsiChildrenAsList(JetStubElementTypes.TYPE_REFERENCE);
            int n = returnTypeRefPositionInPsi = stub.isExtension() ? 1 : 0;
            if (typeReferences.size() <= returnTypeRefPositionInPsi) {
                LOG.error("Invalid stub structure built for property:\n" + this.getText());
                return null;
            }
            return (JetTypeReference)typeReferences.get(returnTypeRefPositionInPsi);
        }
        return TypeRefHelpersPackage.getTypeReference(this);
    }

    @Override
    @Nullable
    public JetTypeReference setTypeReference(@Nullable JetTypeReference typeRef) {
        return TypeRefHelpersPackage.setTypeReference(this, this.getNameIdentifier(), typeRef);
    }

    @Override
    @Nullable
    public PsiElement getColon() {
        return this.findChildByType(JetTokens.COLON);
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @NotNull
    public List<JetPropertyAccessor> getAccessors() {
        List<JetPropertyAccessor> list = this.getStubOrPsiChildrenAsList(JetStubElementTypes.PROPERTY_ACCESSOR);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetProperty", "getAccessors"));
        }
        return list;
    }

    @Nullable
    public JetPropertyAccessor getGetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isGetter()) continue;
            return accessor;
        }
        return null;
    }

    @Nullable
    public JetPropertyAccessor getSetter() {
        for (JetPropertyAccessor accessor : this.getAccessors()) {
            if (!accessor.isSetter()) continue;
            return accessor;
        }
        return null;
    }

    public boolean hasDelegate() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegate();
        }
        return this.getDelegate() != null;
    }

    @Nullable
    public JetPropertyDelegate getDelegate() {
        return (JetPropertyDelegate)this.findChildByType(JetNodeTypes.PROPERTY_DELEGATE);
    }

    public boolean hasDelegateExpression() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasDelegateExpression();
        }
        return this.getDelegateExpression() != null;
    }

    @Nullable
    public JetExpression getDelegateExpression() {
        JetPropertyDelegate delegate2 = this.getDelegate();
        if (delegate2 != null) {
            return delegate2.getExpression();
        }
        return null;
    }

    @Override
    public boolean hasInitializer() {
        KotlinPropertyStub stub = (KotlinPropertyStub)this.getStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Override
    @Nullable
    public JetExpression getInitializer() {
        return (JetExpression)PsiTreeUtil.getNextSiblingOfType((PsiElement)this.findChildByType(JetTokens.EQ), JetExpression.class);
    }

    public boolean hasDelegateExpressionOrInitializer() {
        return this.hasDelegateExpression() || this.hasInitializer();
    }

    @Nullable
    public JetExpression setInitializer(@Nullable JetExpression initializer) {
        JetExpression oldInitializer = this.getInitializer();
        if (oldInitializer != null) {
            if (initializer != null) {
                return (JetExpression)oldInitializer.replace((PsiElement)initializer);
            }
            this.deleteChildRange(this.findChildByType(JetTokens.EQ), (PsiElement)oldInitializer);
            return null;
        }
        if (initializer != null) {
            JetTypeReference addAfter = this.getTypeReference();
            if (addAfter == null) {
                addAfter = this.getNameIdentifier();
            }
            PsiElement eq = this.addAfter(new JetPsiFactory(this.getProject()).createEQ(), (PsiElement)addAfter);
            return (JetExpression)this.addAfter((PsiElement)initializer, eq);
        }
        return null;
    }

    @Nullable
    public JetExpression getDelegateExpressionOrInitializer() {
        JetExpression expression2 = this.getDelegateExpression();
        if (expression2 == null) {
            return this.getInitializer();
        }
        return expression2;
    }

    @Override
    @NotNull
    public PsiElement getValOrVarKeyword() {
        PsiElement element2 = this.findChildByType(VAL_VAR_TOKEN_SET);
        assert (element2 != null) : "Val or var should always exist for property";
        PsiElement psiElement2 = element2;
        if (psiElement2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetProperty", "getValOrVarKeyword"));
        }
        return psiElement2;
    }

    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation((NavigationItem)this);
    }

    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }
}

