/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.JetNodeTypes;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetExpressionImpl;
import org.jetbrains.kotlin.psi.JetStringTemplateEntry;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.KotlinStringLiteralTextEscaper;

public class JetStringTemplateExpression
extends JetExpressionImpl
implements PsiLanguageInjectionHost {
    private static final TokenSet TOKENS_SUITABLE_FOR_INJECTION = TokenSet.create((IElementType[])new IElementType[]{JetNodeTypes.LITERAL_STRING_TEMPLATE_ENTRY, JetNodeTypes.ESCAPE_STRING_TEMPLATE_ENTRY});

    public JetStringTemplateExpression(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetStringTemplateExpression", "<init>"));
        }
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetStringTemplateExpression", "accept"));
        }
        return visitor2.visitStringTemplateExpression(this, data2);
    }

    @NotNull
    public JetStringTemplateEntry[] getEntries() {
        JetStringTemplateEntry[] jetStringTemplateEntryArray = (JetStringTemplateEntry[])this.findChildrenByClass(JetStringTemplateEntry.class);
        if (jetStringTemplateEntryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetStringTemplateExpression", "getEntries"));
        }
        return jetStringTemplateEntryArray;
    }

    public boolean isValidHost() {
        ASTNode node = this.getNode();
        for (ASTNode child = node.getFirstChildNode().getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JetTokens.CLOSING_QUOTE) {
                return true;
            }
            if (TOKENS_SUITABLE_FOR_INJECTION.contains(child.getElementType())) continue;
            return false;
        }
        return false;
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/kotlin/psi/JetStringTemplateExpression", "updateText"));
        }
        return (PsiLanguageInjectionHost)ElementManipulators.handleContentChange((PsiElement)this, (String)text);
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        KotlinStringLiteralTextEscaper kotlinStringLiteralTextEscaper = new KotlinStringLiteralTextEscaper(this);
        if (kotlinStringLiteralTextEscaper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetStringTemplateExpression", "createLiteralTextEscaper"));
        }
        return kotlinStringLiteralTextEscaper;
    }
}

