/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetModifierListOwnerStub;
import org.jetbrains.kotlin.psi.JetProjectionKind;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.stubs.KotlinTypeProjectionStub;
import org.jetbrains.kotlin.psi.stubs.elements.JetStubElementTypes;

public class JetTypeProjection
extends JetModifierListOwnerStub<KotlinTypeProjectionStub> {
    public JetTypeProjection(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/kotlin/psi/JetTypeProjection", "<init>"));
        }
        super(node);
    }

    public JetTypeProjection(@NotNull KotlinTypeProjectionStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/kotlin/psi/JetTypeProjection", "<init>"));
        }
        super(stub, JetStubElementTypes.TYPE_PROJECTION);
    }

    @NotNull
    public JetProjectionKind getProjectionKind() {
        KotlinTypeProjectionStub stub = (KotlinTypeProjectionStub)this.getStub();
        if (stub != null) {
            JetProjectionKind jetProjectionKind = stub.getProjectionKind();
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        PsiElement projectionToken = this.getProjectionToken();
        IElementType token = projectionToken != null ? projectionToken.getNode().getElementType() : null;
        for (JetProjectionKind projectionKind : JetProjectionKind.values()) {
            if (projectionKind.getToken() != token) continue;
            JetProjectionKind jetProjectionKind = projectionKind;
            if (jetProjectionKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/psi/JetTypeProjection", "getProjectionKind"));
            }
            return jetProjectionKind;
        }
        throw new IllegalStateException(projectionToken.getText());
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor2, D data2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/kotlin/psi/JetTypeProjection", "accept"));
        }
        return visitor2.visitTypeProjection(this, data2);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.getStubOrPsiChild(JetStubElementTypes.TYPE_REFERENCE);
    }

    @Nullable
    public PsiElement getProjectionToken() {
        PsiElement star = this.findChildByType(JetTokens.MUL);
        if (star != null) {
            return star;
        }
        JetModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            PsiElement element2 = modifierList.getModifier(JetTokens.IN_KEYWORD);
            if (element2 != null) {
                return element2;
            }
            element2 = modifierList.getModifier(JetTokens.OUT_KEYWORD);
            if (element2 != null) {
                return element2;
            }
        }
        return null;
    }
}

