/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.parsing.JetScriptDefinition;
import org.jetbrains.kotlin.parsing.JetScriptDefinitionProvider;
import org.jetbrains.kotlin.psi.JetFile;
import org.jetbrains.kotlin.psi.JetPackageDirective;
import org.jetbrains.kotlin.psi.JetScript;

public class ScriptNameUtil {
    private ScriptNameUtil() {
    }

    @NotNull
    public static FqName classNameForScript(JetScript script) {
        JetFile file = script.getContainingJetFile();
        JetScriptDefinition scriptDefinition = JetScriptDefinitionProvider.getInstance(file.getProject()).findScriptDefinition((PsiFile)file);
        String name2 = file.getName();
        int index2 = name2.lastIndexOf(47);
        if (index2 != -1) {
            name2 = name2.substring(index2 + 1);
        }
        if (name2.endsWith(scriptDefinition.getExtension())) {
            name2 = name2.substring(0, name2.length() - scriptDefinition.getExtension().length());
        } else {
            index2 = name2.indexOf(46);
            if (index2 != -1) {
                name2 = name2.substring(0, index2);
            }
        }
        name2 = Character.toUpperCase(name2.charAt(0)) + (name2.length() == 0 ? "" : name2.substring(1));
        name2 = name2.replace('.', '_');
        JetPackageDirective directive = file.getPackageDirective();
        if (directive != null && directive.getQualifiedName().length() > 0) {
            name2 = directive.getQualifiedName() + "." + name2;
        }
        FqName fqName2 = new FqName(name2);
        if (fqName2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/ScriptNameUtil", "classNameForScript"));
        }
        return fqName2;
    }
}

