/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetFunction;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeProjection;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TemporaryBindingTrace;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.callableReferences.CallableReferencesPackage;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callResolverUtil.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.InferencePackage;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class ArgumentTypeResolver {
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final CallResolver callResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final ReflectionTypes reflectionTypes;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    public ArgumentTypeResolver(@NotNull TypeResolver typeResolver, @NotNull CallResolver callResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull KotlinBuiltIns builtIns, @NotNull ReflectionTypes reflectionTypes, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        if (typeResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeResolver", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        if (builtIns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builtIns", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        if (reflectionTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reflectionTypes", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "<init>"));
        }
        this.typeResolver = typeResolver;
        this.callResolver = callResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.builtIns = builtIns;
        this.reflectionTypes = reflectionTypes;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }

    public static boolean isSubtypeOfForArgumentType(@NotNull JetType actualType, @NotNull JetType expectedType) {
        if (actualType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actualType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isSubtypeOfForArgumentType"));
        }
        if (ErrorUtils.isFunctionPlaceholder(actualType)) {
            JetType functionType = InferencePackage.createTypeForFunctionPlaceholder(actualType, expectedType);
            return JetTypeChecker.DEFAULT.isSubtypeOf(functionType, expectedType);
        }
        return JetTypeChecker.DEFAULT.isSubtypeOf(actualType, expectedType);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        this.checkTypesWithNoCallee(context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
    }

    public void checkTypesWithNoCallee(@NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveFunctionArgumentBodies) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (resolveFunctionArgumentBodies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveFunctionArgumentBodies", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesWithNoCallee"));
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || argumentExpression instanceof JetFunctionLiteralExpression) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
        if (resolveFunctionArgumentBodies == ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS) {
            this.checkTypesForFunctionArgumentsWithNoCallee(context);
        }
        for (JetTypeProjection jetTypeProjection : context.call.getTypeArguments()) {
            JetTypeReference typeReference = jetTypeProjection.getTypeReference();
            if (typeReference == null) {
                context.trace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(jetTypeProjection));
                continue;
            }
            this.typeResolver.resolveType(context.scope, typeReference, context.trace, true);
        }
    }

    public void checkTypesForFunctionArgumentsWithNoCallee(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "checkTypesForFunctionArgumentsWithNoCallee"));
        }
        if (context.checkArguments != CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS) {
            return;
        }
        for (ValueArgument valueArgument : context.call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null || !ArgumentTypeResolver.isFunctionLiteralArgument(argumentExpression, context)) continue;
            this.checkArgumentTypeWithNoCallee(context, argumentExpression);
        }
    }

    private void checkArgumentTypeWithNoCallee(CallResolutionContext<?> context, JetExpression argumentExpression) {
        this.expressionTypingServices.getTypeInfo(argumentExpression, (ResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        this.updateResultArgumentTypeIfNotDenotable(context, argumentExpression);
    }

    public static boolean isFunctionLiteralArgument(@NotNull JetExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "isFunctionLiteralArgument"));
        }
        return ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context) != null;
    }

    @NotNull
    public static JetFunction getFunctionLiteralArgument(@NotNull JetExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        assert (ArgumentTypeResolver.isFunctionLiteralArgument(expression2, context));
        JetFunction jetFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (jetFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgument"));
        }
        return jetFunction;
    }

    @Nullable
    public static JetFunction getFunctionLiteralArgumentIfAny(@NotNull JetExpression expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralArgumentIfAny"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (deparenthesizedExpression instanceof JetFunctionLiteralExpression) {
            return ((JetFunctionLiteralExpression)deparenthesizedExpression).getFunctionLiteral();
        }
        if (deparenthesizedExpression instanceof JetFunction) {
            return (JetFunction)deparenthesizedExpression;
        }
        return null;
    }

    @Nullable
    public static JetCallableReferenceExpression getCallableReferenceExpressionIfAny(@NotNull JetExpression expression2, @NotNull CallResolutionContext<?> context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceExpressionIfAny"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceExpressionIfAny"));
        }
        JetExpression deparenthesizedExpression = JetPsiUtil.getLastElementDeparenthesized(expression2, context.statementFilter);
        if (deparenthesizedExpression instanceof JetCallableReferenceExpression) {
            return (JetCallableReferenceExpression)deparenthesizedExpression;
        }
        return null;
    }

    @NotNull
    public JetTypeInfo getArgumentTypeInfo(@Nullable JetExpression expression2, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        if (expression2 == null) {
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetFunction functionLiteralArgument = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression2, context);
        if (functionLiteralArgument != null) {
            JetTypeInfo jetTypeInfo = this.getFunctionLiteralTypeInfo(expression2, functionLiteralArgument, context, resolveArgumentsMode);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetCallableReferenceExpression callableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression2, context);
        if (callableReferenceExpression != null) {
            JetTypeInfo jetTypeInfo = this.getCallableReferenceTypeInfo(expression2, callableReferenceExpression, context, resolveArgumentsMode);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context.trace.getBindingContext());
        if (recordedTypeInfo != null) {
            JetTypeInfo jetTypeInfo = recordedTypeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
            }
            return jetTypeInfo;
        }
        Object newContext = ((CallResolutionContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.DEPENDENT);
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)newContext);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getArgumentTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallableReferenceTypeInfo(@NotNull JetExpression expression2, @NotNull JetCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
        }
        if (callableReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableReferenceExpression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            JetType type2 = this.getShapeTypeOfCallableReference(callableReferenceExpression, context, true);
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getCallableReferenceTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getShapeTypeOfCallableReference(@NotNull JetCallableReferenceExpression callableReferenceExpression, @NotNull CallResolutionContext<?> context, boolean expectedTypeIsUnknown) {
        if (callableReferenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callableReferenceExpression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfCallableReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfCallableReference"));
        }
        JetType receiverType = CallableReferencesPackage.resolveCallableReferenceReceiverType(callableReferenceExpression, context, this.typeResolver);
        OverloadResolutionResults<CallableDescriptor> overloadResolutionResults = CallableReferencesPackage.resolvePossiblyAmbiguousCallableReference(callableReferenceExpression, receiverType, context, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS, this.callResolver);
        return CallableReferencesPackage.getResolvedCallableReferenceShapeType(callableReferenceExpression, overloadResolutionResults, context, expectedTypeIsUnknown, this.reflectionTypes, this.builtIns);
    }

    @NotNull
    public JetTypeInfo getFunctionLiteralTypeInfo(@NotNull JetExpression expression2, @NotNull JetFunction functionLiteral, @NotNull CallResolutionContext<?> context, @NotNull ResolveArgumentsMode resolveArgumentsMode) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (functionLiteral == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionLiteral", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolveArgumentsMode", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        if (resolveArgumentsMode == ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS) {
            JetType type2 = this.getShapeTypeOfFunctionLiteral(functionLiteral, context.scope, context.trace, true);
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = this.expressionTypingServices.getTypeInfo(expression2, (ResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getFunctionLiteralTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Nullable
    public JetType getShapeTypeOfFunctionLiteral(@NotNull JetFunction function2, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, boolean expectedTypeIsUnknown) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "getShapeTypeOfFunctionLiteral"));
        }
        boolean isFunctionLiteral = function2 instanceof JetFunctionLiteral;
        if (function2.getValueParameterList() == null && isFunctionLiteral) {
            return expectedTypeIsUnknown ? ErrorUtils.createFunctionPlaceholderType(Collections.<JetType>emptyList(), false) : this.builtIns.getFunctionType(Annotations.EMPTY, null, Collections.<JetType>emptyList(), TypeUtils.DONT_CARE);
        }
        List<JetParameter> valueParameters = function2.getValueParameters();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace, "trace to resolve function literal parameter types");
        ArrayList parameterTypes = Lists.newArrayList();
        for (JetParameter parameter : valueParameters) {
            parameterTypes.add(this.resolveTypeRefWithDefault(parameter.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE));
        }
        JetType returnType2 = this.resolveTypeRefWithDefault(function2.getTypeReference(), scope2, temporaryTrace, TypeUtils.DONT_CARE);
        assert (returnType2 != null);
        JetType receiverType = this.resolveTypeRefWithDefault(function2.getReceiverTypeReference(), scope2, temporaryTrace, null);
        return expectedTypeIsUnknown && isFunctionLiteral ? ErrorUtils.createFunctionPlaceholderType(parameterTypes, true) : this.builtIns.getFunctionType(Annotations.EMPTY, receiverType, parameterTypes, returnType2);
    }

    @Nullable
    public JetType resolveTypeRefWithDefault(@Nullable JetTypeReference returnTypeRef, @NotNull LexicalScope scope2, @NotNull BindingTrace trace, @Nullable JetType defaultValue) {
        if (scope2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "resolveTypeRefWithDefault"));
        }
        if (returnTypeRef != null) {
            return this.typeResolver.resolveType(scope2, returnTypeRef, trace, true);
        }
        return defaultValue;
    }

    public void analyzeArgumentsAndRecordTypes(@NotNull CallResolutionContext<?> context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "analyzeArgumentsAndRecordTypes"));
        }
        MutableDataFlowInfoForArguments infoForArguments = context.dataFlowInfoForArguments;
        Call call = context.call;
        ReceiverValue receiver = call.getExplicitReceiver();
        DataFlowInfo initialDataFlowInfo = context.dataFlowInfo;
        if (receiver.exists() && !(receiver instanceof QualifierReceiver)) {
            DataFlowValue receiverDataFlowValue = DataFlowValueFactory.createDataFlowValue(receiver, context);
            if (CallUtilPackage.isSafeCall(call)) {
                initialDataFlowInfo = initialDataFlowInfo.disequate(receiverDataFlowValue, DataFlowValue.NULL);
            }
        }
        infoForArguments.setInitialDataFlowInfo(initialDataFlowInfo);
        for (ValueArgument valueArgument : call.getValueArguments()) {
            JetExpression expression2 = valueArgument.getArgumentExpression();
            if (expression2 == null) continue;
            CallResolutionContext newContext = (CallResolutionContext)context.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            JetTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression2, newContext, ResolveArgumentsMode.SHAPE_FUNCTION_ARGUMENTS);
            infoForArguments.updateInfo(valueArgument, typeInfoForCall.getDataFlowInfo());
        }
    }

    @Nullable
    public JetType updateResultArgumentTypeIfNotDenotable(@NotNull ResolutionContext context, @NotNull JetExpression expression2) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver", "updateResultArgumentTypeIfNotDenotable"));
        }
        JetType type2 = context.trace.getType(expression2);
        if (type2 != null && !type2.getConstructor().isDenotable() && type2.getConstructor() instanceof IntegerValueTypeConstructor) {
            IntegerValueTypeConstructor constructor = (IntegerValueTypeConstructor)type2.getConstructor();
            JetType primitiveType = TypeUtils.getPrimitiveNumberType(constructor, context.expectedType);
            this.constantExpressionEvaluator.updateNumberType(primitiveType, expression2, context.statementFilter, context.trace);
            return primitiveType;
        }
        return type2;
    }
}

