/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.JetTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetClass;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetParameter;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.CallResolver;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilPackage;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CheckArgumentTypesMode;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsUtil;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.util.CallMaker;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiversPackage;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;

public class CallExpressionResolver {
    private final CallResolver callResolver;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    private final SymbolUsageValidator symbolUsageValidator;
    private final DataFlowAnalyzer dataFlowAnalyzer;
    private ExpressionTypingServices expressionTypingServices;

    public CallExpressionResolver(@NotNull CallResolver callResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull SymbolUsageValidator symbolUsageValidator, @NotNull DataFlowAnalyzer dataFlowAnalyzer) {
        if (callResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callResolver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (constantExpressionEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constantExpressionEvaluator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (symbolUsageValidator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbolUsageValidator", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        if (dataFlowAnalyzer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowAnalyzer", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "<init>"));
        }
        this.callResolver = callResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.symbolUsageValidator = symbolUsageValidator;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
    }

    @Inject
    public void setExpressionTypingServices(@NotNull ExpressionTypingServices expressionTypingServices) {
        if (expressionTypingServices == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressionTypingServices", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "setExpressionTypingServices"));
        }
        this.expressionTypingServices = expressionTypingServices;
    }

    @Nullable
    public ResolvedCall<FunctionDescriptor> getResolvedCallForFunction(@NotNull Call call, @NotNull JetExpression callExpression, @NotNull ResolutionContext context, @NotNull CheckArgumentTypesMode checkArguments, @NotNull boolean[] result2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (checkArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkArguments", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getResolvedCallForFunction"));
        }
        OverloadResolutionResults<FunctionDescriptor> results2 = this.callResolver.resolveFunctionCall(BasicCallResolutionContext.create(context, call, checkArguments));
        if (!results2.isNothing()) {
            result2[0] = true;
            return OverloadResolutionResultsUtil.getResultingCall(results2, context.contextDependency);
        }
        result2[0] = false;
        return null;
    }

    @Nullable
    private JetType getVariableType(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context, @NotNull boolean[] result2) {
        QualifierReceiver qualifier2;
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getVariableType"));
        }
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as local variable or property", nameExpression);
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        BasicCallResolutionContext contextForVariable = BasicCallResolutionContext.create(context.replaceTraceAndCache(temporaryForVariable), call, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS);
        OverloadResolutionResults<VariableDescriptor> resolutionResult = this.callResolver.resolveSimpleProperty(contextForVariable);
        boolean isLHSOfDot = JetPsiUtil.isLHSOfDot(nameExpression);
        if (!resolutionResult.isNothing() && resolutionResult.getResultCode() != OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER) {
            boolean isQualifier;
            boolean bl = isQualifier = isLHSOfDot && resolutionResult.isSingleResult() && resolutionResult.getResultingDescriptor() instanceof FakeCallableDescriptorForObject;
            if (!isQualifier) {
                result2[0] = true;
                temporaryForVariable.commit();
                return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
            }
        }
        if ((qualifier2 = ReceiversPackage.createQualifier(nameExpression, receiver, context)) != null) {
            result2[0] = true;
            if (!isLHSOfDot) {
                ReceiversPackage.resolveAsStandaloneExpression(qualifier2, context, this.symbolUsageValidator);
            }
            return null;
        }
        temporaryForVariable.commit();
        result2[0] = !resolutionResult.isNothing();
        return resolutionResult.isSingleResult() ? resolutionResult.getResultingDescriptor().getReturnType() : null;
    }

    @NotNull
    public JetTypeInfo getSimpleNameExpressionTypeInfo(@NotNull JetSimpleNameExpression nameExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (nameExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        boolean[] result2 = new boolean[1];
        TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable", nameExpression);
        JetType type2 = this.getVariableType(nameExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
        if (result2[0]) {
            temporaryForVariable.commit();
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        Call call = CallMaker.makeCall(nameExpression, receiver, callOperationNode, nameExpression, Collections.emptyList());
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function", nameExpression);
        Object newContext = context.replaceTraceAndCache(temporaryForFunction);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, nameExpression, (ResolutionContext)newContext, CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2);
        if (result2[0]) {
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
            context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(nameExpression, nameExpression, hasValueParameters));
            type2 = functionDescriptor != null ? functionDescriptor.getReturnType() : null;
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        temporaryForVariable.commit();
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSimpleNameExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfo(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck(callExpression, receiver, callOperationNode, context);
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (JetExpression)callExpression, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getCallExpressionTypeInfoWithoutFinalTypeCheck(@NotNull JetCallExpression callExpression, @NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @NotNull ExpressionTypingContext context) {
        if (callExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        boolean[] result2 = new boolean[1];
        Call call = CallMaker.makeCall(receiver, callOperationNode, callExpression);
        TemporaryTraceAndCache temporaryForFunction = TemporaryTraceAndCache.create(context, "trace to resolve as function call", callExpression);
        ResolvedCall<FunctionDescriptor> resolvedCall = this.getResolvedCallForFunction(call, callExpression, (ResolutionContext)((ExpressionTypingContext)context.replaceTraceAndCache(temporaryForFunction)).replaceInsideCallChain(false), CheckArgumentTypesMode.CHECK_VALUE_ARGUMENTS, result2);
        if (result2[0]) {
            DataFlowInfo resultFlowInfo;
            FunctionDescriptor functionDescriptor = resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
            temporaryForFunction.commit();
            if (callExpression.getValueArgumentList() == null && callExpression.getFunctionLiteralArguments().isEmpty()) {
                boolean hasValueParameters = functionDescriptor == null || functionDescriptor.getValueParameters().size() > 0;
                context.trace.report(Errors.FUNCTION_CALL_EXPECTED.on(callExpression, callExpression, hasValueParameters));
            }
            if (functionDescriptor == null) {
                JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
            if (functionDescriptor instanceof ConstructorDescriptor) {
                DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
                if (DescriptorUtils.isAnnotationClass(containingDescriptor) && !CallExpressionResolver.canInstantiateAnnotationClass(callExpression, context.trace)) {
                    context.trace.report(Errors.ANNOTATION_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (DescriptorUtils.isEnumClass(containingDescriptor)) {
                    context.trace.report(Errors.ENUM_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
                if (containingDescriptor instanceof ClassDescriptor && ((ClassDescriptor)containingDescriptor).getModality() == Modality.SEALED) {
                    context.trace.report(Errors.SEALED_CLASS_CONSTRUCTOR_CALL.on(callExpression));
                }
            }
            JetType type2 = functionDescriptor.getReturnType();
            List<JetValueArgument> arguments2 = callExpression.getValueArguments();
            DataFlowInfo jumpFlowInfo = resultFlowInfo = resolvedCall.getDataFlowInfoForArguments().getResultInfo();
            boolean jumpOutPossible = false;
            for (ValueArgument valueArgument : arguments2) {
                JetTypeInfo argTypeInfo = context.trace.get(BindingContext.EXPRESSION_TYPE_INFO, valueArgument.getArgumentExpression());
                if (argTypeInfo == null || !argTypeInfo.getJumpOutPossible()) continue;
                jumpOutPossible = true;
                jumpFlowInfo = argTypeInfo.getJumpFlowInfo();
                break;
            }
            JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.createTypeInfo(type2, resultFlowInfo, jumpOutPossible, jumpFlowInfo);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
            }
            return jetTypeInfo;
        }
        JetExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression && callExpression.getTypeArgumentList() == null) {
            TemporaryTraceAndCache temporaryForVariable = TemporaryTraceAndCache.create(context, "trace to resolve as variable with 'invoke' call", callExpression);
            JetType type3 = this.getVariableType((JetSimpleNameExpression)calleeExpression, receiver, callOperationNode, (ExpressionTypingContext)context.replaceTraceAndCache(temporaryForVariable), result2);
            Qualifier qualifier2 = temporaryForVariable.trace.get(BindingContext.QUALIFIER, calleeExpression);
            if (result2[0] && (qualifier2 == null || qualifier2.getPackageView() == null)) {
                temporaryForVariable.commit();
                context.trace.report(Errors.FUNCTION_EXPECTED.on(calleeExpression, calleeExpression, type3 != null ? type3 : ErrorUtils.createErrorType("")));
                JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
                if (jetTypeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
                }
                return jetTypeInfo;
            }
        }
        temporaryForFunction.commit();
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getCallExpressionTypeInfoWithoutFinalTypeCheck"));
        }
        return jetTypeInfo;
    }

    private static boolean canInstantiateAnnotationClass(@NotNull JetCallExpression expression2, @NotNull BindingTrace trace) {
        JetClass jetClass;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "canInstantiateAnnotationClass"));
        }
        PsiElement parent2 = PsiTreeUtil.getParentOfType((PsiElement)expression2, (Class[])new Class[]{JetValueArgument.class, JetParameter.class});
        if (parent2 instanceof JetValueArgument) {
            return PsiTreeUtil.getParentOfType((PsiElement)parent2, JetAnnotationEntry.class) != null;
        }
        if (parent2 instanceof JetParameter && (jetClass = (JetClass)PsiTreeUtil.getParentOfType((PsiElement)parent2, JetClass.class)) != null) {
            DeclarationDescriptor descriptor2 = trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, jetClass);
            return DescriptorUtils.isAnnotationClass(descriptor2);
        }
        return false;
    }

    @NotNull
    private JetTypeInfo getSelectorReturnTypeInfo(@NotNull ReceiverValue receiver, @Nullable ASTNode callOperationNode, @Nullable JetExpression selectorExpression, @NotNull ExpressionTypingContext context) {
        if (receiver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        if (selectorExpression instanceof JetCallExpression) {
            JetTypeInfo jetTypeInfo = this.getCallExpressionTypeInfoWithoutFinalTypeCheck((JetCallExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression instanceof JetSimpleNameExpression) {
            JetTypeInfo jetTypeInfo = this.getSimpleNameExpressionTypeInfo((JetSimpleNameExpression)selectorExpression, receiver, callOperationNode, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
            }
            return jetTypeInfo;
        }
        if (selectorExpression != null) {
            context.trace.report(Errors.ILLEGAL_SELECTOR.on(selectorExpression, selectorExpression.getText()));
        }
        JetTypeInfo jetTypeInfo = TypeInfoFactoryPackage.noTypeInfo(context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getSelectorReturnTypeInfo"));
        }
        return jetTypeInfo;
    }

    @NotNull
    public JetTypeInfo getQualifiedExpressionTypeInfo(@NotNull JetQualifiedExpression expression2, @NotNull ExpressionTypingContext context) {
        JetTypeInfo typeInfo;
        CompileTimeConstant<?> value2;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        JetExpression selectorExpression = expression2.getSelectorExpression();
        JetExpression receiverExpression = expression2.getReceiverExpression();
        boolean safeCall = expression2.getOperationSign() == JetTokens.SAFE_ACCESS;
        Object contextForReceiver = ((ExpressionTypingContext)((ExpressionTypingContext)context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE)).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceInsideCallChain(true);
        JetTypeInfo receiverTypeInfo = this.expressionTypingServices.getTypeInfo(receiverExpression, (ResolutionContext)contextForReceiver);
        JetType receiverType = receiverTypeInfo.getType();
        QualifierReceiver qualifierReceiver = (QualifierReceiver)context.trace.get(BindingContext.QUALIFIER, receiverExpression);
        if (receiverType == null) {
            receiverType = ErrorUtils.createErrorType("Type for " + expression2.getText());
        }
        ReceiverValue receiver = qualifierReceiver == null ? new ExpressionReceiver(receiverExpression, receiverType) : qualifierReceiver;
        DataFlowInfo receiverDataFlowInfo = receiverTypeInfo.getDataFlowInfo();
        context = (ExpressionTypingContext)context.replaceDataFlowInfo(receiverDataFlowInfo);
        JetTypeInfo selectorReturnTypeInfo = this.getSelectorReturnTypeInfo(receiver, expression2.getOperationTokenNode(), selectorExpression, context);
        JetType selectorReturnType = selectorReturnTypeInfo.getType();
        this.resolveDeferredReceiverInQualifiedExpression(qualifierReceiver, expression2, context);
        CallExpressionResolver.checkNestedClassAccess(expression2, context);
        if (safeCall && selectorReturnType != null && TypeUtils.isNullableType(receiverType)) {
            selectorReturnType = TypeUtils.makeNullable(selectorReturnType);
            selectorReturnTypeInfo = selectorReturnTypeInfo.replaceType(selectorReturnType);
        }
        if (selectorExpression != null && selectorReturnType != null) {
            context.trace.recordType(selectorExpression, selectorReturnType);
        }
        if ((value2 = this.constantExpressionEvaluator.evaluateExpression(expression2, context.trace, context.expectedType)) != null && value2.getIsPure()) {
            JetTypeInfo jetTypeInfo = this.dataFlowAnalyzer.createCompileTimeConstantTypeInfo(value2, expression2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
            }
            return jetTypeInfo;
        }
        DataFlowInfo safeCallChainInfo = receiverTypeInfo instanceof JetTypeInfoInsideSafeCall ? ((JetTypeInfoInsideSafeCall)receiverTypeInfo).getSafeCallChainInfo() : null;
        if (safeCall) {
            if (safeCallChainInfo == null) {
                safeCallChainInfo = receiverDataFlowInfo;
            }
            typeInfo = context.insideCallChain ? new JetTypeInfoInsideSafeCall(selectorReturnTypeInfo, safeCallChainInfo) : selectorReturnTypeInfo.replaceDataFlowInfo(safeCallChainInfo);
        } else {
            typeInfo = context.insideCallChain || safeCallChainInfo == null ? new JetTypeInfoInsideSafeCall(selectorReturnTypeInfo, selectorReturnTypeInfo.getDataFlowInfo()) : selectorReturnTypeInfo.replaceDataFlowInfo(safeCallChainInfo);
        }
        if (context.contextDependency == ContextDependency.INDEPENDENT) {
            this.dataFlowAnalyzer.checkType(typeInfo.getType(), (JetExpression)expression2, (ResolutionContext)context);
        }
        JetTypeInfo jetTypeInfo = typeInfo;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "getQualifiedExpressionTypeInfo"));
        }
        return jetTypeInfo;
    }

    private void resolveDeferredReceiverInQualifiedExpression(@Nullable QualifierReceiver qualifierReceiver, @NotNull JetQualifiedExpression qualifiedExpression, @NotNull ExpressionTypingContext context) {
        if (qualifiedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedExpression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "resolveDeferredReceiverInQualifiedExpression"));
        }
        if (qualifierReceiver == null) {
            return;
        }
        JetExpression calleeExpression = JetPsiUtil.deparenthesize(CallUtilPackage.getCalleeExpressionIfAny(qualifiedExpression.getSelectorExpression()), false);
        DeclarationDescriptor selectorDescriptor = calleeExpression instanceof JetReferenceExpression ? context.trace.get(BindingContext.REFERENCE_TARGET, (JetReferenceExpression)calleeExpression) : null;
        ReceiversPackage.resolveAsReceiverInQualifiedExpression(qualifierReceiver, context, this.symbolUsageValidator, selectorDescriptor);
    }

    private static void checkNestedClassAccess(@NotNull JetQualifiedExpression expression2, @NotNull ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver", "checkNestedClassAccess"));
        }
        JetExpression selectorExpression = expression2.getSelectorExpression();
        if (selectorExpression == null) {
            return;
        }
        Qualifier expressionQualifier = context.trace.get(BindingContext.QUALIFIER, expression2);
        Qualifier receiverQualifier = context.trace.get(BindingContext.QUALIFIER, expression2.getReceiverExpression());
        if (receiverQualifier == null && expressionQualifier != null) {
            assert (expressionQualifier.getClassifier() instanceof ClassDescriptor) : "Only class can (package cannot) be accessed by instance reference: " + expressionQualifier;
            context.trace.report(Errors.NESTED_CLASS_ACCESSED_VIA_INSTANCE_REFERENCE.on(selectorExpression, (ClassDescriptor)expressionQualifier.getClassifier()));
        }
    }

    private static class JetTypeInfoInsideSafeCall
    extends JetTypeInfo {
        private final DataFlowInfo safeCallChainInfo;

        private JetTypeInfoInsideSafeCall(@NotNull JetTypeInfo typeInfo, @Nullable DataFlowInfo safeCallChainInfo) {
            if (typeInfo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeInfo", "org/jetbrains/kotlin/resolve/calls/CallExpressionResolver$JetTypeInfoInsideSafeCall", "<init>"));
            }
            super(typeInfo.getType(), typeInfo.getDataFlowInfo(), typeInfo.getJumpOutPossible(), typeInfo.getJumpFlowInfo());
            this.safeCallChainInfo = safeCallChainInfo;
        }

        @Nullable
        public DataFlowInfo getSafeCallChainInfo() {
            return this.safeCallChainInfo;
        }
    }
}

