/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeIntersector;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.JetTypeChecker;

public class SmartCastManager {
    @NotNull
    public List<JetType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull ResolutionContext context) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        List<JetType> list = this.getSmartCastVariants(receiverToCast, context.trace.getBindingContext(), context.scope.getOwnerDescriptor(), context.dataFlowInfo);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        return list;
    }

    @NotNull
    public List<JetType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        ArrayList variants2 = Lists.newArrayList();
        variants2.add(receiverToCast.getType());
        variants2.addAll(this.getSmartCastVariantsExcludingReceiver(bindingContext2, containingDeclarationOrModule, dataFlowInfo, receiverToCast));
        ArrayList arrayList = variants2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariants"));
        }
        return arrayList;
    }

    @NotNull
    public List<JetType> getSmartCastVariantsWithLessSpecificExcluded(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo) {
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        final List<JetType> variants2 = this.getSmartCastVariants(receiverToCast, bindingContext2, containingDeclarationOrModule, dataFlowInfo);
        List list = KotlinPackage.filter(variants2, (Function1)new Function1<JetType, Boolean>(){

            public Boolean invoke(final JetType type2) {
                return !KotlinPackage.any((Iterable)variants2, (Function1)new Function1<JetType, Boolean>(){

                    public Boolean invoke(JetType another) {
                        return another != type2 && JetTypeChecker.DEFAULT.isSubtypeOf(another, type2);
                    }
                });
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsWithLessSpecificExcluded"));
        }
        return list;
    }

    @NotNull
    public Collection<JetType> getSmartCastVariantsExcludingReceiver(@NotNull ResolutionContext context, @NotNull ReceiverValue receiverToCast) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        Collection<JetType> collection = this.getSmartCastVariantsExcludingReceiver(context.trace.getBindingContext(), context.scope.getOwnerDescriptor(), context.dataFlowInfo, receiverToCast);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        return collection;
    }

    @NotNull
    public Collection<JetType> getSmartCastVariantsExcludingReceiver(@NotNull BindingContext bindingContext2, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo, @NotNull ReceiverValue receiverToCast) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (containingDeclarationOrModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclarationOrModule", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (dataFlowInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowInfo", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        if (receiverToCast == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverToCast", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext2, containingDeclarationOrModule);
        Set<JetType> set = dataFlowInfo.getPossibleTypes(dataFlowValue);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastVariantsExcludingReceiver"));
        }
        return set;
    }

    public boolean isSubTypeBySmartCastIgnoringNullability(@NotNull ReceiverValue receiverArgument, @NotNull JetType receiverParameterType, @NotNull ResolutionContext context) {
        if (receiverArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverArgument", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "isSubTypeBySmartCastIgnoringNullability"));
        }
        List<JetType> smartCastTypes = this.getSmartCastVariants(receiverArgument, context);
        return this.getSmartCastSubType(TypeUtils.makeNullable(receiverParameterType), smartCastTypes) != null;
    }

    @Nullable
    private JetType getSmartCastSubType(@NotNull JetType receiverParameterType, @NotNull Collection<JetType> smartCastTypes) {
        if (receiverParameterType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiverParameterType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastSubType"));
        }
        if (smartCastTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "smartCastTypes", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "getSmartCastSubType"));
        }
        HashSet subTypes = Sets.newHashSet();
        for (JetType smartCastType : smartCastTypes) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(smartCastType, receiverParameterType)) continue;
            subTypes.add(smartCastType);
        }
        if (subTypes.isEmpty()) {
            return null;
        }
        JetType intersection = TypeIntersector.intersectTypes(KotlinBuiltIns.getInstance(), JetTypeChecker.DEFAULT, subTypes);
        if (intersection == null || !intersection.getConstructor().isDenotable()) {
            return receiverParameterType;
        }
        return intersection;
    }

    private static void recordCastOrError(@NotNull JetExpression expression2, @NotNull JetType type2, @NotNull BindingTrace trace, boolean canBeCast, boolean recordExpressionType) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "recordCastOrError"));
        }
        if (canBeCast) {
            trace.record(BindingContext.SMARTCAST, expression2, type2);
            if (recordExpressionType) {
                trace.recordType(expression2, type2);
            }
        } else {
            trace.report(Errors.SMARTCAST_IMPOSSIBLE.on(expression2, type2, expression2.getText()));
        }
    }

    @Nullable
    public SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue, @NotNull JetType expectedType, @Nullable JetExpression expression2, @NotNull ResolutionContext c, boolean recordExpressionType) {
        if (dataFlowValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataFlowValue", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (expectedType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager", "checkAndRecordPossibleCast"));
        }
        for (JetType possibleType : c.dataFlowInfo.getPossibleTypes(dataFlowValue)) {
            if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType)) continue;
            if (expression2 != null) {
                SmartCastManager.recordCastOrError(expression2, possibleType, c.trace, dataFlowValue.isPredictable(), recordExpressionType);
            }
            return new SmartCastResult(possibleType, dataFlowValue.isPredictable());
        }
        if (!c.dataFlowInfo.getNullability(dataFlowValue).canBeNull() && !expectedType.isMarkedNullable()) {
            boolean immanentlyNotNull = !dataFlowValue.getImmanentNullability().canBeNull();
            JetType nullableExpectedType = TypeUtils.makeNullable(expectedType);
            if (ArgumentTypeResolver.isSubtypeOfForArgumentType(dataFlowValue.getType(), nullableExpectedType)) {
                if (!immanentlyNotNull && expression2 != null) {
                    SmartCastManager.recordCastOrError(expression2, dataFlowValue.getType(), c.trace, dataFlowValue.isPredictable(), recordExpressionType);
                }
                return new SmartCastResult(dataFlowValue.getType(), immanentlyNotNull || dataFlowValue.isPredictable());
            }
            return this.checkAndRecordPossibleCast(dataFlowValue, nullableExpectedType, expression2, c, recordExpressionType);
        }
        return null;
    }
}

