/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.lazy.descriptors;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.KotlinPackage;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Mutable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.ReadOnly;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ClassDescriptorBase;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetAnnotationEntry;
import org.jetbrains.kotlin.psi.JetClassOrObject;
import org.jetbrains.kotlin.psi.JetDelegationSpecifier;
import org.jetbrains.kotlin.psi.JetModifierList;
import org.jetbrains.kotlin.psi.JetObjectDeclaration;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetTypeParameter;
import org.jetbrains.kotlin.psi.JetTypeParameterList;
import org.jetbrains.kotlin.psi.JetTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.LazyClassContext;
import org.jetbrains.kotlin.resolve.lazy.LazyEntity;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassInfoUtil;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassLikeInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetClassOrObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.data.JetObjectInfo;
import org.jetbrains.kotlin.resolve.lazy.declarations.ClassMemberDeclarationProvider;
import org.jetbrains.kotlin.resolve.lazy.descriptors.ClassResolutionScopesSupport;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotations;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationsContext;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyClassMemberScope;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyTypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.StaticScopeForKotlinClass;
import org.jetbrains.kotlin.resolve.source.SourcePackage;
import org.jetbrains.kotlin.storage.MemoizedFunctionToNotNull;
import org.jetbrains.kotlin.storage.NotNullLazyValue;
import org.jetbrains.kotlin.storage.NullableLazyValue;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.AbstractClassTypeConstructor;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptorWithResolutionScopes,
LazyEntity {
    private static final Predicate<JetType> VALID_SUPERTYPE = new Predicate<JetType>(){

        public boolean apply(JetType type2) {
            assert (!type2.isError()) : "Error types must be filtered out in DescriptorResolver";
            return TypeUtils.getClassDescriptor(type2) != null;
        }
    };
    private final LazyClassContext c;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final LazyClassTypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final NotNullLazyValue<ClassKind> kind;
    private final NotNullLazyValue<Boolean> isInner;
    private final Annotations annotations;
    private final Annotations danglingAnnotations;
    private final NullableLazyValue<LazyClassDescriptor> companionObjectDescriptor;
    private final MemoizedFunctionToNotNull<JetObjectDeclaration, ClassDescriptor> extraCompanionObjectDescriptors;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final JetScope staticScope;
    private final NullableLazyValue<Void> forceResolveAllContents;
    private final boolean isCompanionObject;
    private final ClassResolutionScopesSupport resolutionScopesSupport;

    public LazyClassDescriptor(@NotNull LazyClassContext c, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name2, @NotNull JetClassLikeInfo classLikeInfo) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (containingDeclaration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingDeclaration", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        if (classLikeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLikeInfo", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "<init>"));
        }
        super(c.getStorageManager(), containingDeclaration, name2, SourcePackage.toSourceElement(classLikeInfo.getCorrespondingClassOrObject()));
        this.c = c;
        JetClassOrObject classOrObject = classLikeInfo.getCorrespondingClassOrObject();
        if (classOrObject != null) {
            this.c.getTrace().record(BindingContext.CLASS, classOrObject, this);
        }
        this.c.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, DescriptorUtils.getFqName(this), this);
        this.declarationProvider = c.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classLikeInfo);
        this.unsubstitutedMemberScope = this.createMemberScope(c, this.declarationProvider);
        this.staticScope = new StaticScopeForKotlinClass(this);
        this.typeConstructor = new LazyClassTypeConstructor();
        final ClassKind syntaxKind = classLikeInfo.getClassKind();
        this.isCompanionObject = classLikeInfo instanceof JetObjectInfo && ((JetObjectInfo)classLikeInfo).isCompanionObject();
        final JetModifierList modifierList = classLikeInfo.getModifierList();
        if (syntaxKind.isSingleton()) {
            this.modality = Modality.FINAL;
        } else {
            Modality defaultModality = syntaxKind == ClassKind.INTERFACE ? Modality.ABSTRACT : Modality.FINAL;
            this.modality = ModifiersChecker.resolveModalityFromModifiers(modifierList, defaultModality);
        }
        boolean isLocal = classOrObject != null && JetPsiUtil.isLocal(classOrObject);
        Visibility defaultVisibility = syntaxKind == ClassKind.ENUM_ENTRY || syntaxKind == ClassKind.OBJECT && this.isCompanionObject ? Visibilities.PUBLIC : Visibilities.DEFAULT_VISIBILITY;
        this.visibility = isLocal ? Visibilities.LOCAL : ModifiersChecker.resolveVisibilityFromModifiers(modifierList, defaultVisibility);
        StorageManager storageManager = c.getStorageManager();
        final LazyClassDescriptor descriptor2 = this;
        this.isInner = storageManager.createLazyValue(new Function0<Boolean>(){

            public Boolean invoke() {
                return ModifiersChecker.isInnerClass(modifierList) && !ModifiersChecker.isIllegalInner(descriptor2);
            }
        });
        this.kind = storageManager.createLazyValue(new Function0<ClassKind>(){

            public ClassKind invoke() {
                return syntaxKind == ClassKind.CLASS && KotlinBuiltIns.isAnnotation(descriptor2) ? ClassKind.ANNOTATION_CLASS : syntaxKind;
            }
        });
        if (modifierList != null) {
            LazyAnnotations classAnnotations = new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

                @Override
                @NotNull
                public LexicalScope getScope() {
                    LexicalScope lexicalScope = LazyClassDescriptor.this.getOuterScope();
                    if (lexicalScope == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$4", "getScope"));
                    }
                    return lexicalScope;
                }
            }, modifierList.getAnnotationEntries());
            this.annotations = c.getAnnotationResolver().resolveAndAppendAnnotationsFromModifiers(classAnnotations, modifierList);
        } else {
            this.annotations = Annotations.EMPTY;
        }
        List<JetAnnotationEntry> jetDanglingAnnotations = classLikeInfo.getDanglingAnnotations();
        this.danglingAnnotations = jetDanglingAnnotations.isEmpty() ? Annotations.EMPTY : new LazyAnnotations(new LazyAnnotationsContext(c.getAnnotationResolver(), storageManager, c.getTrace()){

            @Override
            @NotNull
            public LexicalScope getScope() {
                LexicalScope lexicalScope = LazyClassDescriptor.this.getScopeForMemberDeclarationResolution();
                if (lexicalScope == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$5", "getScope"));
                }
                return lexicalScope;
            }
        }, jetDanglingAnnotations);
        this.companionObjectDescriptor = storageManager.createNullableLazyValue(new Function0<LazyClassDescriptor>(){

            public LazyClassDescriptor invoke() {
                return LazyClassDescriptor.this.computeCompanionObjectDescriptor(LazyClassDescriptor.this.getCompanionObjectIfAllowed());
            }
        });
        this.extraCompanionObjectDescriptors = storageManager.createMemoizedFunction(new Function1<JetObjectDeclaration, ClassDescriptor>(){

            public ClassDescriptor invoke(JetObjectDeclaration companionObject) {
                return LazyClassDescriptor.this.computeCompanionObjectDescriptor(companionObject);
            }
        });
        this.forceResolveAllContents = storageManager.createRecursionTolerantNullableLazyValue(new Function0<Void>(){

            public Void invoke() {
                LazyClassDescriptor.this.doForceResolveAllContents();
                return null;
            }
        }, null);
        this.resolutionScopesSupport = new ClassResolutionScopesSupport(this, storageManager, (Function0<? extends LexicalScope>)new Function0<LexicalScope>(){

            public LexicalScope invoke() {
                return LazyClassDescriptor.this.getOuterScope();
            }
        }, classLikeInfo.getPrimaryConstructorParameters());
    }

    @NotNull
    protected LazyClassMemberScope createMemberScope(@NotNull LazyClassContext c, @NotNull ClassMemberDeclarationProvider declarationProvider) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        if (declarationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declarationProvider", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        LazyClassMemberScope lazyClassMemberScope = new LazyClassMemberScope(c, declarationProvider, this, c.getTrace());
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "createMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedMemberScope() {
        LazyClassMemberScope lazyClassMemberScope = this.unsubstitutedMemberScope;
        if (lazyClassMemberScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getUnsubstitutedMemberScope"));
        }
        return lazyClassMemberScope;
    }

    @NotNull
    protected LexicalScope getOuterScope() {
        LexicalScope lexicalScope = this.c.getDeclarationScopeProvider().getResolutionScopeForDeclaration(this.declarationProvider.getOwnerInfo().getScopeAnchor());
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getOuterScope"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForClassHeaderResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForClassHeaderResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForClassHeaderResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForStaticMemberDeclarationResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForStaticMemberDeclarationResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForStaticMemberDeclarationResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public LexicalScope getScopeForInitializerResolution() {
        LexicalScope lexicalScope = (LexicalScope)this.resolutionScopesSupport.getScopeForInitializerResolution().invoke();
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getScopeForInitializerResolution"));
        }
        return lexicalScope;
    }

    @Override
    @NotNull
    public Collection<CallableMemberDescriptor> getDeclaredCallableMembers() {
        List list = KotlinPackage.filter(this.unsubstitutedMemberScope.getAllDescriptors(), (Function1)new Function1<DeclarationDescriptor, Boolean>(){

            public Boolean invoke(DeclarationDescriptor descriptor2) {
                return descriptor2 instanceof CallableMemberDescriptor && ((CallableMemberDescriptor)descriptor2).getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDeclaredCallableMembers"));
        }
        return list;
    }

    @Override
    @NotNull
    public JetScope getStaticScope() {
        JetScope jetScope = this.staticScope;
        if (jetScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getStaticScope"));
        }
        return jetScope;
    }

    @Override
    @NotNull
    public Collection<ConstructorDescriptor> getConstructors() {
        Collection<ConstructorDescriptor> collection = this.unsubstitutedMemberScope.getConstructors();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getConstructors"));
        }
        return collection;
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        LazyClassTypeConstructor lazyClassTypeConstructor = this.typeConstructor;
        if (lazyClassTypeConstructor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getTypeConstructor"));
        }
        return lazyClassTypeConstructor;
    }

    @Override
    public LazyClassDescriptor getCompanionObjectDescriptor() {
        return (LazyClassDescriptor)this.companionObjectDescriptor.invoke();
    }

    @NotNull
    @ReadOnly
    public List<ClassDescriptor> getDescriptorsForExtraCompanionObjects() {
        final JetObjectDeclaration allowedCompanionObject = this.getCompanionObjectIfAllowed();
        List list = KotlinPackage.map((Iterable)KotlinPackage.filter(this.declarationProvider.getOwnerInfo().getCompanionObjects(), (Function1)new Function1<JetObjectDeclaration, Boolean>(){

            public Boolean invoke(JetObjectDeclaration companionObject) {
                return companionObject != allowedCompanionObject;
            }
        }), (Function1)new Function1<JetObjectDeclaration, ClassDescriptor>(){

            public ClassDescriptor invoke(JetObjectDeclaration companionObject) {
                return (ClassDescriptor)LazyClassDescriptor.this.extraCompanionObjectDescriptors.invoke(companionObject);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDescriptorsForExtraCompanionObjects"));
        }
        return list;
    }

    @Nullable
    private LazyClassDescriptor computeCompanionObjectDescriptor(@Nullable JetObjectDeclaration companionObject) {
        JetClassLikeInfo companionObjectInfo = LazyClassDescriptor.getCompanionObjectInfo(companionObject);
        if (!(companionObjectInfo instanceof JetClassOrObjectInfo)) {
            return null;
        }
        Name name2 = ((JetClassOrObjectInfo)companionObjectInfo).getName();
        assert (name2 != null);
        this.getUnsubstitutedMemberScope().getClassifier(name2, NoLookupLocation.UNSORTED);
        ClassDescriptor companionObjectDescriptor2 = this.c.getTrace().get(BindingContext.CLASS, companionObject);
        if (companionObjectDescriptor2 instanceof LazyClassDescriptor) {
            assert (DescriptorUtils.isCompanionObject(companionObjectDescriptor2)) : "Not a companion object: " + companionObjectDescriptor2;
            return (LazyClassDescriptor)companionObjectDescriptor2;
        }
        return null;
    }

    @Nullable
    private static JetClassLikeInfo getCompanionObjectInfo(@Nullable JetObjectDeclaration companionObject) {
        if (companionObject != null) {
            return JetClassInfoUtil.createClassLikeInfo(companionObject);
        }
        return null;
    }

    @Nullable
    private JetObjectDeclaration getCompanionObjectIfAllowed() {
        JetObjectDeclaration companionObject = (JetObjectDeclaration)KotlinPackage.firstOrNull(this.declarationProvider.getOwnerInfo().getCompanionObjects());
        return companionObject != null && this.isCompanionObjectAllowed() ? companionObject : null;
    }

    private boolean isCompanionObjectAllowed() {
        return !this.getKind().isSingleton() && !this.isInner() && !DescriptorUtils.isLocal(this);
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        ClassKind classKind = (ClassKind)((Object)this.kind.invoke());
        if (classKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getKind"));
        }
        return classKind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        Modality modality = this.modality;
        if (modality == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getModality"));
        }
        return modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        Visibility visibility = this.visibility;
        if (visibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getVisibility"));
        }
        return visibility;
    }

    @Override
    public boolean isInner() {
        return (Boolean)this.isInner.invoke();
    }

    @Override
    public boolean isCompanionObject() {
        return this.isCompanionObject;
    }

    @Override
    @NotNull
    public Annotations getAnnotations() {
        Annotations annotations2 = this.annotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getAnnotations"));
        }
        return annotations2;
    }

    @NotNull
    public Annotations getDanglingAnnotations() {
        Annotations annotations2 = this.danglingAnnotations;
        if (annotations2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor", "getDanglingAnnotations"));
        }
        return annotations2;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    @Override
    public void forceResolveAllContents() {
        this.forceResolveAllContents.invoke();
    }

    private void doForceResolveAllContents() {
        this.resolveMemberHeaders();
        LazyClassDescriptor companionObjectDescriptor2 = this.getCompanionObjectDescriptor();
        if (companionObjectDescriptor2 != null) {
            ForceResolveUtil.forceResolveAllContents(companionObjectDescriptor2);
        }
        ForceResolveUtil.forceResolveAllContents(this.getConstructors());
        ForceResolveUtil.forceResolveAllContents(this.getDescriptorsForExtraCompanionObjects());
        ForceResolveUtil.forceResolveAllContents(this.getUnsubstitutedMemberScope());
        ForceResolveUtil.forceResolveAllContents(this.getTypeConstructor());
    }

    public void resolveMemberHeaders() {
        ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
        ForceResolveUtil.forceResolveAllContents(this.getDanglingAnnotations());
        this.getCompanionObjectDescriptor();
        this.getDescriptorsForExtraCompanionObjects();
        this.getConstructors();
        this.getContainingDeclaration();
        this.getThisAsReceiverParameter();
        this.getKind();
        this.getModality();
        this.getName();
        this.getOriginal();
        this.getScopeForClassHeaderResolution();
        this.getScopeForMemberDeclarationResolution();
        this.getUnsubstitutedMemberScope().getAllDescriptors();
        this.getScopeForInitializerResolution();
        this.getUnsubstitutedInnerClassesScope();
        this.getTypeConstructor().getSupertypes();
        for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
            typeParameterDescriptor.getUpperBounds();
            typeParameterDescriptor.getLowerBounds();
        }
        this.getUnsubstitutedPrimaryConstructor();
        this.getVisibility();
    }

    private class LazyClassTypeConstructor
    extends AbstractClassTypeConstructor
    implements LazyEntity {
        private final NotNullLazyValue<Supertypes> supertypes;
        private final NotNullLazyValue<List<TypeParameterDescriptor>> parameters;
        private final NullableLazyValue<Void> forceResolveAllContents;

        private LazyClassTypeConstructor() {
            this.supertypes = LazyClassDescriptor.this.c.getStorageManager().createLazyValueWithPostCompute(new Function0<Supertypes>(){

                public Supertypes invoke() {
                    if (KotlinBuiltIns.isSpecialClassWithNoSupertypes(LazyClassDescriptor.this)) {
                        return new Supertypes((Collection)Collections.emptyList());
                    }
                    JetClassOrObject classOrObject = LazyClassDescriptor.this.declarationProvider.getOwnerInfo().getCorrespondingClassOrObject();
                    if (classOrObject == null) {
                        return new Supertypes(Collections.singleton(LazyClassDescriptor.this.c.getModuleDescriptor().getBuiltIns().getAnyType()));
                    }
                    List<JetType> allSupertypes = LazyClassDescriptor.this.c.getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), LazyClassDescriptor.this, classOrObject, LazyClassDescriptor.this.c.getTrace());
                    return new Supertypes((Collection)Lists.newArrayList((Iterable)Collections2.filter(allSupertypes, (Predicate)VALID_SUPERTYPE)));
                }
            }, new Function1<Boolean, Supertypes>(){

                public Supertypes invoke(Boolean firstTime) {
                    return new Supertypes((Collection)Collections.emptyList());
                }
            }, new Function1<Supertypes, Unit>(){

                public Unit invoke(@NotNull Supertypes supertypes2) {
                    if (supertypes2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor$3", "invoke"));
                    }
                    LazyClassTypeConstructor.this.findAndDisconnectLoopsInTypeHierarchy(supertypes2);
                    return Unit.INSTANCE$;
                }
            });
            this.parameters = LazyClassDescriptor.this.c.getStorageManager().createLazyValue(new Function0<List<TypeParameterDescriptor>>(){

                public List<TypeParameterDescriptor> invoke() {
                    JetClassLikeInfo classInfo = LazyClassDescriptor.this.declarationProvider.getOwnerInfo();
                    JetTypeParameterList typeParameterList = classInfo.getTypeParameterList();
                    if (typeParameterList == null) {
                        return Collections.emptyList();
                    }
                    if (classInfo.getClassKind() == ClassKind.ENUM_CLASS) {
                        LazyClassDescriptor.this.c.getTrace().report(Errors.TYPE_PARAMETERS_IN_ENUM.on(typeParameterList));
                    }
                    List<JetTypeParameter> typeParameters = typeParameterList.getParameters();
                    ArrayList<TypeParameterDescriptor> parameters2 = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        parameters2.add(new LazyTypeParameterDescriptor(LazyClassDescriptor.this.c, LazyClassDescriptor.this, typeParameters.get(i), i));
                    }
                    return parameters2;
                }
            });
            this.forceResolveAllContents = LazyClassDescriptor.this.c.getStorageManager().createRecursionTolerantNullableLazyValue(new Function0<Void>(){

                public Void invoke() {
                    LazyClassTypeConstructor.this.doForceResolveAllContents();
                    return null;
                }
            }, null);
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            List list = (List)this.parameters.invoke();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getParameters"));
            }
            return list;
        }

        @Override
        @NotNull
        public Collection<JetType> getSupertypes() {
            Collection<JetType> collection = ((Supertypes)this.supertypes.invoke()).trueSupertypes;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getSupertypes"));
            }
            return collection;
        }

        private void findAndDisconnectLoopsInTypeHierarchy(Supertypes supertypes2) {
            Iterator<JetType> iterator2 = supertypes2.trueSupertypes.iterator();
            while (iterator2.hasNext()) {
                JetType supertype = iterator2.next();
                if (!this.isReachable(supertype.getConstructor(), this, new HashSet<TypeConstructor>())) continue;
                iterator2.remove();
                supertypes2.cyclicSupertypes.add(supertype);
                ClassifierDescriptor supertypeDescriptor = supertype.getConstructor().getDeclarationDescriptor();
                if (!(supertypeDescriptor instanceof ClassDescriptor)) continue;
                ClassDescriptor superclass = (ClassDescriptor)supertypeDescriptor;
                this.reportCyclicInheritanceHierarchyError(LazyClassDescriptor.this.c.getTrace(), LazyClassDescriptor.this, superclass);
            }
        }

        private void reportCyclicInheritanceHierarchyError(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ClassDescriptor superclass) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (classDescriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            if (superclass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superclass", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "reportCyclicInheritanceHierarchyError"));
            }
            PsiElement psiElement2 = DescriptorToSourceUtils.getSourceFromDescriptor(classDescriptor);
            Object elementToMark = null;
            if (psiElement2 instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement2;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = trace.get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement2 instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement2).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark != null) {
                trace.report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on((PsiElement)elementToMark));
            }
        }

        private boolean isReachable(TypeConstructor from, TypeConstructor to, Set<TypeConstructor> visited) {
            if (!visited.add(from)) {
                return false;
            }
            for (JetType supertype : this.getNeighbors(from)) {
                TypeConstructor supertypeConstructor = supertype.getConstructor();
                if (supertypeConstructor == to) {
                    return true;
                }
                if (!this.isReachable(supertypeConstructor, to, visited)) continue;
                return true;
            }
            return false;
        }

        private Collection<JetType> getNeighbors(TypeConstructor from) {
            DeclarationDescriptor container2;
            ArrayList<JetType> neighbours = new ArrayList<JetType>(from instanceof LazyClassTypeConstructor ? ((Supertypes)((LazyClassTypeConstructor)from).supertypes.invoke()).getAllSupertypes() : from.getSupertypes());
            ClassifierDescriptor fromDescriptor = from.getDeclarationDescriptor();
            if (fromDescriptor != null && (container2 = fromDescriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
                neighbours.add(((ClassDescriptor)container2).getDefaultType());
            }
            return neighbours;
        }

        @Override
        public boolean isFinal() {
            return !LazyClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public boolean isDenotable() {
            return true;
        }

        @Override
        public ClassifierDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        @Override
        @NotNull
        public Annotations getAnnotations() {
            Annotations annotations2 = Annotations.EMPTY;
            if (annotations2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$LazyClassTypeConstructor", "getAnnotations"));
            }
            return annotations2;
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }

        @Override
        public void forceResolveAllContents() {
            this.forceResolveAllContents.invoke();
        }

        private void doForceResolveAllContents() {
            ForceResolveUtil.forceResolveAllContents(this.getAnnotations());
            ForceResolveUtil.forceResolveAllContents(this.getSupertypes());
            ForceResolveUtil.forceResolveAllContents(this.getParameters());
        }
    }

    private static class Supertypes {
        @Mutable
        public final Collection<JetType> trueSupertypes;
        @Mutable
        public final Collection<JetType> cyclicSupertypes;

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this(trueSupertypes, new ArrayList<JetType>(0));
        }

        private Supertypes(@Mutable @NotNull Collection<JetType> trueSupertypes, @Mutable @NotNull Collection<JetType> cyclicSupertypes) {
            if (trueSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            if (cyclicSupertypes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cyclicSupertypes", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "<init>"));
            }
            this.trueSupertypes = trueSupertypes;
            this.cyclicSupertypes = cyclicSupertypes;
        }

        @NotNull
        public Collection<JetType> getAllSupertypes() {
            List list = KotlinPackage.plus(this.trueSupertypes, this.cyclicSupertypes);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/lazy/descriptors/LazyClassDescriptor$Supertypes", "getAllSupertypes"));
            }
            return list;
        }
    }
}

