/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.scopes.receivers;

import com.intellij.psi.PsiElement;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.JetScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.QualifierReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.resolve.validation.SymbolUsageValidator;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"T\b)y1M]3bi\u0016\fV/\u00197jM&,'O\u0003\u0006fqB\u0014Xm]:j_:TqCS3u'&l\u0007\u000f\\3OC6,W\t\u001f9sKN\u001c\u0018n\u001c8\u000b\u0007=\u0014xMC\u0005kKR\u0014'/Y5og*11n\u001c;mS:T1\u0001]:j\u0015!\u0011XmY3jm\u0016\u0014(\"\u0004*fG\u0016Lg/\u001a:WC2,XMC\u0004sKN|GN^3\u000b\rM\u001cw\u000e]3t\u0015%\u0011XmY3jm\u0016\u00148OC\u0004d_:$X\r\u001f;\u000b/\u0015C\bO]3tg&|g\u000eV=qS:<7i\u001c8uKb$(\"\u0002;za\u0016\u001c(bC3yaJ,7o]5p]NT\u0011#U;bY&4\u0017.\u001a:SK\u000e,\u0017N^3s\u0015-\tV/\u00197jM&,'o\u0013;\u000b?I,7o\u001c7wK\u0006sGMU3d_J$'+\u001a4fe\u0016t7-\u001a+be\u001e,GO\u0003\u000bts6\u0014w\u000e\\+tC\u001e,g+\u00197jI\u0006$xN\u001d\u0006\u0015'fl'm\u001c7Vg\u0006<WMV1mS\u0012\fGo\u001c:\u000b\u0015Y\fG.\u001b3bi&|gN\u0003\u0005tK2,7\r^8s\u0015U!Um\u00197be\u0006$\u0018n\u001c8EKN\u001c'/\u001b9u_JT1\u0002Z3tGJL\u0007\u000f^8sg*!QK\\5u\u0015\u0019\u0012Xm]8mm\u0016\f5OU3dK&4XM]%o#V\fG.\u001b4jK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\u0006\u001ee\u0016\u001cx\u000e\u001c<f\u0003N\u001cF/\u00198eC2|g.Z#yaJ,7o]5p]*9!*\u001a;UsB,'B\u0006:fg>dg/\u001a*fM\u0016\u0014XM\\2f)\u0006\u0014x-\u001a;/\u0004)\u0011\u0001c\u0001\u0006\u0005\u0011\u0001\u0001BA\u0003\u0003\t\u0003A)!\u0002\u0002\u0005\u0003!\u0019Qa\u0001C\u0002\u0011\u0005a\u0001!\u0002\u0002\u0005\u0003!%QA\u0001C\u0003\u0011\u0015)!\u0001B\u0002\t\f\u0015\u0019Aq\u0001\u0005\u0005\u0019\u0001)!\u0001B\u0001\t\u000f\u0015\u0011A\u0011\u0002E\b\u000b\r!Q\u0001#\u0004\r\u0001\u0015\u0019Aq\u0001\u0005\t\u0019\u0001)!\u0001b\u0002\t\u0011\u0015\u0011A1\u0001\u0005\u0002\u000b\t!9\u0001\u0003\u0003\u0006\u0005\u0011)\u0001RB\u0003\u0003\t\u000bA)\"B\u0002\u0005\u0012!QA\u0002A\u0003\u0003\t\u0005AA\"B\u0002\u0005\u0014!]A\u0002A\u0003\u0002\u0011\u000b)1\u0001\"\u0006\t\u001a1\u0001QA\u0001C\t\u0011))!\u0001b\u0005\t\u0018\u0015\u0019A\u0011\u0002\u0005\u000f\u0019\u0001)!\u0001\"\u0003\t\u001d\u0015eCa\u0001\r\u0001;\u001f!\u0001\u0001#\u0001\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0001Qt\u0002\u0003\u0001\u0011\u000fi1!B\u0001\t\ta!\u0001k!\u0001\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0005\tC!B\u0001\t\r1\u0005\u0001DB)\u0004\u0013\u0011\u0001\u0011\"\u0001E\u0007\u001b\u0005Aq!D\u0001\t\u00105\t\u0001\u0002\u0003-\u0004\u0012\u0015\u0015D!A\u000b\u0004\u000b\u0005Aa\u0001\u0007\u0004\u0019\u0013u=A\u0001\u0001\u0005\u0007\u001b\r)\u0011\u0001c\u0003\u0019\fA\u001b\t!h\u0004\u0005\u0001!MQbA\u0003\u0002\u0011%A\u0012\u0002U\u0002\u0002;#!\u0001\u0001C\u0006\u000e\t\u0015\t\u0001B\u0003G\u00011)\u000161A\u0011\u0004\u000b\u0005A1\u0002G\u0006R\u0007-!\u0011\"C\u0001\u0005\u00015\t\u0001RB\u0007\u0002\u0011!i\u0011\u0001c\u0006\u000e\u0003!a\u0001l!\u0005\u0006f\u0011\tQcA\u0003\u0002\u0011\u0019Ab\u0001G\u0007\u001e\u0010\u0011\u0001\u0001BB\u0007\u0004\u000b\u0005AY\u0001g\u0003Q\u0007\u0003iz\u0001\u0002\u0001\t\u00145\u0019Q!\u0001\u0005\n1%\u00016!AO\t\t\u0001A1\"\u0004\u0003\u0006\u0003!QA\u0012\u0001\r\u000b!\u000e\r\u0011eA\u0003\u0002\u0011-A2\"U\u0002\f\t5I\u0011\u0001\u0002\u0001\u000e\u0003!5Q\"\u0001\u0005\t\u001b\u0005A9\"D\u0001\t\u0019a\u001b\t\"\u0002\u0015\u0005\u0003U\u0019Q!\u0001\u0005\u00071\u0019AZ\"h\u0004\u0005\u0001!1QbA\u0003\u0002\u0011\u0017AZ\u0001UB\u0001;\u001f!\u0001\u0001c\u0005\u000e\u0007\u0015\t\u0001\"\u0003\r\n!\u000e\t\u0011\u0005B\u0003\u0002\u00113a\t\u0001'\u0007R\u0007%!Y\"C\u0001\t\u001b5\t\u0001RB\u0007\u0002\u0011!i\u0011\u0001c\u0006Y\u0007#))\u0007B\u0001\u0016\u0007\u0015\t\u0001B\u0002\r\u00071;iz\u0001\u0002\u0001\t\r5\u0019Q!\u0001E\u00061\u0017\u00016\u0011AO\b\t\u0001A\u0019\"D\u0002\u0006\u0003!I\u0001$\u0003)\u0004\u0003uEA\u0001\u0001\u0005\f\u001b\u0011)\u0011\u0001\u0003\u0006\r\u0002aQ\u0001ka\u0001\"\u0007\u0015\t\u0001B\u0003\r\u000b#\u000eYAQD\u0005\u0002\u00111i\u0011\u0001#\u0004\u000e\u0003!AQ\"\u0001E\f\u001b\u0005AA\u0002WB\t"})
public final class QualifierKt {
    @Nullable
    public static final QualifierReceiver createQualifier(@NotNull JetSimpleNameExpression expression2, @NotNull ReceiverValue receiver, @NotNull ExpressionTypingContext context) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)receiver, (String)"receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        JetScope receiverScope = !receiver.exists() ? ScopeUtilsKt.asJetScope(context.scope) : (receiver instanceof QualifierReceiver ? ((QualifierReceiver)receiver).getScope() : receiver.getType().getMemberScope());
        Name name2 = expression2.getReferencedNameAsName();
        PackageViewDescriptor packageViewDescriptor = receiverScope.getPackage(name2);
        ClassifierDescriptor classifierDescriptor = receiverScope.getClassifier(name2);
        if (packageViewDescriptor == null && classifierDescriptor == null) {
            return null;
        }
        BindingContextUtilsKt.recordScopeAndDataFlowInfo(context, expression2);
        QualifierReceiver qualifier2 = new QualifierReceiver(expression2, packageViewDescriptor, classifierDescriptor);
        context.trace.record(BindingContext.QUALIFIER, qualifier2.getExpression(), qualifier2);
        return qualifier2;
    }

    @Nullable
    public static final JetType resolveAsStandaloneExpression(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)symbolUsageValidator, (String)"symbolUsageValidator");
        QualifierKt.resolveAndRecordReferenceTarget($receiver, context, symbolUsageValidator, null);
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)$receiver.getClassifier()));
        } else if ($receiver.getClassifier() instanceof ClassDescriptor && !DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier())) {
            context.trace.report(Errors.NO_COMPANION_OBJECT.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), $receiver.getClassifier()));
        } else if ($receiver.getPackageView() != null) {
            context.trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression())));
        }
        return null;
    }

    public static final void resolveAsReceiverInQualifiedExpression(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator, @Nullable DeclarationDescriptor selector) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)symbolUsageValidator, (String)"symbolUsageValidator");
        QualifierKt.resolveAndRecordReferenceTarget($receiver, context, symbolUsageValidator, selector);
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            context.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((JetSimpleNameExpression)((PsiElement)$receiver.getReferenceExpression()), (TypeParameterDescriptor)$receiver.getClassifier()));
        } else if ($receiver.getClassifier() instanceof ClassDescriptor && DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier())) {
            context.trace.recordType($receiver.getExpression(), DescriptorUtilsKt.getClassObjectType((ClassDescriptor)$receiver.getClassifier()));
        }
    }

    public static final void resolveAndRecordReferenceTarget(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator, @Nullable DeclarationDescriptor selector) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)symbolUsageValidator, (String)"symbolUsageValidator");
        $receiver.setResultingDescriptor(QualifierKt.resolveReferenceTarget($receiver, context, symbolUsageValidator, selector));
        context.trace.record(BindingContext.REFERENCE_TARGET, $receiver.getReferenceExpression(), $receiver.getResultingDescriptor());
    }

    @NotNull
    public static final DeclarationDescriptor resolveReferenceTarget(QualifierReceiver $receiver, @NotNull ExpressionTypingContext context, @NotNull SymbolUsageValidator symbolUsageValidator, @Nullable DeclarationDescriptor selector) {
        ClassDescriptor companionObjectDescriptor2;
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)symbolUsageValidator, (String)"symbolUsageValidator");
        if ($receiver.getClassifier() instanceof TypeParameterDescriptor) {
            return $receiver.getClassifier();
        }
        if (selector instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null;
        }
        if ($receiver.getPackageView() != null && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName($receiver.getPackageView()), (Object)DescriptorUtils.getFqName(selectorContainer))) {
            return $receiver.getPackageView();
        }
        boolean isCallableWithReceiver = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
        DeclarationDescriptor declarationDescriptor3 = $receiver.getDescriptor();
        if (declarationDescriptor3 instanceof ClassifierDescriptor) {
            ClassifierDescriptor classifierDescriptor = (ClassifierDescriptor)declarationDescriptor3;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, (PsiElement)$receiver.getReferenceExpression());
        }
        if (isCallableWithReceiver && $receiver.getClassifier() instanceof ClassDescriptor && DescriptorUtilsKt.getHasClassObjectType((ClassDescriptor)$receiver.getClassifier()) && (companionObjectDescriptor2 = ((ClassDescriptor)$receiver.getClassifier()).getCompanionObjectDescriptor()) != null) {
            context.trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, $receiver.getReferenceExpression(), $receiver.getClassifier());
            ClassifierDescriptor classifierDescriptor = companionObjectDescriptor2;
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingTrace, (String)"context.trace");
            symbolUsageValidator.validateTypeUsage(classifierDescriptor, bindingTrace, (PsiElement)$receiver.getReferenceExpression());
            return companionObjectDescriptor2;
        }
        return declarationDescriptor3;
    }
}

