/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.utils.Interner;

public class StringTable {
    private final Interner<String> strings;
    private final Interner<FqNameProto> qualifiedNames;
    private final SerializerExtension extension;

    public StringTable(@NotNull SerializerExtension extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/kotlin/serialization/StringTable", "<init>"));
        }
        this.strings = new Interner();
        this.qualifiedNames = new Interner();
        this.extension = extension;
    }

    public int getSimpleNameIndex(@NotNull Name name2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/serialization/StringTable", "getSimpleNameIndex"));
        }
        return this.getStringIndex(name2.asString());
    }

    public int getStringIndex(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/kotlin/serialization/StringTable", "getStringIndex"));
        }
        return this.strings.intern(string);
    }

    public int getFqNameIndex(@NotNull ClassOrPackageFragmentDescriptor descriptor2) {
        int shortName;
        DeclarationDescriptor containingDeclaration;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/serialization/StringTable", "getFqNameIndex"));
        }
        if (ErrorUtils.isError(descriptor2)) {
            throw new IllegalStateException("Cannot get FQ name of error class: " + descriptor2);
        }
        ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
        if (descriptor2 instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.CLASS);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration()) instanceof PackageFragmentDescriptor) {
            shortName = this.getSimpleNameIndex(descriptor2.getName());
            PackageFragmentDescriptor fragment = (PackageFragmentDescriptor)containingDeclaration;
            if (!fragment.getFqName().isRoot()) {
                builder.setParentQualifiedName(this.getFqNameIndex(fragment.getFqName()));
            }
        } else if (containingDeclaration instanceof ClassDescriptor) {
            shortName = this.getSimpleNameIndex(descriptor2.getName());
            ClassDescriptor outerClass = (ClassDescriptor)containingDeclaration;
            builder.setParentQualifiedName(this.getFqNameIndex(outerClass));
        } else if (descriptor2 instanceof ClassDescriptor) {
            builder.setKind(ProtoBuf.QualifiedNameTable.QualifiedName.Kind.LOCAL);
            shortName = this.getStringIndex(this.extension.getLocalClassName((ClassDescriptor)descriptor2));
        } else {
            throw new IllegalStateException("Package container should be a package: " + descriptor2);
        }
        builder.setShortName(shortName);
        return this.qualifiedNames.intern(new FqNameProto(builder));
    }

    public int getFqNameIndex(@NotNull FqName fqName2) {
        if (fqName2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/serialization/StringTable", "getFqNameIndex"));
        }
        int result2 = -1;
        for (Name segment : fqName2.pathSegments()) {
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder builder = ProtoBuf.QualifiedNameTable.QualifiedName.newBuilder();
            builder.setShortName(this.getSimpleNameIndex(segment));
            if (result2 != -1) {
                builder.setParentQualifiedName(result2);
            }
            result2 = this.qualifiedNames.intern(new FqNameProto(builder));
        }
        return result2;
    }

    @NotNull
    public ProtoBuf.StringTable serializeSimpleNames() {
        ProtoBuf.StringTable.Builder builder = ProtoBuf.StringTable.newBuilder();
        for (String simpleName : this.strings.getAllInternedObjects()) {
            builder.addString(simpleName);
        }
        ProtoBuf.StringTable stringTable = builder.build();
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/StringTable", "serializeSimpleNames"));
        }
        return stringTable;
    }

    @NotNull
    public ProtoBuf.QualifiedNameTable serializeQualifiedNames() {
        ProtoBuf.QualifiedNameTable.Builder builder = ProtoBuf.QualifiedNameTable.newBuilder();
        for (FqNameProto fqName2 : this.qualifiedNames.getAllInternedObjects()) {
            builder.addQualifiedName(fqName2.fqName);
        }
        ProtoBuf.QualifiedNameTable qualifiedNameTable = builder.build();
        if (qualifiedNameTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/serialization/StringTable", "serializeQualifiedNames"));
        }
        return qualifiedNameTable;
    }

    private static final class FqNameProto {
        public final ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName;

        public FqNameProto(@NotNull ProtoBuf.QualifiedNameTable.QualifiedName.Builder fqName2) {
            if (fqName2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fqName", "org/jetbrains/kotlin/serialization/StringTable$FqNameProto", "<init>"));
            }
            this.fqName = fqName2;
        }

        public int hashCode() {
            int result2 = 13;
            result2 = 31 * result2 + this.fqName.getParentQualifiedName();
            result2 = 31 * result2 + this.fqName.getShortName();
            result2 = 31 * result2 + this.fqName.getKind().hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ProtoBuf.QualifiedNameTable.QualifiedName.Builder other = ((FqNameProto)obj).fqName;
            return this.fqName.getParentQualifiedName() == other.getParentQualifiedName() && this.fqName.getShortName() == other.getShortName() && this.fqName.getKind() == other.getKind();
        }
    }
}

