/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.checker;

import java.util.ArrayDeque;
import java.util.Iterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SubtypePathNode;
import org.jetbrains.kotlin.types.checker.TypeCheckingProcedureCallbacks;

@KotlinFileFacade(version={0, 25, 0}, abiVersion=25, data={"+\u0004)Qb-\u001b8e\u0007>\u0014(/Z:q_:$\u0017N\\4TkB,'\u000f^=qK*91/\u001e2usB,'b\u0002&fiRK\b/\u001a\u0006\u0004_J<'\"\u00036fi\n\u0014\u0018-\u001b8t\u0015\u0019Yw\u000e\u001e7j]*)A/\u001f9fg*I1/\u001e9feRL\b/\u001a\u0006\u001fif\u0004Xm\u00115fG.Lgn\u001a)s_\u000e,G-\u001e:f\u0007\u0006dGNY1dWNTa\u0004V=qK\u000eCWmY6j]\u001e\u0004&o\\2fIV\u0014XmQ1mY\n\f7m[:\u000b\u000f\rDWmY6fe*9Q\u000b^5mg.#\bH\u0003\u0002\u0011\u0007)!\u0001\u0002\u0001\t\u0005\u0015\u0011A\u0011\u0001E\u0003\u000b\t!\u0011\u0001C\u0002\u0006\u0007\u0011\r\u0001\"\u0001\u0007\u0001\u000b\t!\u0019\u0001C\u0003\u0006\u0007\u0011\u0015\u0001\u0012\u0002\u0007\u0001\u000b\t!\u0019\u0001C\u0001\u0006\u0005\u0011\u0015\u0001\u0012BC-\t\rA\u0002!h\u0004\u0005\u0001!\u0005QbA\u0003\u0002\u0011\tA\"\u0001U\u0002\u0001;\u001f!\u0001\u0001c\u0002\u000e\u0007\u0015\t\u0001B\u0001\r\u0003!\u000e\u0005Qt\u0002\u0003\u0001\u0011\u0011i1!B\u0001\t\u0007a\u0019\u0001kA\u0001\"\t\u0015\t\u0001B\u0001G\u00011\t\t6!\u0003\u0003\u0001\u0013\u0005A9!D\u0001\t\b5\t\u0001rA\u0007\u0002\u0011\u0011A61\u0002"})
public final class UtilsKt {
    @Nullable
    public static final JetType findCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedureCallbacks typeCheckingProcedureCallbacks) {
        Intrinsics.checkParameterIsNotNull((Object)subtype, (String)"subtype");
        Intrinsics.checkParameterIsNotNull((Object)supertype, (String)"supertype");
        Intrinsics.checkParameterIsNotNull((Object)typeCheckingProcedureCallbacks, (String)"typeCheckingProcedureCallbacks");
        ArrayDeque<SubtypePathNode> queue = new ArrayDeque<SubtypePathNode>();
        queue.add(new SubtypePathNode(subtype, null));
        TypeConstructor supertypeConstructor = supertype.getConstructor();
        while (!queue.isEmpty()) {
            SubtypePathNode lastPathNode = (SubtypePathNode)queue.poll();
            JetType currentSubtype = lastPathNode.getType();
            TypeConstructor constructor = currentSubtype.getConstructor();
            if (typeCheckingProcedureCallbacks.assertEqualTypeConstructors(constructor, supertypeConstructor)) {
                JetType substituted = currentSubtype;
                boolean isAnyMarkedNullable = currentSubtype.isMarkedNullable();
                for (SubtypePathNode currentPathNode = lastPathNode.getPrevious(); currentPathNode != null; currentPathNode = currentPathNode.getPrevious()) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)TypeSubstitutor.create(currentPathNode.getType()).safeSubstitute(substituted, Variance.INVARIANT), (String)"TypeSubstitutor.create(c\u2026uted, Variance.INVARIANT)");
                    isAnyMarkedNullable = isAnyMarkedNullable || currentPathNode.getType().isMarkedNullable();
                }
                return TypeUtils.makeNullableAsSpecified(substituted, isAnyMarkedNullable);
            }
            Iterator<JetType> iterator2 = constructor.getSupertypes().iterator();
            while (iterator2.hasNext()) {
                JetType immediateSupertype;
                JetType jetType = immediateSupertype = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)jetType, (String)"immediateSupertype");
                queue.add(new SubtypePathNode(jetType, lastPathNode));
            }
        }
        return null;
    }
}

