/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiElement;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.JetAnnotatedExpression;
import org.jetbrains.kotlin.psi.JetArrayAccessExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpression;
import org.jetbrains.kotlin.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.JetBlockExpression;
import org.jetbrains.kotlin.psi.JetBreakExpression;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetCallableReferenceExpression;
import org.jetbrains.kotlin.psi.JetClassLiteralExpression;
import org.jetbrains.kotlin.psi.JetConstantExpression;
import org.jetbrains.kotlin.psi.JetContinueExpression;
import org.jetbrains.kotlin.psi.JetDeclaration;
import org.jetbrains.kotlin.psi.JetDoWhileExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetForExpression;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetIfExpression;
import org.jetbrains.kotlin.psi.JetIsExpression;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetObjectLiteralExpression;
import org.jetbrains.kotlin.psi.JetParenthesizedExpression;
import org.jetbrains.kotlin.psi.JetQualifiedExpression;
import org.jetbrains.kotlin.psi.JetReturnExpression;
import org.jetbrains.kotlin.psi.JetRootPackageExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetStringTemplateExpression;
import org.jetbrains.kotlin.psi.JetSuperExpression;
import org.jetbrains.kotlin.psi.JetThisExpression;
import org.jetbrains.kotlin.psi.JetThrowExpression;
import org.jetbrains.kotlin.psi.JetTryExpression;
import org.jetbrains.kotlin.psi.JetUnaryExpression;
import org.jetbrains.kotlin.psi.JetVisitor;
import org.jetbrains.kotlin.psi.JetWhenExpression;
import org.jetbrains.kotlin.psi.JetWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilPackage;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.types.DeferredType;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.JetType;
import org.jetbrains.kotlin.types.expressions.BasicExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingComponents;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitorForStatements;
import org.jetbrains.kotlin.types.expressions.FunctionsTypingVisitor;
import org.jetbrains.kotlin.types.expressions.JetTypeInfo;
import org.jetbrains.kotlin.types.expressions.PatternMatchingTypingVisitor;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryPackage;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.util.ReenteringLazyValueComputationException;
import org.jetbrains.kotlin.utils.KotlinFrontEndException;

public abstract class ExpressionTypingVisitorDispatcher
extends JetVisitor<JetTypeInfo, ExpressionTypingContext>
implements ExpressionTypingInternals {
    public static final PerformanceCounter typeInfoPerfCounter = PerformanceCounter.Companion.create("Type info", true);
    private static final Logger LOG = Logger.getInstance(ExpressionTypingVisitor.class);
    private final ExpressionTypingComponents components;
    @NotNull
    private final AnnotationChecker annotationChecker;
    protected final BasicExpressionTypingVisitor basic;
    protected final FunctionsTypingVisitor functions;
    protected final ControlStructureTypingVisitor controlStructures;
    protected final PatternMatchingTypingVisitor patterns;

    protected abstract ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext var1);

    private ExpressionTypingVisitorDispatcher(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker) {
        if (components == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "<init>"));
        }
        if (annotationChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "<init>"));
        }
        this.components = components;
        this.annotationChecker = annotationChecker;
        this.basic = new BasicExpressionTypingVisitor(this);
        this.controlStructures = new ControlStructureTypingVisitor(this);
        this.patterns = new PatternMatchingTypingVisitor(this);
        this.functions = new FunctionsTypingVisitor(this);
    }

    @Override
    @NotNull
    public ExpressionTypingComponents getComponents() {
        ExpressionTypingComponents expressionTypingComponents = this.components;
        if (expressionTypingComponents == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getComponents"));
        }
        return expressionTypingComponents;
    }

    @Override
    @NotNull
    public JetTypeInfo checkInExpression(@NotNull JetElement callElement2, @NotNull JetSimpleNameExpression operationSign, @NotNull ValueArgument leftArgument, @Nullable JetExpression right, @NotNull ExpressionTypingContext context) {
        if (callElement2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callElement", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (operationSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationSign", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (leftArgument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftArgument", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        JetTypeInfo jetTypeInfo = this.basic.checkInExpression(callElement2, operationSign, leftArgument, right, context);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkInExpression"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo safeGetTypeInfo(@NotNull JetExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        JetTypeInfo typeInfo = this.getTypeInfo(expression2, context);
        if (typeInfo.getType() != null) {
            JetTypeInfo jetTypeInfo = typeInfo;
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = typeInfo.replaceType(ErrorUtils.createErrorType("Type for " + expression2.getText())).replaceDataFlowInfo(context.dataFlowInfo);
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "safeGetTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        JetTypeInfo result2 = ExpressionTypingVisitorDispatcher.getTypeInfo(expression2, context, this);
        this.annotationChecker.checkExpression(expression2, context.trace);
        JetTypeInfo jetTypeInfo = result2;
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    @Override
    @NotNull
    public final JetTypeInfo getTypeInfo(@NotNull JetExpression expression2, ExpressionTypingContext context, boolean isStatement) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        if (!isStatement) {
            JetTypeInfo jetTypeInfo = this.getTypeInfo(expression2, context);
            if (jetTypeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
            }
            return jetTypeInfo;
        }
        JetTypeInfo jetTypeInfo = ExpressionTypingVisitorDispatcher.getTypeInfo(expression2, context, this.getStatementVisitor(context));
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    protected ExpressionTypingVisitorForStatements createStatementVisitor(ExpressionTypingContext context) {
        return new ExpressionTypingVisitorForStatements(this, ExpressionTypingUtils.newWritableScopeImpl(context, "statement scope"), this.basic, this.controlStructures, this.patterns, this.functions);
    }

    @Override
    public void checkStatementType(@NotNull JetExpression expression2, ExpressionTypingContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "checkStatementType"));
        }
        expression2.accept(this.createStatementVisitor(context), context);
    }

    @NotNull
    private static JetTypeInfo getTypeInfo(final @NotNull JetExpression expression2, final ExpressionTypingContext context, final JetVisitor<JetTypeInfo, ExpressionTypingContext> visitor2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        JetTypeInfo jetTypeInfo = typeInfoPerfCounter.time(new Function0<JetTypeInfo>(){

            public JetTypeInfo invoke() {
                try {
                    JetTypeInfo result2;
                    JetTypeInfo recordedTypeInfo = BindingContextUtils.getRecordedTypeInfo(expression2, context.trace.getBindingContext());
                    if (recordedTypeInfo != null) {
                        return recordedTypeInfo;
                    }
                    try {
                        result2 = (JetTypeInfo)expression2.accept(visitor2, context);
                        if (context.trace.get(BindingContext.PROCESSED, expression2).booleanValue()) {
                            JetType type2 = context.trace.getBindingContext().getType(expression2);
                            return result2.replaceType(type2);
                        }
                        if (result2.getType() instanceof DeferredType) {
                            result2 = result2.replaceType(((DeferredType)result2.getType()).getDelegate());
                        }
                        context.trace.record(BindingContext.EXPRESSION_TYPE_INFO, expression2, result2);
                    }
                    catch (ReenteringLazyValueComputationException e) {
                        context.trace.report(Errors.TYPECHECKER_HAS_RUN_INTO_RECURSIVE_PROBLEM.on(expression2));
                        result2 = TypeInfoFactoryPackage.noTypeInfo(context);
                    }
                    context.trace.record(BindingContext.PROCESSED, expression2);
                    BindingContextUtilPackage.recordScopeAndDataFlowInfo(context.replaceDataFlowInfo(result2.getDataFlowInfo()), expression2);
                    return result2;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (KotlinFrontEndException e) {
                    throw e;
                }
                catch (Throwable e) {
                    context.trace.report(Errors.EXCEPTION_FROM_ANALYZER.on((PsiElement)expression2, e));
                    ExpressionTypingVisitorDispatcher.logOrThrowException(expression2, e);
                    return TypeInfoFactoryPackage.createTypeInfo(ErrorUtils.createErrorType(e.getClass().getSimpleName() + " from analyzer"), context);
                }
            }
        });
        if (jetTypeInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "getTypeInfo"));
        }
        return jetTypeInfo;
    }

    private static void logOrThrowException(@NotNull JetExpression expression2, Throwable e) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "logOrThrowException"));
        }
        try {
            LOG.error("Exception while analyzing expression at " + DiagnosticUtils.atLocation(expression2) + ":\n" + expression2.getText() + "\n", e);
        }
        catch (AssertionError errorFromLogger) {
            throw new KotlinFrontEndException(((Throwable)((Object)errorFromLogger)).getMessage(), e);
        }
    }

    @Override
    public JetTypeInfo visitFunctionLiteralExpression(@NotNull JetFunctionLiteralExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitFunctionLiteralExpression"));
        }
        return this.functions.visitFunctionLiteralExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitNamedFunction(@NotNull JetNamedFunction function2, ExpressionTypingContext data2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitNamedFunction"));
        }
        return this.functions.visitNamedFunction(function2, data2);
    }

    @Override
    public JetTypeInfo visitThrowExpression(@NotNull JetThrowExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitThrowExpression"));
        }
        return this.controlStructures.visitThrowExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitReturnExpression(@NotNull JetReturnExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitReturnExpression"));
        }
        return this.controlStructures.visitReturnExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitContinueExpression(@NotNull JetContinueExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitContinueExpression"));
        }
        return this.controlStructures.visitContinueExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitIfExpression(@NotNull JetIfExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitIfExpression"));
        }
        return this.controlStructures.visitIfExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitTryExpression(@NotNull JetTryExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitTryExpression"));
        }
        return this.controlStructures.visitTryExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitForExpression(@NotNull JetForExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitForExpression"));
        }
        return this.controlStructures.visitForExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitWhileExpression(@NotNull JetWhileExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhileExpression"));
        }
        return this.controlStructures.visitWhileExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitDoWhileExpression(@NotNull JetDoWhileExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitDoWhileExpression"));
        }
        return this.controlStructures.visitDoWhileExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitBreakExpression(@NotNull JetBreakExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitBreakExpression"));
        }
        return this.controlStructures.visitBreakExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitIsExpression(@NotNull JetIsExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitIsExpression"));
        }
        return this.patterns.visitIsExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitWhenExpression(@NotNull JetWhenExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitWhenExpression"));
        }
        return this.patterns.visitWhenExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitSimpleNameExpression(@NotNull JetSimpleNameExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitSimpleNameExpression"));
        }
        return this.basic.visitSimpleNameExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitParenthesizedExpression(@NotNull JetParenthesizedExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitParenthesizedExpression"));
        }
        return this.basic.visitParenthesizedExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitConstantExpression(@NotNull JetConstantExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitConstantExpression"));
        }
        return this.basic.visitConstantExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitBinaryWithTypeRHSExpression(@NotNull JetBinaryExpressionWithTypeRHS expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitBinaryWithTypeRHSExpression"));
        }
        return this.basic.visitBinaryWithTypeRHSExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitThisExpression(@NotNull JetThisExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitThisExpression"));
        }
        return this.basic.visitThisExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitSuperExpression(@NotNull JetSuperExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitSuperExpression"));
        }
        return this.basic.visitSuperExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitBlockExpression(@NotNull JetBlockExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitBlockExpression"));
        }
        return this.basic.visitBlockExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitClassLiteralExpression(@NotNull JetClassLiteralExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitClassLiteralExpression"));
        }
        return this.basic.visitClassLiteralExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitCallableReferenceExpression(@NotNull JetCallableReferenceExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitCallableReferenceExpression"));
        }
        return this.basic.visitCallableReferenceExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitObjectLiteralExpression(@NotNull JetObjectLiteralExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitObjectLiteralExpression"));
        }
        return this.basic.visitObjectLiteralExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitQualifiedExpression(@NotNull JetQualifiedExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitQualifiedExpression"));
        }
        return this.basic.visitQualifiedExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitCallExpression(@NotNull JetCallExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitCallExpression"));
        }
        return this.basic.visitCallExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitUnaryExpression(@NotNull JetUnaryExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitUnaryExpression"));
        }
        return this.basic.visitUnaryExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitLabeledExpression(@NotNull JetLabeledExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitLabeledExpression"));
        }
        return this.basic.visitLabeledExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitBinaryExpression(@NotNull JetBinaryExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitBinaryExpression"));
        }
        return this.basic.visitBinaryExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitArrayAccessExpression(@NotNull JetArrayAccessExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitArrayAccessExpression"));
        }
        return this.basic.visitArrayAccessExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitDeclaration(@NotNull JetDeclaration dcl, ExpressionTypingContext data2) {
        if (dcl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dcl", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitDeclaration"));
        }
        return this.basic.visitDeclaration(dcl, data2);
    }

    @Override
    public JetTypeInfo visitRootPackageExpression(@NotNull JetRootPackageExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitRootPackageExpression"));
        }
        return this.basic.visitRootPackageExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitStringTemplateExpression(@NotNull JetStringTemplateExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitStringTemplateExpression"));
        }
        return this.basic.visitStringTemplateExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitAnnotatedExpression(@NotNull JetAnnotatedExpression expression2, ExpressionTypingContext data2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitAnnotatedExpression"));
        }
        return this.basic.visitAnnotatedExpression(expression2, data2);
    }

    @Override
    public JetTypeInfo visitJetElement(@NotNull JetElement element2, ExpressionTypingContext data2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher", "visitJetElement"));
        }
        return element2.accept(this.basic, data2);
    }

    public static class ForBlock
    extends ExpressionTypingVisitorDispatcher {
        private final ExpressionTypingVisitorForStatements visitorForBlock;

        public ForBlock(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker, @NotNull LexicalWritableScope writableScope) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForBlock", "<init>"));
            }
            if (annotationChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForBlock", "<init>"));
            }
            if (writableScope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writableScope", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForBlock", "<init>"));
            }
            super(components, annotationChecker);
            this.visitorForBlock = new ExpressionTypingVisitorForStatements(this, writableScope, this.basic, this.controlStructures, this.patterns, this.functions);
        }

        @Override
        protected ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForBlock", "getStatementVisitor"));
            }
            return this.visitorForBlock;
        }
    }

    public static class ForDeclarations
    extends ExpressionTypingVisitorDispatcher {
        public ForDeclarations(@NotNull ExpressionTypingComponents components, @NotNull AnnotationChecker annotationChecker) {
            if (components == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "components", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForDeclarations", "<init>"));
            }
            if (annotationChecker == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationChecker", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForDeclarations", "<init>"));
            }
            super(components, annotationChecker);
        }

        @Override
        protected ExpressionTypingVisitorForStatements getStatementVisitor(@NotNull ExpressionTypingContext context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/ExpressionTypingVisitorDispatcher$ForDeclarations", "getStatementVisitor"));
            }
            return this.createStatementVisitor(context);
        }
    }
}

