/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.JetCallExpression;
import org.jetbrains.kotlin.psi.JetElement;
import org.jetbrains.kotlin.psi.JetExpression;
import org.jetbrains.kotlin.psi.JetExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetFunctionLiteral;
import org.jetbrains.kotlin.psi.JetFunctionLiteralArgument;
import org.jetbrains.kotlin.psi.JetFunctionLiteralExpression;
import org.jetbrains.kotlin.psi.JetInstanceExpressionWithLabel;
import org.jetbrains.kotlin.psi.JetLabeledExpression;
import org.jetbrains.kotlin.psi.JetNamedFunction;
import org.jetbrains.kotlin.psi.JetPsiUtil;
import org.jetbrains.kotlin.psi.JetReferenceExpression;
import org.jetbrains.kotlin.psi.JetSimpleNameExpression;
import org.jetbrains.kotlin.psi.JetValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.scopes.utils.UtilsPackage;

public class LabelResolver {
    public static LabelResolver INSTANCE = new LabelResolver();

    private LabelResolver() {
    }

    @NotNull
    private Set<JetElement> getElementsByLabelName(@NotNull Name labelName, @NotNull JetSimpleNameExpression labelExpression) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        if (labelExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        LinkedHashSet elements = Sets.newLinkedHashSet();
        for (PsiElement parent2 = labelExpression.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Name name2 = this.getLabelNameIfAny(parent2);
            if (name2 == null || !name2.equals(labelName)) continue;
            elements.add(this.getExpressionUnderLabel((JetExpression)parent2));
        }
        LinkedHashSet linkedHashSet = elements;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getElementsByLabelName"));
        }
        return linkedHashSet;
    }

    @Nullable
    public Name getLabelNameIfAny(@NotNull PsiElement element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getLabelNameIfAny"));
        }
        if (element2 instanceof JetLabeledExpression) {
            return ((JetLabeledExpression)element2).getLabelNameAsName();
        }
        if (element2 instanceof JetFunctionLiteral) {
            return this.getLabelNameIfAny(element2.getParent());
        }
        if (element2 instanceof JetFunctionLiteralExpression) {
            return this.getLabelForFunctionalExpression((JetExpression)element2);
        }
        if (element2 instanceof JetNamedFunction) {
            Name name2 = ((JetNamedFunction)element2).getNameAsName();
            if (name2 != null) {
                return name2;
            }
            return this.getLabelForFunctionalExpression((JetExpression)element2);
        }
        return null;
    }

    private Name getLabelForFunctionalExpression(@NotNull JetExpression element2) {
        if (element2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getLabelForFunctionalExpression"));
        }
        if (element2.getParent() instanceof JetLabeledExpression) {
            return this.getLabelNameIfAny(element2.getParent());
        }
        return this.getCallerName(element2);
    }

    @NotNull
    private JetExpression getExpressionUnderLabel(@NotNull JetExpression labeledExpression) {
        if (labeledExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
        }
        JetExpression expression2 = JetPsiUtil.safeDeparenthesize(labeledExpression, true);
        if (expression2 instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteral jetFunctionLiteral = ((JetFunctionLiteralExpression)expression2).getFunctionLiteral();
            if (jetFunctionLiteral == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
            }
            return jetFunctionLiteral;
        }
        JetExpression jetExpression = expression2;
        if (jetExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getExpressionUnderLabel"));
        }
        return jetExpression;
    }

    @Nullable
    private Name getCallerName(@NotNull JetExpression expression2) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getCallerName"));
        }
        JetCallExpression callExpression = this.getContainingCallExpression(expression2);
        if (callExpression == null) {
            return null;
        }
        JetExpression calleeExpression = callExpression.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
            return nameExpression.getReferencedNameAsName();
        }
        return null;
    }

    @Nullable
    private JetCallExpression getContainingCallExpression(@NotNull JetExpression expression2) {
        PsiElement call;
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "getContainingCallExpression"));
        }
        PsiElement parent2 = expression2.getParent();
        if (parent2 instanceof JetFunctionLiteralArgument && (call = parent2.getParent()) instanceof JetCallExpression) {
            return (JetCallExpression)call;
        }
        if (parent2 instanceof JetValueArgument) {
            JetValueArgument argument = (JetValueArgument)parent2;
            PsiElement argList = argument.getParent();
            if (argList == null) {
                return null;
            }
            PsiElement call2 = argList.getParent();
            if (call2 instanceof JetCallExpression) {
                return (JetCallExpression)call2;
            }
        }
        return null;
    }

    @Nullable
    public JetElement resolveControlLabel(@NotNull JetExpressionWithLabel expression2, @NotNull ResolutionContext context) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveControlLabel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveControlLabel"));
        }
        JetSimpleNameExpression labelElement = expression2.getTargetLabel();
        Name labelName = expression2.getLabelNameAsName();
        if (labelElement == null || labelName == null) {
            return null;
        }
        Collection<DeclarationDescriptor> declarationsByLabel = UtilsPackage.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size > 1) {
            BindingContextUtils.reportAmbiguousLabel(context.trace, labelElement, declarationsByLabel);
            return null;
        }
        if (size == 0) {
            JetElement element2 = this.resolveNamedLabel(labelName, labelElement, context.trace);
            if (element2 == null) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(labelElement, labelElement));
            }
            return element2;
        }
        DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
        if (!(declarationDescriptor instanceof FunctionDescriptor) && !(declarationDescriptor instanceof ClassDescriptor)) {
            throw new UnsupportedOperationException(declarationDescriptor.getClass().toString());
        }
        JetElement element3 = (JetElement)DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
        context.trace.record(BindingContext.LABEL_TARGET, labelElement, element3);
        return element3;
    }

    private JetElement resolveNamedLabel(@NotNull Name labelName, @NotNull JetSimpleNameExpression labelExpression, @NotNull BindingTrace trace) {
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        if (labelExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelExpression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveNamedLabel"));
        }
        Set<JetElement> list = this.getElementsByLabelName(labelName, labelExpression);
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            trace.report(Errors.LABEL_NAME_CLASH.on(labelExpression));
        }
        JetElement result2 = list.iterator().next();
        trace.record(BindingContext.LABEL_TARGET, labelExpression, result2);
        return result2;
    }

    @NotNull
    public LabeledReceiverResolutionResult resolveThisOrSuperLabel(@NotNull JetInstanceExpressionWithLabel expression2, @NotNull ResolutionContext context, @NotNull Name labelName) {
        if (expression2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        if (labelName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelName", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        JetReferenceExpression referenceExpression = expression2.getInstanceReference();
        JetSimpleNameExpression targetLabel = expression2.getTargetLabel();
        assert (targetLabel != null) : expression2;
        Collection<DeclarationDescriptor> declarationsByLabel = UtilsPackage.getDeclarationsByLabel(context.scope, labelName);
        int size = declarationsByLabel.size();
        if (size == 1) {
            ClassDescriptor classDescriptor;
            ReceiverParameterDescriptor thisReceiver;
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                thisReceiver = classDescriptor2.getThisAsReceiverParameter();
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                thisReceiver = functionDescriptor.getExtensionReceiverParameter();
            } else if (declarationDescriptor instanceof PropertyDescriptor) {
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                thisReceiver = propertyDescriptor.getExtensionReceiverParameter();
            } else {
                throw new UnsupportedOperationException("Unsupported descriptor: " + declarationDescriptor);
            }
            PsiElement element2 = DescriptorToSourceUtils.descriptorToDeclaration(declarationDescriptor);
            assert (element2 != null) : "No PSI element for descriptor: " + declarationDescriptor;
            context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element2);
            context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
            if (declarationDescriptor instanceof ClassDescriptor && !DescriptorResolver.checkHasOuterClassInstance(context.scope, context.trace, (PsiElement)targetLabel, classDescriptor = (ClassDescriptor)declarationDescriptor)) {
                LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
                if (labeledReceiverResolutionResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
                }
                return labeledReceiverResolutionResult;
            }
            LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
            if (labeledReceiverResolutionResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
            }
            return labeledReceiverResolutionResult;
        }
        if (size == 0) {
            JetElement element3 = this.resolveNamedLabel(labelName, targetLabel, context.trace);
            if (element3 instanceof JetFunctionLiteral) {
                DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element3);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    ReceiverParameterDescriptor thisReceiver = ((FunctionDescriptor)declarationDescriptor).getExtensionReceiverParameter();
                    if (thisReceiver != null) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element3);
                        context.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, declarationDescriptor);
                    }
                    LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionSuccess(thisReceiver);
                    if (labeledReceiverResolutionResult == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
                    }
                    return labeledReceiverResolutionResult;
                }
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            } else {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel, targetLabel));
            }
        } else {
            BindingContextUtils.reportAmbiguousLabel(context.trace, targetLabel, declarationsByLabel);
        }
        LabeledReceiverResolutionResult labeledReceiverResolutionResult = LabeledReceiverResolutionResult.labelResolutionFailed();
        if (labeledReceiverResolutionResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/types/expressions/LabelResolver", "resolveThisOrSuperLabel"));
        }
        return labeledReceiverResolutionResult;
    }

    public static final class LabeledReceiverResolutionResult {
        private final Code code;
        private final ReceiverParameterDescriptor receiverParameterDescriptor;

        public static LabeledReceiverResolutionResult labelResolutionSuccess(@Nullable ReceiverParameterDescriptor receiverParameterDescriptor) {
            if (receiverParameterDescriptor == null) {
                return new LabeledReceiverResolutionResult(Code.NO_THIS, null);
            }
            return new LabeledReceiverResolutionResult(Code.SUCCESS, receiverParameterDescriptor);
        }

        public static LabeledReceiverResolutionResult labelResolutionFailed() {
            return new LabeledReceiverResolutionResult(Code.LABEL_RESOLUTION_ERROR, null);
        }

        private LabeledReceiverResolutionResult(Code code, ReceiverParameterDescriptor receiverParameterDescriptor) {
            this.code = code;
            this.receiverParameterDescriptor = receiverParameterDescriptor;
        }

        public Code getCode() {
            return this.code;
        }

        public boolean success() {
            return this.code == Code.SUCCESS;
        }

        public ReceiverParameterDescriptor getReceiverParameterDescriptor() {
            assert (this.success()) : "Don't try to obtain the receiver when resolution failed with " + (Object)((Object)this.code);
            return this.receiverParameterDescriptor;
        }

        public static enum Code {
            LABEL_RESOLUTION_ERROR,
            NO_THIS,
            SUCCESS;

        }
    }
}

