/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;
import org.jetbrains.kotlin.utils.LibraryUtils;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0002\f)i2j\u001c;mS:T\u0015M^1tGJL\u0007\u000f^'fi\u0006$\u0017\r^1Vi&d7OC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015)H/\u001b7t\u0015\r\te.\u001f\u0006\f\u0003\nKuLV#S'&{eJC\u0002J]RTq#\u0011\"J?Z+%kU%P\u001d\u0012\ngN\\8uCRLwN\\:\u000b\u001d\u001d,G/\u0011\"J?Z+%kU%P\u001d*1!jU0F1RSaa\u0015;sS:<'\u0002\u00026bm\u0006TA\u0001\\1oO*Iq-\u001a;K'~+\u0005\f\u0016\u0006\u001e\u0017>#F*\u0013(`\u0015\u00063\u0016iU\"S\u0013B#v,T#U\u0011>#uLT!N\u000b*)3j\u0014+M\u0013:{&*\u0011,B'\u000e\u0013\u0016\n\u0015+`\u001b\u0016#\u0006j\u0014#`\u001d\u0006kUi\u0018)B)R+%K\u0014\u0006\b!\u0006$H/\u001a:o\u0015\u0011)H/\u001b7\u000b\u000bI,w-\u001a=\u000b!5+E+\u0011#B)\u0006{\u0006+\u0011+U\u000bJs%BD'F)\u0006{&jU0T+\u001a3\u0015\n\u0017\u0006\u0012O\u0016$X*\u0012+B?*\u001bvlU+G\r&C&\u0002\u0004,G'~\u0003&k\u0014+P\u0007>c%bD4fiZ35k\u0018)S\u001fR{5i\u0014'\u000b-\u0019|'/\\1u\u001b\u0016$\u0018\rZ1uC\u0006\u001b8\u000b\u001e:j]\u001eT!\"\\8ek2,g*Y7f\u0015\u001d\u0019wN\u001c;f]RT\u0011BQ=uK\u0006\u0013(/Y=\u000b\u0017!\f7/T3uC\u0012\fG/\u0019\u0006\u0005i\u0016DHOC\u0004C_>dW-\u00198\u000bK!\f7/T3uC\u0012\fG/Y,ji\"LenY8na\u0006$\u0018N\u00197f\u0003\nLg+\u001a:tS>t'BF5t\u0003\nLg+\u001a:tS>t7i\\7qCRL'\r\\3\u000b\u0015\u0005\u0014\u0017NV3sg&|gN\u0003\u0007m_\u0006$W*\u001a;bI\u0006$\u0018M\u0003\u0003gS2,'\u0002\u0002$jY\u0016T!![8\u000b\t1K7\u000f\u001e\u0006\u0019\u0017>$H.\u001b8KCZ\f7o\u0019:jaRlU\r^1eCR\f'\u0002\u00029bi\"TQ\u0002]1sg\u0016lU\r^1eCR\f'\u0002D7fi\u0006$\u0017\r^1MSN$(bC'vi\u0006\u0014G.\u001a'jgRTA!\u00168ji*i!/\u001a9mC\u000e,7+\u001e4gSbT\u0001BZ5mKB\u000bG\u000f\u001bX\u0002\u0015\t\u0001\u0012A\u0003\u0003\t\u0001A\u0011!\u0002\u0002\u0005\u0002!\rQA\u0001\u0003\u0002\u0011\t)1\u0001b\u0001\t\u00011\u0001Q!\u0001E\u0002\u000b\r!)\u0001#\u0002\r\u0001\u0015\u0019AQ\u0001E\u0004\u0019\u0001)1\u0001\"\u0002\t\f1\u0001Q!\u0001\u0005\u0007\u000b\t!I\u0001#\u0004\u0006\u0005\u0011)\u00012B\u0003\u0003\t\u0013A\u0011\"\u0002\u0002\u0005\r!MQa\u0001C\u0007\u0011#a\u0001!\u0002\u0002\u0005\u000e!EQa\u0001C\u0003\u00119a\u0001!B\u0002\u0005\u0006!}A\u0002A\u0003\u0003\t\u0013A1#B\u0002\u0005\u0013!\u0015B\u0002A\u0003\u0004\t\u000bA9\u0003\u0004\u0001\u0006\u0007\u0011\r\u0001\u0002\u0006\u0007\u0001\u000b\t!a\u0001c\n\u0006\u0005\u0011I\u0001RE\u0003\u0004\t\u000bAa\u0003\u0004\u0001\u0006\u0007\u0011\u0015\u0001R\u0006\u0007\u0001\t\r\fABA\r\u0004\u000b\u0005A1\u0001G\u0002.+\u0011\u001dG\u0003G\u0002\"\u0007\u0015\t\u0001r\u0001M\u0004I\r)6\u0001D\u0003\u0004\t\rI\u0011\u0001\"\u0002\n\u0007\u0011!\u0011\"\u0001\u0003\u0001\u001b\r!I!C\u0001\u0005\u00065\u0002Ba\u0019\u000b\u0019\u000b\u0005\u001aQ!\u0001\u0005\u00051\u0011)6\u0001C\u0003\u0004\t\u0015I\u0011\u0001c\u0003\u000e\u0007\u00119\u0011\"\u0001E\u0006[1!\u0011\r\u0006M\bC\r)\u0011\u0001\u0003\u0003\u0019\tU\u001bA!B\u0002\u0005\u0010%\t\u00012B\u0017\r\t\u0005$\u0001\u0004C\u0011\u0004\u000b\u0005Aq\u0001G\u0004V\u0007\u0011)1\u0001\u0002\u0005\n\u0003!=Q\u0006\u0004\u0003b\taQ\u0011eA\u0003\u0002\u0011\u001dAr!V\u0002\u0005\u000b\r!!\"C\u0001\t\u00105\u0002Ba\u0019\u000b\u0019\u0016\u0005\u001aQ!\u0001\u0005\u00051\u0011)6\u0001C\u0003\u0004\t+I\u0011\u0001c\u0003\u000e\u0007\u0011Y\u0011\"\u0001E\u0006[A!1\r\u0006M\fC\r)\u0011\u0001\u0003\u0003\u0019\tU\u001b\u0001\"B\u0002\u0005\u0018%\t\u00012B\u0007\u0004\t1I\u0011\u0001c\u0003.B\u0011\u0019\u0001\u0014DO\b\t\u0001AQ\"D\u0002\u0006\u0003!!\u0001\u0004\u0002)\u0004\u0001u=A\u0001\u0001E\u000e\u001b\r)\u0011\u0001\u0003\u0005\u0019\u0011A\u001b\t!I\u0002\u0006\u0003!!\u0001\u0004B)\u0004\u0011\u0011e\u0011\"\u0001E\u0006\u001b\u0005AY!\u0004\u0002\u0005\u00041\u0005Q&\u0006C\u00041;iz\u0001\u0002\u0001\t\u001f5\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001A\u0011\u0004\u000b\u0005A\t\u0002'\u0005R\u0007\u0015!i\"C\u0001\u0005\u00025\t\u00012B\u0017\u0016\t\rA\u0002#h\u0004\u0005\u0001!yQbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001C\r)\u0011\u0001#\u0005\u0019\u0012E\u001bQ\u0001\u0002\t\n\u0003\u0011\u0005Q\"\u0001E\u0006[U!9\u0001'\t\u001e\u0010\u0011\u0001\u0001\"E\u0007\u0004\u000b\u0005A9\u0001g\u0002Q\u0007\u0001\t3!B\u0001\t\u0012aE\u0011kA\u0003\u0005\"%\tA\u0011A\u0007\u0002\t\u000bi#\u0004b\u0002\u0019$u=A\u0001\u0001\u0005\u0013\u001b\r)\u0011\u0001c\u0005\u0019\u0014A\u001b\u0001!\t\u0005\u0006\u0003!Q\u0011\u0002B\u0005\u0004\u000b\u0005A)\u0002'\u0006\u0019\u0015E\u001bQ\u0001b\t\n\u0003!YQ\"\u0001E\f[i!9\u0001g\t\u001e\u0010\u0011\u0001\u0001\u0012F\u0007\u0004\u000b\u0005AA\u0001\u0007\u0003Q\u0007\u0001\t\u0003\"B\u0001\t\u0015%!\u0011bA\u0003\u0002\u0011+A*\u0002\u0007\u0006R\u0007\u0015!\u0019#C\u0001\t\u00175\t\u00012BW%\t\u000fAR#h\u0004\u0005\u0001!yQbA\u0003\u0002\u0011\u0011AB\u0001U\u0002\u0001;3!\u0001\u0001c\u000b\u000e\u0011\u0015\t\u0001\u0002D\u0005\u0005\u0013\r)\u0011\u0001#\u0006\u0019\u0016aa\u0001k!\u0001\"\u0007\u0015\t\u0001\u0012\u0004M\r#\u000e9A!F\u0005\u0002\t\u0001i\u0011\u0001c\u0003\u000e\u0003!YQ&\u0006\u0003\u00041]iz\u0001\u0002\u0001\t05\u0019Q!\u0001\u0005\u00051\u0011\u00016\u0001A\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003R\u0007\u0015!q#C\u0001\t\f5\t\u00012B\u001b\u0001"})
public final class KotlinJavascriptMetadataUtils {
    public static final /* synthetic */ KClass $kotlinClass;
    @NotNull
    public static final String JS_EXT = ".js";
    @NotNull
    public static final String META_JS_SUFFIX = ".meta.js";
    @NotNull
    public static final String VFS_PROTOCOL = "kotlin-js-meta";
    private static final String KOTLIN_JAVASCRIPT_METHOD_NAME = "kotlin_module_metadata";
    private static final Pattern KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN;
    private static final Pattern METADATA_PATTERN;
    public static final int ABI_VERSION = 3;
    public static final KotlinJavascriptMetadataUtils INSTANCE$;

    static {
        $kotlinClass = Reflection.createKotlinClass(KotlinJavascriptMetadataUtils.class);
        new KotlinJavascriptMetadataUtils();
    }

    @NotNull
    public final String getJS_EXT() {
        return JS_EXT;
    }

    @NotNull
    public final String getMETA_JS_SUFFIX() {
        return META_JS_SUFFIX;
    }

    @NotNull
    public final String getVFS_PROTOCOL() {
        return VFS_PROTOCOL;
    }

    @JvmStatic
    private static final /* synthetic */ void ABI_VERSION$annotations() {
    }

    public static final int getABI_VERSION() {
        return ABI_VERSION;
    }

    @NotNull
    public final String replaceSuffix(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return StringsKt.substringBeforeLast$default((String)filePath, (String)JS_EXT, null, (int)2) + META_JS_SUFFIX;
    }

    @JvmStatic
    public static final boolean isAbiVersionCompatible(int abiVersion) {
        return abiVersion == ABI_VERSION;
    }

    @JvmStatic
    public static final boolean hasMetadata(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find() && METADATA_PATTERN.matcher(text).find();
    }

    public final boolean hasMetadataWithIncompatibleAbiVersion(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = StringsKt.toInt((String)matcher.group(1));
            if (abiVersion == ABI_VERSION) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String formatMetadataAsString(@NotNull String moduleName, @NotNull byte[] content2) {
        Intrinsics.checkParameterIsNotNull((Object)moduleName, (String)"moduleName");
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        return "// Kotlin." + KOTLIN_JAVASCRIPT_METHOD_NAME + "(" + ABI_VERSION + ", " + "\"" + moduleName + "\"" + ", " + "\"" + DatatypeConverter.printBase64Binary((byte[])content2) + "\"" + ");" + "\n";
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        boolean value2 = file.exists();
        if (PreconditionsKt.getASSERTIONS_ENABLED() && !value2) {
            String message = "Library " + file + " not found";
            throw (Throwable)((Object)new AssertionError((Object)message));
        }
        ArrayList metadataList = CollectionsKt.arrayListOf((Object[])new KotlinJavascriptMetadata[0]);
        LibraryUtils.traverseJsLibrary(file, (Function2<? super String, ? super String, ? extends Unit>)((Function2)new Function2<String, String, Unit>(file, metadataList){
            final /* synthetic */ File $file;
            final /* synthetic */ ArrayList $metadataList;

            public final void invoke(@NotNull String content2, @NotNull String relativePath) {
                Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
                Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
                String path = this.$file.getPath();
                if (StringsKt.isNotBlank((String)relativePath)) {
                    path = path + ("/" + relativePath);
                }
                KotlinJavascriptMetadataUtils.parseMetadata(content2, this.$metadataList);
            }
            {
                this.$file = file;
                this.$metadataList = arrayList;
                super(2);
            }
        }));
        return metadataList;
    }

    @JvmStatic
    @NotNull
    public static final List<KotlinJavascriptMetadata> loadMetadata(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return KotlinJavascriptMetadataUtils.loadMetadata(new File(path));
    }

    @JvmStatic
    public static final void parseMetadata(@NotNull String text, @NotNull List<KotlinJavascriptMetadata> metadataList) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(metadataList, (String)"metadataList");
        if (!KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN.matcher(text).find()) {
            return;
        }
        Matcher matcher = METADATA_PATTERN.matcher(text);
        while (matcher.find()) {
            int abiVersion = StringsKt.toInt((String)matcher.group(1));
            String moduleName = matcher.group(3);
            String data2 = matcher.group(5);
            String string = moduleName;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)data2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"parseBase64Binary(data)");
            metadataList.add(new KotlinJavascriptMetadata(abiVersion, string, byArray));
        }
    }

    KotlinJavascriptMetadataUtils() {
        INSTANCE$ = this;
        JS_EXT = JS_EXT;
        META_JS_SUFFIX = META_JS_SUFFIX;
        VFS_PROTOCOL = VFS_PROTOCOL;
        KOTLIN_JAVASCRIPT_METHOD_NAME = KOTLIN_JAVASCRIPT_METHOD_NAME;
        KOTLIN_JAVASCRIPT_METHOD_NAME_PATTERN = StringsKt.toPattern$default((String)"\\.kotlin_module_metadata\\(", (int)0, (int)1);
        METADATA_PATTERN = StringsKt.toPattern$default((String)("(?m)" + "\\" + "w+" + "\\" + "." + KOTLIN_JAVASCRIPT_METHOD_NAME + "\\" + "((" + "\\" + "d+)," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "2," + "\\" + "s*(['" + "\"" + "])([^'" + "\"" + "]*)" + "\\" + "4" + "\\" + ")"), (int)0, (int)1);
        ABI_VERSION = 3;
    }
}

