/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.ArraysKt;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InternalPackage;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={0, 25, 0}, abiVersion=25, data={"`\u0004)A1+\\1siN+GOC\u0002pe\u001eT\u0011B[3uEJ\f\u0017N\\:\u000b\r-|G\u000f\\5o\u0015\u0015)H/\u001b7t\u0015\u0005!&bA!os*Y\u0011IY:ue\u0006\u001cGoU3u\u0015\u0011Q\u0017M^1\u000b\tU$\u0018\u000e\u001c\u0006\u0007y%t\u0017\u000e\u001e \u000b\t\u0011\fG/\u0019\u0006\u0005Y\u0006twM\u0003\u0004PE*,7\r\u001e\u0006\u0005g&TXMC\u0002J]RT1!\u00193e\u0015\u0005)'b\u0002\"p_2,\u0017M\u001c\u0006\u0006G2,\u0017M\u001d\u0006\u0005+:LGO\u0003\u0005d_:$\u0018-\u001b8t\u0015\u0005y'\u0002C5uKJ\fGo\u001c:\u000b\u001f5+H/\u00192mK&#XM]1u_JT\u0001\"\u0013;fe\u0006$xN\u001d\u0006\n\u0007>l\u0007/\u00198j_:T\u0011cU5oO2,Go\u001c8Ji\u0016\u0014\u0018\r^8s]*\u0011\u0001#\u0001\u0006\u0005\u0011\u0001\u0001\"A\u0003\u0003\t\u0003A\u0019!\u0002\u0002\u0005\u0003!\u0011Qa\u0001C\u0002\u0011\u0001a\u0001!B\u0001\t\u0004\u0015\u0019AQ\u0001\u0005\u0004\u0019\u0001)\u0011\u0001\u0003\u0003\u0006\u0005\u0011\u001d\u0001\u0012B\u0003\u0004\t\u0011A9\u0001\u0004\u0001\u0006\u0005\u0011\u001d\u0001BB\u0003\u0003\t\u0015Ai!B\u0002\u0005\u0006!=A\u0002A\u0003\u0004\t\u000bA\u0011\u0002\u0004\u0001\u0006\u0007\u0011\u0015\u0001B\u0003\u0007\u0001\u000b\r!)\u0001\u0003\u0007\r\u0001\u0015\u0011A\u0001\u0002E\r\t\u000fa!\u0001E\u0007\u0016\u000f\u0011\u0001\u0001RA\u000b\u0005\u000b\u0005A1\u0001$\u0001\u0019\u0007eIQ!\u0001E\u0005\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\u0005;\u0005iY\"L\u0007\u0005\u00034AZ!\t\u0003\u0006\u0003!\u0019A\u0012\u0001\r\u0004+\u000e!Qa\u0001C\u0006\u0013\u0005AY!\f\u0007\u0005\u00034Ar!I\u0002\u0006\u0003!1\u0001DB+\u0004\t\u0015\u0019AaB\u0005\u0002\t\u000bic\u0003B\u0006\u0019\u0011uEA\u0001\u0001E\t\u001b\u0011)!\u0001\"\u0001\t\u0001q\u0001\u0001k\u0001\u0001\"\u0007\u0015\t\u0001R\u0002M\u0007#\u000e)A\u0001C\u0005\u0002\t\u0003i\u0011\u0001c\u0003.\u0016\u0011Y\u00014C\u0011\u0004\u000b\u0005Aq\u0001G\u0004R\u0007\r!\u0019\"C\u0001\u0005\u00015:Ba\u0013!\u00021+i\n\u0002\u0002\u0001\t\u00175!Q!\u0001\u0005\u0004\u0019\u0003A2\u0001U\u0002\u0001C\r)\u0011\u0001#\u0004\u0019\u000eE\u001bQ\u0001\"\u0006\n\u0003\u0011\u0005Q\"\u0001E\u0006[G!1\nQ\u0001\u0019\u0018\u0005JQ!\u0001E\b\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001M\b#\u000e\u0019AqC\u0005\u0002\u0011!i+\u0002B\u0006\u0019\u000f\u0005\u001aQ!\u0001\u0005\u00071\u0019\t6a\u0001\u0003\b\u0013\u0005!)!\u000e\u000e\u00063\u0011\t\u000f!E\u0004\u0005\u0001!\u0015Q\u0003B\u0003\u0002\u0011\ra\t\u0001G\u0002\u0019\u000b\u0005JQ!\u0001\u0005\u0003\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0001A\u0004\u0001\r\u0003#\u000e\u0019A!B\u0005\u0002\t\u0001\u0001"})
public final class SmartSet<T>
extends AbstractSet<T> {
    public static final /* synthetic */ KClass $kotlinClass;
    private static final int ARRAY_THRESHOLD = 5;
    private Object data;
    private int size;
    public static final Companion Companion;

    static {
        $kotlinClass = Reflection.createKotlinClass(SmartSet.class);
        Companion companion = Companion = new Companion(null);
        ARRAY_THRESHOLD = 5;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        Iterator iterator2;
        if (this.size == 0) {
            iterator2 = SetsKt.emptySet().iterator();
        } else if (this.size == 1) {
            iterator2 = new SingletonIterator<Object>(this.data);
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            iterator2 = InternalPackage.iterator((Object[])((Object[])object));
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            iterator2 = ((Set)object).iterator();
        }
        if (iterator2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableIterator<T>");
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(T e) {
        if (this.size == 0) {
            this.data = e;
        } else if (this.size == 1) {
            if (Intrinsics.areEqual((Object)this.data, e)) {
                return false;
            }
            this.data = new Object[]{this.data, e};
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Cloneable cloneable;
            SmartSet smartSet;
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] arr = (Object[])object;
            if (ArraysKt.contains((Object[])arr, e)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (this.size == SmartSet.Companion.getARRAY_THRESHOLD() - 1) {
                void $receiver;
                LinkedHashSet linkedHashSet = SetsKt.linkedSetOf((Object[])arr);
                SmartSet smartSet3 = smartSet2;
                LinkedHashSet $receiver2 = (LinkedHashSet)$receiver;
                $receiver2.add(e);
                void var6_10 = $receiver;
                smartSet = smartSet3;
                cloneable = (Cloneable)var6_10;
            } else {
                void var3_5;
                Object[] $receiver = Arrays.copyOf(arr, this.size + 1);
                SmartSet smartSet4 = smartSet2;
                Object[] $receiver3 = $receiver;
                $receiver3[$receiver3.length - 1] = e;
                void var6_11 = var3_5;
                smartSet = smartSet4;
                cloneable = (Cloneable)var6_11;
            }
            smartSet.data = cloneable;
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.MutableSet<T>");
            }
            Set set = (Set)object;
            if (!set.add(e)) {
                return false;
            }
        }
        int n = this.size++;
        return true;
    }

    @Override
    public void clear() {
        this.data = null;
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@Nullable Object o) {
        boolean bl;
        if (this.size == 0) {
            bl = false;
        } else if (this.size == 1) {
            bl = Intrinsics.areEqual((Object)this.data, (Object)o);
        } else if (this.size < SmartSet.Companion.getARRAY_THRESHOLD()) {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            bl = ArraysKt.contains((Object[])((Object[])object), (Object)o);
        } else {
            Object object = this.data;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Set<T>");
            }
            bl = ((Set)object).contains(o);
        }
        return bl;
    }

    private SmartSet() {
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    @JvmStatic
    @NotNull
    public static final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
        Intrinsics.checkParameterIsNotNull(set, (String)"set");
        return Companion.create(set);
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\u0005\u0004)I1i\\7qC:LwN\u001c\u0006\t'6\f'\u000f^*fi*\u0019qN]4\u000b\u0013),GO\u0019:bS:\u001c(BB6pi2LgNC\u0003vi&d7OC\u0002B]fTq\"\u0011*S\u0003f{F\u000b\u0013*F'\"{E\n\u0012\u0006\u0004\u0013:$(BE4fi\u0006\u0013&+Q-`)\"\u0013Vi\u0015%P\u0019\u0012S\u0011\u0001\u0016\u0006\u0007GJ,\u0017\r^3\u000b\u0007M,GOC\u0002TKRTAA[1wC*!Q\u000f^5m1*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001B\u0002\t\u00071\u0001Qa\u0001\u0003\u0004\u0011\u0011a\u0001!\u0002\u0002\u0005\u0004!\u0005Qa\u0001\u0003\u0004\u0011\u001ba\u0001!B\u0001\t\u000f\u0015\u0011A1\u0002E\b\u000b\t!a\u0001#\u0004\u0005\u0007\ba)!G\u0002\u0006\u0003!\u001d\u0001tA\u0017\u0012\t\u0005$\u0002tA\u0011\u0004\u000b\u0005AA\u0001\u0007\u0003V\u0007%)A\u0001b\u0002\n\u0003\u0011\u0015A\u0012A\u0007\u0004\t\u0013I\u0011\u0001\"\u0002.2\u0011\u001d\u0011c\u0002C\u0001\u0011\u0015)B!B\u0001\t\b1\u0005\u0001t\u0001M\u0006C%)\u0011\u0001\u0003\u0002\n\u000b%!QA\u0001C\u0001\u0011\u0003a\n\u0001\u0007\u0002R\u0007\r!Y!C\u0001\t\n5JCqA\t\b\t\u0003AQ!\u0006\u0003\u0006\u0003!\u001dA\u0012\u0001M\u00041\u0017iZ\u0002\u0002\u0001\t\r5IQ!\u0001\u0005\u0006\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001\r\u0006!\u000e\u0001\u0011%C\u0003\u0002\u0011\tIQ!\u0003\u0003\u0006\u0005\u0011\u0005\u0001\u0012\u0001O\u00011\t\t6!\u0002C\u0006\u0013\u0005AI!D\u0001\t\u000eU\u0002\u0001"})
    public static final class Companion {
        public static final /* synthetic */ KClass $kotlinClass;

        static {
            $kotlinClass = Reflection.createKotlinClass(Companion.class);
        }

        private final int getARRAY_THRESHOLD() {
            return ARRAY_THRESHOLD;
        }

        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final <T> SmartSet<T> create(@NotNull Set<? extends T> set) {
            void var2_2;
            Intrinsics.checkParameterIsNotNull(set, (String)"set");
            SmartSet $receiver = new SmartSet(null);
            SmartSet $receiver2 = $receiver;
            $receiver2.addAll(set);
            return (SmartSet)var2_2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @KotlinClass(version={0, 25, 0}, abiVersion=25, data={"\f\u0004)\t2+\u001b8hY\u0016$xN\\%uKJ\fGo\u001c:\u000b\u0011Mk\u0017M\u001d;TKRT1a\u001c:h\u0015%QW\r\u001e2sC&t7O\u0003\u0004l_Rd\u0017N\u001c\u0006\u0006kRLGn\u001d\u0006\u0002)*\u0019\u0011I\\=\u000b\u0011%#XM]1u_JTa\u0001P5oSRt$bB3mK6,g\u000e\u001e\u0006\u0005U\u00064\u0018M\u0003\u0003mC:<'BB(cU\u0016\u001cGOC\u0004iCNtU\r\u001f;\u000b\u000f\t{w\u000e\\3b]*!a.\u001a=u%*\u0011\u0001C\u0001\u0006\u0005\u0011\u0001\u00012A\u0003\u0003\t\u0003A!!\u0002\u0002\u0005\u0003!\u0015Qa\u0001C\u0002\u0011\u0003a\u0001!B\u0002\u0005\u0005!\u0001A\u0002A\u0003\u0002\u0011\t)1\u0001B\u0002\t\b1\u0001Qa\u0001\u0003\u0004\u0011\u0011a\u0001!B\u0001\t\f\u0015\u0011A\u0011\u0002\u0005\u0007\u000b\t!Q\u0001#\u0004\u0006\u0007\u0011\u0019\u0001r\u0002\u0007\u0001\t\u0005a)!F\u0004\u0005\u0002!\u0019Q\u0003B\u0003\u0002\u0011\u000fa\t\u0001g\u0002\u001a\u0013\u0015\t\u0001\u0002B\u0005\u0006\u0013\u0011)!\u0001\"\u0001\t\u0002q\u0005\u0001\u0004B\u0017\u000e\t\u0005$\u0001$B\u0011\u0005\u000b\t!\t\u0001#\u0001\u001d\u0002U\u001bA!B\u0002\u0005\u000b%\t\u00012B\u0017\r\t\u0005g\u0001dB\u0011\u0004\u000b\u0005Aa\u0001\u0007\u0004V\u0007\u0011)1\u0001B\u0004\n\u0003\u0011\u0005Qv\u0003\u0003L\u0001\u0006Ar!I\u0002\u0006\u0003!1\u0001DB)\u0004\u0007\u00119\u0011\"\u0001C\u0001[3!1\nQ\u0001\u0019\u0011\u0005\"QA\u0001C\u0001\u0011\u0003a\n!U\u0002\u0004\t!I\u0011\u0001c\u00036L\u0015%Ca9\u0001\u0012\u000f\u0011\u0005\u0001bA\u000b\u0005\u000b\u0005A9\u0001$\u0001\u0019\ba%Q\u0014\u0003\u0003\u0001\u0011\u0015iA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001)\u0004\u0001\u0005JQ!\u0001E\u0003\u0013\u0015IA!\u0002\u0002\u0005\u0002!\u0005A\u0014\u0001M\u0003#\u000e)A\u0011B\u0005\u0002\t\u0001i\u0011\u0001c\u0003"})
    private static final class SingletonIterator<T>
    implements Iterator<T> {
        public static final /* synthetic */ KClass $kotlinClass;
        private boolean hasNext;
        private final T element;

        static {
            $kotlinClass = Reflection.createKotlinClass(SingletonIterator.class);
        }

        @Override
        public T next() {
            if (!this.hasNext) {
                throw (Throwable)new NoSuchElementException();
            }
            this.hasNext = false;
            return this.element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        public SingletonIterator(T element2) {
            this.element = element2;
            this.hasNext = true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Mutating immutable collection");
        }
    }
}

