/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.deployment;

import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DeploymentUtil {
    public static DeploymentUtil getInstance() {
        return ServiceManager.getService(DeploymentUtil.class);
    }

    @Deprecated
    public abstract void copyFile(@NotNull File var1, @NotNull File var2, @NotNull CompileContext var3, @Nullable Set<String> var4, @Nullable FileFilter var5) throws IOException;

    public static String trimForwardSlashes(@NotNull String path2) {
        if (path2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/deployment/DeploymentUtil", "trimForwardSlashes"));
        }
        while (path2.length() != 0 && (path2.charAt(0) == '/' || path2.charAt(0) == File.separatorChar)) {
            path2 = path2.substring(1);
        }
        return path2;
    }

    @Deprecated
    public abstract void reportDeploymentDescriptorDoesNotExists(ConfigFile var1, CompileContext var2, Module var3);

    public static String concatPaths(String ... paths) {
        StringBuilder builder = new StringBuilder();
        for (String path2 : paths) {
            if (path2.length() == 0) continue;
            int len = builder.length();
            if (len > 0 && builder.charAt(len - 1) != '/' && builder.charAt(len - 1) != File.separatorChar) {
                builder.append('/');
            }
            builder.append(len != 0 ? DeploymentUtil.trimForwardSlashes(path2) : path2);
        }
        return builder.toString();
    }

    public static String appendToPath(@NotNull String basePath, @NotNull String relativePath) {
        boolean startsWithSlash;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/deployment/DeploymentUtil", "appendToPath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/openapi/deployment/DeploymentUtil", "appendToPath"));
        }
        boolean endsWithSlash = StringUtil.endsWithChar((CharSequence)basePath, (char)'/') || StringUtil.endsWithChar((CharSequence)basePath, (char)'\\');
        boolean bl = startsWithSlash = StringUtil.startsWithChar((CharSequence)relativePath, (char)'/') || StringUtil.startsWithChar((CharSequence)relativePath, (char)'\\');
        String tail = endsWithSlash && startsWithSlash ? DeploymentUtil.trimForwardSlashes(relativePath) : (!endsWithSlash && !startsWithSlash && basePath.length() > 0 && relativePath.length() > 0 ? "/" + relativePath : relativePath);
        return basePath + tail;
    }

    @Nullable
    public abstract String getConfigFileErrorMessage(ConfigFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath) {
        int len;
        if (basePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "basePath", "com/intellij/openapi/deployment/DeploymentUtil", "getRelativePath"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/openapi/deployment/DeploymentUtil", "getRelativePath"));
        }
        if (basePath.equals(filePath)) {
            return "";
        }
        if (!basePath.endsWith(File.separator)) {
            basePath = basePath + File.separatorChar;
        }
        int lastSeparatorIndex = 0;
        for (len = 0; len < filePath.length() && len < basePath.length() && filePath.charAt(len) == basePath.charAt(len); ++len) {
            if (basePath.charAt(len) != File.separatorChar) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = StringBuilderSpinAllocator.alloc();
        try {
            for (int i = len; i < basePath.length(); ++i) {
                if (basePath.charAt(i) != File.separatorChar) continue;
                relativePath.append("..");
                relativePath.append(File.separatorChar);
            }
            relativePath.append(filePath.substring(lastSeparatorIndex + 1));
            String string = relativePath.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)relativePath);
        }
    }

    @Deprecated
    public abstract void checkConfigFile(ConfigFile var1, CompileContext var2, Module var3);
}

