/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.Node;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageTargetNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.SystemProperties;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFile
implements com.intellij.ide.ExporterToTextFile {
    private final UsageViewImpl myUsageView;

    public ExporterToTextFile(@NotNull UsageViewImpl usageView) {
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/usages/impl/ExporterToTextFile", "<init>"));
        }
        this.myUsageView = usageView;
    }

    @Override
    public JComponent getSettingsEditor() {
        return null;
    }

    @Override
    public void addSettingsChangedListener(ChangeListener listener) throws TooManyListenersException {
    }

    @Override
    public void removeSettingsChangedListener(ChangeListener listener) {
    }

    @Override
    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        this.appendNode(buf, this.myUsageView.getModelRoot(), SystemProperties.getLineSeparator(), "");
        String string = buf.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/ExporterToTextFile", "getReportText"));
        }
        return string;
    }

    private void appendNode(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator, String indent) {
        String childIndent;
        buf.append(indent);
        if (node.getParent() != null) {
            childIndent = indent + "    ";
            this.appendNodeText(buf, node, lineSeparator);
        } else {
            childIndent = indent;
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, childIndent);
        }
    }

    private void appendNodeText(StringBuilder buf, DefaultMutableTreeNode node, String lineSeparator) {
        if (node instanceof Node && ((Node)node).isExcluded()) {
            buf.append("(").append(UsageViewBundle.message("usage.excluded", new Object[0])).append(") ");
        }
        if (node instanceof UsageNode) {
            TextChunk[] chunks;
            for (TextChunk chunk : chunks = ((UsageNode)node).getUsage().getPresentation().getText()) {
                buf.append(chunk.getText());
            }
        } else if (node instanceof GroupNode) {
            UsageGroup group = ((GroupNode)node).getGroup();
            buf.append(group != null ? group.getText(this.myUsageView) : UsageViewBundle.message("usages.title", new Object[0]));
            buf.append(" ");
            int count = ((GroupNode)node).getRecursiveUsageCount();
            buf.append(" (").append(UsageViewBundle.message("usages.n", count)).append(")");
        } else if (node instanceof UsageTargetNode) {
            buf.append(((UsageTargetNode)node).getTarget().getPresentation().getPresentableText());
        } else {
            buf.append(node.toString());
        }
        buf.append(lineSeparator);
    }

    @Override
    @NotNull
    public String getDefaultFilePath() {
        String string = UsageViewSettings.getInstance().EXPORT_FILE_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/ExporterToTextFile", "getDefaultFilePath"));
        }
        return string;
    }

    @Override
    public void exportedTo(String filePath) {
        UsageViewSettings.getInstance().EXPORT_FILE_NAME = filePath;
    }

    @Override
    public boolean canExport() {
        return !this.myUsageView.isSearchInProgress() && this.myUsageView.areTargetsValid();
    }
}

